/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.common.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constant.GiftEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ItemKneadPriceDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.constants.AccountDocumentTypeEnum;
import com.yunxi.dg.base.center.account.constants.ItemCountsTypeEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeBatchReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeRespDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountTypeDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTradeApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderPayAction;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IItemPayRecordDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.ItemPayRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.pay.base.DgBasePayReqDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.ItemPayRecordEo;
import com.yunxi.dg.base.center.trade.eo.PayRecordEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.DocumentTypeConvert;
import com.yunxi.dg.base.center.trade.utils.TradeUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="orderPayActionImpl")
public class OrderPayActionImpl
implements IOrderPayAction {
    private static final Logger log = LoggerFactory.getLogger(OrderPayActionImpl.class);
    @Resource
    private IAccountTradeApiProxy accountTradeApiProxy;
    @Resource
    private IDgPerformOrderItemDomain dgPerformOrderItemDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IItemPayRecordDomain itemPayRecordDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> pay(Long orderId, List<DgPerformOrderLineDto> orderLineDtoList, List<DgBasePayReqDto> payReqDtos) {
        log.info("\u3010\u8ba2\u5355\u53d1\u8d77\u652f\u4ed8,\u8ba2\u5355ID:{}\u3011", (Object)orderId);
        log.info("\u3010\u8ba2\u5355\u53d1\u8d77\u652f\u4ed8,\u8bf7\u6c42\u53c2\u6570:{}\u3011", (Object)JSON.toJSONString(payReqDtos));
        DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryEoById(orderId);
        AssertUtils.isFalse((dgPerformOrderInfoEo == null ? 1 : 0) != 0, (String)"\u672a\u6839\u636e\u8ba2\u5355ID\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(orderId);
        AssertUtils.isFalse((snapshotEo == null ? 1 : 0) != 0, (String)"\u672a\u6839\u636e\u8ba2\u5355ID\u67e5\u8be2\u5230\u8ba2\u5355\u5feb\u7167\u4fe1\u606f");
        List<AccountTradeReqDto> tradeReqDtos = this.buildAccountTradeReqDtos(payReqDtos, snapshotEo);
        AccountTradeBatchReqDto accountTradeBatchReqDto = this.buildAccountTradeBacthReqDto(dgPerformOrderInfoEo, snapshotEo, dgPerformOrderInfoEo.getSaleOrderNo(), dgPerformOrderInfoEo.getSaleOrderNo());
        accountTradeBatchReqDto.setTradeReqDtos(tradeReqDtos);
        log.info("[\u652f\u4ed8\u8bf7\u6c42\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)accountTradeBatchReqDto));
        List respDtos = (List)RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.preempt(accountTradeBatchReqDto));
        log.info("[\u652f\u4ed8\u8bf7\u6c42\u7ed3\u679c]:{}", (Object)JSON.toJSONString((Object)respDtos));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> preemptionToActualPayment(Long orderId, List<DgBasePayReqDto> payReqDtos) {
        log.info("\u3010\u8ba2\u5355\u9884\u5360\u8f6c\u5b9e\u4ed8,\u8ba2\u5355ID:{}\u3011", (Object)orderId);
        DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryEoById(orderId);
        AssertUtils.isFalse((dgPerformOrderInfoEo == null ? 1 : 0) != 0, (String)"\u672a\u6839\u636e\u8ba2\u5355ID\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(orderId);
        AssertUtils.isFalse((snapshotEo == null ? 1 : 0) != 0, (String)"\u672a\u6839\u636e\u8ba2\u5355ID\u67e5\u8be2\u5230\u8ba2\u5355\u5feb\u7167\u4fe1\u606f");
        List<AccountTradeReqDto> tradeReqDtos = this.buildAccountTradeReqDtos(payReqDtos, snapshotEo);
        AccountTradeBatchReqDto accountTradeBatchReqDto = this.buildAccountTradeBacthReqDto(dgPerformOrderInfoEo, snapshotEo, dgPerformOrderInfoEo.getSaleOrderNo(), dgPerformOrderInfoEo.getSaleOrderNo());
        accountTradeBatchReqDto.setTradeReqDtos(tradeReqDtos);
        log.info("[\u989d\u5ea6\u9884\u5360\u8f6c\u5b9e\u4ed8\u8bf7\u6c42\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)accountTradeBatchReqDto));
        RestResponse response = this.accountTradeApiProxy.outboundRelease(accountTradeBatchReqDto);
        log.info("[\u989d\u5ea6\u9884\u5360\u8f6c\u5b9e\u4ed8\u8bf7\u6c42\u7ed3\u679c]:{}", (Object)JSON.toJSONString((Object)response));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> preemptionToReturn(Long orderId, List<DgPerformOrderLineDto> orderLineList, List<DgBasePayReqDto> payReqDtos) {
        log.info("\u3010\u8ba2\u5355\u9884\u5360\u8f6c\u9000\u56de,\u8ba2\u5355ID:{}\u3011", (Object)orderId);
        DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryEoById(orderId);
        AssertUtils.isFalse((dgPerformOrderInfoEo == null ? 1 : 0) != 0, (String)"\u672a\u6839\u636e\u8ba2\u5355ID\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(orderId);
        AssertUtils.isFalse((snapshotEo == null ? 1 : 0) != 0, (String)"\u672a\u6839\u636e\u8ba2\u5355ID\u67e5\u8be2\u5230\u8ba2\u5355\u5feb\u7167\u4fe1\u606f");
        List<AccountTradeReqDto> tradeReqDtos = this.buildAccountTradeReqDtos(payReqDtos, snapshotEo);
        AccountTradeBatchReqDto accountTradeBatchReqDto = this.buildAccountTradeBacthReqDto(dgPerformOrderInfoEo, snapshotEo, dgPerformOrderInfoEo.getSaleOrderNo(), dgPerformOrderInfoEo.getSaleOrderNo());
        accountTradeBatchReqDto.setTradeReqDtos(tradeReqDtos);
        log.info("[\u989d\u5ea6\u9884\u5360\u8f6c\u9000\u56de\u8bf7\u6c42\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)accountTradeBatchReqDto));
        RestResponse response = this.accountTradeApiProxy.cancelRelease(accountTradeBatchReqDto);
        log.info("[\u989d\u5ea6\u9884\u5360\u8f6c\u9000\u56de\u8bf7\u6c42\u7ed3\u679c]:{}", (Object)JSON.toJSONString((Object)response));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<List<AccountTradeRespDto>> refund(Long orderId, List<DgBasePayReqDto> payReqDtos, DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryEoById(orderId);
        AssertUtils.isFalse((dgPerformOrderInfoEo == null ? 1 : 0) != 0, (String)"\u672a\u6839\u636e\u8ba2\u5355ID\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(orderId);
        AssertUtils.isFalse((snapshotEo == null ? 1 : 0) != 0, (String)"\u672a\u6839\u636e\u8ba2\u5355ID\u67e5\u8be2\u5230\u8ba2\u5355\u5feb\u7167\u4fe1\u606f");
        List<AccountTradeReqDto> tradeReqDtos = this.buildAccountTradeReqDtos(payReqDtos, snapshotEo);
        AccountTradeBatchReqDto accountTradeBatchReqDto = this.buildAccountTradeBacthReqDto(dgPerformOrderInfoEo, snapshotEo, dgPerformOrderInfoEo.getSaleOrderNo(), afterSaleOrderRespDto.getAfterSaleOrderNo());
        if (AfterSaleOrderTypeEnum.FHHTK.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType())) {
            accountTradeBatchReqDto.setDocumentType(AccountDocumentTypeEnum.AFTER_SALE_ORDER_FHHTK.getCode());
        } else {
            accountTradeBatchReqDto.setDocumentType(Objects.equals(afterSaleOrderRespDto.getBizType(), "2") ? AccountDocumentTypeEnum.ORDER_MALL_RETURN.getCode() : AccountDocumentTypeEnum.ORDER_RETURN.getCode());
        }
        accountTradeBatchReqDto.setTradeReqDtos(tradeReqDtos);
        log.info("[\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)accountTradeBatchReqDto));
        RestResponse restResponse = this.accountTradeApiProxy.refund(accountTradeBatchReqDto);
        log.info("[\u9000\u6b3e\u8bf7\u6c42\u7ed3\u679c]:{}", (Object)JSON.toJSONString((Object)restResponse.getData()));
        if (!restResponse.getResultCode().equals("0")) {
            log.error("\u9000\u6b3e\u5f02\u5e38,{}", (Object)restResponse.getResultMsg());
            throw new BizException(restResponse.getResultMsg());
        }
        return restResponse;
    }

    @Override
    public RestResponse<List<AccountTradeRespDto>> noOrignaleOrderRefund(Long orderId, List<DgBasePayReqDto> payReqDtos, DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        List<AccountTradeReqDto> tradeReqDtos = this.noOrignalOrderBuildAccountTradeReqDtos(payReqDtos, afterSaleOrderRespDto);
        AccountTradeBatchReqDto accountTradeBatchReqDto = this.noOrignalOrderBuildAccountTradeBacthReqDto(afterSaleOrderRespDto, afterSaleOrderRespDto.getAfterSaleOrderNo(), afterSaleOrderRespDto.getAfterSaleOrderNo());
        if (AfterSaleOrderTypeEnum.FHHTK.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType())) {
            accountTradeBatchReqDto.setDocumentType(AccountDocumentTypeEnum.AFTER_SALE_ORDER_FHHTK.getCode());
        } else {
            accountTradeBatchReqDto.setDocumentType(Objects.equals(afterSaleOrderRespDto.getBizType(), "2") ? AccountDocumentTypeEnum.ORDER_MALL_RETURN.getCode() : AccountDocumentTypeEnum.ORDER_RETURN.getCode());
        }
        accountTradeBatchReqDto.setTradeReqDtos(tradeReqDtos);
        log.info("[\u65e0\u539f\u5355\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)accountTradeBatchReqDto));
        RestResponse restResponse = this.accountTradeApiProxy.noOriginalOrderRefund(accountTradeBatchReqDto);
        log.info("[\u65e0\u539f\u5355\u9000\u6b3e\u8bf7\u6c42\u7ed3\u679c]:{}", (Object)JSON.toJSONString((Object)restResponse.getData()));
        if (!restResponse.getResultCode().equals("0")) {
            log.error("\u65e0\u539f\u5355\u9000\u6b3e\u5f02\u5e38,{}", (Object)restResponse.getResultMsg());
            throw new BizException(restResponse.getResultMsg());
        }
        return restResponse;
    }

    private AccountTradeBatchReqDto buildAccountTradeBacthReqDto(DgPerformOrderInfoEo dgPerformOrderInfoEo, DgPerformOrderSnapshotEo snapshotEo, String orderNo, String businessOrderNo) {
        AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
        accountTradeBatchReqDto.setOrderNo(orderNo);
        accountTradeBatchReqDto.setCustomerNo(snapshotEo.getCustomerCode());
        accountTradeBatchReqDto.setShopCode(snapshotEo.getShopCode());
        accountTradeBatchReqDto.setSaleCompanyCode(snapshotEo.getEnterpriseCode());
        accountTradeBatchReqDto.setCreditFileNo(snapshotEo.getCreditFileNo());
        accountTradeBatchReqDto.setBusinessOrderNo(businessOrderNo);
        accountTradeBatchReqDto.setDocumentType(DocumentTypeConvert.orderTypeToDocumentType(dgPerformOrderInfoEo.getOrderType()));
        return accountTradeBatchReqDto;
    }

    private AccountTradeBatchReqDto noOrignalOrderBuildAccountTradeBacthReqDto(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String orderNo, String businessOrderNo) {
        AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
        accountTradeBatchReqDto.setOrderNo(orderNo);
        accountTradeBatchReqDto.setCustomerNo(afterSaleOrderRespDto.getCustomerCode());
        accountTradeBatchReqDto.setShopCode(afterSaleOrderRespDto.getShopCode());
        accountTradeBatchReqDto.setSaleCompanyCode(afterSaleOrderRespDto.getEnterpriseCode());
        accountTradeBatchReqDto.setBusinessOrderNo(businessOrderNo);
        return accountTradeBatchReqDto;
    }

    private List<AccountTradeReqDto> buildAccountTradeReqDtos(List<DgBasePayReqDto> payReqDtos, DgPerformOrderSnapshotEo snapshotEo) {
        ArrayList tradeReqDtos = Lists.newArrayList();
        for (DgBasePayReqDto payInfo : payReqDtos) {
            AccountTradeReqDto accountTradeReqDto = new AccountTradeReqDto();
            accountTradeReqDto.setAmount(payInfo.getPayAmount());
            accountTradeReqDto.setAccountType(payInfo.getPayMethod());
            accountTradeReqDto.setAccountCategory(payInfo.getAccountCategory());
            accountTradeReqDto.setCreditFileNo(payInfo.getCreditFileNo());
            accountTradeReqDto.setAccountCode(payInfo.getAccountCode());
            accountTradeReqDto.setSaleCompanyCode(Optional.ofNullable(payInfo.getSaleCompanyCode()).orElse(snapshotEo.getEnterpriseCode()));
            accountTradeReqDto.setBusinessOrderNo(payInfo.getBusinessOrderNo());
            tradeReqDtos.add(accountTradeReqDto);
        }
        return tradeReqDtos;
    }

    private List<AccountTradeReqDto> noOrignalOrderBuildAccountTradeReqDtos(List<DgBasePayReqDto> payReqDtos, DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto) {
        ArrayList tradeReqDtos = Lists.newArrayList();
        for (DgBasePayReqDto payInfo : payReqDtos) {
            if (AccountCategoryEnum.THIRD.getCode().equals(payInfo.getAccountCategory())) continue;
            AccountTradeReqDto accountTradeReqDto = new AccountTradeReqDto();
            accountTradeReqDto.setAmount(payInfo.getPayAmount());
            accountTradeReqDto.setAccountType(payInfo.getPayMethod());
            accountTradeReqDto.setAccountCategory(payInfo.getAccountCategory());
            accountTradeReqDto.setCreditFileNo(payInfo.getCreditFileNo());
            accountTradeReqDto.setAccountCode(payInfo.getAccountCode());
            accountTradeReqDto.setSaleCompanyCode(dgAfterSaleOrderRespDto.getEnterpriseCode());
            accountTradeReqDto.setCustomerNo(dgAfterSaleOrderRespDto.getCustomerCode());
            accountTradeReqDto.setShopCode(dgAfterSaleOrderRespDto.getShopCode());
            accountTradeReqDto.setBusinessOrderNo(payInfo.getBusinessOrderNo());
            tradeReqDtos.add(accountTradeReqDto);
        }
        return tradeReqDtos;
    }

    private void updateOrderLineCostDetail(DgBizPerformOrderRespDto dgBizPerformOrderRespDto, List<DgPreviewPerformOrderItemReqDto> allItemList, List<PayRecordDto> payRecordEos, Map<String, AccountTypeDto> accoungtTypeDtoMap) {
        List orderLineEos = ((ExtQueryChainWrapper)this.dgPerformOrderLineDomain.filter().eq((Object)"order_id", (Object)dgBizPerformOrderRespDto.getId())).list();
        List performOrderItemLineEos = ((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().eq((Object)"order_id", (Object)dgBizPerformOrderRespDto.getId())).list();
        ArrayList itemPayRecordInsertList = Lists.newArrayList();
        Map orderItemLineEoMap = performOrderItemLineEos.stream().filter(itemLine -> itemLine.getItemNum().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toMap(DgPerformOrderItemLineEo::getOrderLineId, Function.identity()));
        for (PayRecordDto payRecordDto : payRecordEos) {
            Map itemPayRecordDtoMap = Optional.ofNullable(payRecordDto.getItemPayRecordDtos()).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(ItemPayRecordDto::getOrderItemId, Function.identity(), (e1, e2) -> e1));
            AccountTypeDto accountTypeDto = accoungtTypeDtoMap.get(payRecordDto.getPayMethod());
            BigDecimal payAmount = payRecordDto.getPayAmount();
            BigDecimal allocateAmount = BigDecimal.ZERO;
            for (DgPerformOrderLineEo orderLineEo : orderLineEos) {
                if (orderLineEo.getItemNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                ArrayList itemPayRecordEos = StringUtils.isNotBlank((CharSequence)orderLineEo.getCostDetails()) ? JSON.parseArray((String)orderLineEo.getCostDetails(), ItemPayRecordDto.class) : Lists.newArrayList();
                ItemPayRecordDto costPayRecordDto = (ItemPayRecordDto)itemPayRecordDtoMap.get(orderLineEo.getMainOrderItemId());
                Optional.ofNullable(costPayRecordDto).ifPresent(itemPayRecordEos::add);
                if (AccountCategoryEnum.CAPITAL.getCode().equals(payRecordDto.getAccountCategory())) {
                    if (payAmount.subtract(allocateAmount).compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal itemPayAmount = itemPayRecordEos.stream().map(ItemPayRecordDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal itemNeedPaymount = orderLineEo.getTransactionAmount().subtract(itemPayAmount);
                    if (itemNeedPaymount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    ItemPayRecordDto itemPayRecordDto = new ItemPayRecordDto();
                    itemPayRecordDto.setPayRecordId(payRecordDto.getId());
                    itemPayRecordDto.setOrderItemId(orderLineEo.getId());
                    itemPayRecordDto.setItemCountsType(accountTypeDto.getGoodsCount());
                    itemPayRecordDto.setAccountType(accountTypeDto.getAccountTypeCode());
                    itemPayRecordDto.setAccountCategory(accountTypeDto.getCategory());
                    itemPayRecordDto.setSaleCompanyCode(payRecordDto.getSellerId());
                    itemPayRecordDto.setCreditFileNo(payRecordDto.getCardNo());
                    BigDecimal surpleAllcocateAmount = payAmount.subtract(allocateAmount);
                    if (surpleAllcocateAmount.compareTo(itemNeedPaymount) > 0) {
                        itemPayRecordDto.setAmount(itemNeedPaymount);
                        allocateAmount = allocateAmount.add(itemNeedPaymount);
                    } else {
                        itemPayRecordDto.setAmount(surpleAllcocateAmount);
                        allocateAmount = allocateAmount.add(surpleAllcocateAmount);
                    }
                    itemPayRecordEos.add(itemPayRecordDto);
                    ItemPayRecordEo recordEo = new ItemPayRecordEo();
                    CubeBeanUtils.copyProperties((Object)recordEo, (Object)itemPayRecordDto, (String[])new String[0]);
                    itemPayRecordInsertList.add(recordEo);
                }
                BigDecimal oldCostAmount = Optional.ofNullable(orderLineEo.getCostAmount()).orElse(BigDecimal.ZERO);
                BigDecimal oldPayAmount = Optional.ofNullable(orderLineEo.getPayAmount()).orElse(BigDecimal.ZERO);
                BigDecimal addCostAmount = Optional.ofNullable(costPayRecordDto).map(ItemPayRecordDto::getAmount).orElse(BigDecimal.ZERO);
                orderLineEo.setCostAmount(oldCostAmount.add(addCostAmount));
                orderLineEo.setCostDetails(JSON.toJSONString((Object)itemPayRecordEos));
                orderLineEo.setPayAmount(BigDecimal.ZERO.max(oldPayAmount.subtract(addCostAmount)));
            }
        }
        this.itemPayRecordDomain.insertBatch((List)itemPayRecordInsertList);
        Map orderItemMap = allItemList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        for (DgPerformOrderLineEo updateOrderLineEo : orderLineEos) {
            if (updateOrderLineEo.getItemNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            DgPreviewPerformOrderItemReqDto itemReqDto = (DgPreviewPerformOrderItemReqDto)orderItemMap.get(updateOrderLineEo.getMainOrderItemId());
            BigDecimal costKneadeAmount = Optional.ofNullable(itemReqDto).map(DgPerformOrderItemDto::getCostKneadeAmount).orElse(BigDecimal.ZERO);
            List costKneadPriceDtos = Optional.ofNullable(itemReqDto).map(DgPerformOrderItemDto::getItemKneadDetails).orElse(Lists.newArrayList());
            DgPerformOrderLineEo dgPerformOrderLineEo = new DgPerformOrderLineEo();
            dgPerformOrderLineEo.setId(updateOrderLineEo.getId());
            dgPerformOrderLineEo.setPayAmount(updateOrderLineEo.getPayAmount());
            dgPerformOrderLineEo.setCostAmount(updateOrderLineEo.getCostAmount());
            dgPerformOrderLineEo.setCostDetails(updateOrderLineEo.getCostDetails());
            if (updateOrderLineEo.getCostKneadeAmount() == null || BigDecimal.ZERO.compareTo(updateOrderLineEo.getCostKneadeAmount()) == 0) {
                dgPerformOrderLineEo.setCostKneadeAmount(costKneadeAmount);
                dgPerformOrderLineEo.setKneadeAmount(Optional.ofNullable(updateOrderLineEo.getKneadeAmount()).orElse(BigDecimal.ZERO).add(costKneadeAmount));
                dgPerformOrderLineEo.setKneadLaterTotal(Optional.ofNullable(updateOrderLineEo.getKneadLaterTotal()).orElse(BigDecimal.ZERO).subtract(costKneadeAmount));
                ArrayList olditemKneadPriceDtos = StringUtils.isNotBlank((CharSequence)updateOrderLineEo.getKneadeDetail()) ? JSON.parseArray((String)updateOrderLineEo.getKneadeDetail(), ItemKneadPriceDto.class) : Lists.newArrayList();
                olditemKneadPriceDtos.addAll(costKneadPriceDtos);
                dgPerformOrderLineEo.setKneadeDetail(JSON.toJSONString((Object)olditemKneadPriceDtos));
            }
            dgPerformOrderLineEo.setUpdateTime(new Date());
            this.dgPerformOrderLineDomain.updateSelective((BaseEo)dgPerformOrderLineEo);
            DgPerformOrderItemLineEo dgPerformOrderItemLineEo = (DgPerformOrderItemLineEo)orderItemLineEoMap.get(updateOrderLineEo.getId());
            DgPerformOrderItemLineEo updateItemLineEo = new DgPerformOrderItemLineEo();
            updateItemLineEo.setId(dgPerformOrderItemLineEo.getId());
            updateItemLineEo.setPayAmount(updateOrderLineEo.getPayAmount());
            updateItemLineEo.setCostAmount(updateOrderLineEo.getCostAmount());
            updateItemLineEo.setCostDetails(updateOrderLineEo.getCostDetails());
            if (updateItemLineEo.getCostKneadeAmount() == null || BigDecimal.ZERO.compareTo(updateItemLineEo.getCostKneadeAmount()) == 0) {
                updateItemLineEo.setCostKneadeAmount(costKneadeAmount);
                updateItemLineEo.setKneadeAmount(Optional.ofNullable(dgPerformOrderItemLineEo.getKneadeAmount()).orElse(BigDecimal.ZERO).add(costKneadeAmount));
                dgPerformOrderLineEo.setKneadLaterTotal(Optional.ofNullable(updateOrderLineEo.getKneadLaterTotal()).orElse(BigDecimal.ZERO).subtract(costKneadeAmount));
                ArrayList olditemKneadPriceDtos = StringUtils.isNotBlank((CharSequence)updateItemLineEo.getKneadeDetail()) ? JSON.parseArray((String)updateItemLineEo.getKneadeDetail(), ItemKneadPriceDto.class) : Lists.newArrayList();
                olditemKneadPriceDtos.addAll(costKneadPriceDtos);
                updateItemLineEo.setKneadeDetail(JSON.toJSONString((Object)olditemKneadPriceDtos));
            }
            this.dgPerformOrderItemLineDomain.updateSelective((BaseEo)updateItemLineEo);
        }
    }

    private void saveCapitalItemPayRecords(DgBizPerformOrderRespDto dgBizPerformOrderRespDto, PayRecordEo payRecordEo) {
        List tradeItems = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemDomain.filter().eq((Object)"gift", (Object)GiftEnum.NOT_GIFT.getType())).eq((Object)"order_id", (Object)dgBizPerformOrderRespDto.getId())).list();
        List orderItemIds = tradeItems.stream().map(BaseEo::getId).collect(Collectors.toList());
        List itemPayRecordEos = ((ExtQueryChainWrapper)this.itemPayRecordDomain.filter().in((Object)"order_item_id", orderItemIds)).list();
        ArrayList itemPayRecordInsertList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)itemPayRecordEos)) {
            BigDecimal currentPayAmount = payRecordEo.getPayAmount();
            for (DgPerformOrderItemEo tradeItem : tradeItems) {
                if (currentPayAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal itemPayAmount = tradeItem.getItemOrigAmount();
                if (currentPayAmount.compareTo(itemPayAmount) > 0) {
                    currentPayAmount = currentPayAmount.subtract(itemPayAmount);
                } else {
                    itemPayAmount = currentPayAmount;
                    currentPayAmount = BigDecimal.ZERO;
                }
                ItemPayRecordEo itemPayRecordEo = new ItemPayRecordEo();
                itemPayRecordEo.setOrderItemId(tradeItem.getId());
                itemPayRecordEo.setItemCountsType(ItemCountsTypeEnum.NO.getCode());
                itemPayRecordEo.setAccountType(payRecordEo.getPayMethod());
                itemPayRecordEo.setAmount(itemPayAmount);
                itemPayRecordEo.setPayRecordId(payRecordEo.getId());
                itemPayRecordInsertList.add(itemPayRecordEo);
            }
        } else {
            Map<Long, List<ItemPayRecordEo>> orderItemPayRecordMap = itemPayRecordEos.stream().collect(Collectors.groupingBy(ItemPayRecordEo::getOrderItemId));
            log.info("\u3010itemPayRecordEoMap:{}\u3011", (Object)JSON.toJSONString(orderItemPayRecordMap));
            BigDecimal currentPayAmount = payRecordEo.getPayAmount();
            for (DgPerformOrderItemEo tradeItem : tradeItems) {
                log.info("\u3010currentPayAmount:{}\u3011", (Object)currentPayAmount);
                List<ItemPayRecordEo> itemPayRecordEoList = orderItemPayRecordMap.get(tradeItem.getId());
                if (CollectionUtil.isEmpty(itemPayRecordEoList) || currentPayAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal payAmount = itemPayRecordEoList.stream().map(ItemPayRecordEo::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal needPayAmount = tradeItem.getItemOrigAmount().subtract(payAmount);
                log.info("\u5546\u54c1SKU\u540d\u79f0:{},\u5df2\u7ecf\u652f\u4ed8\u7684\u989d\u5ea6\u4e3a:{},\u8fd8\u9700\u8981\u652f\u4ed8\u7684\u989d\u5ea6\u4e3a:{},\u5f53\u524d\u4ed8\u6b3e\u989d\u5ea6\u4e3a:{}", new Object[]{tradeItem.getSkuName(), payAmount, needPayAmount, currentPayAmount});
                if (needPayAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal itemPayAmount = needPayAmount;
                if (currentPayAmount.compareTo(itemPayAmount) > 0) {
                    currentPayAmount = currentPayAmount.subtract(itemPayAmount);
                } else {
                    itemPayAmount = currentPayAmount;
                    currentPayAmount = BigDecimal.ZERO;
                }
                log.info("\u3010itemPayAmount:{},currentPayAmount:{}\u3011", (Object)itemPayAmount, (Object)currentPayAmount);
                ItemPayRecordEo itemPayRecordEo = new ItemPayRecordEo();
                itemPayRecordEo.setOrderItemId(tradeItem.getId());
                itemPayRecordEo.setItemCountsType(ItemCountsTypeEnum.NO.getCode());
                itemPayRecordEo.setAccountType(payRecordEo.getPayMethod());
                itemPayRecordEo.setAmount(itemPayAmount);
                itemPayRecordEo.setPayRecordId(payRecordEo.getId());
                itemPayRecordInsertList.add(itemPayRecordEo);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)itemPayRecordInsertList)) {
            this.itemPayRecordDomain.insertBatch((List)itemPayRecordInsertList);
        }
    }

    private PayRecordDto buildPayRecordEo(DgPerformOrderRespDto dto, AccountTradeReqDto accountTradeReqDto) {
        PayRecordDto payRecordEo = new PayRecordDto();
        payRecordEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        payRecordEo.setPayStartTime(new Date());
        payRecordEo.setPayTime(new Date());
        payRecordEo.setConfirmTime(new Date());
        payRecordEo.setAuditStatus("pass");
        payRecordEo.setPayStatus(PayStatusEnum.SUCCESS.getName());
        payRecordEo.setOrderNo(dto.getSaleOrderNo());
        payRecordEo.setPayMethod(accountTradeReqDto.getAccountType());
        payRecordEo.setPayMethodName(accountTradeReqDto.getAccountTypeName());
        payRecordEo.setAccountCategory(accountTradeReqDto.getAccountCategory());
        payRecordEo.setPayAmount(accountTradeReqDto.getAmount());
        payRecordEo.setRefundAmount(BigDecimal.ZERO);
        payRecordEo.setUserId(dto.getPerformOrderSnapshotDto().getCustomerId() + "");
        payRecordEo.setPayNo(TradeUtil.generateTradeNo());
        payRecordEo.setTradeNo(payRecordEo.getPayNo());
        payRecordEo.setSellerId(accountTradeReqDto.getSaleCompanyCode());
        payRecordEo.setCardNo(accountTradeReqDto.getCreditFileNo());
        return payRecordEo;
    }
}

