/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.guard.b2b.Impl;

import com.alibaba.fastjson.JSON;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.guard.b2b.IB2BOrderGuard;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class B2BOrderGuardImpl
implements IB2BOrderGuard {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderGuardImpl.class);
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;

    @Override
    public Boolean checkSplitOrderReqDto(DgPerformOrderRespDto respDto, DgSplitOrderReqDto reqDto) {
        AssertUtils.isTrue((boolean)respDto.getId().equals(reqDto.getSaleOrderId()), (String)"\u8ba2\u5355id\u5165\u53c2\u4e0d\u4e00\u81f4");
        AssertUtils.notEmpty((Collection)reqDto.getOrderList(), (String)"\u62c6\u5206\u5b50\u5355\u5217\u8868\u5165\u53c2\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        reqDto.getOrderList().forEach(dgSplitChildOrderReqDto -> AssertUtils.notEmpty((Collection)dgSplitChildOrderReqDto.getOrderLineDtoList(), (String)"\u62c6\u5206\u5b50\u5355\u660e\u7ec6\u5217\u8868\u5165\u53c2\u4e0d\u5141\u8bb8\u4e3a\u7a7a"));
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkOrderCanAutoPick(DgPerformOrderRespDto respDto) {
        log.info("[\u6821\u9a8c\u662f\u5426\u5141\u8bb8\u81ea\u52a8\u9a8c\u8d27]\u5b9e\u9645\u53d1\u8d27\u65f6\u95f4\u914d\u7f6e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)respDto.getDeliveryTime()));
        if (respDto.getDeliveryTime() != null && respDto.getDeliveryTime().compareTo(new Date()) < 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

