/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.after.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.lock.provider.redis.RedisLockService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.entity.AccountTypeDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTradeApiProxy;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTypeApiProxy;
import com.yunxi.dg.base.center.item.dto.request.ShopItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemDgRespDto;
import com.yunxi.dg.base.center.item.proxy.directory.IDirectoryDgQueryApiProxy;
import com.yunxi.dg.base.center.item.proxy.sku.impl.ItemSkuDgQueryApiProxyImpl;
import com.yunxi.dg.base.center.report.dto.entity.BizTagRecordDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordPageReqDto;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagRecordApiProxy;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicQueryOptAction;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgF2BAfterRefundModeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgF2BAfterStatus;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgF2BAfterStorageStatus;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgAfterSaleOrderItemConverter;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderItemDas;
import com.yunxi.dg.base.center.trade.domain.entity.IAttachementDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderExchangeAddressDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderLogisticsWarehouseDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderReturnAddressDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineKneadDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IQualityControlDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IQualityControlItemDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleOrderReturnBizTypeEnum;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.MatchItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.OrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderLabelItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgRefundItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.ItemPayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.eo.AttachementEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderOptService;
import com.yunxi.dg.base.center.trade.service.after.IDgF2BAfterService;
import com.yunxi.dg.base.center.trade.service.entity.IDgAfterSaleRuleService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderConfigurationService;
import com.yunxi.dg.base.center.trade.utils.AssertUtil;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAfterSaleOrderOptServiceImpl
implements IDgAfterSaleOrderOptService {
    private static Logger logger = LoggerFactory.getLogger(DgAfterSaleOrderOptServiceImpl.class);
    @Resource
    protected IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderBasicQueryOptAction afterSaleOrderBasicQueryOptAction;
    @Resource
    private IDgRefundItemDomain dgRefundItemDomain;
    @Resource
    private IDgRefundDomain dgRefundDomain;
    @Autowired
    protected IQualityControlDomain qualityControlDomain;
    @Autowired
    protected IQualityControlItemDomain qualityControlItemDomain;
    @Resource
    protected IDgAfterSaleOrderItemDomain dgAfterSaleOrderItemDomain;
    @Resource
    protected IDgAfterSaleOrderItemService dgAfterSaleOrderItemService;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgAfterSaleOrderDas dgAfterSaleOrderDas;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemDas dgAfterSaleOrderItemDas;
    @Resource
    private IDgAfterSaleOrderReturnAddressDomain dgAfterSaleOrderReturnAddressDomain;
    @Resource
    private IDgAfterSaleOrderExchangeAddressDomain dgAfterSaleOrderExchangeAddressDomain;
    @Resource
    private IDgAfterSaleOrderLogisticsWarehouseDomain dgAfterSaleOrderLogisticsWarehouseDomain;
    @Resource
    private IAttachementDomain attachementDomain;
    @Resource
    protected IContext context;
    @Resource
    protected IAccountTradeApiProxy accountTradeApiProxy;
    @Resource
    protected RedisLockService lockService;
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    protected IDgOrderConfigurationService dgOrderConfigurationService;
    @Resource
    protected IDgPerformOrderLineDomain performOrderLineDomain;
    @Resource
    protected ICommonOrderQueryService commonOrderQueryService;
    @Resource
    protected IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    protected IPayRecordDomain payRecordDomain;
    @Resource
    private IAccountTypeApiProxy accountTypeApi;
    @Resource
    protected IDgPerformOrderItemLineAmountDomain itemLineAmountDomain;
    @Resource
    protected IDgPerformOrderLineAmountDomain lineAmountDomain;
    @Resource
    protected IDgPerformOrderLineKneadDomain dgPerformOrderLineKneadDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgF2BAfterService f2BAfterService;
    @Resource
    protected IDgPerformOrderSnapshotDomain snapshotDomain;
    @Resource
    protected IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    protected IDgAfterSaleRuleService dgAfterSaleRuleService;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgOrderLabelItemDomain orderLabelItemDomain;
    @Resource
    protected ItemSkuDgQueryApiProxyImpl itemSkuDgQueryApiProxy;
    @Resource
    protected IDirectoryDgQueryApiProxy directoryDgQueryApiProxy;
    @Resource
    private IReBizTagRecordApiProxy reBizTagRecordApiProxy;

    public IConverter<DgAfterSaleOrderItemDto, DgAfterSaleOrderItemEo> converter() {
        return DgAfterSaleOrderItemConverter.INSTANCE;
    }

    @Override
    public DgAfterSaleOrderRespDto applyPerformOrderAfter(String orderNo, Integer returnBizType) {
        logger.info("\u8ba2\u8d27\u5355\u7533\u8bf7\u552e\u540e\uff1a{}", (Object)orderNo);
        DgBizPerformOrderRespDto performOrder = this.commonOrderQueryService.queryByOrderNo(orderNo);
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)performOrder), (String)"-1", (String)"\u627e\u4e0d\u5230\u8ba2\u8d27\u5355\u4fe1\u606f");
        DgAfterSaleOrderRespDto orderRespDto = new DgAfterSaleOrderRespDto();
        if (ObjectUtil.isNotEmpty((Object)performOrder.getOrderAddrRespDto())) {
            DgPerformOrderAddrRespDto address = performOrder.getOrderAddrRespDto();
            orderRespDto.setAddressId(address.getAddressId());
            orderRespDto.setReturnCityCode(address.getCityCode());
            orderRespDto.setReturnCityName(address.getCity());
            orderRespDto.setReturnProvinceCode(address.getProvinceCode());
            orderRespDto.setReturnProvinceName(address.getProvince());
            orderRespDto.setReturnCountyCode(address.getCountyCode());
            orderRespDto.setReturnCountyName(address.getCounty());
            orderRespDto.setReturnRecipientPhone(address.getReceivePhone());
            orderRespDto.setReturnRecipient(address.getReceiveName());
        }
        orderRespDto.setSaleOrderId(performOrder.getId());
        orderRespDto.setSaleOrderNo(performOrder.getSaleOrderNo());
        orderRespDto.setCustomerId(performOrder.getPerformOrderSnapshotDto().getCustomerId());
        orderRespDto.setCustomerCode(performOrder.getPerformOrderSnapshotDto().getCustomerCode());
        orderRespDto.setCustomerName(performOrder.getPerformOrderSnapshotDto().getCustomerName());
        orderRespDto.setShopId(performOrder.getPerformOrderSnapshotDto().getShopId());
        orderRespDto.setShopCode(performOrder.getPerformOrderSnapshotDto().getShopCode());
        orderRespDto.setShopName(performOrder.getPerformOrderSnapshotDto().getShopName());
        orderRespDto.setRefundMode(this.f2BAfterService.getRefundModeByShop(performOrder.getPerformOrderSnapshotDto().getShopCode(), performOrder.getId(), null));
        orderRespDto.setEnterpriseId(performOrder.getPerformOrderSnapshotDto().getEnterpriseId());
        orderRespDto.setEnterpriseName(performOrder.getPerformOrderSnapshotDto().getEnterpriseName());
        orderRespDto.setEnterpriseCode(performOrder.getPerformOrderSnapshotDto().getEnterpriseName());
        orderRespDto.setSaleCompanyName(orderRespDto.getEnterpriseName());
        orderRespDto.setSaleCompanyCode(orderRespDto.getEnterpriseCode());
        orderRespDto.setOrderReturnableFlag(Boolean.valueOf(true));
        orderRespDto.setReturnBizType(returnBizType);
        List<DgAfterSaleOrderItemRespDto> saleItemList = this.applyPerformOrderAfterItem(performOrder.getId(), orderRespDto.getRefundMode(), orderRespDto);
        AssertUtil.isTrue((boolean)CollectionUtils.isEmpty(saleItemList), (String)"-1", (String)"\u65e0\u53ef\u7533\u8bf7\u552e\u540e\u7684\u5546\u54c1");
        orderRespDto.setItemRespDtoList(saleItemList);
        return orderRespDto;
    }

    @Override
    public List<DgAfterSaleOrderItemRespDto> applyPerformOrderAfterItem(Long performOrderId, String refundMode, DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        logger.info("\u8ba2\u8d27\u5355\u7533\u8bf7\u552e\u540e\u5546\u54c1\u4fe1\u606f\uff1a{}\uff0c{}", (Object)performOrderId, (Object)refundMode);
        List performOrderLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.performOrderLineDomain.filter().eq((Object)"order_id", (Object)performOrderId)).eq((Object)"dr", (Object)0)).list();
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)performOrderLineEos), (String)"-1", (String)"\u627e\u4e0d\u5230\u8ba2\u8d27\u5355\u5546\u54c1\u4fe1\u606f");
        logger.info("\u83b7\u53d6\u8ba2\u8d27\u5355\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JacksonUtil.toJson((Object)performOrderLineEos));
        List dgPerformOrderLineAmountDtos = this.lineAmountDomain.queryByOrderId(performOrderId);
        Map<Long, List<DgPerformOrderLineAmountDto>> dgPerformOrderLineAmountMap = dgPerformOrderLineAmountDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getOrderLineId));
        String orderNo = ((DgPerformOrderLineEo)performOrderLineEos.get(0)).getOrderNo();
        List<Long> supplySplitOrderIds = this.performOrderInfoDomain.querySplitEoByPlatformOrderNo(orderNo).stream().map(BaseEo::getId).collect(Collectors.toList());
        List supplyOrderLineList = ((ExtQueryChainWrapper)this.performOrderLineDomain.filter().in((Object)"order_id", supplySplitOrderIds)).list();
        Map<Long, List<DgPerformOrderItemLineDto>> supplyOrderNoCancelItemLineMap = this.getSupplyOrderNoCancelItemLineMap(supplySplitOrderIds);
        Map<Long, List<DgPerformOrderItemLineAmountDto>> supplyOrderNoCancelItemLineAmountMapByChannel = this.getNoCancelItemLineAmountMapByChannel(supplyOrderLineList, supplyOrderNoCancelItemLineMap);
        Map<Long, List<DgPerformOrderItemLineDto>> supplyOrderNoCancelItemLineMapByChannel = this.getNoCancelItemLineMapByChannel(supplyOrderLineList, supplyOrderNoCancelItemLineMap);
        List dgPerformOrderLinePayAmountEos = Lists.newArrayList();
        if (refundMode.equals(DgF2BAfterRefundModeEnum.KNEAD.getCode())) {
            dgPerformOrderLinePayAmountEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.lineAmountDomain.filter().eq((Object)"order_id", (Object)performOrderId)).eq((Object)"amount_source", (Object)DgOrderAmountSourceEnum.KNEAD.getCode())).in((Object)"account_category", (Collection)Lists.newArrayList((Object[])new String[]{AccountCategoryEnum.CAPITAL.getCode(), AccountCategoryEnum.COST.getCode()}))).list();
        } else if (refundMode.equals(DgF2BAfterRefundModeEnum.ORDER.getCode())) {
            dgPerformOrderLinePayAmountEos = this.lineAmountDomain.queryByOrderIdAndSources(performOrderId, Arrays.asList(DgOrderAmountSourceEnum.ORDER_LINE_AMOUNT.getCode(), DgOrderAmountSourceEnum.COST.getCode()));
        }
        List dgPerformOrderLinePayAmountDtos = BeanUtil.copyToList((Collection)dgPerformOrderLinePayAmountEos, DgPerformOrderLineAmountDto.class);
        List accountTypes = dgPerformOrderLinePayAmountDtos.stream().map(DgPerformOrderLineAmountDto::getAccountType).collect(Collectors.toList());
        List accountTypeDtos = (List)RestResponseHelper.extractData((RestResponse)this.accountTypeApi.queryByCodes(accountTypes));
        Map<String, String> accountCategoryNameMap = accountTypeDtos.stream().collect(Collectors.toMap(AccountTypeDto::getAccountTypeCode, AccountTypeDto::getDefName, (v1, v2) -> v2));
        logger.info("\u83b7\u53d6\u8ba2\u8d27\u5355\u4ed8\u6b3e\u4fe1\u606f\uff1a{}", accountCategoryNameMap);
        for (DgPerformOrderLineAmountDto dgPerformOrderLinePayAmountDto : dgPerformOrderLinePayAmountDtos) {
            String s = accountCategoryNameMap.get(dgPerformOrderLinePayAmountDto.getAccountType());
            dgPerformOrderLinePayAmountDto.setAccountTypeName(s);
        }
        List<DgAfterSaleOrderItemEo> returnedAfterItemList = this.getReturnedAfterItem(performOrderId);
        Map<Long, List<DgAfterSaleOrderItemEo>> returnedItemNumMap = returnedAfterItemList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemEo::getSaleOrderItemId));
        List<DgAfterSaleOrderItemRespDto> collect = performOrderLineEos.stream().map(performOrderLine -> {
            List<DgPerformOrderLineAmountDto> origPromotionDiscountAmountList;
            Long performOrderLineId = performOrderLine.getId();
            List thisOrderLineAmountDtos = (List)dgPerformOrderLineAmountMap.get(performOrderLineId);
            Map<String, List<DgPerformOrderLineAmountDto>> thisLineAmountMap = thisOrderLineAmountDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountDto::getAccountType));
            BigDecimal calcItemNum = Optional.ofNullable(performOrderLine.getCalcItemNum()).orElse(performOrderLine.getItemNum());
            BigDecimal itemNum = performOrderLine.getItemNum();
            BigDecimal scale = calcItemNum.divide(itemNum, 2, RoundingMode.HALF_UP);
            DgAfterSaleOrderItemRespDto itemRespDto = this.buildAfterSaleOrderItem((DgPerformOrderLineEo)performOrderLine, performOrderLineId);
            List noCancelOrderItemLineDtos = (List)supplyOrderNoCancelItemLineMapByChannel.get(performOrderLineId);
            logger.info("\u5546\u54c1:{}\u8be5\u8ba2\u5355\u884c\u672a\u53d6\u6d88\u7684\u4f9b\u5e94\u94fe\u5546\u54c1\u884c\uff1a{}", (Object)performOrderLine.getSkuCode(), (Object)JSON.toJSONString((Object)noCancelOrderItemLineDtos));
            BigDecimal noCancelItemNum = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)noCancelOrderItemLineDtos)) {
                noCancelItemNum = noCancelOrderItemLineDtos.stream().map(DgPerformOrderItemLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                logger.info("\u5546\u54c1:{}\u8be5\u5546\u54c1\u672a\u53d6\u6d88\u7684\u4f9b\u5e94\u94fe\u5546\u54c1\u884c\u7684\u5546\u54c1\u6570\u91cf(\u8ba1\u4ef7\u6570\u91cf)\uff1a{}", (Object)performOrderLine.getSkuCode(), (Object)noCancelItemNum);
            }
            List returnedAfterItemEoList = Optional.ofNullable(returnedItemNumMap.get(performOrderLineId)).orElse(Lists.newArrayList());
            Integer returnedNum = returnedAfterItemEoList.stream().map(DgAfterSaleOrderItemEo::getReturnedNum).reduce(0, Integer::sum);
            logger.info("\u5546\u54c1:{}\u8be5\u5546\u54c1\u5df2\u53d1\u8d77\u552e\u540e\u7684\u5546\u54c1\u884c\u7684\u6570\u91cf\uff1a{}", (Object)performOrderLine.getSkuCode(), (Object)returnedNum);
            BigDecimal returnedRefundAmount = returnedAfterItemEoList.stream().map(DgAfterSaleOrderItemEo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("\u5546\u54c1:{}\u8be5\u5546\u54c1\u5df2\u53d1\u8d77\u552e\u540e\u7684\u5546\u54c1\u884c\u7684\u7533\u8bf7\u9000\u6b3e\u91d1\u989d\uff1a{}", (Object)performOrderLine.getSkuCode(), (Object)returnedRefundAmount);
            Integer allowReturnNum = noCancelItemNum.subtract(BigDecimal.valueOf(returnedNum.intValue())).intValue();
            logger.info("\u5546\u54c1:{}\u53ef\u9000\u6570\u91cf\uff1a{}", (Object)performOrderLine.getSkuCode(), (Object)allowReturnNum);
            itemRespDto.setAllowReturnNum(allowReturnNum);
            itemRespDto.setOrigOrderItemNum(Integer.valueOf(calcItemNum.intValue()));
            List<DgPerformOrderLineAmountDto> saleAmountList = thisLineAmountMap.get(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode());
            if (CollectionUtils.isNotEmpty(saleAmountList)) {
                BigDecimal saleAmount = saleAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                itemRespDto.setOrigSaleAmount(saleAmount);
            }
            if (CollectionUtils.isNotEmpty(origPromotionDiscountAmountList = thisLineAmountMap.get(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode()))) {
                BigDecimal promotionDiscountAmount = origPromotionDiscountAmountList.stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                itemRespDto.setOrigPromotionDiscountAmount(promotionDiscountAmount);
            }
            itemRespDto.setOrigPromotionDiscountAmount(performOrderLine.getPromotionDiscountAmount());
            BigDecimal noCancelTransaction = this.getNoCancelTransactionAmount(supplyOrderNoCancelItemLineAmountMapByChannel, performOrderLineId, refundMode);
            BigDecimal transactionTotal = this.getOrigOrderAmount((DgPerformOrderLineEo)performOrderLine, thisLineAmountMap, refundMode);
            itemRespDto.setOrigOrderAmount(transactionTotal);
            List<ItemPayRecordDto> origOrderCostDetail = this.getOrigOrderCostDetail(performOrderLineId, dgPerformOrderLinePayAmountDtos);
            itemRespDto.setOrigOrderCostDetail(origOrderCostDetail);
            if (itemRespDto.getAllowReturnNum() <= 0) {
                itemRespDto.setAllowReturnAmount(BigDecimal.ZERO);
            } else {
                BigDecimal allowReturnAmount = BigDecimal.ZERO;
                allowReturnAmount = noCancelTransaction.subtract(returnedRefundAmount);
                logger.info("\u5546\u54c1:{},\u539f\u8ba2\u8d27\u5355\u672a\u53d6\u6d88\u7684\u5546\u54c1\u884c\u603b\u6210\u4ea4\u91d1\u989d\uff1a{}, \u8be5\u5546\u54c1\u5df2\u53d1\u8d77\u552e\u540e\u7684\u5546\u54c1\u884c\u7684\u7533\u8bf7\u9000\u6b3e\u91d1\u989d: {}", new Object[]{performOrderLine.getSkuCode(), allowReturnAmount, returnedRefundAmount});
                itemRespDto.setAllowReturnAmount(allowReturnAmount);
            }
            logger.info("\u8ba2\u8d27\u5355\u7533\u8bf7\u552e\u540e\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JacksonUtil.toJson((Object)itemRespDto));
            AssertUtil.isTrue((itemRespDto.getAllowReturnAmount().compareTo(BigDecimal.ZERO) < 0 ? 1 : 0) != 0, (String)"-1", (String)"\u53ef\u9000\u91d1\u989d\u8ba1\u7b97\u5f02\u5e38\uff0c\u53ef\u9000\u91d1\u989d\u5c0f\u4e8e0");
            return itemRespDto;
        }).collect(Collectors.toList());
        return this.returnableCheck(performOrderId, dgPerformOrderLineAmountMap, collect, afterSaleOrderRespDto);
    }

    @Override
    public Map<Long, List<DgPerformOrderItemLineDto>> getSupplyOrderNoCancelItemLineMap(List<Long> supplySplitOrderIds) {
        List supplyOrderNoCancelItemLineList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().in((Object)"order_id", supplySplitOrderIds)).eq((Object)"delivery_status", (Object)YesNoEnum.YES.getValue())).list();
        List supplyOrderNoCancelItemLineDtoList = BeanUtil.copyToList((Collection)supplyOrderNoCancelItemLineList, DgPerformOrderItemLineDto.class);
        Map<Long, List<DgPerformOrderItemLineDto>> supplyOrderNoCancelItemLineMap = supplyOrderNoCancelItemLineDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        return supplyOrderNoCancelItemLineMap;
    }

    @Override
    public Map<Long, List<DgPerformOrderItemLineDto>> getNoCancelItemLineMapByChannel(List<DgPerformOrderLineEo> supplyOrderLineList, Map<Long, List<DgPerformOrderItemLineDto>> supplyOrderNoCancelItemLineMap) {
        HashMap<Long, List<DgPerformOrderItemLineDto>> supplyOrderNoCancelItemLineMapByChannel = new HashMap<Long, List<DgPerformOrderItemLineDto>>();
        for (DgPerformOrderLineEo supplyOrderLine : supplyOrderLineList) {
            List<DgPerformOrderItemLineDto> supplyOrderNoCancelItemLineDtos = supplyOrderNoCancelItemLineMap.get(supplyOrderLine.getId());
            if (!CollectionUtils.isNotEmpty(supplyOrderNoCancelItemLineDtos)) continue;
            supplyOrderNoCancelItemLineMapByChannel.compute(Long.valueOf(supplyOrderLine.getPlatformOrderItemNo()), (key, oldValue) -> {
                if (oldValue == null) {
                    oldValue = new ArrayList();
                }
                oldValue.addAll(supplyOrderNoCancelItemLineDtos);
                return oldValue;
            });
        }
        return supplyOrderNoCancelItemLineMapByChannel;
    }

    @Override
    public void syncApplyToChannelAfterOrder(DgAfterSaleOrderDto request) {
        logger.info("\u672a\u53d1\u8d27\u9000\u8d27\uff0c\u540c\u6b65\u4f9b\u5e94\u94fe\u9500\u552e\u9000\u5165\u5e93\u4fe1\u606f\u5230\u6e20\u9053\u552e\u540e\u5355-DgAfterSaleOrderDto:{}", (Object)JSON.toJSONString((Object)request));
        Map syncAfterItemMap = request.getItemDtoList().stream().collect(Collectors.toMap(DgAfterSaleOrderItemDto::getPlatformRefundItemId, Function.identity(), (k1, k2) -> k1));
        DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = this.afterSaleOrderDomain.queryById(Long.valueOf(request.getPlatformRefundOrderId()));
        List dgAfterSaleOrderItemRespDtoList = this.dgAfterSaleOrderItemDomain.queryByAfterSaleOrderId(dgAfterSaleOrderRespDto.getId());
        ArrayList<DgAfterSaleOrderItemDto> updateList = new ArrayList<DgAfterSaleOrderItemDto>();
        dgAfterSaleOrderItemRespDtoList.forEach(dto -> {
            DgAfterSaleOrderItemDto syncAfterItem = (DgAfterSaleOrderItemDto)syncAfterItemMap.get(dto.getId());
            DgAfterSaleOrderItemRespDto afterSaleOrderItemDto = new DgAfterSaleOrderItemRespDto();
            afterSaleOrderItemDto.setId(dto.getId());
            if (ObjectUtil.isNotEmpty((Object)syncAfterItem)) {
                logger.info("\u66f4\u65b0\u9000\u8d27\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)syncAfterItem));
                afterSaleOrderItemDto.setCustomerConfirmReceiveNum(new BigDecimal(syncAfterItem.getActualReturnNum()));
                afterSaleOrderItemDto.setReceiveNum(new BigDecimal(syncAfterItem.getActualReturnNum()));
                if (dgAfterSaleOrderRespDto.getBizType().equals(YesNoEnum.YES.getValue().toString())) {
                    afterSaleOrderItemDto.setActualReturnNum(syncAfterItem.getActualReturnNum());
                    afterSaleOrderItemDto.setActualRefundPrice(syncAfterItem.getActualRefundPrice());
                    afterSaleOrderItemDto.setActualRefundAmount(syncAfterItem.getActualRefundAmount());
                }
                updateList.add((DgAfterSaleOrderItemDto)afterSaleOrderItemDto);
            } else {
                logger.info("\u627e\u4e0d\u5230\u540c\u6b65\u5546\u54c1\u4fe1\u606f");
                afterSaleOrderItemDto.setCustomerConfirmReceiveNum(BigDecimal.ZERO);
                afterSaleOrderItemDto.setReceiveNum(BigDecimal.ZERO);
                if (dgAfterSaleOrderRespDto.getBizType().equals(YesNoEnum.YES.getValue().toString())) {
                    afterSaleOrderItemDto.setActualReturnNum(Integer.valueOf(0));
                    afterSaleOrderItemDto.setActualRefundPrice(BigDecimal.ZERO);
                    afterSaleOrderItemDto.setActualRefundAmount(BigDecimal.ZERO);
                }
            }
        });
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.dgAfterSaleOrderItemService.updateBatchById(updateList);
        }
    }

    @Override
    public void channelCompleteUpdateSaleReturn(DgAfterSaleOrderDto dto) {
        List dgAfterSaleOrderEos = this.afterSaleOrderDomain.queryEosByPlatformRefundOrderSn(dto.getAfterSaleOrderNo());
        List afterSaleOrderItemRespDtos = this.dgAfterSaleOrderItemDomain.queryByAfterSaleOrderId(dto.getId());
        List collect = dgAfterSaleOrderEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        Map<Long, List<DgAfterSaleOrderItemRespDto>> applyAfterSaleOrderItemEoMap = this.dgAfterSaleOrderItemDomain.queryByAfterSaleOrderIds(collect).stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemDto::getPlatformRefundItemId));
        ArrayList updateApplyItemRespDtos = Lists.newArrayList();
        for (DgAfterSaleOrderItemRespDto afterSaleOrderItemRespDto : afterSaleOrderItemRespDtos) {
            List<DgAfterSaleOrderItemRespDto> applyItemRespDtos = Optional.ofNullable(applyAfterSaleOrderItemEoMap.get(afterSaleOrderItemRespDto.getId())).orElse(Lists.newArrayList());
            Iterator<DgAfterSaleOrderItemRespDto> iterator = applyItemRespDtos.iterator();
            BigDecimal totalSettlementAmount = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                DgAfterSaleOrderItemRespDto applyItemRespDto = iterator.next();
                if (!iterator.hasNext()) {
                    applyItemRespDto.setSettlementAmount(afterSaleOrderItemRespDto.getSettlementAmount().subtract(totalSettlementAmount));
                    continue;
                }
                applyItemRespDto.setSettlementAmount(afterSaleOrderItemRespDto.getSettlementAmount().multiply(BigDecimal.valueOf(applyItemRespDto.getActualReturnNum().intValue()).divide(BigDecimal.valueOf(applyItemRespDto.getActualReturnNum().intValue()), 2, 4)));
                totalSettlementAmount = totalSettlementAmount.add(applyItemRespDto.getSettlementAmount());
            }
            updateApplyItemRespDtos.addAll(applyItemRespDtos);
        }
        logger.info("\u6e20\u9053\u9000\u8d27\u5355\u5546\u54c1\u884c\uff1a{}\uff0c\u4f9b\u5e94\u94fe\u5546\u54c1\u884c\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)afterSaleOrderItemRespDtos), (Object)JSON.toJSONString((Object)updateApplyItemRespDtos));
        List itemDtoList = BeanUtil.copyToList((Collection)updateApplyItemRespDtos, DgAfterSaleOrderItemDto.class);
        this.dgAfterSaleOrderItemService.updateBatchById(itemDtoList);
    }

    @Override
    public Map<Long, List<DgPerformOrderItemLineAmountDto>> getNoCancelItemLineAmountMapByChannel(List<DgPerformOrderLineEo> supplyOrderLineList, Map<Long, List<DgPerformOrderItemLineDto>> supplyOrderNoCancelItemLineMap) {
        HashMap<Long, List<DgPerformOrderItemLineAmountDto>> supplyOrderNoCancelItemLineAmountMapByChannel = new HashMap<Long, List<DgPerformOrderItemLineAmountDto>>();
        for (DgPerformOrderLineEo supplyOrderLine : supplyOrderLineList) {
            List<DgPerformOrderItemLineDto> supplyOrderNoCancelItemLineDtos = supplyOrderNoCancelItemLineMap.get(supplyOrderLine.getId());
            if (!CollectionUtils.isNotEmpty(supplyOrderNoCancelItemLineDtos)) continue;
            List supplyNoCancelItemLineIds = supplyOrderNoCancelItemLineDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
            List supplyOrderNoCancelItemLineAmountDtos = this.itemLineAmountDomain.queryByOrderItemLineIds(supplyNoCancelItemLineIds);
            supplyOrderNoCancelItemLineAmountMapByChannel.compute(Long.valueOf(supplyOrderLine.getPlatformOrderItemNo()), (key, oldValue) -> {
                if (oldValue == null) {
                    oldValue = new ArrayList();
                }
                oldValue.addAll(supplyOrderNoCancelItemLineAmountDtos);
                return oldValue;
            });
        }
        return supplyOrderNoCancelItemLineAmountMapByChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public long addAfterSaleApplyOfOriginal(DgAfterSaleOrderDto dto) {
        long l;
        block4: {
            logger.info("\u65b0\u589e\u539f\u5355\u9000\u8d27\u5355\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            AssertUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getSaleOrderNo()), (String)"-1", (String)"\u6ca1\u6709\u5173\u8054\u539f\u5355\uff0csaleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            Mutex lock = null;
            try {
                lock = this.lockService.lock("addAfterSaleApplyOfOriginal", dto.getSaleOrderNo(), 10, 15, TimeUnit.SECONDS);
                if (null == lock) {
                    throw new BizException("-1", "\u7533\u8bf7\u539f\u5355\u9000\u8d27\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5f02\u5e38");
                }
                dto.setRelateToPlatformOrder(Integer.valueOf(0));
                String msg = this.checkOriginalAfterItemNum(dto);
                AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)msg), (String)"-1", (String)("\u7533\u8bf7\u539f\u5355\u9000\u8d27\u5931\u8d25\uff0c\u9000\u8d27\u5546\u54c1\u4e0d\u8db3\uff1a" + msg));
                DgAfterSaleOrderEo orderEo = this.createAfterSaleOrderOfOriginal(dto);
                orderEo.setStatus(DgF2BAfterStatus.WAIT_AUDIT.getCode());
                DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
                afterSaleOrderRespDto.setId(orderEo.getId());
                l = orderEo.getId();
                if (null == lock) break block4;
            }
            catch (Throwable throwable) {
                if (null != lock) {
                    this.lockService.unlock(lock);
                }
                throw throwable;
            }
            this.lockService.unlock(lock);
        }
        return l;
    }

    @NotNull
    private DgAfterSaleOrderEo createAfterSaleOrderOfOriginal(DgAfterSaleOrderDto dto) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoByOrderNo(dto.getSaleOrderNo());
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)performOrderRespDto), (String)"-1", (String)"\u627e\u4e0d\u5230\u8ba2\u8d27\u5355\u4fe1\u606f");
        if (dto.getUnshippedReturn() == 1) {
            AssertUtil.isTrue((!performOrderRespDto.getOrderStatus().equals(DgF2BOrderStatus.WAIT_OUT_STORAGE.getCode()) && !performOrderRespDto.getOrderStatus().equals(DgF2BOrderStatus.ALL_DELIVERY.getCode()) ? 1 : 0) != 0, (String)"-1", (String)"\u7533\u8bf7\u672a\u53d1\u8d27\u9000\u8d27\u5931\u8d25\uff0c\u8ba2\u8d27\u5355\u975e\u5f85\u53d1\u8d27\u6216\u5f85\u7b7e\u6536");
        } else {
            AssertUtil.isTrue((!performOrderRespDto.getOrderStatus().equals(DgF2BOrderStatus.ALL_DELIVERY.getCode()) && !performOrderRespDto.getOrderStatus().equals(DgF2BOrderStatus.CONFIRM.getCode()) ? 1 : 0) != 0, (String)"-1", (String)"\u7533\u8bf7\u539f\u5355\u9000\u8d27\u5931\u8d25\uff0c\u8ba2\u8d27\u5355\u975e\u5df2\u5b8c\u6210\u6216\u5f85\u7b7e\u6536");
        }
        dto.setSaleOrderId(performOrderRespDto.getId());
        dto.setShopId(performOrderRespDto.getPerformOrderSnapshotDto().getShopId());
        dto.setShopName(performOrderRespDto.getPerformOrderSnapshotDto().getShopName());
        dto.setShopCode(performOrderRespDto.getPerformOrderSnapshotDto().getShopCode());
        dto.setCustomerId(performOrderRespDto.getPerformOrderSnapshotDto().getCustomerId());
        dto.setCustomerCode(performOrderRespDto.getPerformOrderSnapshotDto().getCustomerCode());
        dto.setCustomerName(performOrderRespDto.getPerformOrderSnapshotDto().getCustomerName());
        dto.setAfterSaleOrderNo(this.noGreateUtil.generateThOrderNo());
        dto.setEnterpriseId(performOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseId());
        dto.setEnterpriseName(performOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseName());
        dto.setEnterpriseCode(performOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode());
        dto.setEnterpriseId(performOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseId());
        dto.setEnterpriseName(performOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseName());
        dto.setEnterpriseCode(performOrderRespDto.getPerformOrderSnapshotDto().getEnterpriseCode());
        DgAfterSaleOrderEo orderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)orderEo, (Object)dto, (String[])new String[0]);
        orderEo.setStorageStatus(DgF2BAfterStorageStatus.WAIT_IN.getCode());
        orderEo.setRelateToPlatformOrder(Integer.valueOf(0));
        orderEo.setBizModel(DgAfterSaleOrderBizModelEnum.F2B.getCode());
        orderEo.setCustomerBatch(performOrderRespDto.getPerformOrderExtensionDto().getCustomerBatch());
        List dgPerformOrderLineEos = ((ExtQueryChainWrapper)this.dgPerformOrderLineDomain.filter().eq((Object)"order_id", (Object)dto.getSaleOrderId())).list();
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)dgPerformOrderLineEos), (String)"-1", (String)"\u627e\u4e0d\u5230\u8ba2\u8d27\u5355\u5546\u54c1\u660e\u7ec6");
        Map<Long, DgPerformOrderLineEo> orderItemMap = dgPerformOrderLineEos.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
        List<DgAfterSaleOrderItemEo> itemEoList = dto.getItemDtoList().stream().map(item -> {
            AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)item.getSaleOrderItemId()), (String)"-1", (String)"\u9000\u8d27\u5546\u54c1saleOrderItemId\u4e0d\u80fd\u4e3a\u7a7a");
            DgPerformOrderLineEo orderLineEo = (DgPerformOrderLineEo)orderItemMap.get(item.getSaleOrderItemId());
            AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)orderLineEo), (String)"-1", (String)"\u9000\u8d27\u5546\u54c1saleOrderItemId\u4e0d\u80fd\u4e3a\u7a7a");
            item.setSkuId(orderLineEo.getSkuId());
            item.setSkuCode(orderLineEo.getSkuCode());
            item.setSkuName(orderLineEo.getSkuName());
            item.setImgUrl(orderLineEo.getImgUrl());
            if (Objects.nonNull(orderLineEo.getCalcUnit())) {
                item.setUnit(orderLineEo.getCalcUnit());
                item.setItemUnit(orderLineEo.getCalcUnitDesc());
            } else {
                item.setUnit(orderLineEo.getBasicUnit());
                item.setItemUnit(orderLineEo.getBasicUnitName());
            }
            item.setCalcUnit(orderLineEo.getCalcUnit());
            item.setCalcUnitDesc(orderLineEo.getCalcUnitDesc());
            if (Objects.equals(item.getReturnNum(), item.getAllowReturnNum())) {
                item.setRefundAmount(item.getAllowReturnAmount().setScale(2, RoundingMode.HALF_UP));
                item.setRefundPrice(item.getRefundAmount().divide(BigDecimal.valueOf(item.getReturnNum().intValue()), 2, RoundingMode.HALF_UP));
            } else {
                BigDecimal returnAmount = BigDecimal.valueOf(item.getReturnNum().intValue()).multiply(Optional.ofNullable(item.getOrigOrderAmount()).orElse(BigDecimal.ZERO)).divide(Optional.ofNullable(orderLineEo.getCalcItemNum()).orElse(orderLineEo.getItemNum()), 2, RoundingMode.HALF_UP);
                item.setRefundAmount(returnAmount.setScale(2, RoundingMode.HALF_UP));
                item.setRefundPrice(returnAmount.divide(BigDecimal.valueOf(item.getReturnNum().intValue()), 2, RoundingMode.HALF_UP));
            }
            if (dto.getBizType().equals("2")) {
                logger.info("\u5982\u679c\u4e3a\u76f4\u8425\u9000\u8d27\u5219\u66f4\u65b0\u5b9e\u9000\u5355\u4ef7\u548c\u5b9e\u9000\u91d1\u989d");
                item.setActualRefundPrice(item.getRefundPrice().setScale(2, RoundingMode.HALF_UP));
                item.setActualRefundAmount(item.getRefundAmount().setScale(2, RoundingMode.HALF_UP));
            }
            item.setSalePrice(orderLineEo.getSalePrice());
            item.setGift(orderLineEo.getGiftFlag());
            item.setSaleOrderItemId(orderLineEo.getId());
            item.setReturnedNum(Integer.valueOf(BigDecimal.ZERO.intValue()));
            DgAfterSaleOrderItemEo itemEo = new DgAfterSaleOrderItemEo();
            CubeBeanUtils.copyProperties((Object)itemEo, (Object)item, (String[])new String[0]);
            return itemEo;
        }).collect(Collectors.toList());
        orderEo.setApplyReturnQty(Long.valueOf(itemEoList.stream().mapToInt(DgAfterSaleOrderItemEo::getReturnNum).sum()));
        orderEo.setOriginalRefundFee(itemEoList.stream().map(DgAfterSaleOrderItemEo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        dto.setOriginalRefundFee(orderEo.getOriginalRefundFee());
        this.dgAfterSaleOrderDomain.insert((BaseEo)orderEo);
        this.dgAfterSaleOrderReturnAddressDomain.saveRerurnAddress(orderEo.getId(), dto);
        this.dgAfterSaleOrderLogisticsWarehouseDomain.saveLogisticsWarehouse(orderEo.getId(), dto);
        this.dgAfterSaleOrderExchangeAddressDomain.saveExchangeAddress(orderEo.getId(), dto);
        itemEoList.forEach(item -> item.setAfterSaleOrderId(orderEo.getId()));
        this.dgAfterSaleOrderItemDas.insertBatch(itemEoList);
        this.judgePakegeNumLabel(dto, orderEo, itemEoList);
        List attachmentList = dto.getAttachmentList();
        List attachementEos = BeanUtil.copyToList((Collection)attachmentList, AttachementEo.class);
        this.attachementDomain.logicDeleteAndSaveReturnAttachment(orderEo.getAfterSaleOrderNo(), attachementEos, OptBizTypeEnum.RETURN.getType());
        this.attachementDomain.saveReceivingReportAttachment(orderEo.getAfterSaleOrderNo(), dto.getReceivingReportList());
        this.saveStatusLog(orderEo);
        return orderEo;
    }

    @Override
    public void saveStatusLog(DgAfterSaleOrderEo afterSaleOrderEo) {
        DgAfterSaleOrderEo updateEo = new DgAfterSaleOrderEo();
        updateEo.setId(afterSaleOrderEo.getId());
        String orderSteps = afterSaleOrderEo.getAfterSaleOrderSteps();
        List<DgOrderStatusLogRespDto> orderStatusLogRespDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
        }
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderEo.getStatus())) {
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(afterSaleOrderEo.getStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDto.setOptPerson((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"system"));
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            boolean b = orderStatusLogRespDtos.stream().map(DgOrderStatusLogRespDto::getOrderStatus).anyMatch(orderStatus -> orderStatus.equals(DgF2BAfterStatus.WAIT_CHECK.getCode()));
            if (!b) {
                DgOrderStatusLogRespDto waitCheckLog = new DgOrderStatusLogRespDto();
                waitCheckLog.setOrderStatus(DgF2BAfterStatus.WAIT_CHECK.getCode());
                waitCheckLog.setOptDate(afterSaleOrderEo.getCreateTime());
                waitCheckLog.setOptPerson((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"system"));
                orderStatusLogRespDtos.add(waitCheckLog);
            }
            updateEo.setAfterSaleOrderSteps(JSON.toJSONString(orderStatusLogRespDtos));
        }
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)updateEo);
    }

    private void judgePakegeNumLabel(DgAfterSaleOrderDto dto, DgAfterSaleOrderEo orderEo, List<DgAfterSaleOrderItemEo> itemEoList) {
        List skuCodeList = itemEoList.stream().map(DgAfterSaleOrderItemEo::getSkuCode).collect(Collectors.toList());
        ShopItemQueryDgReqDto shopItemQueryDgReqDto = new ShopItemQueryDgReqDto();
        shopItemQueryDgReqDto.setSkuCodes(skuCodeList);
        shopItemQueryDgReqDto.setShopIdList(Lists.list((Object[])new Long[]{dto.getShopId()}));
        List skuList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryItemShopListByPage(shopItemQueryDgReqDto))).getList();
        Map<String, BigDecimal> packageNumMap = skuList.stream().filter(e -> Objects.nonNull(e.getPackageNum())).collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, DgItemSkuRespDto::getPackageNum));
        ArrayList labelItemReq = Lists.newArrayList();
        for (DgAfterSaleOrderItemEo item : itemEoList) {
            if (!ObjectUtil.isNotEmpty((Object)packageNumMap.get(item.getSkuCode()))) continue;
            int packageNum = Integer.parseInt(packageNumMap.get(item.getSkuCode()).toString());
            if (item.getReturnNum().compareTo(packageNum) <= 0) continue;
            DgOrderLabelItemDto dgOrderLabelItemDto = new DgOrderLabelItemDto();
            dgOrderLabelItemDto.setOrderId(orderEo.getId());
            dgOrderLabelItemDto.setOrderItemId(item.getId());
            dgOrderLabelItemDto.setLabelCode(DgOrderLabelEnum.F2B_AFTER_SALE_EXCESS_ITEM.getCode());
            dgOrderLabelItemDto.setSkuCode(item.getSkuCode());
            dgOrderLabelItemDto.setDisplay(Integer.valueOf(0));
            labelItemReq.add(dgOrderLabelItemDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)labelItemReq)) {
            this.orderLabelItemDomain.addOrderLabelItems((List)labelItemReq);
            this.orderLabelRecordDomain.addOrderLabelRecord(orderEo.getId(), DgOrderLabelEnum.F2B_AFTER_SALE_EXCESS);
        }
    }

    private String checkOriginalAfterItemNum(DgAfterSaleOrderDto dto) {
        logger.info("\u6821\u9a8c\u539f\u5355\u9000\u8d27\u7533\u8bf7\u7684\u6570\u91cf\u662f\u5426\u8d85\u989d\uff1a{}", (Object)JacksonUtil.toJson((Object)dto));
        StringBuffer str = new StringBuffer("");
        List<Long> supplySplitOrderIds = this.performOrderInfoDomain.querySplitEoByPlatformOrderNo(dto.getSaleOrderNo()).stream().map(BaseEo::getId).collect(Collectors.toList());
        List supplyOrderLineList = ((ExtQueryChainWrapper)this.performOrderLineDomain.filter().in((Object)"order_id", supplySplitOrderIds)).list();
        Map<Long, List<DgPerformOrderItemLineDto>> supplyOrderNoCancelItemLineMap = this.getSupplyOrderNoCancelItemLineMap(supplySplitOrderIds);
        Map<Long, List<DgPerformOrderItemLineDto>> supplyOrderNoCancelItemLineMapByChannel = this.getNoCancelItemLineMapByChannel(supplyOrderLineList, supplyOrderNoCancelItemLineMap);
        logger.info("\u8be5\u8ba2\u8d27\u5355\u672a\u53d6\u6d88\u7684\u5546\u54c1\u884c\uff1a{}", (Object)JSON.toJSONString(supplyOrderNoCancelItemLineMapByChannel));
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty(supplyOrderNoCancelItemLineMapByChannel), (String)"-1", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53ef\u9000\u8ba2\u8d27\u5355\u5546\u54c1\u4fe1\u606f");
        List<DgAfterSaleOrderItemEo> returnedAfterItemList = this.getReturnedAfterItem(dto.getSaleOrderId());
        Map<Long, List<DgAfterSaleOrderItemEo>> returnedItemNumMap = returnedAfterItemList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemEo::getSaleOrderItemId));
        dto.getItemDtoList().forEach(afterItem -> {
            Long saleOrderItemId = afterItem.getSaleOrderItemId();
            List performOrderItemLineDtoList = (List)supplyOrderNoCancelItemLineMapByChannel.get(saleOrderItemId);
            List afterSaleOrderItemEos = (List)returnedItemNumMap.get(saleOrderItemId);
            Integer returnedItemNum = 0;
            if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderItemEos)) {
                returnedItemNum = afterSaleOrderItemEos.stream().map(DgAfterSaleOrderItemEo::getReturnedNum).reduce(0, Integer::sum);
            }
            AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)performOrderItemLineDtoList), (String)"-1", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u8d27\u5355\u5546\u54c1\u4fe1\u606f");
            BigDecimal allowReturnNum = performOrderItemLineDtoList.stream().map(DgPerformOrderItemLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add).subtract(BigDecimal.valueOf(returnedItemNum.intValue()));
            if (new BigDecimal(afterItem.getReturnNum()).compareTo(allowReturnNum) > 0) {
                str.append(afterItem.getItemCode()).append("\u53ef\u9000\u6570\u91cf\u4e3a\uff1a").append(allowReturnNum).append("\uff1b");
            }
        });
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long saveAfterSaleApplyOfOriginal(DgAfterSaleOrderDto dto) {
        long l;
        block4: {
            logger.info("\u65b0\u589e\u539f\u5355\u9000\u8d27\u5355\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            AssertUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getSaleOrderNo()), (String)"-1", (String)"\u6ca1\u6709\u5173\u8054\u539f\u5355\uff0csaleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            Mutex lock = null;
            try {
                lock = this.lockService.lock("addaftersaleapplyoforiginal", dto.getSaleOrderNo(), 10, 15, TimeUnit.SECONDS);
                if (null == lock) {
                    throw new BizException("-1", "\u7533\u8bf7\u539f\u5355\u9000\u8d27\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5f02\u5e38");
                }
                DgAfterSaleOrderEo orderEo = this.createAfterSaleOrderOfOriginal(dto);
                DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
                afterSaleOrderRespDto.setId(orderEo.getId());
                l = orderEo.getId();
                if (null == lock) break block4;
            }
            catch (Throwable throwable) {
                if (null != lock) {
                    this.lockService.unlock(lock);
                }
                throw throwable;
            }
            this.lockService.unlock(lock);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addAfterSaleApplyOfNotOriginal(DgAfterSaleOrderDto dto) {
        long l;
        block7: {
            logger.info("\u65b0\u589e\u65e0\u539f\u5355\u9000\u8d27\u5355\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            Mutex lock = null;
            try {
                lock = this.lockService.lock("addaftersaleapplyoforiginal", dto.getCustomerCode() + "-" + dto.getShopCode(), 10, 15, TimeUnit.SECONDS);
                if (null == lock) {
                    throw new BizException("-1", "\u63d0\u4ea4\u65e0\u539f\u5355\u9000\u8d27\u5355\uff0c\u83b7\u53d6\u9501\u5f02\u5e38");
                }
                dto.setRelateToPlatformOrder(Integer.valueOf(1));
                DgAfterSaleOrderEo orderEo = new DgAfterSaleOrderEo();
                CubeBeanUtils.copyProperties((Object)orderEo, (Object)dto, (String[])new String[]{"id"});
                orderEo.setStatus(dto.getStatus());
                orderEo.setAfterSaleOrderNo(this.noGreateUtil.generateThOrderNo());
                orderEo.setStorageStatus(DgF2BAfterStorageStatus.WAIT_IN.getCode());
                orderEo.setRefundMode(DgF2BAfterRefundModeEnum.ZT_YFK.getCode());
                orderEo.setRelateToPlatformOrder(Integer.valueOf(1));
                orderEo.setBizModel(DgAfterSaleOrderBizModelEnum.F2B.getCode());
                if (ObjectUtil.isNotNull((Object)dto.getEnterpriseCode())) {
                    orderEo.setEnterpriseId(dto.getEnterpriseId());
                    orderEo.setEnterpriseCode(dto.getEnterpriseCode());
                    orderEo.setEnterpriseName(dto.getEnterpriseName());
                } else if (ObjectUtil.isNotNull((Object)dto.getSaleCompanyCode())) {
                    orderEo.setEnterpriseId(dto.getSaleCompanyId());
                    orderEo.setEnterpriseCode(dto.getSaleCompanyCode());
                    orderEo.setEnterpriseName(dto.getSaleCompanyName());
                }
                ArrayList<DgAfterSaleOrderItemEo> itemEoList = new ArrayList<DgAfterSaleOrderItemEo>();
                CubeBeanUtils.copyCollection(itemEoList, (Collection)dto.getItemDtoList(), DgAfterSaleOrderItemEo.class);
                orderEo.setApplyReturnQty(Long.valueOf(itemEoList.stream().mapToInt(DgAfterSaleOrderItemEo::getReturnNum).sum()));
                orderEo.setOriginalRefundFee(itemEoList.stream().map(DgAfterSaleOrderItemEo::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                dto.setOriginalRefundFee(orderEo.getOriginalRefundFee());
                dto.setAfterSaleOrderNo(orderEo.getAfterSaleOrderNo());
                this.dgAfterSaleOrderDomain.insert((BaseEo)orderEo);
                this.dgAfterSaleOrderReturnAddressDomain.saveRerurnAddress(orderEo.getId(), dto);
                this.dgAfterSaleOrderLogisticsWarehouseDomain.saveLogisticsWarehouse(orderEo.getId(), dto);
                this.dgAfterSaleOrderExchangeAddressDomain.saveExchangeAddress(orderEo.getId(), dto);
                itemEoList.forEach(item -> {
                    item.setRefundAmount(BigDecimal.valueOf(item.getReturnNum().intValue()).multiply(item.getRefundPrice()).setScale(2, RoundingMode.HALF_UP));
                    item.setActualReturnNum(null);
                    item.setActualRefundPrice(null);
                    item.setActualRefundAmount(null);
                    if (dto.getBizType().equals("2")) {
                        item.setActualRefundPrice(item.getRefundPrice());
                        item.setActualRefundAmount(item.getRefundAmount());
                    }
                    item.setReturnedNum(Integer.valueOf(BigDecimal.ZERO.intValue()));
                    item.setAfterSaleOrderId(orderEo.getId());
                    if (ObjectUtil.isNotEmpty((Object)item.getCalcUnit())) {
                        item.setUnit(item.getCalcUnit());
                        item.setItemUnit(item.getCalcUnitDesc());
                    }
                });
                this.dgAfterSaleOrderItemDas.insertBatch(itemEoList);
                this.judgePakegeNumLabel(dto, orderEo, itemEoList);
                List attachmentList = dto.getAttachmentList();
                List attachementEos = BeanUtil.copyToList((Collection)attachmentList, AttachementEo.class);
                this.attachementDomain.logicDeleteAndSaveReturnAttachment(orderEo.getAfterSaleOrderNo(), attachementEos, OptBizTypeEnum.RETURN.getType());
                this.attachementDomain.saveReceivingReportAttachment(orderEo.getAfterSaleOrderNo(), dto.getReceivingReportList());
                this.saveStatusLog(orderEo);
                l = orderEo.getId();
                if (null == lock) break block7;
            }
            catch (Throwable throwable) {
                if (null != lock) {
                    this.lockService.unlock(lock);
                }
                throw throwable;
            }
            this.lockService.unlock(lock);
        }
        return l;
    }

    private DgAfterSaleOrderItemRespDto buildAfterSaleOrderItem(DgPerformOrderLineEo performOrderLine, Long performOrderLineId) {
        DgAfterSaleOrderItemRespDto itemRespDto = new DgAfterSaleOrderItemRespDto();
        itemRespDto.setSaleOrderItemId(performOrderLineId);
        itemRespDto.setItemId(performOrderLine.getItemId());
        itemRespDto.setItemCode(performOrderLine.getItemCode());
        itemRespDto.setItemName(performOrderLine.getItemName());
        itemRespDto.setSkuCode(performOrderLine.getSkuCode());
        itemRespDto.setSkuId(performOrderLine.getSkuId());
        itemRespDto.setSkuName(performOrderLine.getSkuName());
        itemRespDto.setImgUrl(performOrderLine.getImgUrl());
        itemRespDto.setItemAttr(performOrderLine.getItemAttribute());
        if (ObjectUtil.isNotEmpty((Object)performOrderLine.getCalcUnit())) {
            itemRespDto.setUnit(performOrderLine.getCalcUnit());
            itemRespDto.setItemUnit(performOrderLine.getCalcUnitDesc());
            itemRespDto.setCalcUnit(performOrderLine.getCalcUnit());
            itemRespDto.setCalcUnitDesc(performOrderLine.getCalcUnitDesc());
        } else {
            itemRespDto.setUnit(performOrderLine.getBasicUnit());
            itemRespDto.setItemUnit(performOrderLine.getBasicUnitName());
            itemRespDto.setCalcUnit(performOrderLine.getBasicUnit());
            itemRespDto.setCalcUnitDesc(performOrderLine.getBasicUnitName());
        }
        if (StringUtils.isNotBlank((CharSequence)itemRespDto.getBatchNo())) {
            HashMap<String, Object> batchMap = new HashMap<String, Object>();
            batchMap.put("batchNumber", itemRespDto.getBatchNo());
            batchMap.put("num", Optional.ofNullable(itemRespDto.getDeliverNum()).orElse(0));
            itemRespDto.setBatchNo(JacksonUtil.toJson((Object)Lists.newArrayList((Object[])new Map[]{batchMap})));
        }
        itemRespDto.setSalePrice(performOrderLine.getSalePrice());
        itemRespDto.setGift(performOrderLine.getGiftFlag());
        return itemRespDto;
    }

    private List<ItemPayRecordDto> getOrigOrderCostDetail(Long performOrderLineId, List<DgPerformOrderLineAmountDto> finalDgPerformOrderLinePayAmountDtos) {
        ArrayList itemPayRecordDtos = Lists.newArrayList();
        finalDgPerformOrderLinePayAmountDtos = finalDgPerformOrderLinePayAmountDtos.stream().filter(e -> e.getOrderLineId().equals(performOrderLineId)).collect(Collectors.toList());
        for (DgPerformOrderLineAmountDto dgPerformOrderLineAmountDto : finalDgPerformOrderLinePayAmountDtos) {
            ItemPayRecordDto itemPayRecordDto = new ItemPayRecordDto();
            itemPayRecordDto.setAccountCategoryName(dgPerformOrderLineAmountDto.getAccountTypeName());
            itemPayRecordDto.setAmount(dgPerformOrderLineAmountDto.getAmount());
            itemPayRecordDtos.add(itemPayRecordDto);
        }
        return itemPayRecordDtos;
    }

    private BigDecimal getOrigOrderAmount(DgPerformOrderLineEo performOrderLine, Map<String, List<DgPerformOrderLineAmountDto>> thisLineAmountMap, String refundMode) {
        String amountType = null;
        amountType = refundMode.equals(DgF2BAfterRefundModeEnum.KNEAD.getCode()) ? DgOmsOrderAmountTypeEnum.LINE_KNEAD_LATER_PAY_AMOUNT.getCode() : DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode();
        BigDecimal transactionTotal = Optional.ofNullable(thisLineAmountMap.get(amountType)).orElse(Lists.newArrayList()).stream().map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        logger.info("\u5546\u54c1:{}\u539f\u8ba2\u8d27\u5355\u5546\u54c1\u884c\u603b\u6210\u4ea4\u91d1\u989d\uff1a{}", (Object)performOrderLine.getSkuCode(), (Object)transactionTotal);
        return transactionTotal;
    }

    private BigDecimal getNoCancelTransactionAmount(Map<Long, List<DgPerformOrderItemLineAmountDto>> supplyItemLineAmountMap, Long performOrderLineId, String refundMode) {
        String accountType = refundMode.equals(DgF2BAfterRefundModeEnum.KNEAD.getCode()) ? DgOmsOrderAmountTypeEnum.ITEM_KNEAD_LATER_PAY_AMOUNT.getCode() : DgOmsOrderAmountTypeEnum.ITEM_LINE_ORIG_PRICE.getCode();
        BigDecimal noCancelTransactionAmount = BigDecimal.ZERO;
        String finalAccountType = accountType;
        noCancelTransactionAmount = noCancelTransactionAmount.add(Optional.ofNullable(supplyItemLineAmountMap.get(performOrderLineId)).orElse(Collections.emptyList()).stream().filter(itemLineAmount -> itemLineAmount.getAccountType().equals(finalAccountType)).map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        return noCancelTransactionAmount;
    }

    private List<DgRefundItemDto> getCancelRefundItem(Long performOrderId) {
        List dgRefundEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgRefundDomain.filter().eq((Object)"dr", (Object)0)).eq((Object)"biz_order_id", (Object)performOrderId)).eq((Object)"dr", (Object)0)).list();
        ArrayList<DgRefundItemDto> list = new ArrayList<DgRefundItemDto>();
        if (CollectionUtils.isNotEmpty((Collection)dgRefundEoList)) {
            List refundIds = dgRefundEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            List dgRefundItemEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgRefundItemDomain.filter().eq((Object)"dr", (Object)0)).in((Object)"refund_id", refundIds)).eq((Object)"dr", (Object)0)).list();
            if (CollectionUtils.isNotEmpty((Collection)dgRefundItemEoList)) {
                CubeBeanUtils.copyCollection(list, (Collection)dgRefundItemEoList, DgRefundItemDto.class);
            }
        }
        logger.info("\u6b63\u5411\u5df2\u9000\u9000\u6b3e\u660e\u7ec6 DgRefundItemDtoList:{}", (Object)JSON.toJSONString(list));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fillAfterItemNum(DgAfterSaleOrderDto request) {
        Mutex lock = null;
        try {
            lock = this.lockService.lock("fillAfterItemNum", request.getAfterSaleOrderNo(), 1, 15, TimeUnit.SECONDS);
            if (null == lock) {
                throw new BizException("-1", "\u586b\u5199\u9000\u8d27\u5355\u6570\u91cf\uff0c\u83b7\u53d6\u9501\u5f02\u5e38");
            }
            ArrayList updateItemList = Lists.newArrayList();
            DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = this.afterSaleOrderDomain.queryByNo(request.getAfterSaleOrderNo());
            AssertUtils.notNull((Object)dgAfterSaleOrderRespDto, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u552e\u540e\u5355,\u552e\u540e\u5355\u53f7\uff1a%s", (Object[])new Object[]{request.getAfterSaleOrderNo()});
            List dgAfterSaleOrderItemRespDtos = this.dgAfterSaleOrderItemDomain.queryByAfterSaleOrderId(dgAfterSaleOrderRespDto.getId());
            AssertUtils.notEmpty((Collection)dgAfterSaleOrderItemRespDtos, (String)"\u552e\u540e\u5355\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u552e\u540e\u5546\u54c1\u884c,\u552e\u540e\u5355Id\uff1a%s", (Object[])new Object[]{dgAfterSaleOrderRespDto.getId()});
            if (CollectionUtils.isNotEmpty((Collection)request.getItemDtoList())) {
                void var11_26;
                void var10_23;
                void var9_20;
                void var12_13;
                void var8_17;
                Map itemRespDtoMap = dgAfterSaleOrderItemRespDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
                logger.info("\u5bf9\u5e94\u552e\u540e\u5355\u7684\u552e\u540e\u5546\u54c1\u884cmap:{}", (Object)JSON.toJSONString(itemRespDtoMap));
                Long saleOrderId = dgAfterSaleOrderRespDto.getSaleOrderId();
                if (dgAfterSaleOrderRespDto.getStatus().equals(DgF2BAfterStatus.RETURNED_WAIT_CONFIRM.getCode()) && dgAfterSaleOrderRespDto.getRelateToPlatformOrder() != null && dgAfterSaleOrderRespDto.getRelateToPlatformOrder() == 0) {
                    List<Long> supplySplitOrderIds = this.performOrderInfoDomain.querySplitEoByPlatformOrderNo(dgAfterSaleOrderRespDto.getSaleOrderNo()).stream().map(BaseEo::getId).collect(Collectors.toList());
                    List supplyOrderLineList = ((ExtQueryChainWrapper)this.performOrderLineDomain.filter().in((Object)"order_id", supplySplitOrderIds)).list();
                    Map<Long, List<DgPerformOrderItemLineDto>> supplyOrderNocancelItemLineMap = this.getSupplyOrderNoCancelItemLineMap(supplySplitOrderIds);
                    Map<Long, List<DgPerformOrderItemLineAmountDto>> map = this.getNoCancelItemLineAmountMapByChannel(supplyOrderLineList, supplyOrderNocancelItemLineMap);
                    List performOrderLineEoList = this.dgPerformOrderLineDomain.queryEosByOrderId(saleOrderId);
                    Map map2 = performOrderLineEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
                    Map<Long, BigDecimal> map3 = this.getActuralReturnedAmountList(saleOrderId, 0);
                    Map<Long, BigDecimal> map4 = this.getActuralReturnedAmountList(saleOrderId, 1);
                    logger.info("\u5ba2\u6237\u786e\u8ba4\u63a5\u6536-\u5404\u5546\u54c1\u5df2\u8ba1\u7b97\u7684\u5b9e\u9000\u5546\u54c1\u4e4b\u548c-refundAmountMap:{}", map3);
                    Map<Long, Integer> map5 = this.getAlreadyReturnItemNum(saleOrderId);
                    logger.info("\u5ba2\u6237\u786e\u8ba4\u63a5\u6536-\u5df2\u8ba1\u7b97\u5b9e\u9000\u5546\u54c1\u6570\u91cf-afterItemMap:{}", map5);
                } else {
                    HashMap hashMap = new HashMap();
                    HashMap hashMap2 = new HashMap();
                    HashMap hashMap3 = new HashMap();
                    HashMap hashMap4 = new HashMap();
                    HashMap hashMap5 = new HashMap();
                }
                request.getItemDtoList().forEach(arg_0 -> this.lambda$fillAfterItemNum$16(itemRespDtoMap, dgAfterSaleOrderRespDto, (Map)var8_17, (Map)var12_13, (Map)var9_20, (Map)var10_23, (Map)var11_26, request, updateItemList, arg_0));
            }
            if (CollectionUtils.isNotEmpty((Collection)updateItemList)) {
                request.setItemDtoList((List)updateItemList);
                this.dgAfterSaleOrderItemDomain.fillAfterItemNum(request);
                if (Objects.nonNull(request.getIsFillReceiveNum()) && request.getIsFillReceiveNum().equals(YesNoEnum.YES.getValue())) {
                    this.updateIsFillReceiveNun(dgAfterSaleOrderRespDto);
                }
                if ((dgAfterSaleOrderRespDto.getStatus().equals(DgF2BAfterStatus.WAIT_IN_STORAGE.getCode()) || dgAfterSaleOrderRespDto.getStatus().equals(DgF2BAfterStatus.COMPLETE.getCode())) && CollectionUtils.isNotEmpty((Collection)request.getQualityReportAttachmentList())) {
                    List attachementEos = BeanUtil.copyToList((Collection)request.getQualityReportAttachmentList(), AttachementEo.class);
                    this.attachementDomain.logicDeleteAndSaveReturnAttachment(dgAfterSaleOrderRespDto.getAfterSaleOrderNo(), attachementEos, OptBizTypeEnum.RETURN_QUALITY_REPORT.getType());
                }
            }
            if (null == lock) return;
        }
        catch (Throwable throwable) {
            if (null == lock) throw throwable;
            this.lockService.unlock(lock);
            throw throwable;
        }
        this.lockService.unlock(lock);
    }

    @Override
    public Map<Long, List<DgPerformOrderItemLineAmountEo>> getNoCancelItemLineAmount(Long saleOrderId) {
        List allPerformOrderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().eq((Object)"order_id", (Object)saleOrderId)).eq((Object)"dr", (Object)0)).list();
        List allPerformOrderItemLineDtos = BeanUtil.copyToList((Collection)allPerformOrderItemLineEos, DgPerformOrderItemLineDto.class);
        Map<Long, List<DgPerformOrderItemLineDto>> allPerformOrderItemLineMap = allPerformOrderItemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        logger.info("\u8be5\u8ba2\u8d27\u5355\u6240\u6709\u672a\u53d6\u6d88\u7684\u5546\u54c1\u884c\uff1a{}", (Object)allPerformOrderItemLineDtos);
        List itemLineIds = allPerformOrderItemLineEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(itemLineIds), (String)"\u8ba2\u8d27\u5355\u5546\u54c1\u884c\u6570\u636e\u4e3a\u7a7a");
        List dgPerformOrderItemLineAmountEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemLineAmountDomain.filter().in((Object)"order_item_line_id", itemLineIds)).eq((Object)"dr", (Object)0)).list();
        Map<Long, List<DgPerformOrderItemLineAmountEo>> itemLineAmountMap = dgPerformOrderItemLineAmountEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineAmountEo::getOrderItemLineId));
        return this.countNoCancelItemLineAmount(allPerformOrderItemLineMap, itemLineAmountMap, saleOrderId);
    }

    private Map<Long, List<DgPerformOrderItemLineAmountEo>> countNoCancelItemLineAmount(Map<Long, List<DgPerformOrderItemLineDto>> allPerformOrderItemLineMap, Map<Long, List<DgPerformOrderItemLineAmountEo>> itemLineAmountMap, Long performOrderLineId) {
        List dgPerformOrderItemLineDtos = allPerformOrderItemLineMap.get(performOrderLineId).stream().filter(itemLineDto -> itemLineDto.getCancelStatus().equals(YesNoEnum.NO.getValue())).collect(Collectors.toList());
        HashMap<Long, List<DgPerformOrderItemLineAmountEo>> itemLinePayDetailMap = new HashMap<Long, List<DgPerformOrderItemLineAmountEo>>();
        if (CollectionUtils.isNotEmpty(dgPerformOrderItemLineDtos)) {
            Map<Long, List<DgPerformOrderItemLineDto>> itemLineMap = dgPerformOrderItemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
            for (Map.Entry<Long, List<DgPerformOrderItemLineDto>> entry : itemLineMap.entrySet()) {
                List<DgPerformOrderItemLineDto> itemLineDtos = entry.getValue();
                Long orderLineId = entry.getKey();
                for (DgPerformOrderItemLineDto dgPerformOrderItemLineDto : itemLineDtos) {
                    List<DgPerformOrderItemLineAmountEo> eos = itemLineAmountMap.get(dgPerformOrderItemLineDto.getId());
                    if (!CollectionUtils.isNotEmpty(eos)) continue;
                    itemLinePayDetailMap.put(orderLineId, eos);
                }
            }
        }
        return itemLinePayDetailMap;
    }

    private void updateAfterAmount(DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto, Map<Long, DgPerformOrderLineEo> performOrderLineEoMap, Map<Long, List<DgPerformOrderItemLineAmountDto>> noCancelItemLineAmountMap, Map<Long, BigDecimal> acturalReturnedAmountMap, Map<Long, BigDecimal> settlementReturnedAmountMap, Map<Long, Integer> afterItemMap, DgAfterSaleOrderItemRespDto dgAfterSaleOrderItemDto) {
        AssertUtils.notNull((Object)dgAfterSaleOrderItemDto, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u552e\u540e\u5546\u54c1\u884c,\u5546\u54c1\u884csku\u7f16\u7801\uff1a%s", (Object[])new Object[]{dgAfterSaleOrderItemDto.getSkuCode()});
        int quantity = dgAfterSaleOrderItemDto.getActualReturnNum();
        dgAfterSaleOrderItemDto.setReturnedNum(Integer.valueOf(quantity));
        BigDecimal actualReturnNum = BigDecimal.valueOf(dgAfterSaleOrderItemDto.getActualReturnNum().intValue());
        if (dgAfterSaleOrderRespDto.getRelateToPlatformOrder() != null && dgAfterSaleOrderRespDto.getRelateToPlatformOrder() == 0) {
            Long orderLineId = dgAfterSaleOrderItemDto.getSaleOrderItemId();
            DgPerformOrderLineEo dgPerformOrderLineEo = performOrderLineEoMap.get(orderLineId);
            String refundMode = dgAfterSaleOrderRespDto.getRefundMode();
            BigDecimal totalPayAmount = BigDecimal.ZERO;
            BigDecimal totalSettleAmount = BigDecimal.ZERO;
            if (refundMode.equals(DgF2BAfterRefundModeEnum.KNEAD.getCode())) {
                totalPayAmount = noCancelItemLineAmountMap.get(orderLineId).stream().filter(itemLineAmount -> itemLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.KNEAD.getCode()) && (Objects.equals(itemLineAmount.getAccountCategory(), AccountCategoryEnum.CAPITAL.getCode()) || Objects.equals(itemLineAmount.getAccountCategory(), AccountCategoryEnum.COST.getCode()))).map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                totalSettleAmount = noCancelItemLineAmountMap.get(orderLineId).stream().filter(itemLineAmount -> itemLineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_KNEAD_LATER_SETTLEMENT_AMOUNT.getCode())).map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            } else {
                totalPayAmount = noCancelItemLineAmountMap.get(orderLineId).stream().filter(itemLineAmount -> itemLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_ITEM_AMOUNT.getCode()) || itemLineAmount.getAmountSource().equals(DgOrderAmountSourceEnum.COST.getCode())).map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                totalSettleAmount = noCancelItemLineAmountMap.get(orderLineId).stream().filter(itemLineAmount -> itemLineAmount.getAccountType().equals(DgOmsOrderAmountTypeEnum.ITEM_LINE_SETTLEMENT_AMOUNT.getCode())).map(DgPerformOrderItemLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            logger.info("\u9000\u6b3e\u5355\uff1a{}, \u5546\u54c1:{}\u539f\u5355\u672a\u53d6\u6d88\u7684\u7ed3\u7b97\u91d1\u989d\uff1a{}", new Object[]{dgAfterSaleOrderRespDto.getAfterSaleOrderNo(), dgAfterSaleOrderItemDto.getSkuCode(), totalSettleAmount});
            logger.info("\u9000\u6b3e\u5355\uff1a{}, \u5546\u54c1:{}\u539f\u5355\u672a\u53d6\u6d88\u7684\u652f\u4ed8\u91d1\u989d\uff1a{}", new Object[]{dgAfterSaleOrderRespDto.getAfterSaleOrderNo(), dgAfterSaleOrderItemDto.getSkuCode(), totalPayAmount});
            BigDecimal alreadyReturnAmount = Optional.ofNullable(acturalReturnedAmountMap.get(orderLineId)).orElse(BigDecimal.ZERO);
            BigDecimal settlementReturnedAmount = Optional.ofNullable(settlementReturnedAmountMap.get(orderLineId)).orElse(BigDecimal.ZERO);
            Integer alreadyNum = Optional.ofNullable(afterItemMap.get(orderLineId)).orElse(0);
            BigDecimal itemNum = dgPerformOrderLineEo.getCalcItemNum();
            if (itemNum.subtract(BigDecimal.valueOf(alreadyNum.intValue())).compareTo(BigDecimal.valueOf(quantity)) <= 0) {
                dgAfterSaleOrderItemDto.setSettlementAmount(totalSettleAmount.subtract(settlementReturnedAmount));
                dgAfterSaleOrderItemDto.setActualRefundAmount(totalPayAmount.subtract(alreadyReturnAmount));
                logger.info("\u9000\u6b3e\u5355\uff1a{}, \u5546\u54c1:{}\u5168\u90e8\u9000\u5b8c\uff0c\u5b9e\u9000\u91d1\u989d\u4e3a\uff1a{}", new Object[]{dgAfterSaleOrderRespDto.getAfterSaleOrderNo(), dgAfterSaleOrderItemDto.getSkuCode(), dgAfterSaleOrderItemDto.getActualRefundAmount()});
            } else {
                dgAfterSaleOrderItemDto.setSettlementAmount(totalSettleAmount.multiply(actualReturnNum).divide(itemNum, 2, 4));
                BigDecimal itemRefundAmount = totalPayAmount.multiply(actualReturnNum).divide(itemNum, 2, 4);
                dgAfterSaleOrderItemDto.setActualRefundAmount(itemRefundAmount);
                logger.info("\u9000\u6b3e\u5355\uff1a{}, \u5546\u54c1:{}\u672a\u9000\u5b8c\uff0c\u5b9e\u9000\u91d1\u989d\u4e3a\uff1a{}", new Object[]{dgAfterSaleOrderRespDto.getAfterSaleOrderNo(), dgAfterSaleOrderItemDto.getSkuCode(), dgAfterSaleOrderItemDto.getActualRefundAmount()});
            }
            if (actualReturnNum.compareTo(BigDecimal.ZERO) > 0) {
                dgAfterSaleOrderItemDto.setSettlementPrice(dgAfterSaleOrderItemDto.getSettlementAmount().divide(actualReturnNum, 2, 4));
                dgAfterSaleOrderItemDto.setActualRefundPrice(dgAfterSaleOrderItemDto.getActualRefundAmount().divide(actualReturnNum, 2, 4));
            } else {
                dgAfterSaleOrderItemDto.setSettlementPrice(BigDecimal.ZERO);
                dgAfterSaleOrderItemDto.setActualRefundPrice(BigDecimal.ZERO);
            }
        }
    }

    public List<DgAfterSaleOrderItemRespDto> returnableCheck(Long performOrderId, Map<Long, List<DgPerformOrderLineAmountDto>> orderLineAmountMap, List<DgAfterSaleOrderItemRespDto> collect, DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        Integer returnBizType = afterSaleOrderRespDto.getReturnBizType();
        if (ObjectUtil.isNotEmpty(collect)) {
            LinkedList<DgAfterSaleOrderItemRespDto> match = new LinkedList<DgAfterSaleOrderItemRespDto>();
            for (DgAfterSaleOrderItemRespDto dgAfterSaleOrderItemRespDto : collect) {
                List<DgPerformOrderLineAmountDto> thisOrderLineAmountList = orderLineAmountMap.get(dgAfterSaleOrderItemRespDto.getSaleOrderItemId());
                BigDecimal saleAmount = thisOrderLineAmountList.stream().filter(orderLineAmountDto -> orderLineAmountDto.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal transactionAmount = thisOrderLineAmountList.stream().filter(orderLineAmountDto -> orderLineAmountDto.getAccountType().equals(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode())).map(DgPerformOrderLineAmountDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal scale = transactionAmount.divide(saleAmount, 2, RoundingMode.HALF_UP);
                if (dgAfterSaleOrderItemRespDto.getAllowReturnNum() <= 0) {
                    dgAfterSaleOrderItemRespDto.setIsReturnable(Integer.valueOf(0));
                    dgAfterSaleOrderItemRespDto.setNoReturnableReason("\u9000\u8d27\u6570\u91cf\u4e3a0");
                    continue;
                }
                if (dgAfterSaleOrderItemRespDto.getGift() == 1 && !Objects.equals(afterSaleOrderRespDto.getReturnBizType(), AfterSaleOrderReturnBizTypeEnum.UNDELIVERED_RETURN.getCode()) && !Objects.equals(afterSaleOrderRespDto.getReturnBizType(), AfterSaleOrderReturnBizTypeEnum.DIRECT_SALE_UNDELIVERED_RETURN.getCode())) {
                    dgAfterSaleOrderItemRespDto.setIsReturnable(Integer.valueOf(0));
                    dgAfterSaleOrderItemRespDto.setNoReturnableReason("\u8d60\u54c1\u4e0d\u53ef\u9000");
                    continue;
                }
                if (!(scale.compareTo(BigDecimal.valueOf(0.6)) >= 0 || returnBizType.equals(AfterSaleOrderReturnBizTypeEnum.DIRECT_SALE_FIRST_RETURN.getCode()) || returnBizType.equals(AfterSaleOrderReturnBizTypeEnum.DIRECT_SALE_UNDELIVERED_RETURN.getCode()) || returnBizType.equals(AfterSaleOrderReturnBizTypeEnum.ADJUSTMENT_RETURN_ORDER.getCode()))) {
                    dgAfterSaleOrderItemRespDto.setIsReturnable(Integer.valueOf(0));
                    dgAfterSaleOrderItemRespDto.setNoReturnableReason("\u4f4e\u4e8e6\u6298\u4e0d\u53ef\u9000");
                    continue;
                }
                match.add(dgAfterSaleOrderItemRespDto);
            }
            if (ObjectUtil.isNotEmpty(match)) {
                DgPerformOrderSnapshotEo dgPerformOrderSnapshotEo = this.snapshotDomain.selectByOrderId(performOrderId);
                DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)this.performOrderInfoDomain.selectByPrimaryKey(performOrderId);
                MatchItemReqDto reqDto = this.dgAfterSaleRuleService.getMatchItemReqDto(dgPerformOrderSnapshotEo.getCustomerId(), dgPerformOrderSnapshotEo.getCustomerCode(), dgPerformOrderSnapshotEo.getShopId(), dgPerformOrderSnapshotEo.getShopCode());
                String orderType = "";
                if (ObjectUtil.isNotEmpty((Object)dgPerformOrderInfoEo)) {
                    orderType = dgPerformOrderInfoEo.getOrderType();
                }
                reqDto.setOrderType(orderType);
                List skuIds = match.stream().map(DgAfterSaleOrderItemDto::getSkuId).collect(Collectors.toList());
                ReBizTagRecordPageReqDto reBizTagRecordPageReqDto = new ReBizTagRecordPageReqDto();
                reBizTagRecordPageReqDto.setSkuIds(skuIds);
                reBizTagRecordPageReqDto.setRecordLinkParentId(dgPerformOrderSnapshotEo.getShopId());
                reBizTagRecordPageReqDto.setTagStatus(Integer.valueOf(1));
                List tagRecordRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.reBizTagRecordApiProxy.findAll(reBizTagRecordPageReqDto));
                Map<Object, Object> skuIdTagMap = new HashMap();
                if (CollectionUtils.isNotEmpty((Collection)tagRecordRespDtoList)) {
                    skuIdTagMap = tagRecordRespDtoList.stream().collect(Collectors.groupingBy(BizTagRecordDto::getRecordLinkId));
                }
                LinkedList<OrderItemDto> items = new LinkedList<OrderItemDto>();
                for (DgAfterSaleOrderItemRespDto dgAfterSaleOrderItemRespDto : match) {
                    DgItemSkuDetailRespDto dgItemSkuDetailRespDto = (DgItemSkuDetailRespDto)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.getItemSkuDetailById(dgAfterSaleOrderItemRespDto.getSkuId()));
                    OrderItemDto dto = new OrderItemDto();
                    dto.setBrand(String.valueOf(dgItemSkuDetailRespDto.getBrandId()));
                    dto.setSkuCode(dgItemSkuDetailRespDto.getSkuCode());
                    dto.setCategoryId(this.getAllParentDirs(dgItemSkuDetailRespDto.getDirId()));
                    dto.setSaleOrderItemId(dgAfterSaleOrderItemRespDto.getSaleOrderItemId());
                    List tagRecordRespDtos = (List)skuIdTagMap.get(dgAfterSaleOrderItemRespDto.getSkuId());
                    if (CollectionUtils.isNotEmpty((Collection)tagRecordRespDtos)) {
                        List tagIdList = tagRecordRespDtos.stream().map(e -> e.getTagId().toString()).collect(Collectors.toList());
                        dto.setTags(tagIdList);
                    }
                    items.add(dto);
                }
                reqDto.setItems(items);
                reqDto.setReturnBizType(returnBizType);
                MatchItemReqDto respDto = this.dgAfterSaleRuleService.matchItem(reqDto);
                afterSaleOrderRespDto.setOrderReturnableFlag(respDto.getOrderReturnableFlag());
                Map<Long, List<OrderItemDto>> collect1 = respDto.getItems().stream().collect(Collectors.groupingBy(OrderItemDto::getSaleOrderItemId));
                for (DgAfterSaleOrderItemRespDto dgAfterSaleOrderItemRespDto : collect) {
                    List<OrderItemDto> orderItemDtos = collect1.get(dgAfterSaleOrderItemRespDto.getSaleOrderItemId());
                    if (ObjectUtil.isEmpty(orderItemDtos)) continue;
                    dgAfterSaleOrderItemRespDto.setIsReturnable(Integer.valueOf(orderItemDtos.get(0).isNonRefundable() ? 0 : 1));
                    dgAfterSaleOrderItemRespDto.setNoReturnableReason(orderItemDtos.get(0).getMessage());
                }
            }
        }
        return collect;
    }

    protected List<String> getAllParentDirs(long id) {
        LinkedList<String> result = new LinkedList<String>();
        while (id > 0L) {
            result.add(String.valueOf(id));
            DirectoryItemDgRespDto directoryItemDgRespDto = (DirectoryItemDgRespDto)RestResponseHelper.extractData((RestResponse)this.directoryDgQueryApiProxy.queryDirById(Long.valueOf(id)));
            if (null != directoryItemDgRespDto && !directoryItemDgRespDto.getId().equals(directoryItemDgRespDto.getParentId())) {
                id = directoryItemDgRespDto.getParentId();
                continue;
            }
            id = 0L;
        }
        return result;
    }

    public List<DgAfterSaleOrderItemEo> getReturnedAfterItem(Long performOrderId) {
        List afterList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleOrderDas.filter().eq((Object)"sale_order_id", (Object)performOrderId)).notIn((Object)"status", (Collection)Lists.newArrayList((Object[])new String[]{DgF2BAfterStatus.CANCEL.getCode(), DgF2BAfterStatus.CLOSE.getCode()}))).eq((Object)"dr", (Object)0)).list();
        List afterItemList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)afterList)) {
            Map afterMap = afterList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            List afterIds = afterList.stream().map(BaseEo::getId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(afterIds)) {
                afterItemList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAfterSaleOrderItemDas.filter().in((Object)"after_sale_order_id", afterIds)).eq((Object)"dr", (Object)0)).list();
            }
            afterItemList.forEach(afterItem -> {
                DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)afterMap.get(afterItem.getAfterSaleOrderId());
                switch (DgF2BAfterStatus.forCode((String)afterSaleOrderEo.getStatus())) {
                    case CREATED: 
                    case WAIT_CHECK: 
                    case WAIT_AUDIT: 
                    case WAIT_IN_STORAGE: 
                    case RETURNED_WAIT_CONFIRM: {
                        afterItem.setReturnedNum(afterItem.getReturnNum());
                        afterItem.setRefundAmount(afterItem.getRefundAmount());
                        break;
                    }
                    case WAIT_QUALITY_TEST: {
                        afterItem.setReturnedNum(Integer.valueOf(afterItem.getCustomerConfirmReceiveNum().intValue()));
                        afterItem.setRefundAmount(afterItem.getRefundAmount());
                        break;
                    }
                    case WAIT_REFUND: 
                    case COMPLETE: {
                        afterItem.setReturnedNum(afterItem.getActualReturnNum());
                        afterItem.setRefundAmount(afterItem.getActualRefundAmount());
                        break;
                    }
                    default: {
                        afterItem.setReturnedNum(Optional.ofNullable(afterItem.getReturnedNum()).orElse(0));
                        afterItem.setRefundAmount(Optional.ofNullable(afterItem.getRefundAmount()).orElse(BigDecimal.ZERO));
                    }
                }
            });
        }
        return afterItemList;
    }

    private void updateIsFillReceiveNun(DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        dgAfterSaleOrderEo.setId(dgAfterSaleOrderRespDto.getId());
        dgAfterSaleOrderEo.setIsFillReceiveNum(YesNoEnum.YES.getValue());
        this.dgAfterSaleOrderDas.updateSelective((BaseEo)dgAfterSaleOrderEo);
    }

    public Map<Long, BigDecimal> getActuralReturnedAmountList(Long orderId, Integer amountType) {
        HashMap<Long, BigDecimal> returnedAmountMap = new HashMap<Long, BigDecimal>();
        logger.info("\u83b7\u53d6\u8ba2\u8d27\u5355\u5df2\u8ba1\u7b97\u7684\u5b9e\u9000\u91d1\u989d\uff1a{}", (Object)orderId);
        List afterSaleOrderEoList = this.afterSaleOrderDomain.queryEosBySaleOrderIdAndStatus(orderId, Lists.newArrayList((Object[])new String[]{DgF2BAfterStatus.COMPLETE.getCode(), DgF2BAfterStatus.WAIT_REFUND.getCode()}));
        if (CollectionUtils.isEmpty((Collection)afterSaleOrderEoList)) {
            return returnedAmountMap;
        }
        Map afterSaleOrderEoMap = afterSaleOrderEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        List afterOrderIds = afterSaleOrderEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        List itemRespDtoList = this.dgAfterSaleOrderItemDomain.queryByAfterSaleOrderIds(afterOrderIds);
        Map<Long, List<DgAfterSaleOrderItemRespDto>> returnedAfterItemMap = itemRespDtoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemDto::getSaleOrderItemId));
        for (Map.Entry<Long, List<DgAfterSaleOrderItemRespDto>> returnedItemEntry : returnedAfterItemMap.entrySet()) {
            if (amountType == 1) {
                BigDecimal totalSettlementAmount = returnedItemEntry.getValue().stream().map(DgAfterSaleOrderItemDto::getSettlementAmount).filter(ObjectUtil::isNotEmpty).reduce(BigDecimal.ZERO, BigDecimal::add);
                returnedAmountMap.put(returnedItemEntry.getKey(), totalSettlementAmount);
                continue;
            }
            if (amountType != 0) continue;
            BigDecimal totalActualRefundAmount = BigDecimal.ZERO;
            List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtos = returnedItemEntry.getValue();
            for (DgAfterSaleOrderItemRespDto afterSaleOrderItemRespDto : afterSaleOrderItemRespDtos) {
                DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)afterSaleOrderEoMap.get(afterSaleOrderItemRespDto.getAfterSaleOrderId());
                if (AfterSaleOrderTypeEnum.JTK.getCode().equals(afterSaleOrderEo.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.FHHTK.getCode().equals(afterSaleOrderEo.getAfterSaleOrderType())) {
                    totalActualRefundAmount = totalActualRefundAmount.add(afterSaleOrderItemRespDto.getRefundAmount());
                    continue;
                }
                totalActualRefundAmount = totalActualRefundAmount.add(afterSaleOrderItemRespDto.getActualRefundAmount());
            }
            returnedAmountMap.put(returnedItemEntry.getKey(), totalActualRefundAmount);
        }
        return returnedAmountMap;
    }

    public Map<Long, Integer> getAlreadyReturnItemNum(Long orderId) {
        logger.info("\u6839\u636e\u8ba2\u8d27\u5355ID\u83b7\u53d6\u5df2\u5b9e\u9000\u7684\u5546\u54c1\u6570\u91cf\uff1a{}", (Object)orderId);
        Map<Long, Integer> afterItemMap = new HashMap<Long, Integer>();
        List afterSaleOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().eq((Object)"sale_order_id", (Object)orderId)).in((Object)"status", (Collection)Lists.newArrayList((Object[])new String[]{DgF2BAfterStatus.COMPLETE.getCode(), DgF2BAfterStatus.WAIT_REFUND.getCode()}))).eq((Object)"dr", (Object)0)).list();
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderEoList)) {
            List afterOrderIds = afterSaleOrderEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            List cancelItemLineList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().eq((Object)"order_id", (Object)orderId)).eq((Object)"cancel_status", (Object)YesNoEnum.YES.getValue())).eq((Object)"dr", (Object)0)).list();
            List itemRespDtoList = this.dgAfterSaleOrderItemDomain.queryByAfterSaleOrderIds(afterOrderIds);
            Map<Object, Object> cancelOrderLineMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)cancelItemLineList)) {
                cancelOrderLineMap = cancelItemLineList.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderLineId, Collectors.reducing(BigDecimal.ZERO, DgPerformOrderItemLineEo::getItemNum, BigDecimal::add)));
            }
            Map afterSaleOrderEoMap = afterSaleOrderEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            for (DgAfterSaleOrderItemRespDto dgAfterSaleOrderItemRespDto : itemRespDtoList) {
                DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)afterSaleOrderEoMap.get(dgAfterSaleOrderItemRespDto.getAfterSaleOrderId());
                if (!AfterSaleOrderTypeEnum.JTK.getCode().equals(afterSaleOrderEo.getAfterSaleOrderType()) && !AfterSaleOrderTypeEnum.FHHTK.getCode().equals(afterSaleOrderEo.getAfterSaleOrderType())) continue;
                dgAfterSaleOrderItemRespDto.setActualReturnNum(Integer.valueOf(0));
                dgAfterSaleOrderItemRespDto.setActualRefundAmount(dgAfterSaleOrderItemRespDto.getRefundAmount());
            }
            afterItemMap = itemRespDtoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemDto::getSaleOrderItemId, Collectors.summingInt(DgAfterSaleOrderItemDto::getActualReturnNum)));
            for (Map.Entry entry : afterItemMap.entrySet()) {
                BigDecimal cancelNum = (BigDecimal)Optional.ofNullable(cancelOrderLineMap.get(entry.getKey())).orElse(BigDecimal.ZERO);
                entry.setValue((Integer)entry.getValue() + cancelNum.intValue());
            }
        }
        return afterItemMap;
    }

    private /* synthetic */ void lambda$fillAfterItemNum$16(Map itemRespDtoMap, DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto, Map performOrderLineEoMap, Map noCancelItemLineAmountMap, Map acturalReturnedAmountMap, Map settlementReturnedAmountMap, Map afterItemMap, DgAfterSaleOrderDto request, ArrayList updateItemList, DgAfterSaleOrderItemDto item) {
        AssertUtils.notNull((Object)item.getSkuCode(), (String)"\u552e\u540e\u5546\u54c1\u884csku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderItemRespDto dgAfterSaleOrderItemDto = (DgAfterSaleOrderItemRespDto)itemRespDtoMap.get(item.getId());
        switch (DgF2BAfterStatus.forCode((String)dgAfterSaleOrderRespDto.getStatus())) {
            case WAIT_IN_STORAGE: {
                AssertUtils.notNull((Object)item.getReceiveNum(), (String)"\u5ba2\u6237\u63a5\u53d7\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                if (item.getReceiveNum().compareTo(BigDecimal.valueOf(item.getReturnNum().intValue())) > 0) {
                    throw new BizException("\u5ba2\u6237\u63a5\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u552e\u540e\u6570\u91cf\uff01");
                }
                dgAfterSaleOrderItemDto.setReceiveNum(item.getReceiveNum());
                break;
            }
            case RETURNED_WAIT_CONFIRM: {
                AssertUtils.notNull((Object)item.getReceiveNum(), (String)"\u5ba2\u6237\u63a5\u53d7\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                dgAfterSaleOrderItemDto.setCustomerConfirmReceiveNum(dgAfterSaleOrderItemDto.getReceiveNum());
                dgAfterSaleOrderItemDto.setActualReturnNum(Integer.valueOf(dgAfterSaleOrderItemDto.getCustomerConfirmReceiveNum().intValue()));
                this.updateAfterAmount(dgAfterSaleOrderRespDto, performOrderLineEoMap, noCancelItemLineAmountMap, acturalReturnedAmountMap, settlementReturnedAmountMap, afterItemMap, dgAfterSaleOrderItemDto);
                break;
            }
            case WAIT_QUALITY_TEST: {
                dgAfterSaleOrderItemDto.setQualityTestAnalyseNum(item.getCustomerConfirmReceiveNum());
                break;
            }
            case COMPLETE: {
                AssertUtils.notEmpty((Object)item.getReceiveNum(), (String)"\u63a5\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                if (ObjectUtil.isNotEmpty((Object)dgAfterSaleOrderRespDto.getIsFillReceiveNum()) && dgAfterSaleOrderRespDto.getIsFillReceiveNum() == 1) {
                    logger.info("\u552e\u540e\u5355\uff1a{}\u5df2\u586b\u5199\u8fc7\u63a5\u6536\u6570\u91cf\uff0c\u4e0d\u80fd\u518d\u6b21\u586b\u5199", (Object)dgAfterSaleOrderRespDto.getAfterSaleOrderNo());
                    return;
                }
                if (item.getReceiveNum().compareTo(BigDecimal.valueOf(item.getReturnNum().intValue())) > 0) {
                    throw new BizException("\u5ba2\u6237\u63a5\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u7533\u8bf7\u552e\u540e\u6570\u91cf\uff01");
                }
                if (!Objects.equals(request.getBizType(), "2")) {
                    throw new BizException("\u975e\u76f4\u8425\u9000\u8d27\u5df2\u5b8c\u6210\u72b6\u6001\u4e0d\u5141\u8bb8\u586b\u5199\u63a5\u6536\u6570\u91cf");
                }
                dgAfterSaleOrderItemDto.setReceiveNum(item.getReceiveNum());
                request.setIsFillReceiveNum(YesNoEnum.YES.getValue());
            }
        }
        dgAfterSaleOrderItemDto.setRemark(item.getRemark());
        updateItemList.add(dgAfterSaleOrderItemDto);
    }
}

