/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgOrderItemAmountConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderItemAmountDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderItemAmountDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderKneadRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderItemAmountEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgOrderItemAmountService;
import com.yunxi.dg.base.center.trade.utils.AssertUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DgOrderItemAmountServiceImpl
extends BaseServiceImpl<DgOrderItemAmountDto, DgOrderItemAmountEo, IDgOrderItemAmountDomain>
implements IDgOrderItemAmountService {
    private static final Logger logger = LoggerFactory.getLogger(DgOrderItemAmountServiceImpl.class);

    public DgOrderItemAmountServiceImpl(IDgOrderItemAmountDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgOrderItemAmountDto, DgOrderItemAmountEo> converter() {
        return DgOrderItemAmountConverter.INSTANCE;
    }

    @Override
    public List<DgOrderItemAmountDto> queryList(DgOrderItemAmountDto dto) {
        AssertUtil.isTrue((ObjectUtil.isEmpty((Object)dto.getOrderAmountId()) && ObjectUtil.isEmpty((Object)dto.getOrderId()) && ObjectUtil.isEmpty((Object)dto.getOrderItemId()) ? 1 : 0) != 0, (String)"-1", (String)"\u8bf7\u6c42\u53c2\u6570\u6709\u8bef");
        DgOrderItemAmountEo queryEo = new DgOrderItemAmountEo();
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)dto, (String[])new String[0]);
        List orderItemAmountEoList = ((IDgOrderItemAmountDomain)this.domain).selectList((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(1024));
        ArrayList<DgOrderItemAmountDto> dtoList = new ArrayList<DgOrderItemAmountDto>();
        if (CollectionUtil.isNotEmpty((Collection)orderItemAmountEoList)) {
            CubeBeanUtils.copyCollection(dtoList, (Collection)orderItemAmountEoList, DgOrderItemAmountDto.class);
        }
        return dtoList;
    }

    @Override
    public List<DgOrderItemAmountDto> queryList(Long orderId, List<String> amountTypes, String amountSource) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgOrderItemAmountDomain)this.domain).filter().eq((Object)"order_id", (Object)orderId)).in((Object)"amount_type", amountTypes)).eq(StringUtils.isNotBlank((CharSequence)amountSource), (Object)"amount_source", (Object)amountSource)).list();
        ArrayList<DgOrderItemAmountDto> dtoList = new ArrayList<DgOrderItemAmountDto>();
        CubeBeanUtils.copyCollection(dtoList, (Collection)list, DgOrderItemAmountDto.class);
        return dtoList;
    }

    @Override
    public List<DgBizPerformOrderKneadRespDto> queryOrderItemKneadAmount(Long orderId) {
        logger.info("\u83b7\u53d6\u8ba2\u8d27\u5355\u5546\u54c1\u63c9\u4ef7\u4fe1\u606f\uff1a{}", (Object)orderId);
        if (ObjectUtil.isEmpty((Object)orderId)) {
            return Lists.newArrayList();
        }
        List itemAmountEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgOrderItemAmountDomain)this.domain).filter().eq((Object)"order_id", (Object)orderId)).eq((Object)"amount_source", (Object)DgOrderAmountSourceEnum.KNEAD.getCode())).list();
        ArrayList<DgBizPerformOrderKneadRespDto> result = new ArrayList<DgBizPerformOrderKneadRespDto>();
        if (CollectionUtil.isNotEmpty((Collection)itemAmountEoList)) {
            Map<Long, List<DgOrderItemAmountEo>> itemAmountMap = itemAmountEoList.stream().collect(Collectors.groupingBy(DgOrderItemAmountEo::getOrderItemId));
            itemAmountMap.forEach((k, v) -> {
                DgBizPerformOrderKneadRespDto kneadRespDto = new DgBizPerformOrderKneadRespDto();
                kneadRespDto.setOrderItemId(k);
                v.forEach(amount -> {
                    switch (DgOrderAmountTypeEnum.getForCode((String)amount.getAmountType())) {
                        case KNEAD_TOTAL: {
                            kneadRespDto.setKneadTotal(amount.getAmount());
                            break;
                        }
                        case KNEAD_PRICE: {
                            kneadRespDto.setKneadPrice(amount.getAmount());
                            break;
                        }
                        case PROMOTION_KNEAD_TOTAL: {
                            kneadRespDto.setPromotionKneadTotal(amount.getAmount());
                            break;
                        }
                        case COST_KNEAD_TOTAL: {
                            kneadRespDto.setCostKneadTotal(amount.getAmount());
                            break;
                        }
                        case KNEAD_LATER_PRICE: {
                            kneadRespDto.setKneadLaterPrice(amount.getAmount());
                            break;
                        }
                        case KNEAD_LATER_TOTAL: {
                            kneadRespDto.setKneadLaterTotal(amount.getAmount());
                            break;
                        }
                        case KNEAD_LATER_TAX: {
                            kneadRespDto.setKneadLaterTax(amount.getAmount());
                            break;
                        }
                        case KNEAD_LATER_TOTAL_NOT_TAX: {
                            kneadRespDto.setKneadLaterTotalNotTax(amount.getAmount());
                            break;
                        }
                    }
                });
                result.add(kneadRespDto);
            });
        }
        return result;
    }

    @Override
    public void delByOrder(Long orderId) {
        logger.info("\u5220\u9664\u8ba2\u5355\u884c\u91d1\u989d\u4fe1\u606f\uff08\u7269\u7406\u5220\u9664\uff09\uff1a{}", (Object)orderId);
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)orderId), (String)"-1", (String)"orderId\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderItemAmountEo itemAmountEo = new DgOrderItemAmountEo();
        itemAmountEo.setOrderId(orderId);
        List orderItemAmountEoList = ((IDgOrderItemAmountDomain)this.domain).selectList((BaseEo)itemAmountEo, Integer.valueOf(1), Integer.valueOf(2048));
        if (CollectionUtil.isNotEmpty((Collection)orderItemAmountEoList)) {
            ((IDgOrderItemAmountDomain)this.domain).delByIds(orderItemAmountEoList.stream().map(BaseEo::getId).collect(Collectors.toList()));
        }
    }

    @Override
    public DgOrderItemAmountEo queryOneAmount(Long orderId, Long orderItemId, DgOrderAmountTypeEnum amountType) {
        DgOrderItemAmountEo query = new DgOrderItemAmountEo();
        query.setOrderId(orderId);
        query.setOrderItemId(orderItemId);
        query.setAmountType(amountType.getCode());
        return (DgOrderItemAmountEo)((IDgOrderItemAmountDomain)this.domain).selectOne((BaseEo)query);
    }

    @Override
    public List<DgOrderItemAmountEo> queryCostByOrderId(Long orderId, Long orderItemId) {
        DgOrderItemAmountEo query = new DgOrderItemAmountEo();
        query.setOrderId(orderId);
        query.setOrderItemId(orderItemId);
        List list = ((IDgOrderItemAmountDomain)this.domain).selectList((BaseEo)query, Integer.valueOf(1), Integer.valueOf(1024));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        return list.stream().filter(en -> {
            DgOrderAmountTypeEnum amountType = DgOrderAmountTypeEnum.getForCode((String)en.getAmountType());
            if (amountType == null) {
                return false;
            }
            return amountType.getBelong().equals(DgOrderAmountSourceEnum.COST.getCode());
        }).collect(Collectors.toList());
    }

    @Override
    public List<DgOrderItemAmountEo> queryPayAndCostByOrderId(Long orderId, List<Long> orderItemIds) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgOrderItemAmountDomain)this.domain).filter().eq((Object)"order_id", (Object)orderId)).in((Object)"order_item_id", orderItemIds)).in((Object)"amount_type", Arrays.asList(DgOrderAmountTypeEnum.PAY_AMOUNT.getCode()))).list();
        return list;
    }
}

