/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.yunxi.dg.base.center.trade.convert.entity.DgTrolleyConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgTrolleyDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgTrolleyDto;
import com.yunxi.dg.base.center.trade.eo.DgTrolleyEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgTrolleyService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DgTrolleyServiceImpl
extends BaseServiceImpl<DgTrolleyDto, DgTrolleyEo, IDgTrolleyDomain>
implements IDgTrolleyService {
    @Resource
    private IDgTrolleyDomain dgTrolleyDomain;

    public DgTrolleyServiceImpl(IDgTrolleyDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgTrolleyDto, DgTrolleyEo> converter() {
        return DgTrolleyConverter.INSTANCE;
    }

    @Override
    public Long addDgTrolley(DgTrolleyDto dto) {
        DgTrolleyEo result = this.getDgTrolleyEo(dto.getUserId(), dto.getCustomerId());
        if (result != null) {
            throw new BizException(TradeExceptionCode.TROLLEY_EXIST_FAIL.getCode(), TradeExceptionCode.TROLLEY_EXIST_FAIL.getMsg());
        }
        return (Long)this.insert((BaseDto)dto).getData();
    }

    @Override
    public DgTrolleyDto getDgTrolleyInfo(DgTrolleyDto dto) {
        DgTrolleyEo result = this.getDgTrolleyEo(dto.getUserId(), dto.getCustomerId());
        return (DgTrolleyDto)this.converter().toDto((BaseEo)result);
    }

    private DgTrolleyEo getDgTrolleyEo(Long userId, Long customerId) {
        DgTrolleyEo querEo = new DgTrolleyEo();
        querEo.setUserId(userId);
        querEo.setCustomerId(customerId);
        DgTrolleyEo result = (DgTrolleyEo)this.dgTrolleyDomain.selectOne((BaseEo)querEo);
        return result;
    }
}

