/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2b.Impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.source.dto.entity.DgOrderItemResultDto;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.SourceRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgLogicWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderWaitPickService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.service.proxy.IDgSourceApiService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class B2BOrderWaitPickServiceImpl
implements IB2BOrderWaitPickService {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderWaitPickServiceImpl.class);
    private static final String MODIFICATE_CODE = "modification";
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgSourceApiService sourceApiService;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderAddrExtDomain performOrderAddrExtDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain orderSplitReleationDomain;
    @Resource
    private ISourceRecordDomain sourceRecordDomain;
    @Resource
    private IDgPerformOrderExtensionDomain dgPerformOrderExtensionDomain;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;

    @Override
    public DgSourceOrderResultRespDto autoSearchSource(Long saleOrderId) {
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(saleOrderId);
        DgPerformOrderAddrDto performOrderAddrDto = this.performOrderAddrExtDomain.queryAddressByOrderId(saleOrderId);
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(saleOrderId);
        DgSourceOrderResultRespDto sourceOrderResultRespDto = null;
        sourceOrderResultRespDto = Objects.equals(saleOrderRespDto.getOrderType(), DgSaleOrderTypeEnum.CHANGE_DELIVERY_ORDER.getType()) ? this.sourceApiService.searchSourceByChangeDeliveryOrderV2(saleOrderRespDto, orderLineDtos, performOrderAddrDto) : this.sourceApiService.searchSourceV2(saleOrderRespDto, orderLineDtos, performOrderAddrDto);
        return sourceOrderResultRespDto;
    }

    @Override
    public InventoryOperateRespDto preemptLogicInventoryBySource(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceOrderResultRespDto) {
        AssertUtils.notNull((Object)sourceOrderResultRespDto, (String)"\u5bfb\u6e90\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("[\u6839\u636e\u5bfb\u6e90\u7ed3\u679c\u5360\u5355]\u5bfb\u6e90\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
            DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
            List orderItemLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
            List skuCodes = orderItemLineDtoList.stream().map(DgPerformOrderLineDto::getSkuCode).distinct().collect(Collectors.toList());
            List sourceOrderItemRespDtos = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().filter(source -> skuCodes.contains(source.getLinkItemSkuCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(sourceOrderItemRespDtos)) {
                DgOrderItemResultDto sourceOrderItemRespDto = (DgOrderItemResultDto)sourceOrderItemRespDtos.get(0);
                Map sourceOrderItemMap = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().collect(Collectors.toMap(DgOrderItemResultDto::getLinkOrderItemId, Function.identity(), (a, b) -> a));
                orderItemLineDtoList.forEach(orderLine -> orderLine.setDeliveryItemBatchNo(sourceOrderItemMap.get(orderLine.getId()) != null ? ((DgOrderItemResultDto)sourceOrderItemMap.get(orderLine.getId())).getBatch() : ""));
                performOrderRespDto.setDeliveryLogicalWarehouseCode(sourceOrderItemRespDto.getDeliveryLogicWarehouseCode());
                if (null == performOrderRespDto.getPerformOrderWarehouseInfoDto()) {
                    performOrderRespDto.setPerformOrderWarehouseInfoDto(new DgPerformOrderWarehouseInfoDto());
                }
                performOrderRespDto.getPerformOrderWarehouseInfoDto().setDeliveryLogicalWarehouseCode(sourceOrderItemRespDto.getDeliveryLogicWarehouseCode());
                InventoryOperateRespDto inventoryOperateRespDto = this.inventoryApiServcie.omsPreemptLogicInventoryBackResult(performOrderRespDto, orderItemLineDtoList);
                if (inventoryOperateRespDto.getFailList() == null || inventoryOperateRespDto.getFailList().size() == 0) {
                    DgLogicWarehouseReqDto logicWarehouseReqDto = new DgLogicWarehouseReqDto();
                    logicWarehouseReqDto.setDeliveryLogicWarehouseCode(sourceOrderItemRespDto.getDeliveryLogicWarehouseCode());
                    this.updateDeliveryLogicWarehouse(respDto.getId(), logicWarehouseReqDto);
                    this.updateChangeCodeWarehouse(sourceOrderItemRespDto.getDeliveryLogicWarehouseCode(), respDto);
                }
                return inventoryOperateRespDto;
            }
            log.warn("\u7236\u8ba2\u5355\u5bfb\u6e90\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
            throw DgPcpTradeExceptionCode.SOURCE_RESULT_EXCEPTION.builderException();
        }
        log.warn("[\u6839\u636e\u5bfb\u6e90\u7ed3\u679c\u5360\u5355]\u5bfb\u6e90\u5931\u8d25\uff0c\u65b9\u6cd5\u8c03\u7528\u94fe\u4e0d\u5e94\u8be5\u8c03\u7528\u5f53\u524d\u65b9\u6cd5\uff0c\u5f53\u524d\u65b9\u6cd5\u53ea\u5904\u7406\u5bfb\u6e90\u6210\u529f\u7684\u573a\u666f");
        throw DgPcpTradeExceptionCode.SOURCE_RESULT_EXCEPTION.builderException();
    }

    public void updateDeliveryLogicWarehouse(Long saleOrderId, DgLogicWarehouseReqDto logicWarehouseReqDto) {
        AssertUtils.notBlank((String)logicWarehouseReqDto.getDeliveryLogicWarehouseCode(), (String)"deliveryLogicWarehouseCode \u4e0d\u80fd\u4e3a\u7a7a");
        LogicalWarehouseRespDto physicsWarehouseByLogic = this.inventoryApiServcie.getPhysicsWarehouseByLogic(logicWarehouseReqDto.getDeliveryLogicWarehouseCode());
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(saleOrderId);
        updateReqDto.setDeliveryLogicalWarehouseCode(logicWarehouseReqDto.getDeliveryLogicWarehouseCode());
        updateReqDto.setPhysicsWarehouseCode(physicsWarehouseByLogic.getPhysicsWarehouseCode());
        updateReqDto.setPhysicsWarehouseName(physicsWarehouseByLogic.getPhysicsWarehouseName());
        DgPerformOrderWarehouseInfoDto warehouseInfoDto = new DgPerformOrderWarehouseInfoDto();
        warehouseInfoDto.setDeliveryLogicalWarehouseCode(logicWarehouseReqDto.getDeliveryLogicWarehouseCode());
        warehouseInfoDto.setPhysicsWarehouseCode(physicsWarehouseByLogic.getPhysicsWarehouseCode());
        warehouseInfoDto.setPhysicsWarehouseName(physicsWarehouseByLogic.getPhysicsWarehouseName());
        updateReqDto.setPerformOrderWarehouseInfoDto(warehouseInfoDto);
        this.omsOrderInfoDomain.update(updateReqDto);
        log.info("[\u66f4\u65b0\u53d1\u8d27\u903b\u8f91\u4ed3]\u4fee\u6539\u53d1\u8d27\u903b\u8f91\u4ed3\u7684\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicWarehouseReqDto));
    }

    private void updateChangeCodeWarehouse(String saleOrderRespDto, DgPerformOrderRespDto saleOrderRespDto1) {
        log.info("\u66f4\u65b0\u662f\u5426\u6539\u7801\u4ed3\u4fe1\u606f={}", (Object)saleOrderRespDto);
        LogicalWarehouseRespDto logicalWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(saleOrderRespDto));
        AssertUtils.notNull((Object)logicalWarehouseRespDto, (String)"\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgPerformOrderExtensionEo dgPerformOrderExtensionEo = new DgPerformOrderExtensionEo();
        dgPerformOrderExtensionEo.setId(saleOrderRespDto1.getPerformOrderExtensionDto().getId());
        dgPerformOrderExtensionEo.setChangeCodeWarehouse(Objects.equals(logicalWarehouseRespDto.getWarehouseProperty(), MODIFICATE_CODE) ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
        this.dgPerformOrderExtensionDomain.updateSelective((BaseEo)dgPerformOrderExtensionEo);
    }

    @Override
    public DgSourceOrderResultRespDto autoSearchSourceByParentOrder(Long orderId) {
        DgPerformOrderSplitReleationEo parentReleationEo;
        DgPerformOrderSplitReleationEo releationEo = this.orderSplitReleationDomain.queryByChildId(orderId);
        Long parentOrderId = releationEo.getOrderId();
        while ((parentReleationEo = this.orderSplitReleationDomain.queryByChildId(parentOrderId)) != null) {
            parentOrderId = parentReleationEo.getOrderId();
        }
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(parentOrderId);
        List orderItemLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(parentOrderId);
        SourceRecordDto sourceRecordDto = this.sourceRecordDomain.querySourceRecordByOrderNoV2(performOrderRespDto.getSaleOrderNo(), orderItemLineDtoList);
        log.info("\u6839\u636e\u7236\u5355\u7b5b\u9009\u5bfb\u6e90\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)sourceRecordDto));
        AssertUtils.notNull((Object)sourceRecordDto, (String)"\u7236\u5355\u5bfb\u6e90\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)sourceRecordDto.getSourceOrderItemDtos(), (String)"\u7236\u5355\u5bfb\u6e90\u8bb0\u5f55\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        DgSourceOrderResultRespDto respDto = new DgSourceOrderResultRespDto();
        respDto.setLinkOrderNo(sourceRecordDto.getOrderNo());
        respDto.setSgOrderNo(sourceRecordDto.getSgOrderNo());
        respDto.setSgStatus(sourceRecordDto.getSgStatus());
        List orderItemResultRespDtoList = sourceRecordDto.getSourceOrderItemDtos().stream().map(item -> {
            DgOrderItemResultDto orderItemResultDto = new DgOrderItemResultDto();
            orderItemResultDto.setSgOrderNo(item.getSgOrderNo());
            orderItemResultDto.setLinkOrderItemId(item.getOrderItemId());
            orderItemResultDto.setLinkItemSkuCode(item.getSkuCode());
            orderItemResultDto.setBatch(item.getBatchNo());
            orderItemResultDto.setDeliveryLogicWarehouseCode(item.getSgWarehouseCode());
            orderItemResultDto.setDeliveryItemNum(item.getSgItemNum());
            return orderItemResultDto;
        }).collect(Collectors.toList());
        respDto.setOrderItemResultRespDtoList(orderItemResultRespDtoList);
        respDto.setSgStatus(SourceStatusEnum.SOURCE_SUCCESS.getCode());
        return respDto;
    }
}

