/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.convert.entity.DgAfterTypeRecordConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterTypeRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterTypeRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterTypeRecordPageReqDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterTypeRecordEo;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgAfterTypeRecordService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgAfterTypeRecordServiceImpl
extends BaseServiceImpl<DgAfterTypeRecordDto, DgAfterTypeRecordEo, IDgAfterTypeRecordDomain>
implements IDgAfterTypeRecordService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgAfterTypeRecordServiceImpl.class);
    @Resource
    private NoGreateUtil noGreateUtil;

    public DgAfterTypeRecordServiceImpl(IDgAfterTypeRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgAfterTypeRecordDto, DgAfterTypeRecordEo> converter() {
        return DgAfterTypeRecordConverter.INSTANCE;
    }

    public RestResponse<Long> insert(DgAfterTypeRecordDto dto) {
        LOGGER.info("\u552e\u540e\u7c7b\u578b\u6863\u6848\u63a5\u53e3\u670d\u52a1\u5b9e\u73b0\u7c7b\uff0c\u65b0\u589e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto.setInitStatus(Integer.valueOf(0));
        if (StringUtils.isBlank((CharSequence)dto.getAfterBusinessTypeCode())) {
            dto.setAfterBusinessTypeCode(this.noGreateUtil.generateAfterBusinessTypeCode());
        }
        this.checkAfterBusinessTypeCodeRep(dto.getId(), dto.getAfterBusinessTypeCode());
        return super.insert((BaseDto)dto);
    }

    public RestResponse<Integer> update(DgAfterTypeRecordDto dto) {
        LOGGER.info("\u552e\u540e\u7c7b\u578b\u6863\u6848\u63a5\u53e3\u670d\u52a1\u5b9e\u73b0\u7c7b\uff0c\u66f4\u65b0\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dto.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        dto.setInitStatus(null);
        this.checkAfterBusinessTypeCodeRep(dto.getId(), dto.getAfterBusinessTypeCode());
        return super.update((BaseDto)dto);
    }

    @Override
    public PageInfo<DgAfterTypeRecordDto> queryPage(DgAfterTypeRecordPageReqDto dto) {
        LOGGER.info("\u552e\u540e\u7c7b\u578b\u6863\u6848\u63a5\u53e3\u670d\u52a1\u5b9e\u73b0\u7c7b\uff0c\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgAfterTypeRecordDomain)this.domain).filter().eq(StringUtils.isNotBlank((CharSequence)dto.getAfterTypeCode()), (Object)"after_type_code", (Object)dto.getAfterTypeCode())).in(CollectionUtil.isNotEmpty((Collection)dto.getAfterTypeCodeList()), (Object)"after_type_code", (Collection)dto.getAfterTypeCodeList())).like(StringUtils.isNotBlank((CharSequence)dto.getAfterBusinessTypeName()), (Object)"after_business_type_name", (Object)("%" + dto.getAfterBusinessTypeName() + "%"))).eq(StringUtils.isNotBlank((CharSequence)dto.getAfterBusinessTypeCode()), (Object)"after_business_type_code", (Object)dto.getAfterBusinessTypeCode())).eq(ObjectUtil.isNotEmpty((Object)dto.getTypeStatus()), (Object)"type_status", (Object)dto.getTypeStatus())).orderByDesc((Object)"update_time")).page(dto.getPageNum(), dto.getPageSize());
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)eoPageInfo.getList())) {
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgAfterTypeRecordDto.class);
        }
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public void statusUpdate(Long id, Integer typeStatus) {
        LOGGER.info("\u552e\u540e\u7c7b\u578b\u6863\u6848\u63a5\u53e3\u670d\u52a1\u5b9e\u73b0\u7c7b\uff0c\u72b6\u6001\u53d8\u66f4\uff08\u542f\u52a8\u7981\u7528\uff09\uff1a{}\uff0c{}", (Object)id, (Object)typeStatus);
        DgAfterTypeRecordEo dgAfterTypeRecordEo = (DgAfterTypeRecordEo)((IDgAfterTypeRecordDomain)this.domain).selectByPrimaryKey(id);
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dgAfterTypeRecordEo), (String)"\u627e\u4e0d\u5230\u8be5\u7c7b\u578b\u4fe1\u606f");
        DgAfterTypeRecordEo updateEo = new DgAfterTypeRecordEo();
        updateEo.setId(id);
        updateEo.setTypeStatus(typeStatus);
        ((IDgAfterTypeRecordDomain)this.domain).updateSelective((BaseEo)updateEo);
    }

    @Override
    public DgAfterTypeRecordDto queryDefault(String afterTypeCode) {
        LOGGER.info("\u83b7\u53d6\u9ed8\u8ba4\u4e1a\u52a1\u7c7b\u578b\uff1a{}", (Object)afterTypeCode);
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgAfterTypeRecordDomain)this.domain).filter().eq((Object)"after_type_code", (Object)afterTypeCode)).eq((Object)"type_status", (Object)YesNoEnum.YES.getValue())).eq((Object)"init_status", (Object)YesNoEnum.YES.getValue())).orderByAsc((Object)"create_time")).list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            DgAfterTypeRecordDto recordDto = new DgAfterTypeRecordDto();
            CubeBeanUtils.copyProperties((Object)recordDto, list.get(0), (String[])new String[0]);
            return recordDto;
        }
        return null;
    }

    private void checkAfterBusinessTypeCodeRep(Long id, String code) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)code), (String)("\u4e1a\u52a1\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff1a" + code));
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgAfterTypeRecordDomain)this.domain).filter().ne(ObjectUtil.isNotEmpty((Object)id), (Object)"id", (Object)id)).eq((Object)"after_business_type_code", (Object)code)).list();
        AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)list), (String)("\u8be5\u4e1a\u52a1\u7c7b\u578b\u7f16\u7801\u5df2\u5b58\u5728\uff1a" + code));
    }
}

