/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountPageReqDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountApiProxy;
import com.yunxi.dg.base.center.credit.dto.entity.RepaymentStrategiesSimpleDto;
import com.yunxi.dg.base.center.credit.proxy.entity.IDemandRepaymentStrategiesDgApiProxy;
import com.yunxi.dg.base.center.report.dto.entity.BizTagRecordDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordPageReqDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagRecordRespDto;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagRecordApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderCreateAction;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountScopeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.dao.vo.DgOrderRemittanceStatisticsVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderItemAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderRemittanceStatisticsReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.custom.DgCustomPackageOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.CustomPackageOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizOrderItemRefundInfoRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgF2bOrderDetailRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgF2bOrderPayInfoRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgRequireRemitAmountRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.CustomPackageOrderPreviewRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgCustomPackageOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgOrderPreviewRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgPreviewRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgOrderItemAmountEo;
import com.yunxi.dg.base.center.trade.service.oms.channel.IDgF2BOrderService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgCalcActivityService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgF2BOrderServiceImpl
implements IDgF2BOrderService {
    private static final Logger log = LoggerFactory.getLogger(DgF2BOrderServiceImpl.class);
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderPaymentDomain dgPerformOrderPaymentDomain;
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private ICommonOrderQueryService commonOrderQueryService;
    @Resource
    private IDgOrderAmountDomain dgOrderAmountDomain;
    @Resource
    private IDgOrderItemAmountDomain dgOrderItemAmountDomain;
    @Resource
    private IDgCalcActivityService dgCalcActivityService;
    @Resource
    private IAccountApiProxy accountApiProxy;
    @Resource
    private IChannelOrderCreateAction channelOrderCreateAction;
    @Resource
    private IReBizTagRecordApiProxy reBizTagRecordApiProxy;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDemandRepaymentStrategiesDgApiProxy demandRepaymentStrategiesDgApiProxy;

    @Override
    public String generateF2BNo(String prefix, Integer footLength) {
        return this.noGreateUtil.generateF2BNo(prefix, footLength);
    }

    @Override
    public DgPreviewRespDto previewOrder(DgOrderPreviewReqDto previewReqDto) {
        previewReqDto.setNeedFeeThrow(false);
        List<DgF2BOrderPreviewContext> dgF2BOrderPreviewContexts = this.channelOrderCreateAction.channelOrderPreviewV2(previewReqDto);
        List orderPreviewRespDtos = dgF2BOrderPreviewContexts.stream().map(this::buildPreviewRespDto).collect(Collectors.toList());
        DgPreviewRespDto dgPreviewRespDto = new DgPreviewRespDto();
        dgPreviewRespDto.setOrganizationId(previewReqDto.getOrganizationId());
        dgPreviewRespDto.setCustomerId(previewReqDto.getCustomerId());
        dgPreviewRespDto.setEnterpriseId(previewReqDto.getEnterpriseId());
        dgPreviewRespDto.setOrderPreviewRespDtos(orderPreviewRespDtos);
        dgPreviewRespDto.setTotalPayAmount(orderPreviewRespDtos.stream().map(DgOrderPreviewRespDto::getTotalPayAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        dgPreviewRespDto.setTotalHandmadeDiscountAmount(orderPreviewRespDtos.stream().map(DgOrderPreviewRespDto::getTotalHandmadeDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        dgPreviewRespDto.setPayableAmount(orderPreviewRespDtos.stream().map(DgOrderPreviewRespDto::getPayableAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        dgPreviewRespDto.setRebatePayableAmount(orderPreviewRespDtos.stream().map(DgOrderPreviewRespDto::getRebatePayableAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        return dgPreviewRespDto;
    }

    @Override
    public CustomPackageOrderPreviewRespDto customPackagePreviewOrder(CustomPackageOrderPreviewReqDto previewReqDto) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)previewReqDto.getOrderAddrReqDtos()), (String)"\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AtomicLong addrLineAtom = new AtomicLong(0L);
        AtomicLong itemLineAtom = new AtomicLong(0L);
        ArrayList itemReqDtoList = Lists.newArrayList();
        for (DgCustomPackageOrderAddrReqDto orderAddrReqDto : previewReqDto.getOrderAddrReqDtos()) {
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)orderAddrReqDto.getItemList()), (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            orderAddrReqDto.setAddrLineNo(Optional.ofNullable(orderAddrReqDto.getAddrLineNo()).orElse(addrLineAtom.incrementAndGet()));
            for (OrderPreviewItemReqDto orderPreviewItemReqDto : orderAddrReqDto.getItemList()) {
                orderPreviewItemReqDto.setItemLineNo(Optional.ofNullable(orderPreviewItemReqDto.getItemLineNo()).orElse(itemLineAtom.incrementAndGet()));
                itemReqDtoList.add(orderPreviewItemReqDto);
            }
        }
        DgOrderPreviewReqDto dgOrderPreviewReqDto = (DgOrderPreviewReqDto)BeanUtil.copyProperties((Object)previewReqDto, DgOrderPreviewReqDto.class, (String[])new String[0]);
        dgOrderPreviewReqDto.setItemList((List)itemReqDtoList);
        dgOrderPreviewReqDto.setNeedFeeThrow(false);
        List<DgF2BOrderPreviewContext> dgF2BOrderPreviewContexts = this.channelOrderCreateAction.channelOrderPreviewV2(dgOrderPreviewReqDto);
        List orderPreviewRespDtos = dgF2BOrderPreviewContexts.stream().peek(f2BOrderPreviewContext -> f2BOrderPreviewContext.setDefPreviewActivity(false)).map(this::buildPreviewRespDto).collect(Collectors.toList());
        DgOrderPreviewRespDto dgOrderPreviewRespDto = (DgOrderPreviewRespDto)orderPreviewRespDtos.stream().findFirst().get();
        Map previewItemRespDtoMap = dgOrderPreviewRespDto.getItemList().stream().collect(Collectors.toMap(DgPreviewPerformOrderItemReqDto::getSortNo, Function.identity(), (e1, e2) -> e1));
        CustomPackageOrderPreviewRespDto dgPreviewRespDto = (CustomPackageOrderPreviewRespDto)BeanUtil.copyProperties((Object)dgOrderPreviewRespDto, CustomPackageOrderPreviewRespDto.class, (String[])new String[0]);
        dgPreviewRespDto.setCustomerId(previewReqDto.getCustomerId());
        ArrayList orderAddrReqDtos = Lists.newArrayList();
        for (DgCustomPackageOrderAddrReqDto orderAddrReqDto : previewReqDto.getOrderAddrReqDtos()) {
            DgCustomPackageOrderAddrRespDto addrRespDto = (DgCustomPackageOrderAddrRespDto)BeanUtil.copyProperties((Object)orderAddrReqDto, DgCustomPackageOrderAddrRespDto.class, (String[])new String[0]);
            ArrayList orderItemReqDtos = Lists.newArrayList();
            BigDecimal addrSpeciesNum = new BigDecimal(orderAddrReqDto.getItemList().size());
            BigDecimal addrTotalNum = BigDecimal.ZERO;
            BigDecimal totalVolume = BigDecimal.ZERO;
            BigDecimal addrTotalMarketAmount = BigDecimal.ZERO;
            BigDecimal addrTotalPayAmount = BigDecimal.ZERO;
            for (OrderPreviewItemReqDto itemReqDto : orderAddrReqDto.getItemList()) {
                DgPreviewPerformOrderItemReqDto itemRespDto = (DgPreviewPerformOrderItemReqDto)previewItemRespDtoMap.get(itemReqDto.getItemLineNo());
                AssertUtils.notNull((Object)itemRespDto, (String)"\u9884\u89c8\u8f6c\u6362\u6570\u636e\u5931\u8d25\uff0c\u5546\u54c1\u6570\u636e\u5f02\u5e38");
                DgPreviewPerformOrderItemReqDto addrItemRespDto = (DgPreviewPerformOrderItemReqDto)BeanUtil.copyProperties((Object)itemRespDto, DgPreviewPerformOrderItemReqDto.class, (String[])new String[0]);
                if (addrItemRespDto.getPackingNumber() != null) {
                    addrItemRespDto.setBoxNum(addrItemRespDto.getItemNum().divide(addrItemRespDto.getPackingNumber(), 2, 1));
                }
                addrItemRespDto.setOrderTotalAmount(addrItemRespDto.getCalcItemNum().multiply(addrItemRespDto.getItemMarketPrice()));
                addrTotalMarketAmount = addrTotalMarketAmount.add(addrItemRespDto.getOrderTotalAmount());
                addrTotalPayAmount = addrTotalPayAmount.add(addrItemRespDto.getPayAmount());
                addrTotalNum = addrTotalNum.add(addrItemRespDto.getCalcItemNum());
                totalVolume = totalVolume.add(itemRespDto.getVolume());
                orderItemReqDtos.add(addrItemRespDto);
            }
            addrRespDto.setAddrSpeciesNum(addrSpeciesNum);
            addrRespDto.setAddrTotalNum(addrTotalNum);
            addrRespDto.setTotalVolume(totalVolume);
            addrRespDto.setAddrTotalMarketAmount(addrTotalMarketAmount);
            addrRespDto.setAddrTotalPayAmount(addrTotalPayAmount);
            addrRespDto.setItemList((List)orderItemReqDtos);
            orderAddrReqDtos.add(addrRespDto);
        }
        dgPreviewRespDto.setOrderAddrRespDtos((List)orderAddrReqDtos);
        return dgPreviewRespDto;
    }

    private DgOrderPreviewRespDto buildPreviewRespDto(DgF2BOrderPreviewContext orderCalcDto) {
        DgF2BPerformOrderReqDto dgF2BPerformOrderReqDto = orderCalcDto.getDgF2BPerformOrderReqDto();
        DgOrderPreviewRespDto dgOrderPreviewRespDto = new DgOrderPreviewRespDto();
        dgOrderPreviewRespDto.setShopId(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getShopId());
        dgOrderPreviewRespDto.setShopCode(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
        dgOrderPreviewRespDto.setShopName(dgF2BPerformOrderReqDto.getPerformOrderSnapshotDto().getShopName());
        dgOrderPreviewRespDto.setTotalMarketAmount(dgF2BPerformOrderReqDto.getTotalAmount());
        dgOrderPreviewRespDto.setTotalOrigAmount(dgF2BPerformOrderReqDto.getPayAmount());
        dgOrderPreviewRespDto.setTotalPayAmount(dgF2BPerformOrderReqDto.getRealPayAmount());
        dgOrderPreviewRespDto.setTotalHandmadeDiscountAmount(dgF2BPerformOrderReqDto.getTotalHandmadeDiscountAmount());
        dgOrderPreviewRespDto.setPayableAmount(dgF2BPerformOrderReqDto.getPayableAmount());
        dgOrderPreviewRespDto.setRebatePayableAmount(dgF2BPerformOrderReqDto.getRebatePayableAmount());
        dgOrderPreviewRespDto.setItemList(orderCalcDto.getDgF2BPerformOrderReqDto().getItemList());
        dgOrderPreviewRespDto.setGiftList(orderCalcDto.getGiftItemList());
        dgOrderPreviewRespDto.setMaterialList(orderCalcDto.getDgF2BPerformOrderReqDto().getMaterialList());
        dgOrderPreviewRespDto.setOrderFeeControlRespDto(orderCalcDto.getOrderFeeControlRespDto());
        ArrayList skuIds = Lists.newArrayList();
        BigDecimal totalVolume = BigDecimal.ZERO;
        BigDecimal totalWeight = BigDecimal.ZERO;
        for (DgPreviewPerformOrderItemReqDto itemReqDto : dgOrderPreviewRespDto.getItemList()) {
            totalVolume = totalVolume.add(itemReqDto.getVolume());
            totalWeight = totalWeight.add(itemReqDto.getWeight());
            skuIds.add(itemReqDto.getSkuId());
        }
        if (CollectionUtil.isNotEmpty((Collection)dgOrderPreviewRespDto.getGiftList())) {
            for (DgPreviewPerformOrderItemReqDto giftItemDto : dgOrderPreviewRespDto.getGiftList()) {
                totalVolume = totalVolume.add(giftItemDto.getVolume());
                totalWeight = totalWeight.add(giftItemDto.getWeight());
                skuIds.add(giftItemDto.getSkuId());
            }
        }
        dgOrderPreviewRespDto.setTotalVolume(totalVolume.setScale(6, 4));
        dgOrderPreviewRespDto.setTotalWeight(totalWeight.setScale(6, 4));
        if (orderCalcDto.isDefPreviewActivity()) {
            this.dgCalcActivityService.previewActivity(orderCalcDto);
        }
        this.dgCalcActivityService.dealActivityInfo(orderCalcDto, dgOrderPreviewRespDto);
        ReBizTagRecordPageReqDto itemTagReqDto = new ReBizTagRecordPageReqDto();
        itemTagReqDto.setSkuIds((List)skuIds);
        itemTagReqDto.setTagStatus(YesNoEnum.YES.getValue());
        itemTagReqDto.setRecordLinkParentId(dgOrderPreviewRespDto.getShopId());
        List reBizTagRecordRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.reBizTagRecordApiProxy.findAll(itemTagReqDto));
        Map<Long, List<ReBizTagRecordRespDto>> itemTagGroup = reBizTagRecordRespDtos.stream().collect(Collectors.groupingBy(BizTagRecordDto::getRecordLinkId));
        for (DgPreviewPerformOrderItemReqDto itemReqDto : dgOrderPreviewRespDto.getItemList()) {
            itemReqDto.setReBizTagRecordRespDtos(itemTagGroup.get(itemReqDto.getSkuId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)dgOrderPreviewRespDto.getGiftList())) {
            for (DgPreviewPerformOrderItemReqDto giftItem : dgOrderPreviewRespDto.getGiftList()) {
                giftItem.setReBizTagRecordRespDtos(itemTagGroup.get(giftItem.getSkuId()));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)dgF2BPerformOrderReqDto.getItemList())) {
            for (DgPreviewPerformOrderItemReqDto item : dgOrderPreviewRespDto.getItemList()) {
                if (item.getTotalUseCostAmount().compareTo(BigDecimal.ZERO) <= 0 || item.getRealPayAmount().compareTo(item.getTotalUseCostAmount()) < 0) continue;
                item.setRealPayAmount(item.getRealPayAmount().subtract(item.getTotalUseCostAmount()));
            }
        }
        return dgOrderPreviewRespDto;
    }

    private void setOrderAmountInfo(DgF2bOrderDetailRespDto dgBizPerformOrderRespDto) {
        LambdaQueryWrapper orderAmountQuery = new LambdaQueryWrapper();
        orderAmountQuery.eq(DgOrderAmountEo::getOrderId, (Object)dgBizPerformOrderRespDto.getId());
        List orderAmountDtoList = this.dgOrderAmountDomain.getMapper().selectList((Wrapper)orderAmountQuery);
        ArrayList discountAmountEos = Lists.newArrayList();
        BigDecimal goodsTotalAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        BigDecimal totalOrderDiscountAmount = BigDecimal.ZERO;
        BigDecimal discountGoodsAmount = BigDecimal.ZERO;
        for (DgOrderAmountEo amount : orderAmountDtoList) {
            switch (DgOrderAmountTypeEnum.getForCode((String)amount.getAmountType())) {
                case SALE_TOTAL: {
                    goodsTotalAmount = goodsTotalAmount.add(amount.getAmount());
                    break;
                }
                case PAY_AMOUNT: {
                    payAmount = payAmount.add(amount.getAmount());
                    break;
                }
                case TOTAL_DISCOUNT_AMOUNT: {
                    if (DgOrderAmountScopeEnum.ALL.getCode().equals(amount.getScope())) {
                        totalOrderDiscountAmount = totalOrderDiscountAmount.add(amount.getAmount());
                    } else {
                        discountGoodsAmount = discountGoodsAmount.add(amount.getAmount());
                    }
                    discountAmountEos.add(amount);
                    break;
                }
            }
        }
        dgBizPerformOrderRespDto.setGoodsTotalAmount(goodsTotalAmount);
        dgBizPerformOrderRespDto.setPayAmount(payAmount);
        dgBizPerformOrderRespDto.setTotalOrderDiscountAmount(totalOrderDiscountAmount);
        dgBizPerformOrderRespDto.setDiscountGoodsAmount(discountGoodsAmount);
        dgBizPerformOrderRespDto.setDiscountAmount(totalOrderDiscountAmount.add(discountGoodsAmount));
        ArrayList allScopeItems = Lists.newArrayList();
        ArrayList assingScopeItems = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty((Collection)discountAmountEos)) {
            LambdaQueryWrapper orderItemAmountQuery = new LambdaQueryWrapper();
            orderItemAmountQuery.in(DgOrderItemAmountEo::getOrderAmountId, (Collection)discountAmountEos.stream().map(BaseEo::getId).collect(Collectors.toList()));
            orderItemAmountQuery.eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue());
            List orderItemAmountDtoList = this.dgOrderItemAmountDomain.getMapper().selectList((Wrapper)orderItemAmountQuery);
            Map<Long, List<DgOrderItemAmountEo>> orderItemAmountEoGroup = orderItemAmountDtoList.stream().collect(Collectors.groupingBy(DgOrderItemAmountEo::getOrderAmountId));
            for (DgOrderAmountEo discountAmountEo : discountAmountEos) {
                List<DgOrderItemAmountEo> dgOrderItemAmountEos = Optional.ofNullable(orderItemAmountEoGroup.get(discountAmountEo.getId())).orElse(Lists.newArrayList());
                Integer scope = discountAmountEo.getScope();
                if (DgOrderAmountScopeEnum.ALL.getCode().equals(scope)) {
                    allScopeItems.addAll(dgOrderItemAmountEos);
                    continue;
                }
                assingScopeItems.addAll(dgOrderItemAmountEos);
            }
        }
        Map<Long, BigDecimal> allScopeAmountMap = allScopeItems.stream().collect(Collectors.groupingBy(DgOrderItemAmountEo::getOrderItemId, Collectors.reducing(BigDecimal.ZERO, DgOrderItemAmountEo::getAmount, BigDecimal::add)));
        Map<Long, BigDecimal> assingAmountMap = assingScopeItems.stream().collect(Collectors.groupingBy(DgOrderItemAmountEo::getOrderItemId, Collectors.reducing(BigDecimal.ZERO, DgOrderItemAmountEo::getAmount, BigDecimal::add)));
        for (DgPerformOrderItemExtRespDto dgPerformOrderItemExtRespDto : dgBizPerformOrderRespDto.getItemList()) {
            BigDecimal allScopeAmount = Optional.ofNullable(allScopeAmountMap.get(dgPerformOrderItemExtRespDto.getId())).orElse(BigDecimal.ZERO);
            BigDecimal assingScopeAmount = Optional.ofNullable(assingAmountMap.get(dgPerformOrderItemExtRespDto.getId())).orElse(BigDecimal.ZERO);
            dgPerformOrderItemExtRespDto.setOrderDiscountAmount(allScopeAmount);
            dgPerformOrderItemExtRespDto.setGoodsDiscountAmount(assingScopeAmount);
            dgPerformOrderItemExtRespDto.setDiscountAmount(allScopeAmount.add(assingScopeAmount));
        }
    }

    private void setOrderItemAmountInfo(DgF2bOrderDetailRespDto dgBizPerformOrderRespDto) {
        LambdaQueryWrapper orderAmountQuery = new LambdaQueryWrapper();
        orderAmountQuery.eq(DgOrderItemAmountEo::getOrderId, (Object)dgBizPerformOrderRespDto.getId());
        List orderItemAmountEos = this.dgOrderItemAmountDomain.getMapper().selectList((Wrapper)orderAmountQuery);
        Map itemAmountMap = orderItemAmountEos.stream().collect(Collectors.groupingBy(DgOrderItemAmountEo::getOrderItemId, Collectors.toMap(DgOrderItemAmountEo::getAmountType, Function.identity(), (e1, e2) -> e1)));
        for (DgPerformOrderItemExtRespDto item : dgBizPerformOrderRespDto.getItemList()) {
            Map amountEoMap = Optional.ofNullable(itemAmountMap.get(item.getId())).orElse(Maps.newHashMap());
            item.setSalePrice(item.getItemMarketPrice());
            item.setTaxRate(Optional.ofNullable(amountEoMap.get(DgOrderAmountTypeEnum.TAX_RATE.getCode())).map(DgOrderItemAmountEo::getAmount).orElse(BigDecimal.ZERO));
            item.setLineTaxAmount(Optional.ofNullable(amountEoMap.get(DgOrderAmountTypeEnum.TAX_AMOUNT.getCode())).map(DgOrderItemAmountEo::getAmount).orElse(BigDecimal.ZERO));
            item.setPayAmountNoTax(Optional.ofNullable(amountEoMap.get(DgOrderAmountTypeEnum.ORIG_AMOUNT_NOTAX.getCode())).map(DgOrderItemAmountEo::getAmount).orElse(BigDecimal.ZERO));
            item.setRealPayAmount(item.getPayAmount());
            item.setRealPayAmountNoTax(Optional.ofNullable(amountEoMap.get(DgOrderAmountTypeEnum.PAY_AMOUNT_NOTAX.getCode())).map(DgOrderItemAmountEo::getAmount).orElse(BigDecimal.ZERO));
            DgBizOrderItemRefundInfoRespDto itemRefundInfoDto = new DgBizOrderItemRefundInfoRespDto();
            itemRefundInfoDto.setOrderId(dgBizPerformOrderRespDto.getId());
            itemRefundInfoDto.setOrderItemId(item.getId());
            itemRefundInfoDto.setRefundPayAmount(Optional.ofNullable(amountEoMap.get(DgOrderAmountTypeEnum.REFUND_PAY_AMOUNT.getCode())).map(DgOrderItemAmountEo::getAmount).orElse(BigDecimal.ZERO));
            itemRefundInfoDto.setRefundCost(Optional.ofNullable(amountEoMap.get(DgOrderAmountTypeEnum.REFUND_COST.getCode())).map(DgOrderItemAmountEo::getAmount).orElse(BigDecimal.ZERO));
            itemRefundInfoDto.setRefundKneadAmount(Optional.ofNullable(amountEoMap.get(DgOrderAmountTypeEnum.REFUND_KNEAD_AMOUNT.getCode())).map(DgOrderItemAmountEo::getAmount).orElse(BigDecimal.ZERO));
            itemRefundInfoDto.setRefundKneadCost(Optional.ofNullable(amountEoMap.get(DgOrderAmountTypeEnum.REFUND_KNEAD_COST.getCode())).map(DgOrderItemAmountEo::getAmount).orElse(BigDecimal.ZERO));
            item.setOrderItemRefundInfoDto(itemRefundInfoDto);
        }
    }

    @Override
    public DgF2bOrderPayInfoRespDto getOrderPayTimeById(Long orderId) {
        DgPerformOrderRespDto dgPerformOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)dgPerformOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgF2bOrderPayInfoRespDto respDto = new DgF2bOrderPayInfoRespDto();
        respDto.setId(dgPerformOrderRespDto.getId());
        respDto.setSaleOrderNo(dgPerformOrderRespDto.getSaleOrderNo());
        respDto.setCloseTime(dgPerformOrderRespDto.getCloseTime());
        if (Objects.nonNull(dgPerformOrderRespDto.getPerformOrderExtensionDto().getStayTime())) {
            respDto.setCloseTime(dgPerformOrderRespDto.getPerformOrderExtensionDto().getStayTime());
        }
        respDto.setPayAmount(dgPerformOrderRespDto.getPerformOrderAmountDto().getRealPayAmount());
        respDto.setRemainingPayAmount(dgPerformOrderRespDto.getPerformOrderPaymentDto().getRemainingPayAmount());
        RepaymentStrategiesSimpleDto demandRepaymentStrategiesReqDto = new RepaymentStrategiesSimpleDto();
        demandRepaymentStrategiesReqDto.setBiNo(dgPerformOrderRespDto.getSaleOrderNo());
        demandRepaymentStrategiesReqDto.setShopId(dgPerformOrderRespDto.getPerformOrderSnapshotDto().getShopId());
        demandRepaymentStrategiesReqDto.setCustomerId(dgPerformOrderRespDto.getPerformOrderSnapshotDto().getCustomerId());
        demandRepaymentStrategiesReqDto.setPaidAmount(dgPerformOrderRespDto.getPerformOrderAmountDto().getRealPayAmount());
        demandRepaymentStrategiesReqDto.setRebateAmount(dgPerformOrderRespDto.getPerformOrderAmountDto().getPayAmount().subtract(dgPerformOrderRespDto.getPerformOrderAmountDto().getRealPayAmount()));
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u8ba2\u5355\uff1a{}\uff0c\u67e5\u8be2\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u5165\u53c2\uff1a{}", (Object)dgPerformOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)demandRepaymentStrategiesReqDto));
        RepaymentStrategiesSimpleDto repaymentStrategiesSimpleDto = (RepaymentStrategiesSimpleDto)RestResponseHelper.extractData((RestResponse)this.demandRepaymentStrategiesDgApiProxy.getRepaymentAmount(demandRepaymentStrategiesReqDto));
        log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\u8ba2\u5355\uff1a{}\uff0c\u67e5\u8be2\u968f\u5355\u8fd8\u6b3e\u91d1\u989d\u51fa\u53c2\uff1a{}", (Object)dgPerformOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)repaymentStrategiesSimpleDto));
        if (null != repaymentStrategiesSimpleDto) {
            BigDecimal payableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getPayableAmount()).orElse(BigDecimal.ZERO);
            BigDecimal repaidMultipleAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRepaidMultipleAmount()).orElse(BigDecimal.ZERO);
            respDto.setRemainingPayableAmount(payableAmount.subtract(repaidMultipleAmount));
            if (dgPerformOrderRespDto.getPerformOrderAmountDto().getPayAmount().subtract(dgPerformOrderRespDto.getPerformOrderAmountDto().getRealPayAmount()).compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal rebatePayableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRebatePayableAmount()).orElse(BigDecimal.ZERO);
                BigDecimal repaidRebateAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRepaidRebateAmount()).orElse(BigDecimal.ZERO);
                respDto.setRemainingRebatePayableAmount(rebatePayableAmount.subtract(repaidRebateAmount));
            } else {
                respDto.setRemainingRebatePayableAmount(BigDecimal.ZERO);
            }
        }
        return respDto;
    }

    @Override
    public List<DgF2bOrderDetailRespDto> f2bOrderSimpleDetailByOrderNos(List<String> orderNos) {
        ArrayList<DgF2bOrderDetailRespDto> resp = new ArrayList<DgF2bOrderDetailRespDto>();
        if (CollectionUtils.isEmpty(orderNos)) {
            return resp;
        }
        for (String orderNo : orderNos) {
            AssertUtils.notNull((Object)orderNo, (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            DgBizPerformOrderRespDto dgBizPerformOrderRespDto = this.commonOrderQueryService.queryByOrderNo(orderNo);
            AssertUtils.notNull((Object)dgBizPerformOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            DgF2bOrderDetailRespDto respDto = new DgF2bOrderDetailRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)dgBizPerformOrderRespDto, (String[])new String[]{"relatedOrderList", "itemList"});
            respDto.setRelatedOrderList(dgBizPerformOrderRespDto.getRelatedOrderList());
            respDto.setItemList(dgBizPerformOrderRespDto.getItemList());
            this.setOrderAmountInfo(respDto);
            this.setOrderItemAmountInfo(respDto);
            if (CollectionUtil.isNotEmpty((Collection)respDto.getItemList())) {
                HashSet<String> itemSet = new HashSet<String>();
                ArrayList<String> itemPathUrlList = new ArrayList<String>();
                for (DgPerformOrderItemExtRespDto item : respDto.getItemList()) {
                    if (itemSet.contains(item.getSkuCode())) continue;
                    if (StringUtils.isNotBlank((CharSequence)item.getImgUrl())) {
                        itemPathUrlList.add(item.getImgUrl());
                    }
                    itemSet.add(item.getSkuCode());
                }
                respDto.setItemCodeCount(new BigDecimal(itemSet.size()));
                respDto.setItemPathUrlList(itemPathUrlList);
            }
            resp.add(respDto);
        }
        return resp;
    }

    @Override
    public List<DgOrderStatusRespDto> queryOrderStatusSteps(List<String> orderNos) {
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryByOrderNos(orderNos);
        if (CollectionUtil.isEmpty((Collection)dgPerformOrderInfoEos)) {
            return Collections.emptyList();
        }
        List dgOrderStatusRespDtoList = BeanUtil.copyToList((Collection)dgPerformOrderInfoEos, DgOrderStatusRespDto.class);
        for (DgOrderStatusRespDto respDto : dgOrderStatusRespDtoList) {
            String orderSteps = respDto.getOrderSteps();
            if (!StringUtils.isNotBlank((CharSequence)orderSteps)) continue;
            respDto.setOrderStepList(JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class));
        }
        return dgOrderStatusRespDtoList;
    }

    @Override
    public DgRequireRemitAmountRespDto getRequireRemitAmount(DgOrderRemittanceStatisticsReqDto reqDto) {
        List<String> f2BOrderStatusCodes = Arrays.asList(DgF2BOrderStatus.WAIT_PAY.getCode(), DgF2BOrderStatus.WAIT_CS_AUDIT.getCode(), DgF2BOrderStatus.WAIT_FINANCE_AUDIT.getCode());
        List statisticsVoList = this.dgPerformOrderPaymentDomain.sumRemainingPayAmountByCustomerCodeAndShopCode(reqDto.getCustomerCode(), reqDto.getShopCode(), f2BOrderStatusCodes);
        BigDecimal sumtTotalRemainingPayAmount = BigDecimal.ZERO;
        BigDecimal sumCreditDebtAmount = BigDecimal.ZERO;
        BigDecimal sumAccountDebtAmount = BigDecimal.ZERO;
        BigDecimal sumTotalRemitAmount = BigDecimal.ZERO;
        ArrayList allAccountDtoList = Lists.newArrayList();
        ArrayList shopRequireRemitAmountRespDtos = Lists.newArrayList();
        for (DgOrderRemittanceStatisticsVo vo : statisticsVoList) {
            DgRequireRemitAmountRespDto remitAmountRespDto = new DgRequireRemitAmountRespDto();
            remitAmountRespDto.setCustomerCode(reqDto.getCustomerCode());
            remitAmountRespDto.setShopCode(reqDto.getShopCode());
            BigDecimal capitalAccountQuota = BigDecimal.ZERO;
            BigDecimal creditDebtAmount = BigDecimal.ZERO;
            AccountPageReqDto accountPageReqDto = new AccountPageReqDto();
            accountPageReqDto.setCustomerNo(reqDto.getCustomerCode());
            accountPageReqDto.setShopCode(reqDto.getShopCode());
            List accountDtoList = (List)RestResponseHelper.extractData((RestResponse)this.accountApiProxy.list(accountPageReqDto));
            remitAmountRespDto.setAccountDtoList(accountDtoList);
            if (vo.getTotalRemainingPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                capitalAccountQuota = accountDtoList.stream().filter(accountDto -> Objects.equals(accountDto.getAccountCategory(), AccountCategoryEnum.CAPITAL.getCode())).map(AccountDto::getDisposable).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                RepaymentStrategiesSimpleDto demandRepaymentStrategiesReqDto = new RepaymentStrategiesSimpleDto();
                demandRepaymentStrategiesReqDto.setBiNo("statistics");
                demandRepaymentStrategiesReqDto.setShopId(vo.getShopId());
                demandRepaymentStrategiesReqDto.setCustomerId(vo.getCustomerId());
                demandRepaymentStrategiesReqDto.setPaidAmount(vo.getTotalUnRepaymentRemainingPayAmount());
                demandRepaymentStrategiesReqDto.setRebateAmount(BigDecimal.ZERO);
                log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\uff0c\u67e5\u8be2\u968f\u5355\u603b\u8fd8\u6b3e\u91d1\u989d\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)demandRepaymentStrategiesReqDto));
                RepaymentStrategiesSimpleDto repaymentStrategiesSimpleDto = (RepaymentStrategiesSimpleDto)RestResponseHelper.extractData((RestResponse)this.demandRepaymentStrategiesDgApiProxy.getRepaymentAmount(demandRepaymentStrategiesReqDto));
                log.info("[\u8ba2\u5355\u652f\u4ed8\u4fe1\u7528\u8fd8\u6b3e]\uff0c\u67e5\u8be2\u968f\u5355\u603b\u8fd8\u6b3e\u91d1\u989d\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)repaymentStrategiesSimpleDto));
                BigDecimal payableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getPayableAmount()).orElse(BigDecimal.ZERO);
                BigDecimal rebatePayableAmount = Optional.ofNullable(repaymentStrategiesSimpleDto.getRebatePayableAmount()).orElse(BigDecimal.ZERO);
                creditDebtAmount = payableAmount.subtract(rebatePayableAmount);
            }
            remitAmountRespDto.setTotalRemainingPayAmount(vo.getTotalRemainingPayAmount());
            remitAmountRespDto.setCreditDebtAmount(creditDebtAmount);
            remitAmountRespDto.setAccountDebtAmount(BigDecimal.ZERO.compareTo(capitalAccountQuota) > 0 ? capitalAccountQuota.abs() : BigDecimal.ZERO);
            BigDecimal totalRemitAmount = remitAmountRespDto.getTotalRemainingPayAmount().add(remitAmountRespDto.getCreditDebtAmount()).add(remitAmountRespDto.getAccountDebtAmount());
            if (BigDecimal.ZERO.compareTo(capitalAccountQuota) < 0) {
                totalRemitAmount = totalRemitAmount.subtract(capitalAccountQuota);
            }
            remitAmountRespDto.setTotalRemitAmount(BigDecimal.ZERO.compareTo(capitalAccountQuota) > 0 ? BigDecimal.ZERO : totalRemitAmount);
            shopRequireRemitAmountRespDtos.add(remitAmountRespDto);
            sumTotalRemitAmount = sumTotalRemitAmount.add(remitAmountRespDto.getTotalRemitAmount());
            sumAccountDebtAmount = sumAccountDebtAmount.add(remitAmountRespDto.getAccountDebtAmount());
            sumCreditDebtAmount = sumCreditDebtAmount.add(remitAmountRespDto.getCreditDebtAmount());
            sumtTotalRemainingPayAmount = sumtTotalRemainingPayAmount.add(remitAmountRespDto.getTotalRemainingPayAmount());
            Optional.ofNullable(remitAmountRespDto.getAccountDtoList()).ifPresent(allAccountDtoList::addAll);
        }
        DgRequireRemitAmountRespDto remitAmountRespDto = new DgRequireRemitAmountRespDto();
        remitAmountRespDto.setCustomerCode(reqDto.getCustomerCode());
        remitAmountRespDto.setShopCode(reqDto.getShopCode());
        remitAmountRespDto.setShopRequireRemitAmountRespDtos((List)shopRequireRemitAmountRespDtos);
        remitAmountRespDto.setTotalRemainingPayAmount(sumtTotalRemainingPayAmount);
        remitAmountRespDto.setCreditDebtAmount(sumCreditDebtAmount);
        remitAmountRespDto.setAccountDebtAmount(sumAccountDebtAmount);
        remitAmountRespDto.setTotalRemitAmount(sumTotalRemitAmount);
        remitAmountRespDto.setAccountDtoList((List)allAccountDtoList);
        return remitAmountRespDto;
    }
}

