/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.common.Impl;

import com.alibaba.fastjson.JSON;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgAfterLabelManageService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgAfterLabelManageServiceImpl
implements IDgAfterLabelManageService {
    private static final Logger log = LoggerFactory.getLogger(DgAfterLabelManageServiceImpl.class);
    @Resource
    private IDgAfterSaleOrderItemDomain dgAfterSaleOrderItemDomain;
    @Resource
    private IDgOrderLabelItemDomain orderLabelItemDomain;

    @Override
    public void markRefundByAfsOrderId(Long afterSaleOrderId) {
        List dgAfterSaleOrderItemEos = this.dgAfterSaleOrderItemDomain.queryEosByAfterSaleOrderId(afterSaleOrderId);
        AssertUtils.notEmpty((Collection)dgAfterSaleOrderItemEos, (String)"\u552e\u540e\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u552e\u540e\u5546\u54c1", (Object[])new Object[]{afterSaleOrderId});
        this.markSaleOrderLineRefundByAfterSaleItem(dgAfterSaleOrderItemEos);
    }

    private void markSaleOrderLineRefundByAfterSaleItem(List<DgAfterSaleOrderItemEo> dgAfterSaleOrderItemEos) {
        for (DgAfterSaleOrderItemEo item : dgAfterSaleOrderItemEos) {
            this.orderLabelItemDomain.addOrderLabelItem(item.getSaleOrderId(), item.getSaleOrderItemId(), DgOrderLabelEnum.REFUND_ITEM);
        }
    }

    @Override
    public void removeRefundByAfsOrderId(Long saleOrderId, List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtoList) {
        log.debug("[\u8ba2\u5355\u5546\u54c1\u9000\u6b3e\u6253\u6807]\u9700\u8981\u79fb\u9664\u6253\u9000\u6b3e\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(afterSaleOrderItemRespDtoList));
        Optional.ofNullable(afterSaleOrderItemRespDtoList).ifPresent(orderRefundRespDtoList -> orderRefundRespDtoList.forEach(item -> this.orderLabelItemDomain.removeOrderLabelItemById(saleOrderId, item.getSaleOrderItemId(), DgOrderLabelEnum.REFUND_ITEM)));
    }

    @Override
    public void markErrorByOrderId(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("[\u6253\u6807]\u8ba2\u5355={}\u6253\u552e\u540e\u8ba2\u5355\u6807\u8bc6", (Object)saleOrderId);
        this.orderLabelItemDomain.addOrderLabelRecord(saleOrderId, DgOrderLabelEnum.AFTER_SALE_ORDER_ERROR);
    }
}

