/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.common.Impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.ds.BaseMapper;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.share.dto.entity.DgInventoryPreemptionSupplyDto;
import com.yunxi.dg.base.center.share.dto.entity.DgInventoryPreemptionSupplyPageReqDto;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgInventoryPreemptionSupplyApiProxy;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSupplyMatchOrderLineRecordDomain;
import com.yunxi.dg.base.center.trade.eo.DgSupplyMatchOrderLineRecordEo;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgSupplyGroupMatchSupportService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class DgSupplyGroupMatchSupportServiceImpl
implements IDgSupplyGroupMatchSupportService {
    private static final Logger log = LoggerFactory.getLogger(DgSupplyGroupMatchSupportServiceImpl.class);
    @Resource
    private IDgInventoryPreemptionSupplyApiProxy dgInventoryPreemptionSupplyApiProxy;
    @Resource
    private IDgSupplyMatchOrderLineRecordDomain dgSupplyMatchOrderLineRecordDomain;
    @Resource
    private PlatformTransactionManager transactionManager;
    @Resource
    private ILockService lockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<IDgSupplyGroupMatchSupportService.MatchResultBo> matchAndSave(IDgSupplyGroupMatchSupportService.MatchBo matchBo) {
        List list;
        AssertUtils.isTrue((StringUtils.isNotBlank((CharSequence)matchBo.getPlatformOrderNo()) && StringUtils.isNotBlank((CharSequence)matchBo.getOrderNo()) && CollectionUtils.isNotEmpty(matchBo.getLineBoList()) ? 1 : 0) != 0, (String)("\u5339\u914d\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38:" + JSONObject.toJSONString((Object)matchBo)));
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setIsolationLevel(2);
        transactionTemplate.setPropagationBehavior(3);
        try {
            list = (List)transactionTemplate.execute(s -> {
                Mutex lock = null;
                try {
                    lock = this.lockService.lock("DgSupplyGroupMatchSupportServiceImpl.matchAndSave", matchBo.getPlatformOrderNo(), 20, 40, TimeUnit.SECONDS);
                    List<IDgSupplyGroupMatchSupportService.MatchResultBo> list = this.doMatch(matchBo);
                    return list;
                }
                finally {
                    Optional.ofNullable(lock).ifPresent(arg_0 -> ((ILockService)this.lockService).unlock(arg_0));
                }
            });
        }
        catch (Throwable throwable) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(matchBo){
                final /* synthetic */ IDgSupplyGroupMatchSupportService.MatchBo val$matchBo;
                {
                    this.val$matchBo = matchBo;
                }

                public void afterCompletion(int status) {
                    log.info("\u5bfb\u6e90\u7ed3\u675f:{}, \u5f53\u524d\u72b6\u6001", (Object)status);
                    if (status == 1 || status == 2) {
                        DgSupplyGroupMatchSupportServiceImpl.this.removeRecord(this.val$matchBo.getOrderNo());
                    }
                }
            });
            throw throwable;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* invalid duplicate definition of identical inner class */);
        return list;
    }

    private List<IDgSupplyGroupMatchSupportService.MatchResultBo> doMatch(IDgSupplyGroupMatchSupportService.MatchBo matchBo) {
        List supplyMatchOrderLineRecordEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgSupplyMatchOrderLineRecordDomain.filter().ne(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{matchBo.getPreOrderNo()}), (Object)"order_no", (Object)matchBo.getPreOrderNo())).eq((Object)"platform_order_no", (Object)matchBo.getPlatformOrderNo())).list();
        Map<String, Map<Long, BigDecimal>> groupLineApplyNumMap = supplyMatchOrderLineRecordEos.stream().collect(Collectors.groupingBy(DgSupplyMatchOrderLineRecordEo::getGroupCode, Collectors.groupingBy(DgSupplyMatchOrderLineRecordEo::getOrderItemId, Collectors.mapping(DgSupplyMatchOrderLineRecordEo::getApplyNum, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))));
        DgInventoryPreemptionSupplyPageReqDto reqDto = new DgInventoryPreemptionSupplyPageReqDto();
        reqDto.setSourceNo(matchBo.getPlatformOrderNo());
        reqDto.setValid("enable");
        Map<Long, BigDecimal> supplyMap = matchBo.getLineBoList().stream().collect(Collectors.toMap(IDgSupplyGroupMatchSupportService.MatchLineBo::getOrderLineId, IDgSupplyGroupMatchSupportService.MatchLineBo::getSupplyNum));
        ArrayList<IDgSupplyGroupMatchSupportService.MatchResultBo> resultBos = new ArrayList<IDgSupplyGroupMatchSupportService.MatchResultBo>();
        List supplyDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgInventoryPreemptionSupplyApiProxy.list(reqDto));
        supplyDtos.stream().filter(supplyDto -> {
            BigDecimal lessNum;
            BigDecimal preemptNum = Optional.ofNullable(supplyDto.getPreemptNum()).orElse(BigDecimal.ZERO);
            return preemptNum.compareTo(lessNum = Optional.ofNullable(supplyDto.getLessNum()).orElse(BigDecimal.ZERO)) != 0;
        }).collect(Collectors.groupingBy(DgInventoryPreemptionSupplyDto::getGroupCode)).forEach((k, v) -> {
            IDgSupplyGroupMatchSupportService.MatchResultBo matchResultBo = new IDgSupplyGroupMatchSupportService.MatchResultBo();
            matchResultBo.setGroupCode((String)k);
            Map<Long, BigDecimal> hasMap = v.stream().collect(Collectors.groupingBy(DgInventoryPreemptionSupplyDto::getPreOrderItemId, Collectors.mapping(supplyDto -> {
                BigDecimal preemptNum = Optional.ofNullable(supplyDto.getPreemptNum()).orElse(BigDecimal.ZERO);
                BigDecimal lessNum = Optional.ofNullable(supplyDto.getLessNum()).orElse(BigDecimal.ZERO);
                return BigDecimalUtils.subtract((BigDecimal)preemptNum, (BigDecimal)lessNum);
            }, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            Map lineApplyNumMap = groupLineApplyNumMap.getOrDefault(k, new HashMap(10));
            matchResultBo.setLineBoList(matchBo.getLineBoList().stream().filter(r -> BigDecimalUtils.gtZero((BigDecimal)((BigDecimal)supplyMap.get(r.getOrderLineId())))).map(r -> {
                BigDecimal supplyNum;
                IDgSupplyGroupMatchSupportService.MatchLineBo lineBo = new IDgSupplyGroupMatchSupportService.MatchLineBo(r.getSkuCode(), r.getOrderLineId());
                BigDecimal hasNum = BigDecimalUtils.subtract((BigDecimal)((BigDecimal)hasMap.get(lineBo.getOrderLineId())), (BigDecimal)((BigDecimal)lineApplyNumMap.get(lineBo.getOrderLineId())));
                if (BigDecimalUtils.ge((BigDecimal)hasNum, (BigDecimal)(supplyNum = (BigDecimal)supplyMap.get(lineBo.getOrderLineId()))).booleanValue()) {
                    lineBo.setSupplyNum(supplyNum);
                    supplyNum = BigDecimal.ZERO;
                } else {
                    lineBo.setSupplyNum(hasNum);
                    supplyNum = supplyNum.subtract(hasNum);
                }
                supplyMap.put(lineBo.getOrderLineId(), supplyNum);
                return lineBo;
            }).filter(r -> BigDecimalUtils.gtZero((BigDecimal)r.getSupplyNum())).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(matchResultBo.getLineBoList())) {
                resultBos.add(matchResultBo);
            }
        });
        List orderLineRecordEos = resultBos.stream().flatMap(r -> r.getLineBoList().stream().map(line -> {
            DgSupplyMatchOrderLineRecordEo dgSupplyMatchOrderLineRecordEo = new DgSupplyMatchOrderLineRecordEo();
            dgSupplyMatchOrderLineRecordEo.setId(Long.valueOf(IdWorker.getId()));
            dgSupplyMatchOrderLineRecordEo.setSkuCode(line.getSkuCode());
            dgSupplyMatchOrderLineRecordEo.setGroupCode(r.getGroupCode());
            dgSupplyMatchOrderLineRecordEo.setOrderItemId(line.getOrderLineId());
            dgSupplyMatchOrderLineRecordEo.setApplyNum(line.getSupplyNum());
            dgSupplyMatchOrderLineRecordEo.setOrderNo(matchBo.getOrderNo());
            dgSupplyMatchOrderLineRecordEo.setPlatformOrderNo(matchBo.getPlatformOrderNo());
            return dgSupplyMatchOrderLineRecordEo;
        })).collect(Collectors.toList());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{matchBo.getPreOrderNo()})) {
            List parentOrderLineList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgSupplyMatchOrderLineRecordDomain.filter().eq(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{matchBo.getPreOrderNo()}), (Object)"order_no", (Object)matchBo.getPreOrderNo())).eq((Object)"platform_order_no", (Object)matchBo.getPlatformOrderNo())).list();
            Map<String, BigDecimal> decimalMap = orderLineRecordEos.stream().collect(Collectors.groupingBy(DgSupplyGroupMatchSupportServiceImpl::getKey, Collectors.mapping(DgSupplyMatchOrderLineRecordEo::getApplyNum, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            ArrayList<DgSupplyMatchOrderLineRecordEo> updateList = new ArrayList<DgSupplyMatchOrderLineRecordEo>();
            for (DgSupplyMatchOrderLineRecordEo dgSupplyMatchOrderLineRecordEo : parentOrderLineList) {
                String key = DgSupplyGroupMatchSupportServiceImpl.getKey(dgSupplyMatchOrderLineRecordEo);
                if (!decimalMap.containsKey(key)) continue;
                dgSupplyMatchOrderLineRecordEo.setApplyNum(BigDecimalUtils.subtract((BigDecimal)dgSupplyMatchOrderLineRecordEo.getApplyNum(), (BigDecimal)decimalMap.get(key)));
                updateList.add(dgSupplyMatchOrderLineRecordEo);
            }
            Optional.of(updateList).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((BaseMapper)this.dgSupplyMatchOrderLineRecordDomain.getMapper()).updateBatchByIds(arg_0));
        }
        if (CollectionUtils.isNotEmpty(orderLineRecordEos)) {
            this.dgSupplyMatchOrderLineRecordDomain.insertBatch(orderLineRecordEos);
        }
        return resultBos;
    }

    private static String getKey(DgSupplyMatchOrderLineRecordEo r) {
        return String.join((CharSequence)"__", r.getGroupCode(), r.getOrderItemId() + "");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRecord(String orderNo) {
        this.dgSupplyMatchOrderLineRecordDomain.getMapper().delete((Wrapper)Wrappers.lambdaQuery((Object)new DgSupplyMatchOrderLineRecordEo()).eq(DgSupplyMatchOrderLineRecordEo::getOrderNo, (Object)orderNo));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRecordByLineOrNo(String orderNo, List<IDgSupplyGroupMatchSupportService.MatchLineBo> lineBos) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)new DgSupplyMatchOrderLineRecordEo()).eq(DgSupplyMatchOrderLineRecordEo::getOrderNo, (Object)orderNo);
        for (IDgSupplyGroupMatchSupportService.MatchLineBo lineBo : lineBos) {
            wrapper.or(c -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)c.eq(DgSupplyMatchOrderLineRecordEo::getOrderItemId, (Object)lineBo.getOrderLineId())).eq(DgSupplyMatchOrderLineRecordEo::getOrderNo, (Object)orderNo)).eq(DgSupplyMatchOrderLineRecordEo::getApplyNum, (Object)lineBo.getSupplyNum())).eq(BaseEo::getDr, (Object)0);
            });
        }
        this.dgSupplyMatchOrderLineRecordDomain.getMapper().delete((Wrapper)wrapper);
    }
}

