/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MyBatisUtil {
    private static Pattern humpPattern = Pattern.compile("[A-Z]");

    public static String getUpdateSelective(Class<?> clazz) {
        Field[] fields;
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            return "#Exception.\u53cd\u5c04\u751f\u6210\u5b9e\u4f53\u5f02\u5e38#";
        }
        String clazzName = clazz.getSimpleName();
        String resultMapId = Character.toLowerCase(clazzName.charAt(0)) + clazzName.substring(1) + "Map";
        String pkgName = clazz.getName();
        StringBuilder resultMap = new StringBuilder();
        resultMap.append("<update id=\"updateSelective\" parameterType=\"");
        resultMap.append(pkgName);
        resultMap.append("\">\n");
        resultMap.append("UPDATE X_TABLE");
        resultMap.append("\n<set>\n");
        for (Field f : fields = clazz.getDeclaredFields()) {
            String property = f.getName();
            String javaType = f.getType().getName();
            if ("serialVersionUID".equals(property)) continue;
            resultMap.append("    <if test=\"");
            resultMap.append(property + "!=null\">");
            resultMap.append(MyBatisUtil.property2Column(property).toUpperCase());
            resultMap.append("=#{" + property + ", jdbcType=" + MyBatisUtil.javaType2jdbcType(javaType.toLowerCase()) + "},</if>\n");
        }
        resultMap.append("</set>\n");
        resultMap.append("where id = #{id,jdbcType=VARCHAR}\n");
        resultMap.append("</update>");
        return resultMap.toString();
    }

    public static void getInsert(Class<?> clazz) {
        String text = MyBatisUtil.getUpdateSelective(clazz);
        Pattern p = Pattern.compile("#\\{[^}]+}");
        Matcher m = p.matcher(text);
        while (m.find()) {
            System.out.println(m.group() + ",");
        }
    }

    public void getColumns(Class<?> clazz) {
        String text = MyBatisUtil.getResultMap(clazz);
        Pattern p = Pattern.compile("column=[\"\\w\"]+");
        Matcher m = p.matcher(text);
        while (m.find()) {
            Pattern p1 = Pattern.compile("[\"\\w\"]+$");
            Matcher m1 = p1.matcher(m.group());
            while (m1.find()) {
                Pattern p2 = Pattern.compile("[\\w]+");
                Matcher m2 = p2.matcher(m1.group());
                while (m2.find()) {
                    System.err.println(m2.group().toUpperCase());
                }
            }
        }
    }

    public static String getResultMap(Class<?> clazz) {
        Field[] fields;
        Object obj = null;
        try {
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            return "#Exception.\u53cd\u5c04\u751f\u6210\u5b9e\u4f53\u5f02\u5e38#";
        }
        String clazzName = clazz.getSimpleName();
        String resultMapId = Character.toLowerCase(clazzName.charAt(0)) + clazzName.substring(1) + "Map";
        String pkgName = clazz.getName();
        StringBuilder resultMap = new StringBuilder();
        resultMap.append("<resultMap id=\"");
        resultMap.append(resultMapId);
        resultMap.append("\" type=\"");
        resultMap.append(pkgName);
        resultMap.append("\">\n");
        for (Field f : fields = clazz.getDeclaredFields()) {
            String property = f.getName();
            String javaType = f.getType().getName();
            if ("serialVersionUID".equals(property)) continue;
            resultMap.append("    <result column=\"");
            resultMap.append(MyBatisUtil.property2Column(property).toLowerCase());
            resultMap.append("\" jdbcType=\"");
            resultMap.append(MyBatisUtil.javaType2jdbcType(javaType.toLowerCase()));
            resultMap.append("\" property=\"");
            resultMap.append(property);
            resultMap.append("\" />\n");
        }
        resultMap.append("</resultMap>");
        return resultMap.toString();
    }

    private static String property2Column(String property) {
        Matcher matcher = humpPattern.matcher(property);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getAttribute(Class<?> clazz) {
        Field[] fields;
        StringBuilder attribute = new StringBuilder();
        for (Field f : fields = clazz.getDeclaredFields()) {
            String property = f.getName();
            String javaType = f.getType().getName();
            if ("serialVersionUID".equals(property)) continue;
            attribute.append(MyBatisUtil.property2Column(property).toLowerCase());
            attribute.append(" as ");
            attribute.append(property);
            attribute.append("\n");
        }
        return attribute.toString();
    }

    private static String javaType2jdbcType(String javaType) {
        if (javaType.contains("string")) {
            return "VARCHAR";
        }
        if (javaType.contains("boolean")) {
            return "BIT";
        }
        if (javaType.contains("byte")) {
            return "TINYINT";
        }
        if (javaType.contains("short")) {
            return "SMALLINT";
        }
        if (javaType.contains("int")) {
            return "INTEGER";
        }
        if (javaType.contains("long")) {
            return "BIGINT";
        }
        if (javaType.contains("double")) {
            return "DOUBLE";
        }
        if (javaType.contains("float")) {
            return "REAL";
        }
        if (javaType.contains("date")) {
            return "DATE";
        }
        if (javaType.contains("timestamp")) {
            return "TIMESTAMP";
        }
        if (javaType.contains("time")) {
            return "TIME";
        }
        if (javaType.contains("bigdecimal")) {
            return "DECIMAL";
        }
        return "\u672a\u77e5\u7c7b\u578b";
    }

    public static void main(String[] args) throws ClassNotFoundException {
        System.out.println("-------------->");
        System.out.println(MyBatisUtil.getAttribute(DgStrategyRuleEo.class));
    }
}

