/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.b2c.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.yunxi.dg.base.center.inventory.api.warehouse.ILogicWarehouseApi;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PhysicsWarehouseDto;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.b2c.IDgB2CAfterSaleOrderSaveAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderLineOptAction;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderBizSystemEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderItemDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderExchangeAddressDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemSnRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderLogisticsWarehouseDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderReturnAddressDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderGoodsItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemSnRecordDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderReturnBizTypeEnum;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderExchangeAddressEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemSnRecordEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderLogisticsWarehouseEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderReturnAddressEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgB2CAfterSaleOrderSaveAction
implements IDgB2CAfterSaleOrderSaveAction {
    private static final Logger log = LoggerFactory.getLogger(DgB2CAfterSaleOrderSaveAction.class);
    @Resource
    private DgNoGreateUtil dgNoGreateUtil;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderReturnAddressDomain dgAfterSaleOrderReturnAddressDomain;
    @Resource
    private IDgAfterSaleOrderExchangeAddressDomain dgAfterSaleOrderExchangeAddressDomain;
    @Resource
    private IDgAfterSaleOrderLogisticsWarehouseDomain dgAfterSaleOrderLogisticsWarehouseDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain dgAfterSaleOrderItemDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    protected ILogicWarehouseApi logicWarehouseApi;
    @Resource
    private IDgAfterSaleOrderItemDas dgAfterSaleOrderItemDas;
    @Resource
    private IDgAfterSaleOrderLineOptAction dgAfterSaleOrderLineOptAction;
    @Resource
    private IDgAfterSaleOrderItemSnRecordDomain dgAfterSaleOrderItemSnRecordDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    private static final String log_prefix = "afterSaleOrderAction";
    private static final Integer BATCH_INSERT_THRESHOLD = 2000;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> noOrigOrderCreate(DgAfterSaleOrderDto addReqDto, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList) {
        Long aftersaleOrderId = this.saveAfsOrderAndOtherTableInfo(addReqDto, itemReqDtoList);
        return new RestResponse((Object)aftersaleOrderId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> create(DgAfterSaleOrderDto addReqDto, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        Long aftersaleOrderId = this.saveAfsOrderAndOtherTableInfo(addReqDto, itemReqDtoList);
        return new RestResponse((Object)aftersaleOrderId);
    }

    private Long saveAfsOrderAndOtherTableInfo(DgAfterSaleOrderDto addReqDto, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList) {
        boolean isRelate;
        if (StringUtils.isEmpty((CharSequence)addReqDto.getAfterSaleOrderNo())) {
            ArrayList returnBizTypeList = Lists.newArrayList((Object[])new Integer[]{AfterSaleOrderReturnBizTypeEnum.E3_DAY_SETTLEMENT_RETURN_ORDER.getCode(), AfterSaleOrderReturnBizTypeEnum.PLATFORM_SETTLEMENT_RETURN_ORDER.getCode()});
            if (returnBizTypeList.contains(addReqDto.getReturnBizType())) {
                addReqDto.setAfterSaleOrderNo(this.dgNoGreateUtil.generatePlatformAfterSaleOrderNo());
            } else {
                addReqDto.setAfterSaleOrderNo(this.dgNoGreateUtil.generateAfterSaleOrderNo());
            }
        }
        boolean bl = isRelate = addReqDto.getRelateToPlatformOrder() != null && addReqDto.getRelateToPlatformOrder() == 0;
        if (isRelate && StrUtil.isNotBlank((CharSequence)addReqDto.getSaleOrderNo())) {
            DgPerformOrderInfoEo orderInfo = this.dgPerformOrderInfoDomain.queryByOrderNo(addReqDto.getSaleOrderNo());
            addReqDto.setIsMultiArea(orderInfo.getIsMultiArea());
            addReqDto.setPlatformSellerEntityNumber(orderInfo.getPlatformSellerEntityNumber());
            addReqDto.setPlatformSellerEntityName(orderInfo.getPlatformSellerEntityName());
            addReqDto.setRelatedEntityNumber(orderInfo.getRelatedEntityNumber());
            addReqDto.setRelatedEntityName(orderInfo.getRelatedEntityName());
        }
        if (StringUtils.isNotEmpty((CharSequence)addReqDto.getReturnShippingSn())) {
            addReqDto.setReturnShippingSn(addReqDto.getReturnShippingSn().trim());
            log.info("\u4fdd\u5b58\u552e\u540e\u8ba2\u5355,\u7269\u6d41\u5355\u53f7:{}", (Object)addReqDto.getReturnShippingSn());
        }
        if (StrUtil.isBlank((CharSequence)addReqDto.getRefundType())) {
            addReqDto.setRefundType(null);
        }
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderEo, (Object)addReqDto, (String[])new String[0]);
        if (StringUtils.isEmpty((CharSequence)dgAfterSaleOrderEo.getBizSystem())) {
            dgAfterSaleOrderEo.setBizSystem(DgAfterSaleOrderBizSystemEnum.DEFAULT.getCode());
        }
        this.dgAfterSaleOrderDomain.insert((BaseEo)dgAfterSaleOrderEo);
        Long afterSaleOrderId = dgAfterSaleOrderEo.getId();
        if (AfterSaleOrderTypeEnum.THTK.getCode().equals(addReqDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.EXCHANGE.getCode().equals(addReqDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.HH.getCode().equals(addReqDto.getAfterSaleOrderType())) {
            DgAfterSaleOrderReturnAddressEo returnAddressEo = new DgAfterSaleOrderReturnAddressEo();
            if (Objects.equals(addReqDto.getUnshippedReturn(), YesNoEnum.YES.getValue())) {
                this.getReturnWarehouseBySaleOrder(addReqDto);
            }
            CubeBeanUtils.copyProperties((Object)returnAddressEo, (Object)addReqDto, (String[])new String[]{"id"});
            returnAddressEo.setAfterSaleOrderId(afterSaleOrderId);
            returnAddressEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            this.dgAfterSaleOrderReturnAddressDomain.insert((BaseEo)returnAddressEo);
        }
        if (AfterSaleOrderTypeEnum.EXCHANGE.getCode().equals(addReqDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.HH.getCode().equals(addReqDto.getAfterSaleOrderType())) {
            DgAfterSaleOrderExchangeAddressEo exchangeAddressEo = new DgAfterSaleOrderExchangeAddressEo();
            CubeBeanUtils.copyProperties((Object)exchangeAddressEo, (Object)addReqDto, (String[])new String[]{"id"});
            exchangeAddressEo.setAfterSaleOrderId(afterSaleOrderId);
            exchangeAddressEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            this.dgAfterSaleOrderExchangeAddressDomain.insert((BaseEo)exchangeAddressEo);
        }
        DgAfterSaleOrderLogisticsWarehouseEo logisticsWarehouseEo = new DgAfterSaleOrderLogisticsWarehouseEo();
        CubeBeanUtils.copyProperties((Object)logisticsWarehouseEo, (Object)addReqDto, (String[])new String[0]);
        logisticsWarehouseEo.setAfterSaleOrderId(afterSaleOrderId);
        logisticsWarehouseEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        this.dgAfterSaleOrderLogisticsWarehouseDomain.insert((BaseEo)logisticsWarehouseEo);
        ArrayList dgAfterSaleOrderItemEos = Lists.newArrayList();
        ArrayList dgAfterSaleOrderItemSnRecordEos = Lists.newArrayList();
        for (DgAfterSaleOrderItemModifyReqDto itemModifyReqDto : itemReqDtoList) {
            DgAfterSaleOrderItemEo afterSaleOrderItemEo = new DgAfterSaleOrderItemEo();
            CubeBeanUtils.copyProperties((Object)afterSaleOrderItemEo, (Object)itemModifyReqDto, (String[])new String[0]);
            afterSaleOrderItemEo.setAfterSaleOrderId(afterSaleOrderId);
            afterSaleOrderItemEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            afterSaleOrderItemEo.setRefundWarehouseCode(addReqDto.getReturnWarehouseCode());
            afterSaleOrderItemEo.setRefundWarehouseId(addReqDto.getReturnWarehouseId());
            afterSaleOrderItemEo.setRefundWarehouseName(addReqDto.getReturnWarehouseName());
            afterSaleOrderItemEo.setAfterSaleOrderType(dgAfterSaleOrderEo.getAfterSaleOrderType());
            afterSaleOrderItemEo.setPlatformRefundOrderId(dgAfterSaleOrderEo.getPlatformRefundOrderId());
            afterSaleOrderItemEo.setPlatformRefundOrderNo(dgAfterSaleOrderEo.getPlatformRefundOrderSn());
            afterSaleOrderItemEo.setOrigRealPayAmount(afterSaleOrderItemEo.getRealPayAmount());
            if (AfterSaleOrderTypeEnum.HH.getCode().equals(dgAfterSaleOrderEo.getAfterSaleOrderType()) && afterSaleOrderItemEo.getRealPayAmount() != null) {
                log.info("\u6362\u8d27\u5355\u5546\u54c1\u884c\u751f\u6210 \u8d4b\u503c\u5b9e\u4ed8\u5355\u4ef7 {} {}", (Object)dgAfterSaleOrderEo.getAfterSaleOrderNo(), (Object)afterSaleOrderItemEo.getSaleOrderItemId());
                afterSaleOrderItemEo.setRefundPrice(afterSaleOrderItemEo.getRealPayAmount().divide(BigDecimal.valueOf(afterSaleOrderItemEo.getItemNum().intValue()), 4, RoundingMode.HALF_UP));
            }
            dgAfterSaleOrderItemEos.add(afterSaleOrderItemEo);
            if (!CollUtil.isNotEmpty((Collection)itemModifyReqDto.getSnRecordDtoList())) continue;
            this.fillDgAfterSaleOrderItemSnRecordEo(itemModifyReqDto.getSnRecordDtoList(), afterSaleOrderItemEo, dgAfterSaleOrderItemSnRecordEos);
        }
        this.dgAfterSaleOrderItemDomain.insertBatch((List)dgAfterSaleOrderItemEos);
        if (CollUtil.isNotEmpty((Collection)dgAfterSaleOrderItemSnRecordEos)) {
            this.dgAfterSaleOrderItemSnRecordDomain.insertBatch((List)dgAfterSaleOrderItemSnRecordEos);
        }
        if (addReqDto.getRelateToPlatformOrder() != null && addReqDto.getRelateToPlatformOrder() == 0) {
            log.info("\u3010\u6709\u539f\u5355\u4fdd\u5b58\u552e\u540e\u3011");
            this.dgAfterSaleOrderLineOptAction.B2CSaveAfterSaleOrderItemLines(dgAfterSaleOrderEo, dgAfterSaleOrderItemEos);
        }
        return afterSaleOrderId;
    }

    private void fillDgAfterSaleOrderItemSnRecordEo(List<DgAfterSaleOrderItemSnRecordDto> snRecordDtoList, DgAfterSaleOrderItemEo afterSaleOrderItemEo, List<DgAfterSaleOrderItemSnRecordEo> dgAfterSaleOrderItemSnRecordEos) {
        for (DgAfterSaleOrderItemSnRecordDto dto : snRecordDtoList) {
            DgAfterSaleOrderItemSnRecordEo snRecordEo = new DgAfterSaleOrderItemSnRecordEo();
            snRecordEo.setSnCode(dto.getSnCode());
            snRecordEo.setAfterSaleOrderId(afterSaleOrderItemEo.getAfterSaleOrderId());
            snRecordEo.setAfterSaleOrderItemId(afterSaleOrderItemEo.getId());
            snRecordEo.setSaleOrderItemId(afterSaleOrderItemEo.getSaleOrderId());
            dgAfterSaleOrderItemSnRecordEos.add(snRecordEo);
        }
    }

    private void getReturnWarehouseBySaleOrder(DgAfterSaleOrderDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getSaleOrderId(), (String)"\u9500\u552e\u9000\u5bf9\u5e94\u7684\u9500\u552e\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = this.performOrderWarehouseInfoDomain.selectByOrderId(addReqDto.getSaleOrderId());
        LogicWarehousePageReqDto logicWarehousePageReqDto = new LogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseCode(dgPerformOrderWarehouseInfoEo.getDeliveryLogicalWarehouseCode());
        List logicalWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryListWithPhysicsWarehouse(logicWarehousePageReqDto));
        com.yunxi.dg.base.commons.utils.AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)logicalWarehouseRespDtos), (String)"\u627e\u4e0d\u5230\u9500\u552e\u8ba2\u5355\uff1a{} \u7684\u53d1\u8d27\u4ed3\u5e93\u4fe1\u606f\uff0c\u4ed3\u5e93\u7f16\u7801\uff1a{}", (Object[])new Object[]{addReqDto.getSaleOrderNo(), dgPerformOrderWarehouseInfoEo.getDeliveryLogicalWarehouseCode()});
        LogicalWarehouseRespDto logicalWarehouseRespDto = (LogicalWarehouseRespDto)logicalWarehouseRespDtos.get(0);
        addReqDto.setReturnWarehouseName(logicalWarehouseRespDto.getWarehouseName());
        addReqDto.setReturnWarehouseId(logicalWarehouseRespDto.getId());
        addReqDto.setReturnWarehouseCode(logicalWarehouseRespDto.getWarehouseCode());
        PhysicsWarehouseDto physicsWarehouseInfo = logicalWarehouseRespDto.getPhysicsWarehouseInfo();
        addReqDto.setReturnAddress(physicsWarehouseInfo.getDetailAddress());
        addReqDto.setReturnCityCode(physicsWarehouseInfo.getCityCode());
        addReqDto.setReturnCityName(physicsWarehouseInfo.getCity());
        addReqDto.setReturnCountyCode(physicsWarehouseInfo.getDistrictCode());
        addReqDto.setReturnCountyName(physicsWarehouseInfo.getDistrict());
        addReqDto.setReturnProvinceName(physicsWarehouseInfo.getProvince());
        addReqDto.setReturnProvinceCode(physicsWarehouseInfo.getProvinceCode());
        addReqDto.setReturnRecipientPhone(physicsWarehouseInfo.getPhone());
        addReqDto.setReturnRecipient(physicsWarehouseInfo.getContact());
    }

    @Override
    public RestResponse<Void> update(DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        DgAfterSaleOrderLogisticsWarehouseEo oldLogisticsWarehouseEo;
        DgAfterSaleOrderReturnAddressEo oldReturnAddressEo;
        DgAfterSaleOrderExchangeAddressEo oldExchangeAddressEo;
        if (afterSaleOrderRespDto.getId() == null || StringUtils.isEmpty((CharSequence)afterSaleOrderRespDto.getAfterSaleOrderNo())) {
            throw new BizException("\u552e\u540e\u5355ID\u548c\u552e\u540e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((CharSequence)afterSaleOrderRespDto.getReturnShippingSn())) {
            afterSaleOrderRespDto.setReturnShippingSn(afterSaleOrderRespDto.getReturnShippingSn().trim());
        }
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)afterSaleOrderRespDto, (BaseEo)dgAfterSaleOrderEo);
        dgAfterSaleOrderEo.setUpdateTime(new Date());
        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)dgAfterSaleOrderEo);
        if (StrUtil.isBlank((CharSequence)dgAfterSaleOrderEo.getRefundType())) {
            this.dgAfterSaleOrderDomain.updateRefundTypeToNull(afterSaleOrderRespDto.getId());
        }
        if ((oldExchangeAddressEo = this.dgAfterSaleOrderExchangeAddressDomain.selectByAfterSaleOrderNo(afterSaleOrderRespDto.getAfterSaleOrderNo())) != null) {
            this.dgAfterSaleOrderExchangeAddressDomain.logicDeleteById(oldExchangeAddressEo.getId());
        }
        if ((oldReturnAddressEo = this.dgAfterSaleOrderReturnAddressDomain.selectByAfterSaleOrderNo(afterSaleOrderRespDto.getAfterSaleOrderNo())) != null) {
            this.dgAfterSaleOrderReturnAddressDomain.logicDeleteById(oldReturnAddressEo.getId());
        }
        if ((oldLogisticsWarehouseEo = this.dgAfterSaleOrderLogisticsWarehouseDomain.selectByAfterSaleOrderNo(afterSaleOrderRespDto.getAfterSaleOrderNo())) != null) {
            this.dgAfterSaleOrderLogisticsWarehouseDomain.logicDeleteById(oldLogisticsWarehouseEo.getId());
        }
        List afterSaleOrderItemEos = this.dgAfterSaleOrderItemDomain.queryEosByAfterSaleOrderId(afterSaleOrderRespDto.getId());
        this.dgAfterSaleOrderItemDas.removeByAfterSaleOrder(afterSaleOrderRespDto.getId());
        List<Long> afsOrderItemIds = afterSaleOrderItemEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        this.dgAfterSaleOrderLineOptAction.deleteItemLineByAfsOrderItemIds(afterSaleOrderRespDto.getId(), afsOrderItemIds);
        if (AfterSaleOrderTypeEnum.THTK.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.EXCHANGE.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.HH.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType())) {
            DgAfterSaleOrderReturnAddressEo returnAddressEo = new DgAfterSaleOrderReturnAddressEo();
            CubeBeanUtils.copyProperties((Object)returnAddressEo, (Object)afterSaleOrderRespDto, (String[])new String[0]);
            returnAddressEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            returnAddressEo.setAfterSaleOrderId(afterSaleOrderRespDto.getId());
            this.dgAfterSaleOrderReturnAddressDomain.insert((BaseEo)returnAddressEo);
        }
        if (AfterSaleOrderTypeEnum.EXCHANGE.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.HH.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType())) {
            DgAfterSaleOrderExchangeAddressEo exchangeAddressEo = new DgAfterSaleOrderExchangeAddressEo();
            CubeBeanUtils.copyProperties((Object)exchangeAddressEo, (Object)afterSaleOrderRespDto, (String[])new String[0]);
            exchangeAddressEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            exchangeAddressEo.setAfterSaleOrderId(afterSaleOrderRespDto.getId());
            this.dgAfterSaleOrderExchangeAddressDomain.insert((BaseEo)exchangeAddressEo);
        }
        DgAfterSaleOrderLogisticsWarehouseEo logisticsWarehouseEo = new DgAfterSaleOrderLogisticsWarehouseEo();
        CubeBeanUtils.copyProperties((Object)logisticsWarehouseEo, (Object)afterSaleOrderRespDto, (String[])new String[0]);
        logisticsWarehouseEo.setAfterSaleOrderId(dgAfterSaleOrderEo.getId());
        logisticsWarehouseEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        this.dgAfterSaleOrderLogisticsWarehouseDomain.insert((BaseEo)logisticsWarehouseEo);
        ArrayList dgAfterSaleOrderItemEos = Lists.newArrayList();
        ArrayList dgAfterSaleOrderItemSnRecordEos = Lists.newArrayList();
        for (DgAfterSaleOrderItemModifyReqDto itemModifyReqDto : itemReqDtoList) {
            DgAfterSaleOrderItemEo afterSaleOrderItemEo = new DgAfterSaleOrderItemEo();
            CubeBeanUtils.copyProperties((Object)afterSaleOrderItemEo, (Object)itemModifyReqDto, (String[])new String[0]);
            afterSaleOrderItemEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            afterSaleOrderItemEo.setAfterSaleOrderId(afterSaleOrderRespDto.getId());
            dgAfterSaleOrderItemEos.add(afterSaleOrderItemEo);
            if (!CollUtil.isNotEmpty((Collection)itemModifyReqDto.getSnRecordDtoList())) continue;
            this.fillDgAfterSaleOrderItemSnRecordEo(itemModifyReqDto.getSnRecordDtoList(), afterSaleOrderItemEo, dgAfterSaleOrderItemSnRecordEos);
        }
        this.dgAfterSaleOrderItemDomain.insertBatch((List)dgAfterSaleOrderItemEos);
        List snRecordEos = this.dgAfterSaleOrderItemSnRecordDomain.queryByAfterSaleOrderItemId((List)Lists.newArrayList((Object[])new Long[]{afterSaleOrderRespDto.getId()}));
        if (CollUtil.isNotEmpty((Collection)snRecordEos)) {
            for (DgAfterSaleOrderItemSnRecordEo snRecordEo : snRecordEos) {
                this.dgAfterSaleOrderItemSnRecordDomain.logicDeleteById(snRecordEo.getId());
            }
        }
        if (CollUtil.isNotEmpty((Collection)dgAfterSaleOrderItemSnRecordEos)) {
            this.dgAfterSaleOrderItemSnRecordDomain.insertBatch((List)dgAfterSaleOrderItemSnRecordEos);
        }
        if (afterSaleOrderRespDto.getRelateToPlatformOrder() != null && afterSaleOrderRespDto.getRelateToPlatformOrder() == 0) {
            log.info("\u3010\u6709\u539f\u5355\u5173\u8054\u4fdd\u5b58\u8ba2\u5355\u5546\u54c1\u884c\u3011");
            this.dgAfterSaleOrderLineOptAction.B2CSaveAfterSaleOrderItemLines(dgAfterSaleOrderEo, dgAfterSaleOrderItemEos);
        }
        return RestResponse.VOID;
    }
}

