/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.B2C.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedQueryApi;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryBasicsQueryReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryBasicsQueryRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.VerificationDeliveryAccessReqDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.VerificationDeliveryAccessRespDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgMqMessageAction;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgOmsOrderHandleAction;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderCommonHandleAction;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.OutNoticeResultSyncStatusEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisSaleOrderPushTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLineReleationItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderSplitSaleOrderModeDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSyncPlatformDeliveryReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderCheckPaymentAccountRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.eo.OrderLineReleationItemLineEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderWarehouseInfoService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsLabelStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderHandleService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsPaymentAccountService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgOrderAutoStrategyRuleService;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyPoolService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class DgOmsOrderHandleActionImpl
implements IDgOmsOrderHandleAction {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderHandleActionImpl.class);
    private static final String ZGC = "zgc";
    @Value(value="${oms.supplement.sale.order.info.enable:false}")
    private Boolean supplementSaleOrderInfoEnable;
    @Value(value="${oms.sale.order.item.supply.price.enable:false}")
    private Boolean saleOrderItemSupplyPriceEnable;
    @Value(value="${oms.sale.order.item.price.cost.enable:false}")
    private Boolean saleOrderItemCostPriceEnable;
    @Resource
    private IDgOmsOrderHandleService omsOrderHandleService;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgMqMessageAction dgMqMessageAction;
    @Resource
    private IDgOmsPaymentAccountService omsPaymentAccountService;
    @Resource
    private IDgStrategyPoolService dgStrategyPoolService;
    @Resource
    private IDgOrderAutoStrategyRuleService dgOrderAutoStrategyRuleService;
    @Resource
    private IDgOmsLabelStrategyRuleService omsLabelStrategyRuleService;
    @Resource
    private IDgOmsOrderSplitSaleOrderModeDomain omsSplitSaleOrderModeDomain;
    @Resource
    private IDgOmsOrderCalculatorAmountModeDomain omsOrderAmountCalculatorModeDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain performOrderSplitReleationDomain;
    @Resource
    private IOrderLineReleationItemLineDomain orderLineReleationItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain orderItemLineDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoService dgPerformOrderWarehouseInfoService;
    @Resource
    private IOrderCommonHandleAction orderCommonHandleAction;
    @Resource
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Resource
    private ILogicInventoryExposedQueryApi inventoryExposedQueryApi;
    @Resource
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    public RestResponse<Void> reCalculatorAmountAction(DgPerformOrderRespDto respDto, List<DgPerformOrderRespDto> orderRespDtoList) {
        this.omsSplitSaleOrderModeDomain.modifyChildOrderBySplit(respDto, orderRespDtoList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Boolean> preemptLogicoInventoryAndReleaseInventory(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        Boolean result = this.omsOrderHandleService.preemptLogicoInventoryAndReleaseInventory(respDto.getId());
        return new RestResponse((Object)result);
    }

    @Override
    public RestResponse<InventoryOperateRespDto> preemptLogicInventoryByParentOrderSource(DgPerformOrderRespDto respDto) {
        DgSourceOrderResultRespDto sourceOrderResultRespDto = this.omsOrderHandleService.autoSearchSourceByParentOrder(respDto.getId());
        return new RestResponse((Object)this.omsOrderHandleService.preemptLogicInventoryBySource(respDto, sourceOrderResultRespDto));
    }

    @Override
    public RestResponse<InventoryOperateRespDto> preemptLogicInventoryByOrderAppointDeliveryWarehouse(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        return new RestResponse((Object)this.omsOrderHandleService.preemptLogicInventoryByOrderAppointDeliveryWarehouse(respDto));
    }

    @Override
    public RestResponse<DgSourceOrderResultRespDto> autoSearchSource(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgSourceOrderResultRespDto sourceOrderResultRespDto = this.omsOrderHandleService.autoSearchSource(respDto.getId());
        return new RestResponse((Object)sourceOrderResultRespDto);
    }

    @Override
    public RestResponse<DgArrangeShipmentEnterpriseReqDto> autoShipmentEnterpriseSource(DgPerformOrderRespDto respDto) {
        return new RestResponse((Object)this.omsOrderHandleService.autoShipmentEnterpriseSource(respDto));
    }

    @Override
    public RestResponse<Void> checkReachabilityOfLogistics(DgPerformOrderRespDto respDto) {
        log.info("\u6821\u9a8c\u5feb\u9012\u4e0d\u53ef\u8fbe\u4fe1\u606f{}", (Object)respDto.getSaleOrderNo());
        DgPerformOrderWarehouseInfoDto performOrderWarehouseInfoDto = respDto.getPerformOrderWarehouseInfoDto();
        VerificationDeliveryAccessReqDto verificationDeliveryAccessReqDto = new VerificationDeliveryAccessReqDto();
        verificationDeliveryAccessReqDto.setAction(Boolean.valueOf(true));
        verificationDeliveryAccessReqDto.setKuaidicom(performOrderWarehouseInfoDto.getShipmentEnterpriseCode());
        VerificationDeliveryAccessRespDto verificationDeliveryAccessRespDto = this.dgPerformOrderWarehouseInfoService.verifyDeliveryAccessibility(respDto.getId(), verificationDeliveryAccessReqDto, "0");
        log.info("\u6821\u9a8c\u5feb\u9012\u4e0d\u53ef\u8fbe\u4fe1\u606f{}\u7ed3\u679c{}", (Object)respDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)verificationDeliveryAccessRespDto));
        AssertUtils.isTrue((boolean)Objects.equals(verificationDeliveryAccessRespDto.getReachable(), "1"), (String)"\u7269\u6d41\u4e0d\u53ef\u8fbe\u62e6\u622a");
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderBySourceResult(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceOrderResultRespDto) {
        return new RestResponse((Object)this.omsSplitSaleOrderModeDomain.splitOrderBySourceResult(respDto, sourceOrderResultRespDto));
    }

    @Override
    public RestResponse<InventoryOperateRespDto> preemptLogicInventoryBySource(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceOrderResultRespDto) {
        return new RestResponse((Object)this.omsOrderHandleService.preemptLogicInventoryBySource(respDto, sourceOrderResultRespDto));
    }

    @Override
    public RestResponse<Boolean> preemptChannelInventory(Long saleOrderId) {
        return this.omsOrderHandleService.preemptChannelInventory(saleOrderId);
    }

    @Override
    public void saveLogisticsCompanyInfo(DgPerformOrderRespDto request) {
        this.omsOrderHandleService.saveLogisticsCompanyInfo(request);
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderByMultiWarehouse(DgPerformOrderRespDto saleOrderRespDto, DgBizPerformOrderReqDto bizSaleOrderReqDto) {
        return new RestResponse((Object)this.omsSplitSaleOrderModeDomain.splitOrderByMultiWarehouse(saleOrderRespDto, bizSaleOrderReqDto));
    }

    @Override
    public void setOrderLogicalWarehouse(DgPerformOrderRespDto dto, DgBizPerformOrderReqDto saleOrderRespDto) {
        this.omsOrderHandleService.setOrderLogicalWarehouse(dto, saleOrderRespDto);
    }

    @Override
    public RestResponse<Void> deducateInventoryForOrder(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            log.info("\u5f53\u524d\u5b58\u5728\u4e8b\u52a1\u672a\u63d0\u4ea4\uff0c\u6e05\u9664\u4e00\u7ea7\u7f13\u5b58");
            this.sqlSessionTemplate.clearCache();
        } else {
            log.info("\u6e05\u9664\u4e00\u7ea7\u7f13\u5b58");
            this.sqlSessionTemplate.clearCache();
        }
        return this.omsOrderHandleService.deducateInventoryForOrder(respDto);
    }

    @Override
    public RestResponse<Void> deducateInventoryForOrderNoFlush(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            log.info("\u5f53\u524d\u5b58\u5728\u4e8b\u52a1\u672a\u63d0\u4ea4\uff0c\u6e05\u9664\u4e00\u7ea7\u7f13\u5b58");
            this.sqlSessionTemplate.clearCache();
        } else {
            log.info("\u6e05\u9664\u4e00\u7ea7\u7f13\u5b58");
            this.sqlSessionTemplate.clearCache();
        }
        return this.omsOrderHandleService.deducateInventoryForOrder(respDto);
    }

    @Override
    public RestResponse<Void> sourceWarehouseAction(DgPerformOrderRespDto respDto) {
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(respDto.getId());
        DgShopRespDto shopExtRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.getShopDetailById(snapshotEo.getShopId()));
        log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e97\u94fa\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c{},{}", (Object)respDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)shopExtRespDto));
        List logicWarehouseCodes = shopExtRespDto.getLogicWarehouseCodes();
        if (CollectionUtil.isEmpty((Collection)logicWarehouseCodes)) {
            throw new BizException("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u6ca1\u914d\u7f6e\u903b\u8f91\u4ed3" + respDto.getSaleOrderNo());
        }
        List dgPerformOrderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderIdFilterCancel(respDto.getId());
        List longCodeList = dgPerformOrderLineDtoList.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList());
        InventoryBasicsQueryReqDto inventoryBasicsQueryReqDto = new InventoryBasicsQueryReqDto();
        inventoryBasicsQueryReqDto.setWarehouseCodeList(logicWarehouseCodes);
        inventoryBasicsQueryReqDto.setLongCodeList(longCodeList);
        inventoryBasicsQueryReqDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        List inventoryList = (List)RestResponseHelper.extractData((RestResponse)this.inventoryExposedQueryApi.queryCommonInventory(inventoryBasicsQueryReqDto));
        log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c{},{}", (Object)respDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)inventoryList));
        if (CollectionUtils.isEmpty((Collection)inventoryList)) {
            throw new BizException("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u67e5\u8be2\u7a7a" + respDto.getSaleOrderNo());
        }
        Map<String, List<InventoryBasicsQueryRespDto>> inventoryMapByWarehouseCode = inventoryList.stream().collect(Collectors.groupingBy(InventoryBasicsQueryRespDto::getWarehouseCode));
        HashSet<String> unAvailableWarehouseCodes = new HashSet<String>();
        block0: for (Map.Entry<String, List<InventoryBasicsQueryRespDto>> entry : inventoryMapByWarehouseCode.entrySet()) {
            String warehouseCode = entry.getKey();
            List<InventoryBasicsQueryRespDto> inventoryDtoList = entry.getValue();
            Map<String, List<InventoryBasicsQueryRespDto>> inventoryMapBySkuCode = inventoryDtoList.stream().collect(Collectors.groupingBy(InventoryBasicsQueryRespDto::getCargoCode));
            for (DgPerformOrderLineDto orderLine : dgPerformOrderLineDtoList) {
                BigDecimal itemNum = orderLine.getItemNum();
                List inventoryDtos = inventoryMapBySkuCode.getOrDefault(orderLine.getSkuCode(), new ArrayList());
                if (!inventoryDtos.stream().map(inventory -> Optional.ofNullable(inventory).map(InventoryBasicsQueryRespDto::getAvailable).orElse(BigDecimal.ZERO)).noneMatch(available -> available.compareTo(itemNum) >= 0)) continue;
                unAvailableWarehouseCodes.add(warehouseCode);
                continue block0;
            }
        }
        log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u6821\u9a8c\u7ed3\u679c{},unAvailableWarehouseCodes{},inventoryWarehouseCodes{}", new Object[]{respDto.getSaleOrderNo(), JSON.toJSONString(unAvailableWarehouseCodes), JSON.toJSONString(inventoryMapByWarehouseCode.keySet())});
        InventoryBasicsQueryRespDto choose = inventoryList.stream().filter(inventory -> !unAvailableWarehouseCodes.contains(inventory.getWarehouseCode())).findAny().orElseThrow(() -> new BizException("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u4e0d\u8db3" + respDto.getSaleOrderNo()));
        DgArrangeWarehouseReqDto arrangeWarehouseReqDto = new DgArrangeWarehouseReqDto();
        arrangeWarehouseReqDto.setLogicalWarehouseCode(choose.getWarehouseCode());
        arrangeWarehouseReqDto.setLogicalWarehouseId(choose.getWarehouseId());
        arrangeWarehouseReqDto.setLogicalWarehouseName(choose.getWarehouseName());
        respDto.setLogicalWarehouseId(choose.getWarehouseId());
        respDto.setLogicalWarehouseCode(choose.getWarehouseCode());
        respDto.setLogicalWarehouseName(choose.getWarehouseName());
        respDto.setDeliveryLogicalWarehouseCode(choose.getWarehouseCode());
        if (respDto.getPerformOrderWarehouseInfoDto() != null) {
            respDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseId(choose.getWarehouseId());
            respDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseCode(choose.getWarehouseCode());
            respDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseName(choose.getWarehouseName());
            respDto.getPerformOrderWarehouseInfoDto().setDeliveryLogicalWarehouseCode(choose.getWarehouseCode());
        }
        this.orderCommonHandleAction.arrangeWarehouse(respDto, arrangeWarehouseReqDto);
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            log.info("\u5f53\u524d\u5b58\u5728\u4e8b\u52a1\u672a\u63d0\u4ea4\uff0c\u6e05\u9664\u4e00\u7ea7\u7f13\u5b58");
            this.sqlSessionTemplate.clearCache();
        } else {
            log.info("\u6e05\u9664\u4e00\u7ea7\u7f13\u5b58");
            this.sqlSessionTemplate.clearCache();
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> calculatorOrderAmountBySplit(DgPerformOrderRespDto throughSaleOrderDto, List<DgPerformOrderRespDto> orderRespDtoList) {
        this.omsOrderAmountCalculatorModeDomain.calculatorOrderAmountBySplit(orderRespDtoList);
        this.omsSplitSaleOrderModeDomain.modifyChildOrderBySplit(throughSaleOrderDto, orderRespDtoList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyOrderType(DgPerformOrderRespDto respDto, String type) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(respDto.getId());
        updateReqDto.setOrderType(type);
        this.omsOrderInfoDomain.update(updateReqDto);
        return RestResponse.VOID;
    }

    @Override
    public void appointAfterSaleWarehouse(DgPerformOrderRespDto respDto) {
        this.omsOrderHandleService.appointAfterSaleWarehouse(respDto);
    }

    @Override
    public RestResponse<Void> resetToCsAudit(DgPerformOrderRespDto saleOrderRespDto) {
        this.omsOrderHandleService.resetToCsAudit(saleOrderRespDto);
        log.info("[\u81ea\u52a8\u7b56\u7565]\u64a4\u56de\u5ba2\u5ba1\uff0c\u53d1\u9001mq\u63a8\u9001\u7ed9\u7528\u670d\u7cfb\u7edf\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
        this.dgMqMessageAction.sendMsgSaleOrderPush(saleOrderRespDto, DgCisSaleOrderPushTypeEnum.CS_AUDIT_PUSH);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> resetChannelPreemptForSplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        if (CollectionUtils.isNotEmpty(childOrderList)) {
            List orderIds = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
            List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderIds(orderIds);
            Map<Long, List<DgPerformOrderLineDto>> orderItemsMap = orderLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getOrderId));
            this.inventoryApiServcie.omsResetChannelPreemptForSplit(dto, childOrderList, orderItemsMap);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyChildOrderBySplit(DgPerformOrderRespDto dto, List<DgPerformOrderRespDto> childOrderList) {
        AssertUtils.notNull((Object)dto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.omsSplitSaleOrderModeDomain.modifyChildOrderBySplit(dto, childOrderList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> recoverySaleOrderGoodsItems(DgPerformOrderRespDto dto) {
        ArrayList childIds = new ArrayList();
        List releationEos = this.performOrderSplitReleationDomain.queryByOrderId(dto.getId());
        Boolean flag = Boolean.TRUE;
        while (flag.booleanValue()) {
            List<Long> ids = releationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList());
            List splitReleationEos = this.performOrderSplitReleationDomain.queryByOrderIds(ids);
            if (CollectionUtils.isNotEmpty((Collection)splitReleationEos)) {
                List subIds = splitReleationEos.stream().map(DgPerformOrderSplitReleationEo::getOrderId).collect(Collectors.toList());
                ids.forEach(id -> {
                    if (!subIds.contains(id)) {
                        childIds.add(id);
                    }
                });
                releationEos = splitReleationEos;
                continue;
            }
            flag = false;
        }
        List orderLineReleationItemLineEos = this.orderLineReleationItemLineDomain.queryByOrderLineIds(childIds);
        Map releationItemLineMap = orderLineReleationItemLineEos.stream().collect(Collectors.toMap(OrderLineReleationItemLineEo::getOrderItemLineId, Function.identity(), (a, b) -> a));
        List splitOrderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderIds(childIds);
        List orderItemLineEos = this.orderItemLineDomain.queryItemLineByOrderLineIds(splitOrderLineDtoList.stream().map(BaseDto::getId).collect(Collectors.toList()));
        orderItemLineEos.forEach(item -> {
            OrderLineReleationItemLineEo releationItemLineEo = (OrderLineReleationItemLineEo)releationItemLineMap.get(item.getId());
            if (null == releationItemLineEo) {
                throw new BizException("-1", "\u5386\u53f2\u5355\u636e\u6682\u65e0\u6cd5\u6062\u590d\u539f\u5546\u54c1\u884c");
            }
            item.setOrderLineId(releationItemLineEo.getOrderLineId());
            this.orderItemLineDomain.updateSelective((BaseEo)item);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<DgBizPerformOrderCheckPaymentAccountRespDto> checkPaymentAccount(DgPerformOrderRespDto saleOrderRespDto) {
        return new RestResponse((Object)this.omsPaymentAccountService.checkPaymentAccount(saleOrderRespDto));
    }

    @Override
    public RestResponse<DgBizPerformOrderCheckPaymentAccountRespDto> preemptAccount(DgPerformOrderRespDto respDto) {
        return new RestResponse((Object)this.omsPaymentAccountService.preemptAccount(respDto));
    }

    @Override
    public RestResponse<Void> preemptionToActualPayment(DgPerformOrderRespDto respDto) {
        this.omsPaymentAccountService.preemptionToActualPayment(respDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelPreemptAccount(DgPerformOrderRespDto respDto) {
        this.omsPaymentAccountService.cancelPreemptAccount(respDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> preemptCreditAccount(DgPerformOrderRespDto saleOrderRespDto) {
        this.omsPaymentAccountService.preemptCreditAccount(saleOrderRespDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelCreditPreemptAccount(DgPerformOrderRespDto saleOrderRespDto) {
        this.omsPaymentAccountService.cancelPreemptCreditAccount(saleOrderRespDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderByAppointResult(DgPerformOrderRespDto respDto, InventoryOperateRespDto inventoryOperateRespDto) {
        List saleOrderRespDtoList = this.omsSplitSaleOrderModeDomain.splitOrderByAppointResult(respDto, inventoryOperateRespDto);
        return new RestResponse((Object)saleOrderRespDtoList);
    }

    @Override
    public RestResponse<List<DgPerformOrderRespDto>> splitOrderByGift(Long saleOrderId) {
        return new RestResponse((Object)this.omsSplitSaleOrderModeDomain.splitOrderByGift(saleOrderId));
    }

    @Override
    public RestResponse<Void> syncPlatformDeliveryStatus(DgPerformOrderRespDto respDto, DgSyncPlatformDeliveryReqDto syncPlatformDeliveryReqDto) {
        if (OutNoticeResultSyncStatusEnum.SUCCESS.getCode().equals(respDto.getPlatformOrderDeliveryStatusSyncStatus())) {
            log.info(respDto.getSaleOrderNo() + "\u5e73\u53f0\u53d1\u8d27\u72b6\u6001\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u518d\u6b21\u540c\u6b65");
            return RestResponse.VOID;
        }
        DgPerformOrderReqDto performOrderReqDto = new DgPerformOrderReqDto();
        performOrderReqDto.setId(respDto.getId());
        performOrderReqDto.setPlatformOrderDeliveryStatusSyncResult(syncPlatformDeliveryReqDto.getOutNoticeSyncStatusResultMsg());
        if (syncPlatformDeliveryReqDto.getOutNoticeResultSyncStatus().equals("1")) {
            performOrderReqDto.setPlatformOrderDeliveryStatus(DgOmsSaleOrderStatus.DELIVERED.getCode());
            performOrderReqDto.setPlatformOrderDeliveryStatusSyncStatus(OutNoticeResultSyncStatusEnum.SUCCESS.getCode());
        } else {
            performOrderReqDto.setPlatformOrderDeliveryStatus(DgOmsSaleOrderStatus.WAIT_DELIVERY.getCode());
            performOrderReqDto.setPlatformOrderDeliveryStatusSyncStatus(OutNoticeResultSyncStatusEnum.FAIL.getCode());
            performOrderReqDto.setPlatformOrderDeliveryStatusSyncResult(syncPlatformDeliveryReqDto.getOutNoticeSyncStatusResultMsg());
        }
        this.omsOrderInfoDomain.update(performOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> outDeliveryResult(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto resultReqDto) {
        this.omsOrderInfoDomain.modifyOrderByDeliveredResult(respDto, resultReqDto);
        return RestResponse.VOID;
    }
}

