/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.after.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.lock.provider.redis.RedisLockService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.aftersale.AfterSaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.AttachementReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.entity.AccountTypeDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTradeApiProxy;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTypeApiProxy;
import com.yunxi.dg.base.center.customer.dto.request.DgEnterpriseQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgTobEnterpriseQueryApiProxy;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DirectoryItemDgRespDto;
import com.yunxi.dg.base.center.item.proxy.directory.IDirectoryDgQueryApiProxy;
import com.yunxi.dg.base.center.item.proxy.sku.impl.ItemSkuDgQueryApiProxyImpl;
import com.yunxi.dg.base.center.openai.proxy.ExternalOaProxy;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagRecordApiProxy;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicQueryOptAction;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.channel.IDgF2BAfterOrderSaveAction;
import com.yunxi.dg.base.center.trade.constants.NoticeResultSyncStatusEnum;
import com.yunxi.dg.base.center.trade.constants.SaleOrderStatusFlowTemplate;
import com.yunxi.dg.base.center.trade.constants.TradeAfterSaleStatusFlowSelector;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgF2BAfterRefundModeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgF2BAfterStatus;
import com.yunxi.dg.base.center.trade.convert.entity.DgAfterSaleOrderItemConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IAttachementDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderAuditDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IQualityControlDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IQualityControlItemDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.MatchItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.OrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderAuditDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgRefundDetailDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgRefundItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgAfterSaleOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelBaseRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderReturnBizTypeEnum;
import com.yunxi.dg.base.center.trade.enums.NewDgRefundDetailStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.DgRefundDetailEo;
import com.yunxi.dg.base.center.trade.eo.OrderAuditEo;
import com.yunxi.dg.base.center.trade.eo.QualityControlEo;
import com.yunxi.dg.base.center.trade.eo.QualityControlItemEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderOptService;
import com.yunxi.dg.base.center.trade.service.after.IDgF2BAfterService;
import com.yunxi.dg.base.center.trade.service.entity.IDgAfterSaleQuotaService;
import com.yunxi.dg.base.center.trade.service.entity.IDgAfterSaleRuleService;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.service.oms.common.ICommonOrderQueryService;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderConfigurationService;
import com.yunxi.dg.base.center.trade.utils.AssertUtil;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DgF2BAfterServiceImpl
implements IDgF2BAfterService {
    private static Logger logger = LoggerFactory.getLogger(DgF2BAfterServiceImpl.class);
    @Resource
    private IDgRefundDetailDomain dgRefundDetailDomain;
    @Resource
    private IDgAfterSaleOrderOptService afterSaleOrderOptService;
    @Resource
    protected IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Autowired
    protected IQualityControlDomain qualityControlDomain;
    @Autowired
    protected IQualityControlItemDomain qualityControlItemDomain;
    @Resource
    protected IDgAfterSaleOrderItemDomain dgAfterSaleOrderItemDomain;
    @Resource
    protected IDgF2BAfterOrderSaveAction dgF2BAfterOrderSaveAction;
    @Resource
    protected IContext context;
    @Resource
    protected IAccountTradeApiProxy accountTradeApiProxy;
    @Resource
    protected IDgPerformNoticeSyncRecordService dgPerformNoticeSyncRecordService;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgOrderLabelDomain dgOrderLabelDomain;
    @Resource
    private IDgOrderLabelItemDomain orderLabelItemDomain;
    @Resource
    protected RedisLockService lockService;
    @Resource
    protected IDgOrderConfigurationService dgOrderConfigurationService;
    @Resource
    protected ICommonOrderQueryService commonOrderQueryService;
    @Resource
    protected IAccountTypeApiProxy accountTypeApiProxy;
    @Resource
    private IDgTobEnterpriseQueryApiProxy dgTobEnterpriseQueryApiProxy;
    @Resource
    protected IAttachementDomain attachementDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    protected IDgRefundItemDomain refundItemDomain;
    @Resource
    protected IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    protected IOrderAuditDomain orderAuditDomain;
    @Resource
    protected IPayRecordDomain payRecordDomain;
    @Resource
    private IDgAfterSaleOrderOptService dgAfterSaleOrderOptService;
    @Resource
    private IDgAfterSaleOrderBasicQueryOptAction dgAfterSaleOrderBasicQueryOptAction;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    protected IDgAfterSaleQuotaService dgAfterSaleQuotaService;
    @Resource
    protected ExternalOaProxy externalOaProxy;
    @Resource
    protected IDgPerformOrderSnapshotDomain snapshotDomain;
    @Resource
    protected IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    protected IDgAfterSaleRuleService dgAfterSaleRuleService;
    @Resource
    protected ItemSkuDgQueryApiProxyImpl itemSkuDgQueryApiProxy;
    @Resource
    protected IDirectoryDgQueryApiProxy directoryDgQueryApiProxy;
    @Resource
    private IReBizTagRecordApiProxy reBizTagRecordApiProxy;

    public IConverter<DgAfterSaleOrderItemDto, DgAfterSaleOrderItemEo> converter() {
        return DgAfterSaleOrderItemConverter.INSTANCE;
    }

    @Override
    public Long saveAfterSaleApplyOfNotOriginal(DgAfterSaleOrderDto dto) {
        this.addAfterSaleVerify(dto, false);
        dto.setStatus(DgF2BAfterStatus.WAIT_CHECK.getCode());
        return this.afterSaleOrderOptService.addAfterSaleApplyOfNotOriginal(dto);
    }

    @Override
    public List<DgAfterSaleOrderStatusLogRespDto> queryAfterSaleOrderStatus(Long orderId, String type) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto orderDasOne = this.dgAfterSaleOrderBasicQueryOptAction.queryById(orderId);
        AssertUtils.notNull((Object)orderDasOne, (String)String.format("orderId=%s\u7684\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
        TradeAfterSaleStatusFlowSelector statusFlowSelector = TradeAfterSaleStatusFlowSelector.enumOf((String)type);
        Map orderStatusMap = statusFlowSelector.getLookup();
        List saleOrderStatusList = statusFlowSelector.getSaleOrderStatusList();
        List<DgAfterSaleOrderStatusLogRespDto> orderStatusTemplateList = this.getOrderStatusTemplate(saleOrderStatusList);
        String orderSteps = orderDasOne.getAfterSaleOrderSteps();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            List orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgAfterSaleOrderStatusLogRespDto.class);
            orderStatusLogRespDtos.sort(Comparator.comparing(DgAfterSaleOrderStatusLogRespDto::getOptDate).reversed());
            Map<String, List<DgAfterSaleOrderStatusLogRespDto>> orderStatusHistoryListMap = orderStatusLogRespDtos.stream().collect(Collectors.groupingBy(DgAfterSaleOrderStatusLogRespDto::getOrderStatus));
            logger.info("[\u8ba2\u5355\u72b6\u6001]\u5f53\u524d\u552e\u540e\u8ba2\u5355\uff08orderId={}\uff09\u7684\u72b6\u6001\u5217\u8868:{}", (Object)orderId, (Object)orderSteps);
            for (int i = 0; i < orderStatusTemplateList.size(); ++i) {
                DgAfterSaleOrderStatusLogRespDto templateItem = orderStatusTemplateList.get(i);
                List<DgAfterSaleOrderStatusLogRespDto> statusList = orderStatusHistoryListMap.get(templateItem.getOrderStatus());
                if (statusList != null) {
                    DgAfterSaleOrderStatusLogRespDto statusLogRespDto = statusList.get(0);
                    templateItem.setOptDate(statusLogRespDto.getOptDate());
                } else if (i == 0) {
                    templateItem.setOptDate(orderDasOne.getCreateTime());
                }
                if (!orderDasOne.getStatus().equals(templateItem.getOrderStatus())) continue;
                templateItem.setActive(Boolean.TRUE);
                break;
            }
        }
        orderStatusTemplateList.parallelStream().forEach(item -> {
            SaleOrderStatusFlowTemplate saleOrderStatus;
            if (Objects.equals(orderDasOne.getStatus(), item.getOrderStatus())) {
                item.setActive(Boolean.TRUE);
            }
            if ((saleOrderStatus = (SaleOrderStatusFlowTemplate)orderStatusMap.get(item.getOrderStatus())) != null) {
                item.setOrderStatus(saleOrderStatus.getDesc());
                item.setOrderStatusCode(saleOrderStatus.getCode());
            }
        });
        logger.info("[\u8ba2\u5355\u72b6\u6001]\u5f53\u524d\u552e\u540e\u8ba2\u5355\uff08orderId={}\uff09\u7684\u72b6\u6001\u5217\u8868:{}", (Object)orderId, (Object)JSON.toJSONString(orderStatusTemplateList));
        return orderStatusTemplateList;
    }

    @Override
    public DgAfterSaleOrderAuditDto queryAfterSaleOrderAuditDetail(String afterSaleOrderNo) {
        AssertUtils.notNull((Object)afterSaleOrderNo, (String)"\u552e\u540e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        OrderAuditEo orderAuditEo = (OrderAuditEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderAuditDomain.filter().eq((Object)"trade_no", (Object)afterSaleOrderNo)).orderByDesc((Object)"create_time")).last("limit 1")).one();
        return (DgAfterSaleOrderAuditDto)BeanUtil.copyProperties((Object)orderAuditEo, DgAfterSaleOrderAuditDto.class, (String[])new String[0]);
    }

    protected List<DgAfterSaleOrderStatusLogRespDto> getOrderStatusTemplate(List<SaleOrderStatusFlowTemplate> saleOrderStatusList) {
        return saleOrderStatusList.stream().map(item -> {
            DgAfterSaleOrderStatusLogRespDto orderStatusLogRespDto = new DgAfterSaleOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(item.getCode());
            return orderStatusLogRespDto;
        }).collect(Collectors.toList());
    }

    @Override
    public DgAfterSaleOrderRespDto queryById(Long id) {
        DgAfterSaleOrderEo orderEo = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectByPrimaryKey(id);
        DgAfterSaleOrderRespDto orderRespDto = new DgAfterSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)orderRespDto, (Object)orderEo, (String[])new String[0]);
        return orderRespDto;
    }

    protected void addAfterSaleVerify(DgAfterSaleOrderDto dto, boolean ifHaveSale) {
        DgPerformOrderRespDto dgPerformOrderRespDto;
        AssertUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getReason()), (String)"-1", (String)"\u9000\u8d27\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff0creason");
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)dto.getBizType()), (String)"-1", (String)"\u9000\u8d27\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0cbizType");
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)dto.getUnshippedReturn()), (String)"-1", (String)"\u662f\u5426\u672a\u53d1\u8d27\u9000\u8d27\u4e0d\u80fd\u4e3a\u7a7a\uff0cunshippedReturn");
        AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)dto.getItemDtoList()), (String)"-1", (String)"\u9000\u8d27\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\uff0citemDtoList");
        if (ifHaveSale) {
            AssertUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getSaleOrderNo()), (String)"-1", (String)"\u539f\u8ba2\u8d27\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0csaleOrderNo");
            AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)dto.getSaleOrderId()), (String)"-1", (String)"\u539f\u8ba2\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff0csaleOrderId");
        } else {
            AssertUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getShopCode()), (String)"-1", (String)"\u9000\u8d27\u5e97\u94fa\u4e0d\u80fd\u4e3a\u7a7a\uff0cshopCode");
            AssertUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getCustomerCode()), (String)"-1", (String)"\u9000\u8d27\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff0ccustomerCode");
        }
        dto.getItemDtoList().forEach(item -> {
            AssertUtil.isTrue((ObjectUtil.isEmpty((Object)item.getReturnNum()) || item.getReturnNum() == 0 ? 1 : 0) != 0, (String)"-1", (String)"\u9000\u8d27\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff0creturnNum");
            AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)item.getRefundAmount()), (String)"-1", (String)"\u9000\u8d27\u5546\u54c1\u9000\u8d27\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0crefundAmount");
            if (ifHaveSale) {
                AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)item.getSaleOrderItemId()), (String)"-1", (String)"\u539f\u8ba2\u8d27\u5355\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a\uff0csaleOrderItemId");
            } else {
                AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)item.getSkuCode()), (String)"-1", (String)"\u9000\u8d27\u5355\u5546\u54c1sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0cskuCode");
            }
        });
        if (ifHaveSale) {
            Map<Long, List<DgAfterSaleOrderItemDto>> collect = dto.getItemDtoList().stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemDto::getSaleOrderItemId));
            collect.forEach((k, v) -> AssertUtil.isTrue((v.size() > 1 ? 1 : 0) != 0, (String)"-1", (String)("\u9000\u8d27\u884c\u91cd\u590d\uff1a" + k)));
        }
        MatchItemReqDto reqDto = this.dgAfterSaleRuleService.getMatchItemReqDto(dto.getCustomerId(), dto.getCustomerCode(), dto.getShopId(), dto.getShopCode());
        String orderType = "";
        if (ObjectUtil.isNotEmpty((Object)dto.getSaleOrderId()) && null != (dgPerformOrderRespDto = this.commonOrderQueryService.querySaleOrderById(dto.getSaleOrderId()))) {
            orderType = dgPerformOrderRespDto.getOrderType();
        }
        reqDto.setOrderType(orderType);
        LinkedList<OrderItemDto> items = new LinkedList<OrderItemDto>();
        for (DgAfterSaleOrderItemDto dgAfterSaleOrderItemRespDto : dto.getItemDtoList()) {
            if (!ObjectUtil.equals((Object)0, (Object)dgAfterSaleOrderItemRespDto.getGift())) continue;
            DgItemSkuDetailRespDto dgItemSkuDetailRespDto = (DgItemSkuDetailRespDto)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.getItemSkuDetailById(dgAfterSaleOrderItemRespDto.getSkuId()));
            OrderItemDto nDto = new OrderItemDto();
            nDto.setBrand(String.valueOf(dgItemSkuDetailRespDto.getBrandId()));
            nDto.setSkuCode(dgItemSkuDetailRespDto.getSkuCode());
            nDto.setCategoryId(this.getAllParentDirs(dgItemSkuDetailRespDto.getDirId()));
            items.add(nDto);
        }
        reqDto.setItems(items);
        reqDto.setReturnBizType(dto.getReturnBizType());
        MatchItemReqDto reqDto1 = this.dgAfterSaleRuleService.matchItem(reqDto);
        for (OrderItemDto item2 : reqDto1.getItems()) {
            AssertUtil.isTrue((boolean)item2.isNonRefundable(), (String)("sku\uff1a" + item2.getSkuCode() + "\u4e0d\u53ef\u9000"));
        }
    }

    protected List<String> getAllParentDirs(long id) {
        LinkedList<String> result = new LinkedList<String>();
        while (id > 0L) {
            result.add(String.valueOf(id));
            DirectoryItemDgRespDto directoryItemDgRespDto = (DirectoryItemDgRespDto)RestResponseHelper.extractData((RestResponse)this.directoryDgQueryApiProxy.queryDirById(Long.valueOf(id)));
            if (null != directoryItemDgRespDto && !directoryItemDgRespDto.getId().equals(directoryItemDgRespDto.getParentId())) {
                id = directoryItemDgRespDto.getParentId();
                continue;
            }
            id = 0L;
        }
        return result;
    }

    @Override
    public DgAfterSaleOrderRespDto queryDetails(Long id, String afterSaleOrderNo) {
        logger.info("\u67e5\u8be2\u9000\u8d27\u5355\u8be6\u60c5\uff1a{}\uff0c{}", (Object)id, (Object)afterSaleOrderNo);
        AssertUtil.isTrue((ObjectUtil.isEmpty((Object)id) && StringUtils.isBlank((CharSequence)afterSaleOrderNo) ? 1 : 0) != 0, (String)"-1", (String)"\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38\uff0cid\u4e0eafterSaleOrderNo\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        DgAfterSaleOrderEo orderEo = this.dgAfterSaleOrderBasicQueryOptAction.queryByIdOrAfsOrderNo(id, afterSaleOrderNo);
        if (ObjectUtil.isEmpty((Object)orderEo)) {
            return null;
        }
        DgAfterSaleOrderRespDto orderRespDto = new DgAfterSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)orderRespDto, (Object)orderEo, (String[])new String[0]);
        this.dgAfterSaleOrderBasicQueryOptAction.queryAfsOrderOtherTableInfo(orderRespDto);
        orderRespDto.setReturnAddress(orderRespDto.getReturnProvinceName() + orderRespDto.getReturnCountyName() + orderRespDto.getReturnCityName() + orderRespDto.getReturnAddress());
        orderRespDto.setOrderSourceStr(Optional.ofNullable(orderRespDto.getOrderSource()).map(orderSource -> AfterSaleOrderSourceEnum.enumOf((Integer)orderSource).getDesc()).orElse(""));
        AfterSaleOrderReturnBizTypeEnum afterSaleOrderReturnBizTypeEnum = AfterSaleOrderReturnBizTypeEnum.forCode((Integer)orderRespDto.getReturnBizType());
        orderRespDto.setReturnBizTypeName(afterSaleOrderReturnBizTypeEnum.getDescription());
        orderRespDto.setSaleCompanyCode(orderRespDto.getEnterpriseCode());
        orderRespDto.setSaleCompanyId(orderRespDto.getEnterpriseId());
        orderRespDto.setSaleCompanyName(orderRespDto.getEnterpriseName());
        this.setAfterAttachment(orderRespDto);
        this.dgAfterSaleOrderBasicQueryOptAction.getParentRefundWaySummaryDtos(orderRespDto);
        List<DgAfterSaleOrderEo> afterSaleOrderEoList = this.dgAfterSaleOrderBasicQueryOptAction.queryEosByPlatformRefundOrderSn(orderEo.getAfterSaleOrderNo());
        if (CollectionUtils.isNotEmpty(afterSaleOrderEoList)) {
            orderRespDto.setSaleReturnOrder(afterSaleOrderEoList.get(0).getAfterSaleOrderNo());
        }
        List qualityControlEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.qualityControlDomain.filter().eq((Object)"after_sale_code", (Object)orderEo.getAfterSaleOrderNo())).eq((Object)"status", (Object)1)).list();
        Map<Object, Object> controlItemEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)qualityControlEos)) {
            QualityControlEo qualityControlEo = (QualityControlEo)qualityControlEos.get(0);
            List qcItemList = ((ExtQueryChainWrapper)this.qualityControlItemDomain.filter().eq((Object)"qc_id", (Object)qualityControlEo.getId())).list();
            controlItemEoMap = qcItemList.stream().collect(Collectors.toMap(QualityControlItemEo::getAfterSaleItemId, Function.identity()));
        }
        List itemEoList = this.dgAfterSaleOrderItemDomain.queryEosByAfterSaleOrderId(orderRespDto.getId());
        BigDecimal expectRefundAmount = BigDecimal.ZERO;
        BigDecimal actualRefundAmount = BigDecimal.ZERO;
        BigDecimal settlementAmount = BigDecimal.ZERO;
        BigDecimal yfkRefundAmount = BigDecimal.ZERO;
        BigDecimal rebateRefundAmount = BigDecimal.ZERO;
        BigDecimal creditRefundAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)itemEoList)) {
            ArrayList<DgAfterSaleOrderItemDto> itemDtoList = new ArrayList<DgAfterSaleOrderItemDto>();
            CubeBeanUtils.copyCollection(itemDtoList, (Collection)itemEoList, DgAfterSaleOrderItemRespDto.class);
            List<Long> ids = itemDtoList.stream().map(BaseDto::getId).collect(Collectors.toList());
            List allRefundItemEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.refundItemDomain.filter().in((Object)"biz_item_id", ids)).eq((Object)"dr", (Object)0)).list();
            List allRefundItemDtos = BeanUtil.copyToList((Collection)allRefundItemEos, DgRefundItemDto.class);
            Map<Long, List<DgRefundItemDto>> refundItemMap = allRefundItemDtos.stream().collect(Collectors.groupingBy(DgRefundItemDto::getBizItemId));
            for (DgAfterSaleOrderItemDto itemDto : itemDtoList) {
                List<DgRefundItemDto> dgRefundItemDtoList;
                QualityControlItemEo qualityControlItemEo = (QualityControlItemEo)controlItemEoMap.get(itemDto.getId());
                if (ObjectUtil.isNotNull((Object)qualityControlItemEo)) {
                    itemDto.setDesignBadNum(qualityControlItemEo.getDesignBadNum());
                    itemDto.setOperationBadNum(qualityControlItemEo.getOperationBadNum());
                    itemDto.setMaterialBadNum(qualityControlItemEo.getMaterialBadNum());
                    itemDto.setCustomerBrokeBadNum(qualityControlItemEo.getCustomerBrokeBadNum());
                    itemDto.setCustomerObsoleteBadNum(qualityControlItemEo.getCustomerObsoleteBadNum());
                    itemDto.setMistakeBadNum(qualityControlItemEo.getMistakeBadNum());
                }
                expectRefundAmount = expectRefundAmount.add(Optional.ofNullable(itemDto.getRefundAmount()).orElse(BigDecimal.ZERO));
                actualRefundAmount = actualRefundAmount.add(Optional.ofNullable(itemDto.getActualRefundAmount()).orElse(BigDecimal.ZERO));
                settlementAmount = settlementAmount.add(Optional.ofNullable(itemDto.getSettlementAmount()).orElse(BigDecimal.ZERO));
                if (!ObjectUtil.isNotEmpty(refundItemMap) || !CollectionUtils.isNotEmpty(dgRefundItemDtoList = refundItemMap.get(itemDto.getId()))) continue;
                yfkRefundAmount = yfkRefundAmount.add(dgRefundItemDtoList.stream().filter(refundItem -> refundItem.getAccountCategory().equals(AccountCategoryEnum.CAPITAL.getCode()) && refundItem.getRefundWay().equals("YFK")).map(DgRefundItemDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                List costRefundItemEos = dgRefundItemDtoList.stream().filter(refundItem -> refundItem.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())).collect(Collectors.toList());
                rebateRefundAmount = rebateRefundAmount.add(costRefundItemEos.stream().map(DgRefundItemDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                creditRefundAmount = creditRefundAmount.add(dgRefundItemDtoList.stream().filter(refundItem -> refundItem.getAccountCategory().equals(AccountCategoryEnum.CAPITAL.getCode()) && refundItem.getRefundWay().equals("CREDIT")).map(DgRefundItemDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                List dgRefundItemDtos = BeanUtil.copyToList(costRefundItemEos, DgRefundItemDto.class);
                itemDto.setRefundItemDtoList(dgRefundItemDtos);
            }
            this.buildAfsItemLabels(orderRespDto.getId(), ids, itemDtoList);
            orderRespDto.setItemDtoList(itemDtoList);
        }
        orderRespDto.setExpectRefundAmount(expectRefundAmount);
        orderRespDto.setActualRefundAmount(actualRefundAmount);
        orderRespDto.setSettlementAmount(settlementAmount);
        orderRespDto.setYfkRefundAmount(yfkRefundAmount);
        orderRespDto.setRebateRefundAmount(rebateRefundAmount);
        orderRespDto.setCreditRefundAmount(creditRefundAmount);
        if (ObjectUtil.isNotEmpty((Object)orderEo.getSaleOrderId()) && (orderEo.getStatus().equals(DgF2BAfterStatus.WAIT_AUDIT.getCode()) || orderEo.getStatus().equals(DgF2BAfterStatus.WAIT_CHECK.getCode()))) {
            logger.info("\u9000\u8d27\u5355\u4e3a\u539f\u5355\u9000\u8d27\u3001\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838\uff0c\u67e5\u8be2\u5546\u54c1\u7684\u53ef\u9000\u6570\u91cf");
            List itemRespDtoList = this.dgF2BAfterOrderSaveAction.applyPerformOrderAfter(orderEo.getSaleOrderNo(), orderEo.getReturnBizType()).getItemRespDtoList();
            Map<Object, Object> itemRespMap = new HashMap();
            if (CollectionUtil.isNotEmpty((Collection)itemRespDtoList)) {
                logger.info("\u53ef\u9000\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)itemRespDtoList));
                itemRespMap = itemRespDtoList.stream().collect(Collectors.toMap(DgAfterSaleOrderItemDto::getSaleOrderItemId, Function.identity()));
            }
            HashMap finalItemRespMap = itemRespMap;
            orderRespDto.getItemDtoList().forEach(afterItem -> {
                DgAfterSaleOrderItemRespDto respDto = (DgAfterSaleOrderItemRespDto)finalItemRespMap.get(afterItem.getSaleOrderItemId());
                afterItem.setAllowReturnNum(Integer.valueOf(respDto.getAllowReturnNum() + afterItem.getReturnNum()));
                afterItem.setAllowReturnAmount(respDto.getAllowReturnAmount().add(afterItem.getRefundAmount()));
                afterItem.setOrigOrderAmount(respDto.getOrigOrderAmount());
                afterItem.setOrigOrderItemNum(respDto.getOrigOrderItemNum());
            });
        }
        this.buildAfsOrderLabels(orderRespDto.getId(), orderRespDto);
        return orderRespDto;
    }

    private void buildAfsOrderLabels(Long afsOrderId, DgAfterSaleOrderRespDto orderRespDto) {
        List dgOrderLabelRecordRespDtos = this.orderLabelRecordDomain.queryByOrderId(afsOrderId);
        if (CollectionUtils.isNotEmpty((Collection)dgOrderLabelRecordRespDtos)) {
            List lableCodes = dgOrderLabelRecordRespDtos.stream().map(DgOrderLabelBaseRespDto::getLabelCode).collect(Collectors.toList());
            List labelEoList = this.dgOrderLabelDomain.queryEosByLabelCodes(lableCodes);
            orderRespDto.setLabelRecordCodes(labelEoList);
        }
    }

    private void buildAfsItemLabels(Long id, List<Long> ids, List<DgAfterSaleOrderItemDto> itemDtoList) {
        List labelCodes;
        List labelDtoList;
        List labelItemDtos = this.orderLabelItemDomain.queryAfsOrderLabelItemDtos(id, ids);
        if (CollectionUtils.isNotEmpty((Collection)labelItemDtos) && CollectionUtils.isNotEmpty((Collection)(labelDtoList = this.dgOrderLabelDomain.queryEosByLabelCodes(labelCodes = labelItemDtos.stream().map(DgOrderLabelBaseRespDto::getLabelCode).collect(Collectors.toList()))))) {
            Map labelCodeMap = labelDtoList.stream().collect(Collectors.toMap(DgOrderLabelRespDto::getLabelCode, Function.identity()));
            Map<Long, List<DgOrderLabelItemRespDto>> orderLabelItemMap = labelItemDtos.stream().collect(Collectors.groupingBy(DgOrderLabelItemRespDto::getOrderItemId));
            for (DgAfterSaleOrderItemDto dgAfterSaleOrderItemDto : itemDtoList) {
                List<DgOrderLabelItemRespDto> labelItemRespDtos = orderLabelItemMap.get(dgAfterSaleOrderItemDto.getId());
                if (!CollectionUtils.isNotEmpty(labelItemRespDtos)) continue;
                ArrayList itemLabelDtoList = com.google.common.collect.Lists.newArrayList();
                for (DgOrderLabelItemRespDto labelItemRespDto : labelItemRespDtos) {
                    DgOrderLabelRespDto dgOrderLabelRespDto = (DgOrderLabelRespDto)labelCodeMap.get(labelItemRespDto.getLabelCode());
                    itemLabelDtoList.add(dgOrderLabelRespDto);
                }
                dgAfterSaleOrderItemDto.setItemLabelDtoList((List)itemLabelDtoList);
            }
        }
    }

    @Override
    public List<DgBizOrderRespDto> queryBizOrder(String afterSaleOrderNo) {
        DgAfterSaleOrderEo platformOrderEo;
        DgPerformOrderInfoEo dgPerformOrderInfoEo;
        logger.info("\u67e5\u8be2\u9000\u8d27\u5355\u5173\u8054\u4e1a\u52a1\u5355\u636e\uff1a{}", (Object)afterSaleOrderNo);
        ArrayList resultList = Lists.newArrayList();
        DgAfterSaleOrderEo orderEo = this.dgAfterSaleOrderDomain.queryByAfterSaleOrderNo(afterSaleOrderNo);
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)orderEo), (String)"-1", (String)(afterSaleOrderNo + " \u9000\u8d27\u5355\u4e0d\u5b58\u5728"));
        if (StringUtils.isNotBlank((CharSequence)orderEo.getSaleOrderNo()) && (dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryByOrderNo(orderEo.getSaleOrderNo())) != null) {
            DgPerformOrderRespDto performOrderRespDto = new DgPerformOrderRespDto();
            CubeBeanUtils.copyProperties((Object)performOrderRespDto, (Object)dgPerformOrderInfoEo, (String[])new String[0]);
            DgF2BOrderStatus dgF2BOrderStatus = DgF2BOrderStatus.forCode((String)performOrderRespDto.getOrderStatus());
            DgBizOrderRespDto respDto = new DgBizOrderRespDto(performOrderRespDto.getId(), performOrderRespDto.getSaleOrderNo(), "\u8ba2\u8d27\u5355", performOrderRespDto.getOrderStatus(), dgF2BOrderStatus.getDesc(), performOrderRespDto.getCreateTime());
            resultList.add(respDto);
        }
        if (StringUtils.isNotBlank((CharSequence)orderEo.getPlatformOrderNo()) && ObjectUtil.isNotEmpty((Object)(platformOrderEo = this.dgAfterSaleOrderDomain.queryByAfterSaleOrderNo(orderEo.getPlatformOrderNo())))) {
            DgF2BAfterStatus dgF2BAfterStatus = DgF2BAfterStatus.forCode((String)platformOrderEo.getStatus());
            DgBizOrderRespDto respDto = new DgBizOrderRespDto(platformOrderEo.getId(), platformOrderEo.getAfterSaleOrderNo(), "\u9500\u552e\u9000\u8d27\u5355", platformOrderEo.getStatus(), dgF2BAfterStatus.getDesc(), platformOrderEo.getCreateTime());
            resultList.add(respDto);
        }
        return resultList;
    }

    @Override
    public List<DgBizOrderRespDto> queryStockOrder(String afterSaleOrderNo) {
        logger.info("\u67e5\u8be2\u9000\u8d27\u5355\u5173\u8054\u5e93\u5b58\u5355\u636e\uff1a{}", (Object)afterSaleOrderNo);
        DgPerformNoticeSyncRecordDto recordDto = new DgPerformNoticeSyncRecordDto();
        recordDto.setBusinessNo(afterSaleOrderNo);
        List<DgBizPerformNoticeSyncRecordDto> list = this.dgPerformNoticeSyncRecordService.queryList(recordDto);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.stream().map(dto -> new DgBizOrderRespDto(dto.getId(), dto.getResultNoticeOrderNo(), "\u5165\u5e93\u7ed3\u679c\u5355", dto.getNoticeResultSyncStatus(), NoticeResultSyncStatusEnum.forCode((String)dto.getNoticeResultSyncStatus()).getDesc(), dto.getCreateTime())).collect(Collectors.toList());
        }
        return com.google.common.collect.Lists.newArrayList();
    }

    @Override
    public List<DgRefundDetailDto> queryRefundDetail(String afterSaleOrderNo) {
        logger.info("\u67e5\u8be2\u9000\u8d27\u9000\u6b3e\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)afterSaleOrderNo));
        List refundDetailEoList = this.dgRefundDetailDomain.queryEosByAfterSaleOrderNo(afterSaleOrderNo);
        if (CollectionUtils.isNotEmpty((Collection)refundDetailEoList)) {
            List accountCodes = refundDetailEoList.stream().map(DgRefundDetailEo::getRefundAccount).distinct().collect(Collectors.toList());
            List accountTypeDtoList = (List)RestResponseHelper.extractData((RestResponse)this.accountTypeApiProxy.queryByCodes(accountCodes));
            Map<Object, Object> accountTypeMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)accountTypeDtoList)) {
                accountTypeMap = accountTypeDtoList.stream().collect(Collectors.toMap(AccountTypeDto::getAccountTypeCode, AccountTypeDto::getCustomName, (v1, v2) -> v2));
            }
            List enterpriceCodeList = refundDetailEoList.stream().map(DgRefundDetailEo::getEnterpriseCode).distinct().collect(Collectors.toList());
            DgEnterpriseQueryReqDto dgEnterpriseQueryReqDto = new DgEnterpriseQueryReqDto();
            dgEnterpriseQueryReqDto.setCodeList(enterpriceCodeList);
            List list = (List)RestResponseHelper.extractData((RestResponse)this.dgTobEnterpriseQueryApiProxy.queryList(dgEnterpriseQueryReqDto));
            Map<Object, Object> enterpriceNameMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                enterpriceNameMap = list.stream().collect(Collectors.toMap(DgEnterpriseRespDto::getCode, DgEnterpriseRespDto::getName, (v1, v2) -> v2));
            }
            Map<Object, Object> finalAccountTypeMap = accountTypeMap;
            HashMap finalEnterpriceNameMap = enterpriceNameMap;
            return refundDetailEoList.stream().map(m -> {
                DgRefundDetailDto respDto = new DgRefundDetailDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)m, (String[])new String[0]);
                if (StringUtils.isNotBlank((CharSequence)respDto.getStatus())) {
                    respDto.setStatusStr(NewDgRefundDetailStatusEnum.getDescByCode((String)respDto.getStatus()));
                }
                respDto.setRefundAccountName((String)finalAccountTypeMap.get(respDto.getRefundAccount()));
                respDto.setEnterpriseName((String)finalEnterpriceNameMap.get(respDto.getEnterpriseCode()));
                return respDto;
            }).collect(Collectors.toList());
        }
        return com.google.common.collect.Lists.newArrayList();
    }

    @Override
    public List<DgAfterSaleOrderItemRespDto> applyPerformOrderAfterItemList(Long afterOrderId) {
        logger.info("\u539f\u5355\u9000\u8d27\u5355\u7f16\u8f91\u5546\u54c1\u5217\u8868\uff1a{}", (Object)afterOrderId);
        DgAfterSaleOrderEo afterOrder = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectByPrimaryKey(afterOrderId);
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)afterOrder), (String)"-1", (String)"\u627e\u4e0d\u5230\u9000\u8d27\u5355\u4fe1\u606f");
        AssertUtil.isTrue((boolean)ObjectUtil.isEmpty((Object)afterOrder.getSaleOrderId()), (String)"-1", (String)"\u8be5\u9000\u8d27\u5355\u4e3a\u975e\u539f\u5355\u9000\u8d27");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = (DgAfterSaleOrderRespDto)BeanUtil.copyProperties((Object)afterOrder, DgAfterSaleOrderRespDto.class, (String[])new String[0]);
        List afterItemList = this.dgAfterSaleOrderItemDomain.queryEosByAfterSaleOrderId(afterOrder.getId());
        AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)afterItemList), (String)"-1", (String)"\u627e\u4e0d\u5230\u9000\u8d27\u5355\u5546\u54c1\u4fe1\u606f");
        Map afterItemMap = afterItemList.stream().collect(Collectors.toMap(DgAfterSaleOrderItemEo::getSaleOrderItemId, Function.identity()));
        List itemRespDtoList = this.dgF2BAfterOrderSaveAction.applyPerformOrderAfter(afterOrder.getSaleOrderNo(), afterOrder.getReturnBizType()).getItemRespDtoList();
        itemRespDtoList.forEach(item -> {
            DgAfterSaleOrderItemEo itemEo = (DgAfterSaleOrderItemEo)afterItemMap.get(item.getSaleOrderItemId());
            if (ObjectUtil.isNotEmpty((Object)itemEo)) {
                item.setAllowReturnNum(Integer.valueOf(item.getAllowReturnNum() + itemEo.getReturnNum()));
                item.setAllowReturnAmount(item.getAllowReturnAmount().add(itemEo.getRefundAmount()));
            }
        });
        return itemRespDtoList;
    }

    @Override
    public String getRefundModeByShop(String shopCode, Long saleOrderId, Integer returnBizType) {
        logger.info("\u6839\u636e\u5e97\u94fa\u7f16\u53f7\u53ca\u539f\u8ba2\u8d27\u5355\u83b7\u53d6\u9000\u6b3e\u65b9\u5f0f\uff08\u4e3a\u63c9\u4ef7\u9000\u6b3e\uff0c\u589e\u52a0\u539f\u8ba2\u8d27\u5355\u662f\u5426\u5b58\u5728\u63c9\u4ef7\u660e\u7ec6\u6821\u9a8c\uff09\uff1a{}\uff0c{}\uff0c{}", new Object[]{shopCode, saleOrderId, returnBizType});
        if (ObjectUtil.isNotEmpty((Object)returnBizType) && Objects.equals(returnBizType, AfterSaleOrderReturnBizTypeEnum.ADJUSTMENT_RETURN_ORDER.getCode())) {
            logger.info("\u9000\u8d27\u8c03\u8d26\u7c7b\u578b\u6307\u5b9a\u9884\u4ed8\u6b3e\u9000\u8d27");
            return DgF2BAfterRefundModeEnum.ZT_YFK.getCode();
        }
        if (saleOrderId == null) {
            return DgF2BAfterRefundModeEnum.ORDER.getCode();
        }
        DgPerformOrderSnapshotEo dgPerformOrderSnapshotEo = this.performOrderSnapshotDomain.selectByOrderId(saleOrderId);
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)dgPerformOrderSnapshotEo), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u8ba2\u8d27\u5355\u7684\u5feb\u7167\u4fe1\u606f");
        if (ObjectUtil.isNotEmpty((Object)dgPerformOrderSnapshotEo.getKneadeFlag()) && dgPerformOrderSnapshotEo.getKneadeFlag().equals(YesNoEnum.YES.getValue())) {
            return DgF2BAfterRefundModeEnum.KNEAD.getCode();
        }
        return DgF2BAfterRefundModeEnum.ORDER.getCode();
    }

    private void setAfterAttachment(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        logger.info("\u8bbe\u7f6e\u9000\u8d27\u5355\u9644\u4ef6\u4fe1\u606f\uff1a{}", (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderRespDto.getAfterSaleOrderNo())) {
            ArrayList types = com.google.common.collect.Lists.newArrayList((Object[])new String[]{OptBizTypeEnum.RETURN.getType(), OptBizTypeEnum.RETURN_RECEIVING_REPORT.getType(), OptBizTypeEnum.RETURN_QUALITY_REPORT.getType()});
            List eoList = this.attachementDomain.queryEosByAfsOrderNoAndTypes(afterSaleOrderRespDto.getAfterSaleOrderNo(), types);
            if (CollectionUtils.isNotEmpty((Collection)eoList)) {
                ArrayList reqDtoList = new ArrayList();
                DtoHelper.eoList2DtoList((Collection)eoList, reqDtoList, AttachementReqDto.class);
                List attachementReqDtoList = reqDtoList.stream().filter(f -> f.getBizType().equals(OptBizTypeEnum.RETURN.getType())).collect(Collectors.toList());
                afterSaleOrderRespDto.setAttachmentList(attachementReqDtoList);
                List receivingReportList = reqDtoList.stream().filter(f -> f.getBizType().equals(OptBizTypeEnum.RETURN_RECEIVING_REPORT.getType())).collect(Collectors.toList());
                afterSaleOrderRespDto.setReceivingReportList(receivingReportList);
                List returnQualityReportList = reqDtoList.stream().filter(f -> f.getBizType().equals(OptBizTypeEnum.RETURN_QUALITY_REPORT.getType())).collect(Collectors.toList());
                afterSaleOrderRespDto.setQualityReportAttachmentList(returnQualityReportList);
            }
        }
    }
}

