/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountMatchesItemRespDto;
import com.yunxi.dg.base.center.account.dto.entity.AccountDto;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgAccountProportionalControlConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAccountProportionalControlDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAccountSpecialProportionalControlDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAccountProportionalControlDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.cost.AccountPreviewDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAccountProportionalControlEo;
import com.yunxi.dg.base.center.trade.eo.DgAccountSpecialProportionalControlEo;
import com.yunxi.dg.base.center.trade.eo.PayRecordEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAccountProportionalControlService;
import com.yunxi.dg.base.center.trade.service.help.CostHelper;
import com.yunxi.dg.base.center.trade.service.oms.common.ICalculateAmountService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAccountProportionalControlServiceImpl
extends BaseServiceImpl<DgAccountProportionalControlDto, DgAccountProportionalControlEo, IDgAccountProportionalControlDomain>
implements IDgAccountProportionalControlService {
    private static final Logger log = LoggerFactory.getLogger(DgAccountProportionalControlServiceImpl.class);
    @Resource(name="costHelper")
    private CostHelper costHelper;
    @Resource
    private ICalculateAmountService channelCalculateAmountService;
    @Resource
    private IDgAccountSpecialProportionalControlDomain dgAccountSpecialProportionalControlDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IPayRecordDomain payRecordDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;

    public DgAccountProportionalControlServiceImpl(IDgAccountProportionalControlDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgAccountProportionalControlDto, DgAccountProportionalControlEo> converter() {
        return DgAccountProportionalControlConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> addOrUpdate(List<DgAccountProportionalControlDto> dtos) {
        if (CollectionUtil.isEmpty(dtos)) {
            return RestResponse.VOID;
        }
        List eos = ((ExtQueryChainWrapper)((IDgAccountProportionalControlDomain)this.domain).filter().in((Object)"account_type", (Collection)dtos.stream().map(DgAccountProportionalControlDto::getAccountType).collect(Collectors.toList()))).list();
        Map map = eos.stream().collect(Collectors.toMap(DgAccountProportionalControlEo::getAccountType, Function.identity(), (e1, e2) -> e1));
        ArrayList addEos = Lists.newArrayList();
        for (DgAccountProportionalControlDto dto : dtos) {
            AssertUtils.notNull((Object)dto.getAccountType(), (String)"\u8d26\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)dto.getScale(), (String)"\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            DgAccountProportionalControlEo eo = (DgAccountProportionalControlEo)map.get(dto.getAccountType());
            if (eo != null) {
                DgAccountProportionalControlEo updateEo = new DgAccountProportionalControlEo();
                updateEo.setId(dto.getId());
                updateEo.setScale(dto.getScale());
                ((IDgAccountProportionalControlDomain)this.domain).updateSelective((BaseEo)updateEo);
                continue;
            }
            DgAccountProportionalControlEo addEo = (DgAccountProportionalControlEo)BeanUtil.copyProperties((Object)dto, DgAccountProportionalControlEo.class, (String[])new String[0]);
            addEos.add(addEo);
        }
        if (CollectionUtil.isNotEmpty((Collection)addEos)) {
            ((IDgAccountProportionalControlDomain)this.domain).insertBatch((List)addEos);
        }
        return RestResponse.VOID;
    }

    @Override
    public Map<String, String> matchCustomerAccount(String customerCode, List<String> accountTypeList) {
        LambdaQueryWrapper specialAccountQuery = new LambdaQueryWrapper();
        specialAccountQuery.eq(BaseEo::getDr, (Object)0);
        specialAccountQuery.eq(DgAccountSpecialProportionalControlEo::getCustomerCode, (Object)customerCode);
        specialAccountQuery.in(DgAccountSpecialProportionalControlEo::getAccountType, accountTypeList);
        List dgAccountSpecialProportionalControlEos = this.dgAccountSpecialProportionalControlDomain.getMapper().selectList((Wrapper)specialAccountQuery);
        Map<String, String> specialAccountTypeMap = new HashMap<String, String>();
        if (CollectionUtil.isNotEmpty((Collection)dgAccountSpecialProportionalControlEos)) {
            specialAccountTypeMap = dgAccountSpecialProportionalControlEos.stream().collect(Collectors.toMap(DgAccountSpecialProportionalControlEo::getAccountType, DgAccountSpecialProportionalControlEo::getScale, (k1, k2) -> k1));
        }
        if (specialAccountTypeMap.size() == accountTypeList.size()) {
            return specialAccountTypeMap;
        }
        LambdaQueryWrapper accountQuery = new LambdaQueryWrapper();
        accountQuery.eq(BaseEo::getDr, (Object)0);
        accountQuery.in(DgAccountProportionalControlEo::getAccountType, accountTypeList);
        List dgAccountProportionalControlEos = ((IDgAccountProportionalControlDomain)this.domain).getMapper().selectList((Wrapper)accountQuery);
        Map<Object, Object> accountTypeMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)dgAccountProportionalControlEos)) {
            accountTypeMap = dgAccountProportionalControlEos.stream().collect(Collectors.toMap(DgAccountProportionalControlEo::getAccountType, DgAccountProportionalControlEo::getScale, (k1, k2) -> k1));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String accountType : accountTypeList) {
            if (specialAccountTypeMap.containsKey(accountType)) {
                map.put(accountType, specialAccountTypeMap.get(accountType));
                continue;
            }
            if (accountTypeMap.containsKey(accountType)) {
                map.put(accountType, (String)accountTypeMap.get(accountType));
                continue;
            }
            map.put(accountType, "100.00");
        }
        return map;
    }

    @Override
    public Map<String, BigDecimal> getAccountPayMaxAmount(DgPerformOrderRespDto order, List<AccountDto> accountDtoList) {
        HashMap<String, BigDecimal> accountPayMaxMap = new HashMap<String, BigDecimal>();
        Map accountDtoMap = accountDtoList.stream().collect(Collectors.toMap(AccountDto::getAccountType, Function.identity(), (a, b) -> a));
        List orderLineDtos = order.getOrderLineList();
        Map<Long, BigDecimal> itemPayAmountMap = this.channelCalculateAmountService.calculateOrderLineBasicAmount(orderLineDtos, DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode());
        String customerCode = order.getPerformOrderSnapshotDto().getCustomerCode();
        List<String> accountTypeList = accountDtoList.stream().map(AccountDto::getAccountType).collect(Collectors.toList());
        Map<String, String> accountProportionalMap = this.matchCustomerAccount(customerCode, accountTypeList);
        log.info("[\u8d26\u6237\u6bd4\u4f8b\u914d\u7f6e]\u8ba2\u5355={},\u5ba2\u6237={},\u6bd4\u4f8b\u914d\u7f6e={}", new Object[]{order.getSaleOrderNo(), customerCode, JSONObject.toJSON(accountProportionalMap)});
        List payRecordEos = this.payRecordDomain.selectListByOrderNo(order.getSaleOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
            payRecordEos = payRecordEos.stream().filter(bean -> PayStatusEnum.SUCCESS.getName().equals(bean.getPayStatus())).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty((Collection)payRecordEos)) {
            log.info("\u81ea\u52a8\u7ec4\u5408\u652f\u4ed8\u53c2\u6570--\u4e8c\u6b21\u652f\u4ed8\uff0c\u6700\u5927\u652f\u4ed8\u6bd4\u4f8b\u6d41\u7a0b");
            Map<Long, BigDecimal> itemRealPayAmountMap = this.channelCalculateAmountService.calculateOrderLineBasicAmount(orderLineDtos, DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode());
            Map<Object, Object> payRecordMap = new HashMap();
            if (CollectionUtils.isNotEmpty(payRecordEos)) {
                payRecordMap = payRecordEos.stream().filter(bean -> PayStatusEnum.SUCCESS.getName().equals(bean.getPayStatus())).collect(Collectors.toMap(PayRecordEo::getPayMethod, PayRecordEo::getPayAmount, (k1, k2) -> {
                    k1 = k1.add((BigDecimal)k2);
                    return k1;
                }));
            }
            for (String accountType : accountProportionalMap.keySet()) {
                BigDecimal proportional = new BigDecimal(accountProportionalMap.get(accountType)).divide(new BigDecimal(100), 2, 4);
                AccountDto accountDto = (AccountDto)accountDtoMap.get(accountType);
                List<Object> subItems = new ArrayList(orderLineDtos);
                if (CollectionUtil.isNotEmpty((Collection)accountDto.getItems())) {
                    List ids = accountDto.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                    subItems = subItems.stream().filter(item -> ids.contains(item.getId())).collect(Collectors.toList());
                }
                log.info("\u8d26\u6237\u3010{}\u3011\u9002\u7528\u5546\u54c1\u4e3a\uff1a{}", (Object)accountType, subItems.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList()));
                BigDecimal transactionAmount = BigDecimal.ZERO;
                for (DgPerformOrderLineDto orderLineDto : subItems) {
                    if (accountDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) {
                        transactionAmount = transactionAmount.add(Optional.ofNullable(itemPayAmountMap.get(orderLineDto.getId())).orElse(BigDecimal.ZERO));
                        continue;
                    }
                    transactionAmount = transactionAmount.add(Optional.ofNullable(itemRealPayAmountMap.get(orderLineDto.getId())).orElse(BigDecimal.ZERO));
                }
                BigDecimal accountMaxPayAmount = transactionAmount.multiply(proportional).setScale(2, 4);
                BigDecimal payAmount = BigDecimal.ZERO;
                if (payRecordMap.containsKey(accountType)) {
                    payAmount = (BigDecimal)payRecordMap.get(accountType);
                    accountMaxPayAmount = (accountMaxPayAmount = accountMaxPayAmount.subtract(payAmount)).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : accountMaxPayAmount;
                }
                log.info("\u8d26\u6237\u3010{}\u3011\u672c\u5355\u53ef\u7528\u6700\u5927\u91d1\u989d\uff1a{} || \u5df2\u652f\u4ed8\u8fc7\u7684\u91d1\u989d\uff1a{}", new Object[]{accountType, accountMaxPayAmount, payAmount});
                accountPayMaxMap.put(accountType, accountMaxPayAmount);
            }
        } else {
            BigDecimal proportional;
            log.info("\u81ea\u52a8\u7ec4\u5408\u652f\u4ed8\u53c2\u6570--\u9996\u6b21\u652f\u4ed8\uff0c\u6700\u5927\u652f\u4ed8\u6bd4\u4f8b\u6d41\u7a0b");
            ArrayList<DgPreviewPerformOrderItemReqDto> orderItems = new ArrayList<DgPreviewPerformOrderItemReqDto>();
            for (DgPerformOrderLineDto oorderLineDto : orderLineDtos) {
                DgPreviewPerformOrderItemReqDto itemReqDto = new DgPreviewPerformOrderItemReqDto();
                itemReqDto.setSortNo(oorderLineDto.getId());
                itemReqDto.setPayAmount(Optional.ofNullable(itemPayAmountMap.get(oorderLineDto.getId())).orElse(BigDecimal.ZERO));
                itemReqDto.setAllocatedAmount(BigDecimal.ZERO);
                orderItems.add(itemReqDto);
            }
            ArrayList<AccountPreviewDto> accountPreviewDtos = new ArrayList<AccountPreviewDto>();
            for (AccountDto accountDto : accountDtoList) {
                if (!accountDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) continue;
                proportional = new BigDecimal(accountProportionalMap.get(accountDto.getAccountType())).divide(new BigDecimal(100), 2, 4);
                AccountPreviewDto accountPreviewDto = new AccountPreviewDto();
                accountPreviewDto.setAccountCategory(accountDto.getAccountCategory());
                accountPreviewDto.setAccountType(accountDto.getAccountType());
                accountPreviewDto.setItems(accountDto.getItems());
                accountPreviewDto.setProportional(proportional);
                accountPreviewDto.setPayCalculateMode(order.getPerformOrderSnapshotDto().getPayCalculateMode());
                BigDecimal amount = BigDecimal.ZERO;
                if (CollectionUtil.isNotEmpty((Collection)accountPreviewDto.getItems())) {
                    List ids = accountPreviewDto.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                    amount = orderItems.stream().filter(item -> ids.contains(item.getSortNo())).map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                } else {
                    amount = orderItems.stream().map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                if (null == order.getPerformOrderSnapshotDto().getPayCalculateMode() || order.getPerformOrderSnapshotDto().getPayCalculateMode() == 1) {
                    amount = amount.multiply(proportional).setScale(2, 4);
                }
                if (amount.compareTo(accountDto.getDisposable()) > 0) {
                    log.info("\u53ef\u7528\u6700\u5927\u989d\u5ea6 \uff1a{} > \u8d26\u6237\u4f59\u989d \uff1a{}", (Object)amount, (Object)accountDto.getDisposable());
                    amount = accountDto.getDisposable();
                }
                accountPreviewDto.setOrderAvaBalance(amount);
                accountPreviewDtos.add(accountPreviewDto);
            }
            if (CollectionUtil.isNotEmpty(accountPreviewDtos)) {
                log.info("\u8ba1\u7b97\u6700\u5927\u652f\u4ed8\u91d1\u989d--\u63d0\u524d\u5206\u644a\u91d1\u989d");
                this.costHelper.suggestAccount(accountPreviewDtos, orderItems);
            }
            for (AccountDto accountDto : accountDtoList) {
                List ids;
                if (!accountProportionalMap.containsKey(accountDto.getAccountType())) continue;
                proportional = new BigDecimal(accountProportionalMap.get(accountDto.getAccountType())).divide(new BigDecimal(100), 2, 4);
                BigDecimal amount = BigDecimal.ZERO;
                if (accountDto.getAccountCategory().equals(AccountCategoryEnum.COST.getCode())) {
                    if (null == order.getPerformOrderSnapshotDto().getPayCalculateMode() || order.getPerformOrderSnapshotDto().getPayCalculateMode() == 1) {
                        if (CollectionUtil.isNotEmpty((Collection)accountDto.getItems())) {
                            ids = accountDto.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                            amount = orderItems.stream().filter(item -> ids.contains(item.getSortNo())).map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        } else {
                            amount = orderItems.stream().map(DgPerformOrderItemDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                    } else if (CollectionUtil.isNotEmpty((Collection)accountDto.getItems())) {
                        ids = accountDto.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                        amount = orderItems.stream().filter(item -> ids.contains(item.getSortNo())).map(item -> item.getPayAmount().multiply(proportional)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    } else {
                        amount = orderItems.stream().map(item -> item.getPayAmount().multiply(proportional)).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                } else {
                    if (CollectionUtil.isNotEmpty((Collection)accountDto.getItems())) {
                        ids = accountDto.getItems().stream().map(AccountMatchesItemRespDto::getOrderItemId).collect(Collectors.toList());
                        amount = orderItems.stream().filter(item -> ids.contains(item.getSortNo())).map(item -> item.getPayAmount().subtract(item.getAllocatedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                    } else {
                        amount = orderItems.stream().map(item -> item.getPayAmount().subtract(item.getAllocatedAmount())).reduce(BigDecimal.ZERO, BigDecimal::add);
                    }
                    BigDecimal accountMaxPayAmount = accountDto.getDisposable();
                    log.info("\u8d26\u6237{},\u8d26\u6237\u5360\u6bd4{},\u6700\u5927\u4f7f\u7528\u989d\u5ea6\uff1a{}", new Object[]{accountDto.getAccountType(), proportional, accountMaxPayAmount});
                    if (amount.compareTo(accountMaxPayAmount) > 0) {
                        amount = accountMaxPayAmount;
                    }
                }
                if (null == order.getPerformOrderSnapshotDto().getPayCalculateMode() || order.getPerformOrderSnapshotDto().getPayCalculateMode() == 1) {
                    amount = amount.multiply(proportional);
                }
                if (amount.compareTo(accountDto.getDisposable()) > 0) {
                    amount = accountDto.getDisposable();
                }
                amount = amount.setScale(2, 4);
                log.info("\u8d26\u6237{},\u5269\u4f59\u989d\u5ea6\uff1a{},\u8d26\u6237\u5360\u6bd4\uff1a{},\u6700\u5927\u4f7f\u7528\u989d\u5ea6\uff1a{},\u9002\u914d\u5546\u54c1\u4fe1\u606f\uff1a{}", new Object[]{accountDto.getAccountType(), accountDto.getDisposable(), proportional, amount, JSON.toJSONString((Object)accountDto.getItems())});
                accountPayMaxMap.put(accountDto.getAccountType(), amount);
            }
        }
        log.info("[\u8d26\u6237\u6bd4\u4f8b\u914d\u7f6e]\u8ba2\u5355={},\u5ba2\u6237={},\u8d26\u6237\u6700\u5927\u989d\u5ea6={}", new Object[]{order.getSaleOrderNo(), customerCode, JSONObject.toJSON(accountPayMaxMap)});
        return accountPayMaxMap;
    }
}

