/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.JacksonUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.NoticeResultSyncStatusEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgPerformNoticeSyncRecordConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryDetailResultExtDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformNoticeSyncRecordEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordItemService;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordShippingService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgPerformNoticeSyncRecordServiceImpl
extends BaseServiceImpl<DgPerformNoticeSyncRecordDto, DgPerformNoticeSyncRecordEo, IDgPerformNoticeSyncRecordDomain>
implements IDgPerformNoticeSyncRecordService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgPerformNoticeSyncRecordServiceImpl.class);
    @Resource
    private IDgPerformNoticeSyncRecordItemService dgPerformNoticeSyncRecordItemService;
    @Resource
    private IDgPerformNoticeSyncRecordShippingService dgPerformNoticeSyncRecordShippingService;

    public DgPerformNoticeSyncRecordServiceImpl(IDgPerformNoticeSyncRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPerformNoticeSyncRecordDto, DgPerformNoticeSyncRecordEo> converter() {
        return DgPerformNoticeSyncRecordConverter.INSTANCE;
    }

    @Override
    public void saveExternalNoticeRecord(DgBizPerformNoticeSyncRecordDto req) {
        DgPerformNoticeSyncRecordEo dgPerformNoticeSyncRecordEo = (DgPerformNoticeSyncRecordEo)this.converter().toEo((BaseDto)req);
        ((IDgPerformNoticeSyncRecordDomain)this.domain).insert((BaseEo)dgPerformNoticeSyncRecordEo);
        if (CollectionUtil.isNotEmpty((Collection)req.getDgPerformNoticeSyncRecordDtoItems())) {
            req.getDgPerformNoticeSyncRecordDtoItems().forEach(e -> e.setRecordId(dgPerformNoticeSyncRecordEo.getId()));
        }
        Optional.ofNullable(req).map(DgBizPerformNoticeSyncRecordDto::getDgPerformNoticeSyncRecordDtoItems).ifPresent(items -> items.forEach(e -> e.setRecordId(dgPerformNoticeSyncRecordEo.getId())));
        this.dgPerformNoticeSyncRecordItemService.saveExternalNoticeRecordItems(req.getDgPerformNoticeSyncRecordDtoItems());
        Optional.ofNullable(req).map(DgBizPerformNoticeSyncRecordDto::getDgPerformNoticeSyncRecordShippingDtos).ifPresent(shipping -> shipping.forEach(e -> e.setRecordId(dgPerformNoticeSyncRecordEo.getId())));
        this.dgPerformNoticeSyncRecordShippingService.saveExternalNoticeRecordShipping(req.getDgPerformNoticeSyncRecordShippingDtos());
    }

    @Override
    public void saveExternalNoticeRecordByDeliveryResult(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto req) {
        DgBizPerformNoticeSyncRecordDto noticeSyncRecordDto = new DgBizPerformNoticeSyncRecordDto();
        noticeSyncRecordDto.setResultNoticeOrderNo(req.getOrderNo());
        noticeSyncRecordDto.setResultNoticeOrderNo(req.getOutNoticeOrderNo());
        noticeSyncRecordDto.setBusinessId(respDto.getId());
        noticeSyncRecordDto.setBusinessNo(respDto.getSaleOrderNo());
        noticeSyncRecordDto.setBusinessType(Integer.valueOf(1));
        noticeSyncRecordDto.setNoticeResultJson(JSON.toJSONString((Object)req));
        noticeSyncRecordDto.setShippingCompany(req.getShipmentEnterpriseCode());
        noticeSyncRecordDto.setShippingCompanyPhone(req.getShipmentEnterpriseName());
        noticeSyncRecordDto.setTotalCartons(req.getTotalCartons());
        noticeSyncRecordDto.setTotalQuantity(req.getTotalQuantity());
        List dgPerformNoticeSyncRecordDtoItems = req.getDeliveryDetailList().stream().map(item -> {
            DgPerformNoticeSyncRecordItemDto recordItemDto = new DgPerformNoticeSyncRecordItemDto();
            recordItemDto.setOrderItemId(item.getTradeOrderItemId());
            recordItemDto.setSkuCode(item.getLongCode());
            recordItemDto.setBatch(item.getBatch());
            recordItemDto.setQuantity(item.getOutQuantity());
            return recordItemDto;
        }).collect(Collectors.toList());
        List dgPerformNoticeSyncRecordShippingDtos = req.getShippingInfoList().stream().map(shippingInfo -> {
            DgPerformNoticeSyncRecordShippingDto shippingDto = new DgPerformNoticeSyncRecordShippingDto();
            shippingDto.setNoticeOrderNo(shippingInfo.getOutNoticeOrderNo());
            shippingDto.setDeliveryTime(shippingInfo.getDeliveryTime());
            shippingDto.setShippingType(shippingInfo.getShippingType());
            shippingDto.setShippingCompany(shippingInfo.getShippingCompanyCode());
            shippingDto.setShippingCompanyPhone(shippingInfo.getShippingCompanyName());
            shippingDto.setConsignmentNo(shippingInfo.getConsignNo());
            return shippingDto;
        }).collect(Collectors.toList());
        noticeSyncRecordDto.setDgPerformNoticeSyncRecordDtoItems(dgPerformNoticeSyncRecordDtoItems);
        noticeSyncRecordDto.setDgPerformNoticeSyncRecordShippingDtos(dgPerformNoticeSyncRecordShippingDtos);
        this.saveExternalNoticeRecord(noticeSyncRecordDto);
    }

    @Override
    public DgBizPerformNoticeSyncRecordDto queryByResultNoticeOrderNo(String resultNoticeOrderNo, Integer business) {
        DgPerformNoticeSyncRecordEo noticeSyncRecordEo = new DgPerformNoticeSyncRecordEo();
        noticeSyncRecordEo.setResultNoticeOrderNo(resultNoticeOrderNo);
        noticeSyncRecordEo.setBusinessType(business);
        DgPerformNoticeSyncRecordEo dgPerformNoticeSyncRecordEo = (DgPerformNoticeSyncRecordEo)((IDgPerformNoticeSyncRecordDomain)this.domain).selectOne((BaseEo)noticeSyncRecordEo);
        DgBizPerformNoticeSyncRecordDto dgBizPerformNoticeSyncRecordDto = null;
        if (dgPerformNoticeSyncRecordEo != null) {
            dgBizPerformNoticeSyncRecordDto = new DgBizPerformNoticeSyncRecordDto();
            BeanUtil.copyProperties((Object)dgPerformNoticeSyncRecordEo, (Object)dgBizPerformNoticeSyncRecordDto, (String[])new String[0]);
            List<DgPerformNoticeSyncRecordItemDto> dgPerformNoticeSyncRecordItemDtos = this.dgPerformNoticeSyncRecordItemService.queryByRecordId(dgPerformNoticeSyncRecordEo.getId());
            dgBizPerformNoticeSyncRecordDto.setDgPerformNoticeSyncRecordDtoItems(dgPerformNoticeSyncRecordItemDtos);
            List<DgPerformNoticeSyncRecordShippingDto> dgPerformNoticeSyncRecordShippingDtos = this.dgPerformNoticeSyncRecordShippingService.queryByRecordId(dgPerformNoticeSyncRecordEo.getId());
            dgBizPerformNoticeSyncRecordDto.setDgPerformNoticeSyncRecordShippingDtos(dgPerformNoticeSyncRecordShippingDtos);
        }
        return dgBizPerformNoticeSyncRecordDto;
    }

    @Override
    public void cancelById(Long id, String cancelReason) {
        DgPerformNoticeSyncRecordEo updateEo = new DgPerformNoticeSyncRecordEo();
        updateEo.setId(id);
        updateEo.setCancelReason(cancelReason);
        updateEo.setNoticeResultSyncStatus(NoticeResultSyncStatusEnum.CANCEL.getCode());
        int row = ((IDgPerformNoticeSyncRecordDomain)this.domain).updateSelective((BaseEo)updateEo);
        AssertUtils.isTrue((row == 1 ? 1 : 0) != 0, (String)"\u53d6\u6d88\u7ed3\u679c\u5355\u5931\u8d25");
        this.dgPerformNoticeSyncRecordShippingService.cancelByRecordId(id);
    }

    @Override
    public List<DgBizPerformNoticeSyncRecordDto> queryByOrderId(Long orderId) {
        DgPerformNoticeSyncRecordEo noticeSyncRecordEo = new DgPerformNoticeSyncRecordEo();
        noticeSyncRecordEo.setBusinessId(orderId);
        List dgPerformNoticeSyncRecordEos = ((IDgPerformNoticeSyncRecordDomain)this.domain).selectList((BaseEo)noticeSyncRecordEo);
        if (CollectionUtil.isEmpty((Collection)dgPerformNoticeSyncRecordEos)) {
            return Lists.newArrayList();
        }
        List dgBizPerformNoticeSyncRecordDtos = BeanUtil.copyToList((Collection)dgPerformNoticeSyncRecordEos, DgBizPerformNoticeSyncRecordDto.class);
        for (DgBizPerformNoticeSyncRecordDto dgBizPerformNoticeSyncRecordDto : dgBizPerformNoticeSyncRecordDtos) {
            List<DgPerformNoticeSyncRecordItemDto> dgPerformNoticeSyncRecordItemDtos = this.dgPerformNoticeSyncRecordItemService.queryByRecordId(dgBizPerformNoticeSyncRecordDto.getId());
            dgBizPerformNoticeSyncRecordDto.setDgPerformNoticeSyncRecordDtoItems(dgPerformNoticeSyncRecordItemDtos);
            List<DgPerformNoticeSyncRecordShippingDto> dgPerformNoticeSyncRecordShippingDtos = this.dgPerformNoticeSyncRecordShippingService.queryByRecordId(dgBizPerformNoticeSyncRecordDto.getId());
            dgBizPerformNoticeSyncRecordDto.setDgPerformNoticeSyncRecordShippingDtos(dgPerformNoticeSyncRecordShippingDtos);
        }
        return dgBizPerformNoticeSyncRecordDtos;
    }

    @Override
    public List<DgBizPerformNoticeSyncRecordDto> queryList(DgPerformNoticeSyncRecordDto dto) {
        LOGGER.info("\u51fa\u5165\u5e93\u7ed3\u679c\u540c\u6b65\u8bb0\u5f55\u5217\u8868\u67e5\u8be2\uff1a{}", (Object)JacksonUtil.toJson((Object)dto));
        if (ObjectUtil.isEmpty((Object)dto.getBusinessId()) && StringUtils.isBlank((CharSequence)dto.getBusinessNo())) {
            return Lists.newArrayList();
        }
        DgPerformNoticeSyncRecordEo queryEo = new DgPerformNoticeSyncRecordEo();
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)dto, (String[])new String[0]);
        List dgPerformNoticeSyncRecordEos = ((IDgPerformNoticeSyncRecordDomain)this.domain).selectList((BaseEo)queryEo, Integer.valueOf(1), Integer.valueOf(99));
        ArrayList<DgBizPerformNoticeSyncRecordDto> list = new ArrayList<DgBizPerformNoticeSyncRecordDto>();
        if (CollectionUtil.isNotEmpty((Collection)dgPerformNoticeSyncRecordEos)) {
            CubeBeanUtils.copyCollection(list, (Collection)dgPerformNoticeSyncRecordEos, DgBizPerformNoticeSyncRecordDto.class);
        }
        return list;
    }

    @Override
    public void saleOutSyncRecord(DgPerformOrderRespDto performOrder, DgOutDeliveryResultReqDto deliveryResultReqDto) {
        ((IDgPerformNoticeSyncRecordDomain)this.domain).saleOutSyncRecord(performOrder, deliveryResultReqDto);
    }

    @Override
    public DgOutDeliveryResultReqDto queryOutDeliveryResult(Long orderId) {
        Long id;
        List<DgPerformNoticeSyncRecordItemDto> dgPerformNoticeSyncRecordItemDtoList;
        List<DgPerformNoticeSyncRecordShippingDto> recordShippingDtoList;
        LOGGER.info("\u83b7\u53d6\u51fa\u5165\u5e93\u7ed3\u679c\u540c\u6b65\u8bb0\u5f55\u8f6c\u5316\u4e3a\u53d1\u8d27\u7ed3\u679c\uff1a{}", (Object)orderId);
        DgOutDeliveryResultReqDto reqDto = new DgOutDeliveryResultReqDto();
        List syncRecordEoList = ((ExtQueryChainWrapper)((IDgPerformNoticeSyncRecordDomain)this.domain).filter().eq((Object)"business_id", (Object)orderId)).list();
        if (CollectionUtil.isNotEmpty((Collection)syncRecordEoList)) {
            DgPerformNoticeSyncRecordEo recordEo = (DgPerformNoticeSyncRecordEo)syncRecordEoList.get(0);
            reqDto.setOutResultOrderNo(recordEo.getResultNoticeOrderNo());
            reqDto.setOutNoticeOrderNo(recordEo.getNoticeOrderNo());
            reqDto.setDeliveryTime(null);
            reqDto.setOrderNo(recordEo.getBusinessNo());
            reqDto.setPhoneNum(null);
            reqDto.setShipmentEnterpriseName(null);
            reqDto.setShippingNo(null);
            reqDto.setTotalQuantity(null);
        }
        if (CollectionUtil.isNotEmpty(recordShippingDtoList = this.dgPerformNoticeSyncRecordShippingService.queryByOrderId(orderId))) {
            DgPerformNoticeSyncRecordShippingDto recordShippingDto = recordShippingDtoList.get(0);
            reqDto.setShippingNo(recordShippingDto.getConsignmentNo());
            reqDto.setShippingCompanyCode(recordShippingDto.getShippingCompanyCode());
            reqDto.setShippingCompanyName(recordShippingDto.getShippingCompany());
            reqDto.setDeliveryTime(recordShippingDto.getDeliveryTime());
            List shippingInfoList = recordShippingDtoList.stream().map(shipping -> {
                DgWmsShippingInfoReqDto wmsShippingInfo = new DgWmsShippingInfoReqDto();
                wmsShippingInfo.setDeliveryTime(shipping.getDeliveryTime());
                wmsShippingInfo.setShippingCompanyCode(shipping.getShippingCompanyCode());
                wmsShippingInfo.setShippingCompanyName(shipping.getShippingCompany());
                wmsShippingInfo.setShippingNo(shipping.getConsignmentNo());
                return wmsShippingInfo;
            }).collect(Collectors.toList());
            reqDto.setShippingInfoList(shippingInfoList);
        }
        if (CollectionUtil.isNotEmpty((Collection)syncRecordEoList) && CollectionUtil.isNotEmpty(dgPerformNoticeSyncRecordItemDtoList = this.dgPerformNoticeSyncRecordItemService.queryByRecordId(id = ((DgPerformNoticeSyncRecordEo)syncRecordEoList.get(0)).getId()))) {
            List deliveryDetailList = dgPerformNoticeSyncRecordItemDtoList.stream().map(item -> {
                DgOutDeliveryDetailResultExtDto detailResultExtDto = new DgOutDeliveryDetailResultExtDto();
                detailResultExtDto.setBatch(item.getBatch());
                detailResultExtDto.setLongCode(item.getSkuCode());
                detailResultExtDto.setOrderNo(((DgPerformNoticeSyncRecordEo)syncRecordEoList.get(0)).getBusinessNo());
                detailResultExtDto.setOutQuantity(item.getQuantity());
                detailResultExtDto.setRatio(null);
                detailResultExtDto.setTradeOrderItemId(item.getOrderItemId());
                return detailResultExtDto;
            }).collect(Collectors.toList());
            reqDto.setDeliveryDetailList(deliveryDetailList);
        }
        LOGGER.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        return reqDto;
    }
}

