/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.customer.dto.response.DgCsShipmentEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgCsShipmentEnterpriseQueryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.deppon.DepponReqDto;
import com.yunxi.dg.base.center.openapi.dto.deppon.DepponRespDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.VerificationDeliveryAccessReqDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.VerificationDeliveryAccessRespDto;
import com.yunxi.dg.base.center.openapi.proxy.deppon.IDepponApiProxy;
import com.yunxi.dg.base.center.openapi.proxy.kuaidi100.IKuaidi100ApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderCommonHandleAction;
import com.yunxi.dg.base.center.trade.convert.entity.DgPerformOrderWarehouseInfoConverter;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.DeliveryAddressCheckEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderWarehouseInfoService;
import com.yunxi.dg.base.center.trade.service.oms.common.IOrderCommonHandleService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderWarehouseInfoServiceImpl
extends BaseServiceImpl<DgPerformOrderWarehouseInfoDto, DgPerformOrderWarehouseInfoEo, IDgPerformOrderWarehouseInfoDomain>
implements IDgPerformOrderWarehouseInfoService {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderWarehouseInfoServiceImpl.class);
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IKuaidi100ApiProxy kuaidi100ApiProxy;
    @Resource
    private IDepponApiProxy depponApiProxy;
    @Resource
    private IOrderCommonHandleAction orderCommonHandleAction;
    @Resource
    private IOrderCommonHandleService orderCommonHandleService;
    @Resource
    private IDgCsShipmentEnterpriseQueryApiProxy dgCsShipmentEnterpriseQueryApiProxy;
    @Value(value="${yunxi.dg.base.logistics.code:76.0069}")
    private String depponLogisticsCode;
    @Value(value="${yunxi.dg.base.logistics.flag:false}")
    private boolean isDeppon;

    public DgPerformOrderWarehouseInfoServiceImpl(IDgPerformOrderWarehouseInfoDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPerformOrderWarehouseInfoDto, DgPerformOrderWarehouseInfoEo> converter() {
        return DgPerformOrderWarehouseInfoConverter.INSTANCE;
    }

    @Override
    public void removeShipmentEnterpriseInfo(Long orderId) {
        ((IDgPerformOrderWarehouseInfoDomain)this.domain).removeShipmentEnterpriseInfo(orderId);
    }

    @Override
    public void removeB2bPlanShipmentEnterpriseInfo(Long orderId) {
        ((IDgPerformOrderWarehouseInfoDomain)this.domain).removeB2bPlanShipmentEnterpriseInfo(orderId);
    }

    @Override
    public DepponRespDto verfiyDepponDeliveryAccess(Long id, VerificationDeliveryAccessReqDto reqDto, String type) {
        log.info("\u6821\u9a8c\u5fb7\u90a6\u53ef\u8fbe\u6027\u53c2\u6570+" + type + "+\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        DepponRespDto respDto = new DepponRespDto();
        String kuaidicom = reqDto.getKuaidicom();
        if (null == kuaidicom) {
            log.info("\u7269\u6d41\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u6821\u9a8c");
            respDto.setReachable("1");
            respDto.setReason("\u7269\u6d41\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u6821\u9a8c");
            respDto.setExpressCode(kuaidicom);
            return respDto;
        }
        DgCsShipmentEnterpriseRespDto dgCsShipmentEnterpriseRespDto = (DgCsShipmentEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.dgCsShipmentEnterpriseQueryApiProxy.getDataByCode(kuaidicom));
        if (null != dgCsShipmentEnterpriseRespDto && "no".equals(dgCsShipmentEnterpriseRespDto.getVerificationDeliveryAddress())) {
            log.info("\u5feb\u9012\u672a\u5f00\u59cb\u6821\u9a8c");
            respDto.setReachable("1");
            respDto.setReason("\u5feb\u9012\u672a\u5f00\u59cb\u6821\u9a8c");
            respDto.setExpressCode(kuaidicom);
            if (null != id && reqDto.getAction().booleanValue()) {
                this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(DeliveryAddressCheckEnum.UNVERIFIED.getCode());
                dgPerformOrderWarehouseInfoDto.setUnreachableCause("\u5feb\u9012\u672a\u5f00\u59cb\u6821\u9a8c");
                dgPerformOrderWarehouseInfoDto.setWhetherToFlow("yes");
                CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
            }
        }
        log.info("depponLogisticsCode:{}", (Object)this.depponLogisticsCode);
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getKuaidicom()) && this.depponLogisticsCode.equals(kuaidicom) && 1 == dgCsShipmentEnterpriseRespDto.getType()) {
            respDto = this.orderCommonHandleService.getWaybillScreening(id, kuaidicom);
            String reason = respDto.getReason();
            String reachable = respDto.getReachable();
            log.info("\u5fb7\u90a6\u6821\u9a8c\u7269\u6d41\u53ef\u8fbe\u6027\u8fd4\u56de\u7ed3\u679c\uff1a{},{}", (Object)id, (Object)JSONObject.toJSONString((Object)respDto));
            if ("0".equals(reachable)) {
                if (null != id) {
                    log.info("\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c\uff0c\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u4e0d\u6d41\u8f6c");
                    this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u4e0d\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                    DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                    DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                    dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(reachable.equals("0") ? DeliveryAddressCheckEnum.UNREACHABLE.getCode() : DeliveryAddressCheckEnum.REACHABLE.getCode());
                    dgPerformOrderWarehouseInfoDto.setUnreachableCause(reason);
                    dgPerformOrderWarehouseInfoDto.setWhetherToFlow("no");
                    CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                    this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
                }
            } else if ("true".equals(respDto.getResult())) {
                this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(reachable.equals("0") ? DeliveryAddressCheckEnum.UNREACHABLE.getCode() : DeliveryAddressCheckEnum.REACHABLE.getCode());
                dgPerformOrderWarehouseInfoDto.setUnreachableCause(reason);
                dgPerformOrderWarehouseInfoDto.setWhetherToFlow("yes");
                CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
            } else {
                log.info("\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c\uff0c\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u4e0d\u6d41\u8f6c");
                this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u4e0d\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(reachable.equals("0") ? DeliveryAddressCheckEnum.UNREACHABLE.getCode() : DeliveryAddressCheckEnum.REACHABLE.getCode());
                dgPerformOrderWarehouseInfoDto.setUnreachableCause(reason);
                dgPerformOrderWarehouseInfoDto.setWhetherToFlow("no");
                CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
            }
        } else {
            VerificationDeliveryAccessRespDto verificationDeliveryAccessRespDto = this.verificationDeliveryAccessRespDto(reqDto);
            String reason = verificationDeliveryAccessRespDto.getReason();
            String reachable = verificationDeliveryAccessRespDto.getReachable();
            if (reachable.equals("0")) {
                if (null != id && reqDto.getAction().booleanValue()) {
                    log.info("\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c\uff0c\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u4e0d\u6d41\u8f6c");
                    this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u4e0d\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                    DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                    DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                    dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(reachable.equals("0") ? DeliveryAddressCheckEnum.UNREACHABLE.getCode() : DeliveryAddressCheckEnum.REACHABLE.getCode());
                    dgPerformOrderWarehouseInfoDto.setUnreachableCause(reason);
                    dgPerformOrderWarehouseInfoDto.setWhetherToFlow("no");
                    CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                    this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
                }
            } else if (null != id && reqDto.getAction().booleanValue()) {
                this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(reachable.equals("0") ? DeliveryAddressCheckEnum.UNREACHABLE.getCode() : DeliveryAddressCheckEnum.REACHABLE.getCode());
                dgPerformOrderWarehouseInfoDto.setUnreachableCause(reason);
                dgPerformOrderWarehouseInfoDto.setWhetherToFlow("yes");
                CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
            }
            respDto.setReason(reason);
            respDto.setResult(verificationDeliveryAccessRespDto.getReason());
            respDto.setExpressCode(verificationDeliveryAccessRespDto.getExpressCode());
            respDto.setReachable(reachable);
        }
        return respDto;
    }

    @Override
    public VerificationDeliveryAccessRespDto verifyDeliveryAccessibility(Long id, VerificationDeliveryAccessReqDto reqDto, String type) {
        log.info("\u6821\u9a8c\u53ef\u8fbe\u6027\u53c2\u6570+" + type + "+\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        VerificationDeliveryAccessRespDto verificationDeliveryAccessRespDto = new VerificationDeliveryAccessRespDto();
        reqDto = this.packetParam(id, reqDto, type);
        String kuaidicom = reqDto.getKuaidicom();
        log.info("kuaidicom:{}", (Object)kuaidicom);
        if (null == kuaidicom) {
            log.info("\u7269\u6d41\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u6821\u9a8c");
            verificationDeliveryAccessRespDto.setReachable("1");
            verificationDeliveryAccessRespDto.setReason("\u7269\u6d41\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u6821\u9a8c");
            verificationDeliveryAccessRespDto.setExpressCode(kuaidicom);
            return verificationDeliveryAccessRespDto;
        }
        DgCsShipmentEnterpriseRespDto dgCsShipmentEnterpriseRespDto = (DgCsShipmentEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.dgCsShipmentEnterpriseQueryApiProxy.getDataByCode(kuaidicom));
        log.info("dgCsShipmentEnterpriseRespDto:{}", (Object)JSONObject.toJSONString((Object)dgCsShipmentEnterpriseRespDto));
        if (null != dgCsShipmentEnterpriseRespDto && "no".equals(dgCsShipmentEnterpriseRespDto.getVerificationDeliveryAddress())) {
            log.info("\u5feb\u9012\u672a\u5f00\u59cb\u6821\u9a8c");
            verificationDeliveryAccessRespDto.setReachable("1");
            verificationDeliveryAccessRespDto.setReason("\u5feb\u9012\u672a\u5f00\u59cb\u6821\u9a8c");
            verificationDeliveryAccessRespDto.setExpressCode(kuaidicom);
            if (null != id && reqDto.getAction().booleanValue()) {
                this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(DeliveryAddressCheckEnum.UNVERIFIED.getCode());
                dgPerformOrderWarehouseInfoDto.setUnreachableCause("\u5feb\u9012\u672a\u5f00\u59cb\u6821\u9a8c");
                dgPerformOrderWarehouseInfoDto.setWhetherToFlow("yes");
                CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
            }
            return verificationDeliveryAccessRespDto;
        }
        log.info("\u6821\u9a8c\u5fb7\u90a6\u7269\u6d41\u53ef\u8fbe\u6027\uff1a{},{},{}", new Object[]{id, reqDto.getAction(), reqDto.getKuaidicom()});
        if (this.isDeppon && StringUtils.isNotEmpty((CharSequence)reqDto.getKuaidicom()) && this.depponLogisticsCode.equals(kuaidicom) && 1 == dgCsShipmentEnterpriseRespDto.getType()) {
            if (null != id) {
                DepponRespDto respDto = this.orderCommonHandleService.getWaybillScreening(id, kuaidicom);
                log.info("\u5fb7\u90a6\u6821\u9a8c\u7269\u6d41\u53ef\u8fbe\u6027\u8fd4\u56de\u7ed3\u679c\uff1a{},{}", (Object)id, (Object)JSONObject.toJSONString((Object)respDto));
                String reason = respDto.getReason();
                String reachable = respDto.getReachable();
                if ("0".equals(reachable)) {
                    if (null != id) {
                        log.info("\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c\uff0c\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u4e0d\u6d41\u8f6c");
                        this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u4e0d\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                        DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                        DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                        dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(reachable.equals("0") ? DeliveryAddressCheckEnum.UNREACHABLE.getCode() : DeliveryAddressCheckEnum.REACHABLE.getCode());
                        dgPerformOrderWarehouseInfoDto.setUnreachableCause(reason);
                        dgPerformOrderWarehouseInfoDto.setWhetherToFlow("no");
                        CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                        this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
                    }
                } else if ("true".equals(respDto.getResult())) {
                    this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                    DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                    DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                    dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(reachable.equals("0") ? DeliveryAddressCheckEnum.UNREACHABLE.getCode() : DeliveryAddressCheckEnum.REACHABLE.getCode());
                    dgPerformOrderWarehouseInfoDto.setUnreachableCause(reason);
                    dgPerformOrderWarehouseInfoDto.setWhetherToFlow("yes");
                    CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                    this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
                } else {
                    log.info("\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c\uff0c\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u4e0d\u6d41\u8f6c");
                    this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u4e0d\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                    DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                    DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                    dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(reachable.equals("0") ? DeliveryAddressCheckEnum.UNREACHABLE.getCode() : DeliveryAddressCheckEnum.REACHABLE.getCode());
                    dgPerformOrderWarehouseInfoDto.setUnreachableCause(reason);
                    dgPerformOrderWarehouseInfoDto.setWhetherToFlow("no");
                    CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                    this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
                }
                verificationDeliveryAccessRespDto.setExpressCode(kuaidicom);
                verificationDeliveryAccessRespDto.setReason(reason);
                verificationDeliveryAccessRespDto.setReachable(reachable);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)reqDto.getKuaidicom()) && StringUtils.isNotEmpty((CharSequence)reqDto.getRecManPrintAddr())) {
            verificationDeliveryAccessRespDto = this.verificationDeliveryAccessRespDto(reqDto);
            String reason = verificationDeliveryAccessRespDto.getReason();
            String reachable = verificationDeliveryAccessRespDto.getReachable();
            if (reachable.equals("0")) {
                if (null != id && reqDto.getAction().booleanValue()) {
                    log.info("\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c\uff0c\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u4e0d\u6d41\u8f6c");
                    this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u4e0d\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                    DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                    DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                    dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(reachable.equals("0") ? DeliveryAddressCheckEnum.UNREACHABLE.getCode() : DeliveryAddressCheckEnum.REACHABLE.getCode());
                    dgPerformOrderWarehouseInfoDto.setUnreachableCause(reason);
                    dgPerformOrderWarehouseInfoDto.setWhetherToFlow("no");
                    CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                    this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
                }
            } else if (null != id && reqDto.getAction().booleanValue()) {
                this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
                DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
                DgPerformOrderWarehouseInfoDto dgPerformOrderWarehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
                dgPerformOrderWarehouseInfoDto.setDeliveryAddressCheck(reachable.equals("0") ? DeliveryAddressCheckEnum.UNREACHABLE.getCode() : DeliveryAddressCheckEnum.REACHABLE.getCode());
                dgPerformOrderWarehouseInfoDto.setUnreachableCause(reason);
                dgPerformOrderWarehouseInfoDto.setWhetherToFlow("yes");
                CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)dgPerformOrderWarehouseInfoDto, (String[])new String[0]);
                this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
            }
        }
        log.info("verificationDeliveryAccessRespDto:{}", (Object)JSONObject.toJSONString((Object)verificationDeliveryAccessRespDto));
        return verificationDeliveryAccessRespDto;
    }

    private VerificationDeliveryAccessReqDto packetParam(Long id, VerificationDeliveryAccessReqDto reqDto, String type) {
        DgPerformOrderAddrEo queryByOrderId;
        String shipmentEnterpriseCode = "";
        if (type.equals("1")) {
            DgPerformOrderWarehouseInfoDto warehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
            shipmentEnterpriseCode = warehouseInfoDto.getShipmentEnterpriseCode();
            reqDto.setKuaidicom(shipmentEnterpriseCode);
        }
        String newAddress = "";
        if (type.equals("0") && null != (queryByOrderId = (DgPerformOrderAddrEo)((ExtQueryChainWrapper)this.dgPerformOrderAddrDomain.filter().eq((Object)"order_id", (Object)id)).one())) {
            String receiveName = queryByOrderId.getReceiveName();
            reqDto.setRecManName(receiveName);
            String encryptReceivePhone = queryByOrderId.getEncryptReceivePhone();
            reqDto.setRecManMobile(encryptReceivePhone);
            String receiveAddress = queryByOrderId.getReceiveAddress();
            String province = queryByOrderId.getProvince();
            String city = queryByOrderId.getCity();
            String county = queryByOrderId.getCounty();
            newAddress = province + city + county + receiveAddress;
            reqDto.setRecManPrintAddr(newAddress);
        }
        if (type.equals("3")) {
            // empty if block
        }
        return reqDto;
    }

    @Override
    public void interceptStatus(Long id) {
        if (null != id) {
            DgPerformOrderWarehouseInfoDto warehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
            DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
            CubeBeanUtils.copyProperties((Object)dgPerformOrderWarehouseInfoEo, (Object)warehouseInfoDto, (String[])new String[0]);
            dgPerformOrderWarehouseInfoEo.setWhetherToFlow("yes");
            this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
            this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c->\u66f4\u6539\u4e3a\u6d41\u8f6c", "DELIVERY_INACCESSIBILITY");
        }
    }

    public VerificationDeliveryAccessRespDto verificationDeliveryAccessRespDto(VerificationDeliveryAccessReqDto verificationDeliveryAccessReqDto) {
        log.info("\u6821\u9a8c\u8bf7\u6c42\u53c2\u6570:{}", (Object)verificationDeliveryAccessReqDto);
        RestResponse verificationDeliveryAccessRespDtoRestResponse = this.kuaidi100ApiProxy.verifyDeliveryAccessibility(verificationDeliveryAccessReqDto);
        VerificationDeliveryAccessRespDto data = (VerificationDeliveryAccessRespDto)verificationDeliveryAccessRespDtoRestResponse.getData();
        log.info("\u6821\u9a8c\u54cd\u5e94\u7ed3\u679c:{}", (Object)data);
        return data;
    }

    @Override
    public VerificationDeliveryAccessRespDto verificationDepponDeliveryAccess(DgBizPerformOrderReqDto addReqDto, VerificationDeliveryAccessReqDto verificationDeliveryAccessReqDto, DgPerformOrderAddrReqDto orderAddrReqDto) {
        VerificationDeliveryAccessRespDto verificationDeliveryAccessRespDto = new VerificationDeliveryAccessRespDto();
        try {
            DgCsShipmentEnterpriseRespDto dgCsShipmentEnterpriseRespDto = (DgCsShipmentEnterpriseRespDto)RestResponseHelper.extractData((RestResponse)this.dgCsShipmentEnterpriseQueryApiProxy.getDataByCode(this.depponLogisticsCode));
            log.info("verificationDepponDeliveryAccess-dgCsShipmentEnterpriseRespDto:{}", (Object)JSONObject.toJSONString((Object)dgCsShipmentEnterpriseRespDto));
            if (null != dgCsShipmentEnterpriseRespDto && "no".equals(dgCsShipmentEnterpriseRespDto.getVerificationDeliveryAddress())) {
                log.info("\u5feb\u9012\u672a\u5f00\u59cb\u6821\u9a8c");
                verificationDeliveryAccessRespDto.setReachable("1");
                verificationDeliveryAccessRespDto.setReason("\u5feb\u9012\u672a\u5f00\u59cb\u6821\u9a8c");
                verificationDeliveryAccessRespDto.setExpressCode(addReqDto.getShipmentEnterpriseCode());
                return verificationDeliveryAccessRespDto;
            }
            DepponReqDto reqDto = new DepponReqDto();
            reqDto.setLogisticID(addReqDto.getSaleOrderNo());
            DepponReqDto.Sender sender = new DepponReqDto.Sender();
            sender.setName(dgCsShipmentEnterpriseRespDto.getContact());
            sender.setPhone(dgCsShipmentEnterpriseRespDto.getContactPhone());
            sender.setProvince(dgCsShipmentEnterpriseRespDto.getProvince());
            sender.setCity(dgCsShipmentEnterpriseRespDto.getCity());
            sender.setCounty(dgCsShipmentEnterpriseRespDto.getCounty());
            StringBuffer buffer = new StringBuffer();
            if (StringUtils.isNotBlank((CharSequence)dgCsShipmentEnterpriseRespDto.getProvince())) {
                buffer.append(dgCsShipmentEnterpriseRespDto.getProvince());
            }
            if (StringUtils.isNotBlank((CharSequence)dgCsShipmentEnterpriseRespDto.getCity())) {
                buffer.append(dgCsShipmentEnterpriseRespDto.getCity());
            }
            if (StringUtils.isNotBlank((CharSequence)dgCsShipmentEnterpriseRespDto.getCounty())) {
                buffer.append(dgCsShipmentEnterpriseRespDto.getCounty());
            }
            if (StringUtils.isNotBlank((CharSequence)dgCsShipmentEnterpriseRespDto.getContactAddress())) {
                buffer.append(dgCsShipmentEnterpriseRespDto.getContactAddress());
            }
            sender.setAddress(StringUtils.isBlank((CharSequence)buffer.toString()) ? null : buffer.toString());
            reqDto.setSender(sender);
            DepponReqDto.Receiver receiver = new DepponReqDto.Receiver();
            receiver.setName(orderAddrReqDto.getReceiveName());
            receiver.setPhone(orderAddrReqDto.getReceivePhone());
            receiver.setProvince(orderAddrReqDto.getProvince());
            receiver.setCity(orderAddrReqDto.getCity());
            receiver.setCounty(orderAddrReqDto.getCounty());
            receiver.setTown(orderAddrReqDto.getStreet());
            StringBuffer stringBuffer = new StringBuffer();
            if (StringUtils.isNotBlank((CharSequence)orderAddrReqDto.getProvince())) {
                stringBuffer.append(orderAddrReqDto.getProvince());
            }
            if (StringUtils.isNotBlank((CharSequence)orderAddrReqDto.getCity())) {
                stringBuffer.append(orderAddrReqDto.getCity());
            }
            if (StringUtils.isNotBlank((CharSequence)orderAddrReqDto.getCounty())) {
                stringBuffer.append(orderAddrReqDto.getCounty());
            }
            if (StringUtils.isNotBlank((CharSequence)orderAddrReqDto.getStreet())) {
                stringBuffer.append(orderAddrReqDto.getStreet());
            }
            if (StringUtils.isNotBlank((CharSequence)orderAddrReqDto.getReceiveAddress())) {
                stringBuffer.append(orderAddrReqDto.getReceiveAddress());
            }
            receiver.setAddress(StringUtils.isBlank((CharSequence)stringBuffer.toString()) ? null : stringBuffer.toString());
            reqDto.setReceiver(receiver);
            reqDto.setTransportType("PACKAGE");
            reqDto.setDeliveryType("3");
            log.info("\u8c03\u7528\u67e5\u8be2\u5feb\u9012\u7535\u5b50\u8fd0\u5355\u7b5b\u5355\u63a5\u53e3\u5165\u53c2\uff1a{},{}", (Object)addReqDto.getSaleOrderNo(), (Object)JSONObject.toJSONString((Object)reqDto));
            DepponRespDto respDto = (DepponRespDto)RestResponseHelper.extractData((RestResponse)this.depponApiProxy.getWaybillScreening(reqDto));
            log.info("\u8c03\u7528\u67e5\u8be2\u5feb\u9012\u7535\u5b50\u8fd0\u5355\u7b5b\u5355\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{},{}", (Object)addReqDto.getSaleOrderNo(), (Object)JSONObject.toJSONString((Object)respDto));
            verificationDeliveryAccessRespDto.setReachable("1");
            verificationDeliveryAccessRespDto.setExpressCode(addReqDto.getShipmentEnterpriseCode());
            verificationDeliveryAccessRespDto.setReason(respDto.getReason());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u67e5\u8be2\u5feb\u9012\u7535\u5b50\u8fd0\u5355\u7b5b\u5355\u63a5\u53e3\u5f02\u5e38(\u6821\u9a8c\u7269\u6d41\u53ef\u8fbe\u6027\u5f02\u5e38)\uff1a{},{}", (Object)addReqDto.getSaleOrderNo(), (Object)e);
            verificationDeliveryAccessRespDto.setReachable("0");
            verificationDeliveryAccessRespDto.setReason(e.getMessage());
            verificationDeliveryAccessRespDto.setExpressCode(addReqDto.getShipmentEnterpriseCode());
        }
        return verificationDeliveryAccessRespDto;
    }

    @Override
    public Boolean verifyDeliveryAccessibilityAction(Long id) {
        DgPerformOrderWarehouseInfoDto warehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(id);
        if (null != warehouseInfoDto && warehouseInfoDto.getWhetherToFlow().equals("no")) {
            DgPerformOrderRespDto dgPerformOrderRespDto = new DgPerformOrderRespDto();
            dgPerformOrderRespDto.setId(id);
            this.orderCommonHandleAction.modifyInterceptReason(dgPerformOrderRespDto, "\u8ba2\u5355\u5feb\u9012\u4e0d\u53ef\u8fbe\u62e6\u622a");
            this.orderCommonHandleService.modifyOptimizationLog(id, "\u5feb\u9012\u53ef\u8fbe\u6027\u6821\u9a8c", "\u5feb\u9012\u4e0d\u53ef\u8fbe\u62e6\u622a", "DELIVERY_INACCESSIBILITY");
            return false;
        }
        return true;
    }
}

