/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2b.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.enums.ItemLineReturnStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderReturnService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class B2BOrderReturnServiceImpl
implements IB2BOrderReturnService {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderReturnServiceImpl.class);
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain dgPerformOrderItemLineAmountDomain;

    @Override
    public void orderReturnSplitItemLine(List<DgPerformOrderLineDto> orderLineDtoList) {
        log.info("\u9500\u552e\u9000\u8d27\u62c6\u5206\u9500\u552e\u5546\u54c1\u884c\uff1a{}", (Object)JSON.toJSONString(orderLineDtoList));
        orderLineDtoList.forEach(orderLine -> {
            List itemLineEoList = this.dgPerformOrderItemLineDomain.queryItemLineByOrderLineId(orderLine.getId());
            itemLineEoList = itemLineEoList.stream().filter(f -> f.getReturnStatus() == 0 && f.getDeliveryStatus() == 1).collect(Collectors.toList());
            BigDecimal mayReturnNum = itemLineEoList.stream().map(DgPerformOrderItemLineEo::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            AssertUtils.isFalse((orderLine.getReturnNum().compareTo(mayReturnNum) > 0 ? 1 : 0) != 0, (String)"\u53ef\u9000\u6570\u91cf\u4e0d\u8db3");
            ArrayList<DgPerformOrderItemLineEo> upOrderItemLineList = new ArrayList<DgPerformOrderItemLineEo>();
            ArrayList<DgPerformOrderItemLineEo> addOrderItemLineList = new ArrayList<DgPerformOrderItemLineEo>();
            ArrayList<DgPerformOrderItemLineAmountEo> upOrderItemLineAmountList = new ArrayList<DgPerformOrderItemLineAmountEo>();
            ArrayList<DgPerformOrderItemLineAmountEo> addOrderItemLineAmountList = new ArrayList<DgPerformOrderItemLineAmountEo>();
            BigDecimal returnNum = orderLine.getReturnNum();
            for (DgPerformOrderItemLineEo item : itemLineEoList) {
                if (returnNum.compareTo(item.getCalcItemNum()) >= 0) {
                    DgPerformOrderItemLineEo lineEo = new DgPerformOrderItemLineEo();
                    lineEo.setId(item.getId());
                    lineEo.setReturnStatus(ItemLineReturnStatusEnum.YES.getType());
                    upOrderItemLineList.add(lineEo);
                    returnNum = returnNum.subtract(item.getCalcItemNum());
                    continue;
                }
                DgPerformOrderItemLineEo subItemEo = new DgPerformOrderItemLineEo();
                CubeBeanUtils.copyProperties((Object)subItemEo, (Object)item, (String[])new String[]{"id", "create_time", "create_person", "update_time", "update_person"});
                Long orderItemLineId = IdGenrator.getDistributedId();
                subItemEo.setId(orderItemLineId);
                subItemEo.setItemNum(item.getItemNum().multiply(returnNum.divide(item.getCalcItemNum(), 2, RoundingMode.HALF_UP)));
                subItemEo.setCalcItemNum(returnNum);
                subItemEo.setReturnStatus(ItemLineReturnStatusEnum.YES.getType());
                addOrderItemLineList.add(subItemEo);
                DgPerformOrderItemLineEo itemEo = new DgPerformOrderItemLineEo();
                itemEo.setId(item.getId());
                itemEo.setItemNum(item.getItemNum().subtract(subItemEo.getItemNum()));
                itemEo.setCalcItemNum(item.getCalcItemNum().subtract(subItemEo.getCalcItemNum()));
                upOrderItemLineList.add(itemEo);
                List dgPerformOrderItemLineAmountDtoList = this.dgPerformOrderItemLineAmountDomain.queryByOrderItemLineId(item.getId());
                for (DgPerformOrderItemLineAmountDto itemAmount : dgPerformOrderItemLineAmountDtoList) {
                    DgPerformOrderItemLineAmountEo subItemAmountEo = new DgPerformOrderItemLineAmountEo();
                    CubeBeanUtils.copyProperties((Object)subItemAmountEo, (Object)itemAmount, (String[])new String[]{"id", "amount", "create_time", "create_person", "update_time", "update_person"});
                    subItemAmountEo.setOrderItemLineId(orderItemLineId);
                    subItemAmountEo.setAmount(itemAmount.getAmount().multiply(returnNum.divide(item.getCalcItemNum(), 2, RoundingMode.HALF_UP)));
                    addOrderItemLineAmountList.add(subItemAmountEo);
                    DgPerformOrderItemLineAmountEo itemAmountEo = new DgPerformOrderItemLineAmountEo();
                    itemAmountEo.setId(itemAmount.getId());
                    itemAmountEo.setAmount(itemAmount.getAmount().subtract(subItemAmountEo.getAmount()));
                    upOrderItemLineAmountList.add(itemAmountEo);
                }
            }
            if (CollectionUtil.isNotEmpty(addOrderItemLineList)) {
                log.info("\u9500\u552e\u9000\u8d27\u62c6\u5206\u9500\u552e\u5546\u54c1\uff0caddOrderItemLineList\uff1a{}", (Object)JSON.toJSONString(addOrderItemLineList));
                this.dgPerformOrderItemLineDomain.insertBatch(addOrderItemLineList);
            }
            if (CollectionUtil.isNotEmpty(upOrderItemLineList)) {
                log.info("\u9500\u552e\u9000\u8d27\u62c6\u5206\u9500\u552e\u5546\u54c1\uff0cupOrderItemLineList\uff1a{}", (Object)JSON.toJSONString(upOrderItemLineList));
                upOrderItemLineList.forEach(upd -> this.dgPerformOrderItemLineDomain.updateSelective((BaseEo)upd));
            }
            if (CollectionUtil.isNotEmpty(addOrderItemLineAmountList)) {
                log.info("\u9500\u552e\u9000\u8d27\u62c6\u5206\u9500\u552e\u5546\u54c1\uff0caddOrderItemLineAmountList\uff1a{}", (Object)JSON.toJSONString(addOrderItemLineAmountList));
                this.dgPerformOrderItemLineAmountDomain.insertBatch(addOrderItemLineAmountList);
            }
            if (CollectionUtil.isNotEmpty(upOrderItemLineAmountList)) {
                log.info("\u9500\u552e\u9000\u8d27\u62c6\u5206\u9500\u552e\u5546\u54c1\uff0cupOrderItemLineAmountList\uff1a{}", (Object)JSON.toJSONString(upOrderItemLineAmountList));
                upOrderItemLineAmountList.forEach(upd -> this.dgPerformOrderItemLineAmountDomain.updateSelective((BaseEo)upd));
            }
        });
    }
}

