/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2b.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgOmsOrderLineStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryDetailResultExtDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderInfoOutNoticeSyncRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.ItemLineDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.service.oms.b2b.IB2BOrderWaitDeliverService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class B2BOrderWaitDeliverServiceImpl
implements IB2BOrderWaitDeliverService {
    private static final Logger log = LoggerFactory.getLogger(B2BOrderWaitDeliverServiceImpl.class);
    private static final String DEFAULT_BATCH_NO = "default_batch_no";
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderLineDomain performOrderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IDgPerformNoticeSyncRecordDomain performNoticeSyncRecordDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#respDto.getId()")
    public void modifyOrderByDeliveredResult(DgPerformOrderRespDto respDto, DgOutDeliveryResultReqDto reqDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        log.info("[\u51fa\u5e93\u56de\u4f20]\u4fee\u6539\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        DgPerformOrderRespDto performOrderInfoDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        AssertUtils.isTrue((boolean)respDto.getSaleOrderNo().equals(reqDto.getOrderNo()), (String)"\u56de\u4f20\u9500\u552e\u5355\u53f7\u4e0d\u4e00\u81f4");
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(respDto.getId());
        AssertUtils.notEmpty((Collection)orderLineDtos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        BigDecimal totalOutDeliveryCount = orderLineDtos.stream().filter(Objects::nonNull).map(item -> Optional.ofNullable(item.getOutItemNum()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.performNoticeSyncRecordDomain.saleOutSyncRecord(performOrderInfoDto, reqDto);
        if (reqDto.getTotalQuantity() != null) {
            this.modifyOrderItemOutDeliveredResult(orderLineDtos, reqDto);
            List performOrderItemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(respDto.getId());
            BigDecimal outGoodsNum = BigDecimal.ZERO;
            if (CollectionUtil.isNotEmpty((Collection)performOrderItemLineDtos) && CollectionUtil.isNotEmpty(performOrderItemLineDtos = performOrderItemLineDtos.stream().filter(item -> item.getDeliveryStatus().equals(ItemLineDeliveryStatusEnum.YES.getType())).collect(Collectors.toList()))) {
                outGoodsNum = performOrderItemLineDtos.stream().map(DgPerformOrderItemLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            log.info("\u5df2\u51fa\u5e93\u6570\u91cf\u4e3a\uff1a{}", (Object)outGoodsNum);
            if (outGoodsNum.compareTo(performOrderInfoDto.getGoodsTotalNum()) >= 0) {
                log.info("[\u51fa\u5e93\u56de\u4f20]\u5546\u54c1\u5df2\u5168\u90e8\u51fa\u5e93\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)performOrderInfoDto.getSaleOrderNo());
                DgPerformOrderInfoEo updateStatusEo = new DgPerformOrderInfoEo();
                if (reqDto.getDeliveryTime() != null) {
                    updateStatusEo.setDeliveryTime(reqDto.getDeliveryTime());
                    updateStatusEo.setDeliveryCompleteDate(reqDto.getDeliveryTime());
                } else {
                    updateStatusEo.setDeliveryCompleteDate(new Date());
                    updateStatusEo.setDeliveryTime(new Date());
                }
                updateStatusEo.setId(performOrderInfoDto.getId());
                this.performOrderInfoDomain.updateSaleOrderById(performOrderInfoDto.getId(), updateStatusEo);
            } else {
                log.info("[\u51fa\u5e93\u56de\u4f20]\u8ba2\u5355\u5546\u54c1\u5df2\u90e8\u5206\u51fa\u5e93\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)performOrderInfoDto.getSaleOrderNo());
            }
        } else {
            log.error("\u51fa\u5e93\u5f02\u5e38\uff0c\u7f3a\u5c11\u51fa\u5e93\u6570\u91cf");
        }
    }

    @Override
    @Deprecated
    public DgPerformOrderInfoOutNoticeSyncRecordRespDto saveOutNoticeRecord(DgPerformOrderRespDto saleOrderRespDto, DgOutDeliveryResultReqDto reqDto) {
        log.info("[\u51fa\u5e93\u56de\u4f20]\u4fdd\u5b58\u56de\u4f20\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)reqDto));
        return null;
    }

    private void modifyOrderItemOutDeliveredResult(List<DgPerformOrderLineDto> orderLineDtos, DgOutDeliveryResultReqDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getDeliveryDetailList(), (String)"\u51fa\u5e93\u5546\u54c1\u4e3a\u7a7a");
        log.info("[\u51fa\u5e93\u56de\u4f20]\u8ba2\u5355\u539f\u8ba2\u5355\u884c\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderLineDtos));
        List performOrderItemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(orderLineDtos.get(0).getOrderId());
        Map performOrderLineDtoMap = orderLineDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
        Map<Long, List<DgPerformOrderItemLineDto>> performOrderItemLineDtoMap = performOrderItemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        Map outDeliveryDetailResultDtoMap = reqDto.getDeliveryDetailList().stream().collect(Collectors.toMap(DgOutDeliveryDetailResultExtDto::getTradeOrderItemId, Function.identity(), (a, b) -> a));
        ArrayList upOrderLineList = new ArrayList();
        ArrayList upOrderItemLineList = new ArrayList();
        ArrayList addOrderItemLineList = new ArrayList();
        ArrayList upOrderItemLineAmountList = new ArrayList();
        ArrayList addOrderItemLineAmountList = new ArrayList();
        outDeliveryDetailResultDtoMap.forEach((id, outDto) -> {
            DgPerformOrderLineDto orderLineDto = (DgPerformOrderLineDto)performOrderLineDtoMap.get(id);
            if (null != orderLineDto && orderLineDto.getStatus().equals(DgOmsOrderLineStatusEnum.NORMAL.getCode()) && orderLineDto.getItemNum().subtract(orderLineDto.getOutItemNum()).compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal waitDeliveryNum = orderLineDto.getItemNum().subtract(orderLineDto.getOutItemNum());
                BigDecimal currentDeliveryNum = BigDecimal.ZERO;
                BigDecimal outDeliveryNum = outDto.getOutQuantity();
                log.info("\u5546\u54c1\u884c\u5f85\u51fa\u5e93\u6570\u91cf\uff1a{}=={}====>\u56de\u4f20\u6570\u91cf\uff1a{}", new Object[]{id, waitDeliveryNum, outDeliveryNum});
                List itemLineDtos = (List)performOrderItemLineDtoMap.get(id);
                if (CollectionUtil.isNotEmpty((Collection)itemLineDtos)) {
                    int i = 1;
                    for (DgPerformOrderItemLineDto item : itemLineDtos) {
                        if (item.getDeliveryStatus() != null && item.getDeliveryStatus().equals(ItemLineDeliveryStatusEnum.YES.getType())) {
                            log.info("\u5546\u54c1\u884c\u5df2\u7ecf\u53d1\u8d27\uff1a{}", (Object)item.getId());
                            continue;
                        }
                        if (outDeliveryNum.compareTo(item.getItemNum()) >= 0) {
                            item.setDeliveryStatus(ItemLineDeliveryStatusEnum.YES.getType());
                            DgPerformOrderItemLineEo itemEo = new DgPerformOrderItemLineEo();
                            itemEo.setId(item.getId());
                            itemEo.setDeliveryStatus(ItemLineDeliveryStatusEnum.YES.getType());
                            itemEo.setDeliverySortNo(outDto.getSortNo());
                            upOrderItemLineList.add(itemEo);
                            waitDeliveryNum = waitDeliveryNum.subtract(item.getItemNum());
                            outDeliveryNum = outDeliveryNum.subtract(item.getItemNum());
                            currentDeliveryNum = currentDeliveryNum.add(item.getItemNum());
                        } else {
                            DgPerformOrderItemLineEo subItemEo = new DgPerformOrderItemLineEo();
                            CubeBeanUtils.copyProperties((Object)subItemEo, (Object)item, (String[])new String[]{"id"});
                            Long orderItemLineId = IdGenrator.getDistributedId();
                            subItemEo.setId(orderItemLineId);
                            subItemEo.setItemNum(outDeliveryNum);
                            subItemEo.setCalcItemNum(item.getCalcItemNum().multiply(outDeliveryNum.divide(item.getItemNum(), 8, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP));
                            subItemEo.setDeliveryStatus(ItemLineDeliveryStatusEnum.YES.getType());
                            subItemEo.setDeliverySortNo(outDto.getSortNo());
                            addOrderItemLineList.add(subItemEo);
                            DgPerformOrderItemLineEo itemEo = new DgPerformOrderItemLineEo();
                            itemEo.setId(item.getId());
                            itemEo.setItemNum(item.getItemNum().subtract(subItemEo.getItemNum()));
                            itemEo.setCalcItemNum(item.getCalcItemNum().subtract(subItemEo.getCalcItemNum()));
                            itemEo.setDeliveryStatus(ItemLineDeliveryStatusEnum.NO.getType());
                            itemEo.setDeliverySortNo(outDto.getSortNo());
                            upOrderItemLineList.add(itemEo);
                            for (DgPerformOrderItemLineAmountDto itemAmount : item.getPerformOrderItemLineAmountDtoList()) {
                                DgPerformOrderItemLineAmountEo subItemAmountEo = new DgPerformOrderItemLineAmountEo();
                                CubeBeanUtils.copyProperties((Object)subItemAmountEo, (Object)itemAmount, (String[])new String[]{"id", "amount"});
                                subItemAmountEo.setOrderItemLineId(orderItemLineId);
                                subItemAmountEo.setAmount(itemAmount.getAmount().multiply(outDeliveryNum.divide(item.getItemNum(), 8, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP));
                                addOrderItemLineAmountList.add(subItemAmountEo);
                                DgPerformOrderItemLineAmountEo itemAmountEo = new DgPerformOrderItemLineAmountEo();
                                itemAmountEo.setId(itemAmount.getId());
                                itemAmountEo.setAmount(itemAmount.getAmount().subtract(subItemAmountEo.getAmount()));
                                upOrderItemLineAmountList.add(itemAmountEo);
                            }
                            currentDeliveryNum = currentDeliveryNum.add(outDeliveryNum);
                            waitDeliveryNum = waitDeliveryNum.subtract(outDeliveryNum);
                            outDeliveryNum = BigDecimal.ZERO;
                        }
                        if (waitDeliveryNum.compareTo(BigDecimal.ZERO) <= 0) {
                            log.info("\u5546\u54c1\u51fa\u5e93\u6570\u91cf\u5206\u914d\u5b8c\u6bd5\uff1a{} == >>{}", id, (Object)waitDeliveryNum);
                            break;
                        }
                        ++i;
                    }
                    log.info("\u8ba2\u5355\u884c\uff1a{}===>>>\u672c\u6b21\u51fa\u5e93\u6570\u91cf\uff1a{} ===>>>\u5269\u4f59\u5f85\u51fa\u5e93\u6570\u91cf\uff1a{}", new Object[]{id, currentDeliveryNum, waitDeliveryNum});
                    DgPerformOrderLineEo upOrderLineEo = new DgPerformOrderLineEo();
                    upOrderLineEo.setId(id);
                    upOrderLineEo.setOutItemNum(orderLineDto.getOutItemNum().add(currentDeliveryNum));
                    upOrderLineList.add(upOrderLineEo);
                } else {
                    log.info("\u8ba2\u5355\u884c{}\u5bf9\u5e94\u7684\u5546\u54c1\u884c\u4e0d\u5b58\u5728", id);
                }
            } else {
                log.info("\u51fa\u5e93\u56de\u4f20\u8ba2\u5355\u884c\u4e0d\u5b58\u5728\uff1a{}", id);
            }
        });
        if (CollectionUtil.isNotEmpty(upOrderLineList)) {
            log.info("\u53d1\u8d27\u56de\u8c03 -- \u66f4\u65b0\u8ba2\u5355\u884c");
            upOrderLineList.forEach(line -> this.performOrderLineDomain.updateSelective((BaseEo)line));
        }
        if (CollectionUtil.isNotEmpty(addOrderItemLineList)) {
            log.info("\u53d1\u8d27\u56de\u8c03 -- \u65b0\u589e\u5546\u54c1\u884c");
            this.performOrderItemLineDomain.insertBatch(addOrderItemLineList);
        }
        if (CollectionUtil.isNotEmpty(addOrderItemLineAmountList)) {
            log.info("\u53d1\u8d27\u56de\u8c03 -- \u65b0\u589e\u5546\u54c1\u91d1\u989d\u884c");
            this.performOrderItemLineAmountDomain.insertBatch(addOrderItemLineAmountList);
        }
        if (CollectionUtil.isNotEmpty(upOrderItemLineList)) {
            log.info("\u53d1\u8d27\u56de\u8c03 -- \u66f4\u65b0\u5546\u54c1\u884c");
            upOrderItemLineList.forEach(item -> this.performOrderItemLineDomain.updateSelective((BaseEo)item));
        }
        if (CollectionUtil.isNotEmpty(upOrderItemLineAmountList)) {
            log.info("\u53d1\u8d27\u56de\u8c03 -- \u66f4\u65b0\u5546\u54c1\u91d1\u989d\u884c");
            upOrderItemLineAmountList.forEach(amount -> this.performOrderItemLineAmountDomain.updateSelective((BaseEo)amount));
        }
    }

    @Override
    public void deliveryNoticeOrderFinish(DgPerformOrderRespDto respDto, String completeReason) {
        DgPerformOrderInfoEo updateReqDto = new DgPerformOrderInfoEo();
        updateReqDto.setId(respDto.getId());
        updateReqDto.setCompleteReason(completeReason);
        this.performOrderInfoDomain.updateSelective((BaseEo)updateReqDto);
    }
}

