/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.b2c.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedQueryApi;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryBasicsQueryReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryBasicsQueryRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.VerificationDeliveryAccessReqDto;
import com.yunxi.dg.base.center.openapi.dto.kuaidi100.VerificationDeliveryAccessRespDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.shop.proxy.query.IDgShopQueryApiProxy;
import com.yunxi.dg.base.center.source.dto.entity.DgClueWarehouseGroupRuleShipmentDto;
import com.yunxi.dg.base.center.source.dto.entity.DgOrderItemResultDto;
import com.yunxi.dg.base.center.source.dto.entity.DgSourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.action.oms.common.IOrderCommonHandleAction;
import com.yunxi.dg.base.center.trade.config.DgPerformOrderGlobalConfig;
import com.yunxi.dg.base.center.trade.constants.DgConsignTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.SourceRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgLogicWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderWarehouseInfoEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderWarehouseInfoService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderHandleService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderItemService;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgCommonLabelManageService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.service.proxy.IDgSourceApiService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgOmsOrderHandleServiceImpl
implements IDgOmsOrderHandleService {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderHandleServiceImpl.class);
    @Value(value="${oms.sale.order.phy.source.enable:true}")
    private Boolean phySourceEnable;
    @Value(value="${oms.sale.order.ship.logistics.relation.enable:false}")
    private Boolean shipLogisticsRelationEnable;
    @Resource
    private DgPerformOrderGlobalConfig performOrderGlobalConfig;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApi;
    @Resource
    private IDgSourceApiService sourceApiService;
    @Resource
    private IDgShopQueryApiProxy shopQueryApiProxy;
    @Resource
    private ILogicInventoryExposedQueryApi inventoryExposedQueryApi;
    @Resource
    IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgOmsOrderItemService omsOrderItemService;
    @Resource
    IDgCommonLabelManageService dgCommonLabelManageService;
    @Resource
    private IOrderCommonHandleAction orderCommonHandleAction;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain warehouseInfoDomain;
    @Resource
    private IDgPerformOrderAddrExtDomain performOrderAddrExtDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain orderSplitReleationDomain;
    @Resource
    private ISourceRecordDomain sourceRecordDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoService dgPerformOrderWarehouseInfoService;
    @Resource
    private IDgPerformNoticeSyncRecordDomain performNoticeSyncRecordDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Autowired
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;

    @Override
    public RestResponse<Boolean> preemptChannelInventory(Long orderId) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)performOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        DgPerformOrderSnapshotDto performOrderSnapshotDto = this.performOrderSnapshotDomain.selectDtoByOrderId(orderId);
        performOrderRespDto.setPerformOrderSnapshotDto(performOrderSnapshotDto);
        List performOrderItemRespDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(orderId);
        return new RestResponse((Object)this.inventoryApiServcie.preemptChannelInventoryV2(performOrderItemRespDtos, performOrderRespDto));
    }

    @Override
    public void saveLogisticsCompanyInfo(DgPerformOrderRespDto req) {
        DgPerformOrderWarehouseInfoDto performOrderWarehouseInfoDto = req.getPerformOrderWarehouseInfoDto();
        if (StringUtils.isNotBlank((CharSequence)performOrderWarehouseInfoDto.getLogisticsInfo())) {
            List shippingInfoList = JSON.parseArray((String)performOrderWarehouseInfoDto.getLogisticsInfo(), DgWmsShippingInfoReqDto.class);
            DgOutDeliveryResultReqDto outDeliveryResultReqDto = new DgOutDeliveryResultReqDto();
            outDeliveryResultReqDto.setShippingInfoList(shippingInfoList);
            log.info("[\u4fdd\u5b58\u8ba2\u5355\u7269\u6d41\u4fe1\u606f]\u4fdd\u5b58\u5e73\u53f0\u5355\uff1a{}\uff0c\u7269\u6d41\u4fe1\u606f\u4e3a\uff1a{}", (Object)req.getPlatformOrderNo(), (Object)JSON.toJSONString((Object)outDeliveryResultReqDto));
            this.performNoticeSyncRecordDomain.saleOutSyncRecord(req, outDeliveryResultReqDto);
        }
    }

    @Override
    public void setOrderLogicalWarehouse(DgPerformOrderRespDto dto, DgBizPerformOrderReqDto saleOrderRespDto) {
        String logicalWarehouseCode = null;
        if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDto.getItemList()) && StringUtils.isNotBlank((CharSequence)((DgPerformOrderItemReqDto)saleOrderRespDto.getItemList().get(0)).getLogicalWarehouseCode())) {
            logicalWarehouseCode = ((DgPerformOrderItemReqDto)saleOrderRespDto.getItemList().get(0)).getLogicalWarehouseCode();
        } else if (CollectionUtils.isNotEmpty((Collection)saleOrderRespDto.getGiftList()) && StringUtils.isNotBlank((CharSequence)((DgPerformOrderItemReqDto)saleOrderRespDto.getGiftList().get(0)).getLogicalWarehouseCode())) {
            AssertUtils.notEmpty((Collection)saleOrderRespDto.getGiftList(), (String)"\u8d60\u54c1\u5217\u8868\u4e3a\u7a7a");
            logicalWarehouseCode = ((DgPerformOrderItemReqDto)saleOrderRespDto.getGiftList().get(0)).getLogicalWarehouseCode();
        } else {
            logicalWarehouseCode = dto.getLogicalWarehouseCode();
        }
        if (StringUtils.isBlank((CharSequence)logicalWarehouseCode)) {
            return;
        }
        log.info("[\u4ee3\u53d1\u8ba2\u5355]\u8bbe\u7f6e\u53d1\u8d27\u4ed3\u4e3a\uff1a{}", (Object)logicalWarehouseCode);
        LogicalWarehouseRespDto logicalWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryLogicWarehouseByCode(logicalWarehouseCode));
        log.info("[\u4ee3\u53d1\u8ba2\u5355]\u8bbe\u7f6e\u53d1\u8d27\u4ed3\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)logicalWarehouseRespDto));
        DgPerformOrderWarehouseInfoEo warehouseInfoEo = new DgPerformOrderWarehouseInfoEo();
        warehouseInfoEo.setId(dto.getPerformOrderWarehouseInfoDto().getId());
        warehouseInfoEo.setLogicalWarehouseCode(logicalWarehouseCode);
        warehouseInfoEo.setDeliveryLogicalWarehouseCode(logicalWarehouseCode);
        warehouseInfoEo.setPhysicsWarehouseCode(logicalWarehouseRespDto.getPhysicsWarehouseCode());
        warehouseInfoEo.setPhysicsWarehouseName(logicalWarehouseRespDto.getPhysicsWarehouseName());
        this.warehouseInfoDomain.updateSelective((BaseEo)warehouseInfoEo);
    }

    @Override
    public RestResponse<Void> deducateInventoryForOrder(Long orderId) {
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)performOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        List orderItemLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderIdFilterCancel(orderId);
        this.inventoryApiServcie.deducateAllInventory(performOrderRespDto, orderItemLineDtoList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> deducateInventoryForOrder(DgPerformOrderRespDto dgPerformOrderRespDto) {
        AssertUtils.notNull((Object)dgPerformOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dgPerformOrderRespDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        List orderItemLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderIdFilterCancel(dgPerformOrderRespDto.getId());
        this.inventoryApiServcie.deducateAllInventory(dgPerformOrderRespDto, orderItemLineDtoList);
        return RestResponse.VOID;
    }

    @Override
    public DgSourceOrderResultRespDto autoSearchSourceByParentOrder(Long orderId) {
        DgPerformOrderSplitReleationEo parentReleationEo;
        DgPerformOrderSplitReleationEo releationEo = this.orderSplitReleationDomain.queryByChildId(orderId);
        Long parentOrderId = releationEo.getOrderId();
        while ((parentReleationEo = this.orderSplitReleationDomain.queryByChildId(parentOrderId)) != null) {
            parentOrderId = parentReleationEo.getOrderId();
        }
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(parentOrderId);
        List orderItemLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(parentOrderId);
        SourceRecordDto sourceRecordDto = this.sourceRecordDomain.querySourceRecordByOrderNoV2(performOrderRespDto.getSaleOrderNo(), orderItemLineDtoList);
        log.info("\u6839\u636e\u7236\u5355\u7b5b\u9009\u5bfb\u6e90\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)sourceRecordDto));
        AssertUtils.notNull((Object)sourceRecordDto, (String)"\u7236\u5355\u5bfb\u6e90\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)sourceRecordDto.getSourceOrderItemDtos(), (String)"\u7236\u5355\u5bfb\u6e90\u8bb0\u5f55\u5546\u54c1\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        DgSourceOrderResultRespDto respDto = new DgSourceOrderResultRespDto();
        respDto.setLinkOrderNo(sourceRecordDto.getOrderNo());
        respDto.setSgOrderNo(sourceRecordDto.getSgOrderNo());
        respDto.setSgStatus(sourceRecordDto.getSgStatus());
        List orderItemResultRespDtoList = sourceRecordDto.getSourceOrderItemDtos().stream().map(item -> {
            DgOrderItemResultDto orderItemResultDto = new DgOrderItemResultDto();
            orderItemResultDto.setSgOrderNo(item.getSgOrderNo());
            orderItemResultDto.setLinkOrderItemId(item.getOrderItemId());
            orderItemResultDto.setLinkItemSkuCode(item.getSkuCode());
            orderItemResultDto.setBatch(item.getBatchNo());
            orderItemResultDto.setDeliveryLogicWarehouseCode(item.getSgWarehouseCode());
            orderItemResultDto.setDeliveryItemNum(item.getSgItemNum());
            return orderItemResultDto;
        }).collect(Collectors.toList());
        respDto.setOrderItemResultRespDtoList(orderItemResultRespDtoList);
        respDto.setSgStatus(SourceStatusEnum.SOURCE_SUCCESS.getCode());
        return respDto;
    }

    @Override
    public InventoryOperateRespDto preemptLogicInventoryBySource(DgPerformOrderRespDto respDto, DgSourceOrderResultRespDto sourceOrderResultRespDto) {
        AssertUtils.notNull((Object)sourceOrderResultRespDto, (String)"\u5bfb\u6e90\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("[\u6839\u636e\u5bfb\u6e90\u7ed3\u679c\u5360\u5355]\u5bfb\u6e90\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceOrderResultRespDto.getSgStatus())) {
            DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
            List orderItemLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(respDto.getId());
            List skuCodes = orderItemLineDtoList.stream().map(DgPerformOrderLineDto::getSkuCode).distinct().collect(Collectors.toList());
            List sourceOrderItemRespDtos = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().filter(source -> skuCodes.contains(source.getLinkItemSkuCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(sourceOrderItemRespDtos)) {
                DgOrderItemResultDto sourceOrderItemRespDto = (DgOrderItemResultDto)sourceOrderItemRespDtos.get(0);
                Map sourceOrderItemMap = sourceOrderResultRespDto.getOrderItemResultRespDtoList().stream().collect(Collectors.toMap(DgOrderItemResultDto::getLinkOrderItemId, Function.identity(), (a, b) -> a));
                orderItemLineDtoList.forEach(orderLine -> orderLine.setDeliveryItemBatchNo(sourceOrderItemMap.get(orderLine.getId()) != null ? ((DgOrderItemResultDto)sourceOrderItemMap.get(orderLine.getId())).getBatch() : ""));
                performOrderRespDto.setDeliveryLogicalWarehouseCode(sourceOrderItemRespDto.getDeliveryLogicWarehouseCode());
                if (null == performOrderRespDto.getPerformOrderWarehouseInfoDto()) {
                    performOrderRespDto.setPerformOrderWarehouseInfoDto(new DgPerformOrderWarehouseInfoDto());
                }
                performOrderRespDto.getPerformOrderWarehouseInfoDto().setDeliveryLogicalWarehouseCode(sourceOrderItemRespDto.getDeliveryLogicWarehouseCode());
                InventoryOperateRespDto inventoryOperateRespDto = this.inventoryApiServcie.omsPreemptLogicInventoryBackResult(performOrderRespDto, orderItemLineDtoList);
                if (inventoryOperateRespDto.getFailList() == null || inventoryOperateRespDto.getFailList().size() == 0) {
                    DgLogicWarehouseReqDto logicWarehouseReqDto = new DgLogicWarehouseReqDto();
                    logicWarehouseReqDto.setDeliveryLogicWarehouseCode(sourceOrderItemRespDto.getDeliveryLogicWarehouseCode());
                    this.updateDeliveryLogicWarehouse(respDto.getId(), logicWarehouseReqDto);
                }
                return inventoryOperateRespDto;
            }
            log.warn("\u7236\u8ba2\u5355\u5bfb\u6e90\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
            throw DgPcpTradeExceptionCode.SOURCE_RESULT_EXCEPTION.builderException();
        }
        log.warn("[\u6839\u636e\u5bfb\u6e90\u7ed3\u679c\u5360\u5355]\u5bfb\u6e90\u5931\u8d25\uff0c\u65b9\u6cd5\u8c03\u7528\u94fe\u4e0d\u5e94\u8be5\u8c03\u7528\u5f53\u524d\u65b9\u6cd5\uff0c\u5f53\u524d\u65b9\u6cd5\u53ea\u5904\u7406\u5bfb\u6e90\u6210\u529f\u7684\u573a\u666f");
        throw DgPcpTradeExceptionCode.SOURCE_RESULT_EXCEPTION.builderException();
    }

    public void updateDeliveryLogicWarehouse(Long saleOrderId, DgLogicWarehouseReqDto logicWarehouseReqDto) {
        AssertUtils.notBlank((String)logicWarehouseReqDto.getDeliveryLogicWarehouseCode(), (String)"deliveryLogicWarehouseCode \u4e0d\u80fd\u4e3a\u7a7a");
        LogicalWarehouseRespDto physicsWarehouseByLogic = this.inventoryApiServcie.getPhysicsWarehouseByLogic(logicWarehouseReqDto.getDeliveryLogicWarehouseCode());
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(saleOrderId);
        updateReqDto.setDeliveryLogicalWarehouseCode(logicWarehouseReqDto.getDeliveryLogicWarehouseCode());
        updateReqDto.setPhysicsWarehouseCode(physicsWarehouseByLogic.getPhysicsWarehouseCode());
        updateReqDto.setPhysicsWarehouseName(physicsWarehouseByLogic.getPhysicsWarehouseName());
        DgPerformOrderWarehouseInfoDto warehouseInfoDto = new DgPerformOrderWarehouseInfoDto();
        warehouseInfoDto.setDeliveryLogicalWarehouseCode(logicWarehouseReqDto.getDeliveryLogicWarehouseCode());
        warehouseInfoDto.setPhysicsWarehouseCode(physicsWarehouseByLogic.getPhysicsWarehouseCode());
        warehouseInfoDto.setPhysicsWarehouseName(physicsWarehouseByLogic.getPhysicsWarehouseName());
        updateReqDto.setPerformOrderWarehouseInfoDto(warehouseInfoDto);
        this.omsOrderInfoDomain.update(updateReqDto);
        log.info("[\u66f4\u65b0\u53d1\u8d27\u903b\u8f91\u4ed3]\u4fee\u6539\u53d1\u8d27\u903b\u8f91\u4ed3\u7684\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicWarehouseReqDto));
    }

    @Override
    public Boolean preemptLogicoInventoryAndReleaseInventory(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        AssertUtils.notBlank((String)saleOrderRespDto.getLogicalWarehouseCode(), (String)"\u8ba2\u5355\u5c1a\u672a\u6307\u5b9a\u53d1\u8d27\u903b\u8f91\u4ed3");
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(orderId);
        List orderLineAmountDtos = this.performOrderLineAmountDomain.queryByOrderId(orderId);
        saleOrderRespDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
        Boolean result = this.inventoryApiServcie.releaseAndpreemptInventoryForOrderLine(saleOrderRespDto, orderLineDtoList, orderLineAmountDtos);
        log.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u6210\u529f");
        if (!result.booleanValue()) {
            log.error("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58\u5931\u8d25");
            throw DgPcpTradeExceptionCode.PREEMPT_LOGICAL_BY_APPOINT_EXCEPTION.builderException();
        }
        log.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u6210\u529f");
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(orderId);
        updateReqDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
        DgPerformOrderWarehouseInfoDto performOrderWarehouseInfoDto = new DgPerformOrderWarehouseInfoDto();
        performOrderWarehouseInfoDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
        updateReqDto.setPerformOrderWarehouseInfoDto(performOrderWarehouseInfoDto);
        this.omsOrderInfoDomain.update(updateReqDto);
        return result;
    }

    @Override
    public InventoryOperateRespDto preemptLogicInventoryByOrderAppointDeliveryWarehouse(DgPerformOrderRespDto respDto) {
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        Long orderId = respDto.getId();
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode()) && StringUtils.isBlank((CharSequence)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseCode())) {
            AssertUtils.notBlank((String)"", (String)"\u8ba2\u5355\u5c1a\u672a\u6307\u5b9a\u53d1\u8d27\u903b\u8f91\u4ed3");
        }
        if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode())) {
            saleOrderRespDto.getPerformOrderWarehouseInfoDto().setDeliveryLogicalWarehouseCode(saleOrderRespDto.getPerformOrderWarehouseInfoDto().getLogicalWarehouseCode());
        }
        LogicalWarehouseRespDto physicsWarehouseByLogic = this.inventoryApiServcie.getPhysicsWarehouseByLogic(saleOrderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode());
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(orderId);
        InventoryOperateRespDto inventoryOperateRespDto = this.inventoryApiServcie.omsPreemptLogicInventoryBackResult(saleOrderRespDto, orderLineDtoList);
        log.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateRespDto));
        if (inventoryOperateRespDto.getFailList() == null || inventoryOperateRespDto.getFailList().isEmpty()) {
            log.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u6210\u529f");
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setId(orderId);
            updateReqDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
            updateReqDto.setPhysicsWarehouseCode(physicsWarehouseByLogic.getPhysicsWarehouseCode());
            updateReqDto.setPhysicsWarehouseName(physicsWarehouseByLogic.getPhysicsWarehouseName());
            DgPerformOrderWarehouseInfoDto warehouseInfoDto = new DgPerformOrderWarehouseInfoDto();
            warehouseInfoDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
            warehouseInfoDto.setPhysicsWarehouseCode(physicsWarehouseByLogic.getPhysicsWarehouseCode());
            warehouseInfoDto.setPhysicsWarehouseName(physicsWarehouseByLogic.getPhysicsWarehouseName());
            updateReqDto.setPerformOrderWarehouseInfoDto(warehouseInfoDto);
            this.omsOrderInfoDomain.update(updateReqDto);
        }
        return inventoryOperateRespDto;
    }

    @Override
    public DgSourceOrderResultRespDto autoSearchSource(Long saleOrderId) {
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(saleOrderId);
        DgPerformOrderAddrDto performOrderAddrDto = this.performOrderAddrExtDomain.queryAddressByOrderId(saleOrderId);
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(saleOrderId);
        List<DgPerformOrderLineDto> lineDtos = orderLineDtos.stream().filter(e -> !e.getStatus().equals(DgSaleOrderItemStatusEnum.CANCEL.getCode())).collect(Collectors.toList());
        DgSourceOrderResultRespDto sourceOrderResultRespDto = this.sourceApiService.searchSourceV2(saleOrderRespDto, lineDtos, performOrderAddrDto);
        return sourceOrderResultRespDto;
    }

    @Override
    public DgArrangeShipmentEnterpriseReqDto autoShipmentEnterpriseSource(DgPerformOrderRespDto respDto) {
        DgClueWarehouseGroupRuleShipmentDto dgClueWarehouseGroupRuleShipmentDto;
        log.info("\u4ea4\u6613\u5355\u636e\u7269\u6d41\u5bfb\u6e90autoShipmentEnterpriseSource\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        if (!this.phySourceEnable.booleanValue()) {
            log.info("[\u7269\u6d41\u5bfb\u6e90]\u672a\u5f00\u542f\u81ea\u52a8\u7269\u6d41\u5bfb\u6e90\uff0c\u8fd4\u56de\u7a7a");
            throw new BizException("[\u7269\u6d41\u5bfb\u6e90]\u672a\u5f00\u542f\u81ea\u52a8\u7269\u6d41\u5bfb\u6e90");
        }
        AssertUtils.notBlank((String)respDto.getSaleOrderNo(), (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto orderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        AssertUtils.notNull((Object)orderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        AssertUtils.notBlank((String)orderRespDto.getPerformOrderWarehouseInfoDto().getDeliveryLogicalWarehouseCode(), (String)"\u8ba2\u5355\u65e0\u5b9e\u9645\u53d1\u8d27\u903b\u8f91\u4ed3");
        List orderLineDtoList = orderRespDto.getOrderLineList();
        DgPerformOrderAddrDto saleOrderAddrRespDto = this.performOrderAddrExtDomain.queryAddressByOrderId(respDto.getId());
        DgSourceOrderResultRespDto sourceOrderResultRespDto = this.sourceApiService.shippingSearchSourceV2(orderRespDto, orderLineDtoList, saleOrderAddrRespDto);
        log.info("[\u7269\u6d41\u5bfb\u6e90],\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)sourceOrderResultRespDto));
        List clueWarehouseGroupRuleShipmentRespDtoList = sourceOrderResultRespDto.getClueWarehouseGroupRuleShipmentRespDtoList();
        if (CollectionUtils.isNotEmpty((Collection)clueWarehouseGroupRuleShipmentRespDtoList) && null != (dgClueWarehouseGroupRuleShipmentDto = (DgClueWarehouseGroupRuleShipmentDto)clueWarehouseGroupRuleShipmentRespDtoList.get(0))) {
            log.info("\u6821\u9a8c\u5feb\u9012\u4e0d\u53ef\u8fbe\u4fe1\u606f");
            VerificationDeliveryAccessReqDto verificationDeliveryAccessReqDto = new VerificationDeliveryAccessReqDto();
            verificationDeliveryAccessReqDto.setAction(Boolean.valueOf(true));
            verificationDeliveryAccessReqDto.setKuaidicom(dgClueWarehouseGroupRuleShipmentDto.getShipmentEnterpriseCode());
            VerificationDeliveryAccessRespDto verificationDeliveryAccessRespDto = this.dgPerformOrderWarehouseInfoService.verifyDeliveryAccessibility(respDto.getId(), verificationDeliveryAccessReqDto, "0");
            if (verificationDeliveryAccessRespDto.getReachable().equals("0")) {
                DgPerformOrderRespDto dgPerformOrderRespDto = new DgPerformOrderRespDto();
                dgPerformOrderRespDto.setId(respDto.getId());
                this.orderCommonHandleAction.modifyInterceptReason(dgPerformOrderRespDto, "\u8ba2\u5355\u5feb\u9012\u4e0d\u53ef\u8fbe\u62e6\u622a");
                DgPerformOrderWarehouseInfoEo dgPerformOrderWarehouseInfoEo = (DgPerformOrderWarehouseInfoEo)((ExtQueryChainWrapper)this.performOrderWarehouseInfoDomain.filter().eq((Object)"order_id", (Object)respDto.getId())).one();
                dgPerformOrderWarehouseInfoEo.setShipmentEnterpriseId(dgClueWarehouseGroupRuleShipmentDto.getShipmentEnterpriseId());
                dgPerformOrderWarehouseInfoEo.setShipmentEnterpriseCode(dgClueWarehouseGroupRuleShipmentDto.getShipmentEnterpriseCode());
                dgPerformOrderWarehouseInfoEo.setShipmentEnterpriseName(dgClueWarehouseGroupRuleShipmentDto.getShipmentEnterpriseName());
                dgPerformOrderWarehouseInfoEo.setTransportStyle(dgClueWarehouseGroupRuleShipmentDto.getTransportStyle());
                dgPerformOrderWarehouseInfoEo.setTransportTypeCode(dgClueWarehouseGroupRuleShipmentDto.getTransportTypeCode());
                dgPerformOrderWarehouseInfoEo.setTransportTypeName(dgClueWarehouseGroupRuleShipmentDto.getTransportTypeName());
                this.performOrderWarehouseInfoDomain.updateSelective((BaseEo)dgPerformOrderWarehouseInfoEo);
                throw new BizException("[\u7269\u6d41\u5bfb\u6e90]\u8ba2\u5355\u5feb\u9012\u4e0d\u53ef\u8fbe\u62e6\u622a");
            }
        }
        DgArrangeShipmentEnterpriseReqDto reqDto = new DgArrangeShipmentEnterpriseReqDto();
        reqDto.setOrderId(respDto.getId());
        if (Objects.nonNull(sourceOrderResultRespDto)) {
            reqDto.setSgStatus(sourceOrderResultRespDto.getSgStatus());
            reqDto.setSgFindOptCode(sourceOrderResultRespDto.getSgFindOptCode());
            reqDto.setSgFindOptDesc(sourceOrderResultRespDto.getSgFailResultDesc());
            if (CollectionUtils.isNotEmpty((Collection)sourceOrderResultRespDto.getClueWarehouseGroupRuleShipmentRespDtoList())) {
                List list = sourceOrderResultRespDto.getClueWarehouseGroupRuleShipmentRespDtoList();
                reqDto.setShipmentEnterpriseCode(((DgClueWarehouseGroupRuleShipmentDto)list.get(0)).getShipmentEnterpriseCode());
                reqDto.setShipmentEnterpriseName(((DgClueWarehouseGroupRuleShipmentDto)list.get(0)).getShipmentEnterpriseName());
                reqDto.setShipmentEnterpriseId(((DgClueWarehouseGroupRuleShipmentDto)list.get(0)).getShipmentEnterpriseId());
                reqDto.setTransportStyle(((DgClueWarehouseGroupRuleShipmentDto)list.get(0)).getTransportStyle());
                reqDto.setTransportTypeCode(((DgClueWarehouseGroupRuleShipmentDto)list.get(0)).getTransportTypeCode());
                reqDto.setTransportTypeName(((DgClueWarehouseGroupRuleShipmentDto)list.get(0)).getTransportTypeName());
                reqDto.setLineName(((DgClueWarehouseGroupRuleShipmentDto)list.get(0)).getLineName());
                reqDto.setLineCode(((DgClueWarehouseGroupRuleShipmentDto)list.get(0)).getLineCode());
            }
        }
        respDto.setDgArrangeShipmentEnterpriseDto(reqDto);
        return reqDto;
    }

    @Override
    public void resetToCsAudit(DgPerformOrderRespDto saleOrderRespDto) {
        Boolean cancelResult = this.inventoryApiServcie.releaseChannelInventory(saleOrderRespDto);
        if (!cancelResult.booleanValue()) {
            throw DgPcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getRevokeReason())) {
            this.omsOrderInfoDomain.modifyFinancialRevokeReason(saleOrderRespDto.getId(), saleOrderRespDto.getRevokeReason());
        }
        this.omsOrderInfoDomain.cleanSourceData(saleOrderRespDto.getId());
    }

    @Override
    public void autoPreemptChannelInventory(Long orderId) {
        DgPerformOrderRespDto orderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)orderRespDto, (String)"\u8ba2\u5355id=%s\u4e0d\u5b58\u5728", (Object[])new Object[]{orderId});
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(orderId);
        this.inventoryApiServcie.preemptChannelInventoryForBSAuditV2(orderLineDtoList, orderRespDto);
    }

    @Override
    public void appointAfterSaleWarehouse(DgPerformOrderRespDto respDto) {
        DgPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(respDto.getId());
        if (DgSaleOrderTypeEnum.EXCHANGE_FIX_ORDER.getType().equals(saleOrderRespDto.getOrderType()) || DgSaleOrderTypeEnum.AFTER_SALE_ORDER.getType().equals(saleOrderRespDto.getOrderType())) {
            String warehouseCode = this.performOrderGlobalConfig.getAfterSaleWarehouseCode();
            String warehouseName = this.performOrderGlobalConfig.getAfterSaleWarehouseName();
            String warehouseId = this.performOrderGlobalConfig.getAfterSaleWarehouseId();
            if (DgSaleOrderTypeEnum.EXCHANGE_FIX_ORDER.getType().equals(saleOrderRespDto.getOrderType())) {
                warehouseId = this.performOrderGlobalConfig.getExchangeFixWarehouseId();
                warehouseCode = this.performOrderGlobalConfig.getExchangeFixWarehouseCode();
                warehouseName = this.performOrderGlobalConfig.getExchangeFixWarehouseName();
            } else if (StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getLogicalWarehouseCode())) {
                LogicalWarehouseRespDto logicWarehousePageRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryLogicWarehouseByCode(saleOrderRespDto.getLogicalWarehouseCode()));
                warehouseId = logicWarehousePageRespDto.getId() + "";
                warehouseCode = saleOrderRespDto.getLogicalWarehouseCode();
                warehouseName = logicWarehousePageRespDto.getWarehouseName();
            }
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setId(saleOrderRespDto.getId());
            updateReqDto.setPerformOrderWarehouseInfoDto(new DgPerformOrderWarehouseInfoDto());
            updateReqDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseId(Long.valueOf(warehouseId));
            updateReqDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseCode(warehouseCode);
            updateReqDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseName(warehouseName);
            updateReqDto.getPerformOrderWarehouseInfoDto().setDeliveryLogicalWarehouseCode(warehouseCode);
            log.info("[\u6307\u5b9a\u4ed3\u5e93]\u6307\u5b9a\u4ed3\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updateReqDto));
            this.omsOrderInfoDomain.update(updateReqDto);
        }
    }

    @Override
    public Boolean modifySameSpecSku(DgPerformOrderInfoEo orderInfoEo) {
        DgPerformOrderRespDto orderDto = this.omsOrderInfoQueryDomain.queryDtoById(orderInfoEo.getId());
        if (!Objects.equals(orderDto.getConsignType(), DgConsignTypeEnum.THIRD.getType())) {
            return false;
        }
        List dgPerformOrderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderIdFilterCancel(orderInfoEo.getId());
        Map<String, DgPerformOrderLineDto> orderLineMapBySkuCode = dgPerformOrderLineDtoList.stream().collect(Collectors.toMap(DgPerformOrderLineDto::getSkuCode, line -> line, (existing, replacement) -> existing));
        List<String> logicalWarehouseList = this.getLogicalWarehouse(orderInfoEo);
        if (this.checkThirdOrderInventory(orderInfoEo, dgPerformOrderLineDtoList, logicalWarehouseList).booleanValue()) {
            return true;
        }
        List skuCodeList = dgPerformOrderLineDtoList.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList());
        List orderSkuInfoList = (List)RestResponseHelper.extractData((RestResponse)this.iItemSkuDgQueryApiProxy.queryBySkuCode(skuCodeList));
        if (!orderSkuInfoList.stream().allMatch(sku -> StringUtils.isNotBlank((CharSequence)Optional.ofNullable(sku).map(ItemSkuDgRespDto::getSameModel).orElse(null)))) {
            throw new BizException("\u8ba2\u5355sku\u540c\u89c4\u683c\u672a\u914d\u7f6e");
        }
        List<String> sameSpecList = orderSkuInfoList.stream().map(ItemSkuDgRespDto::getSameModel).collect(Collectors.toList());
        Map<String, List<DgItemSkuPageRespDto>> sameSpecSkuMapBySpec = this.getSameSpecSkuMapBySpec(sameSpecList);
        Map<String, Map<String, List<InventoryBasicsQueryRespDto>>> skuInventoryMapWarehouse = this.getSkuInventory(orderDto, sameSpecSkuMapBySpec, logicalWarehouseList);
        HashMap<String, Map> availableWarehouse = new HashMap<String, Map>();
        for (Map.Entry<String, Map<String, List<InventoryBasicsQueryRespDto>>> entry : skuInventoryMapWarehouse.entrySet()) {
            String logicalWarehouseCode = entry.getKey();
            Map<String, List<InventoryBasicsQueryRespDto>> sameSpecMapInventory = entry.getValue();
            HashMap changeSkuMap = new HashMap();
            orderSkuInfoList.forEach(orderSku -> {
                DgPerformOrderLineDto orderLine = (DgPerformOrderLineDto)orderLineMapBySkuCode.get(orderSku.getCode());
                BigDecimal itemNum = orderLine.getItemNum();
                List sameSpecSkuInventory = sameSpecMapInventory.getOrDefault(orderSku.getSameModel(), new ArrayList());
                List sameSpecSkuList = (List)sameSpecSkuMapBySpec.get(orderSku.getSameModel());
                for (DgItemSkuPageRespDto sku : sameSpecSkuList) {
                    InventoryBasicsQueryRespDto inventory = sameSpecSkuInventory.stream().filter(skuInventory -> Objects.equals(skuInventory.getCargoCode(), sku.getSkuCode())).findFirst().orElse(new InventoryBasicsQueryRespDto());
                    if (Optional.ofNullable(inventory.getAvailable()).orElse(BigDecimal.ZERO).compareTo(itemNum) < 0) continue;
                    changeSkuMap.put(orderLine.getSkuCode(), sku.getSkuCode());
                    break;
                }
            });
            if (!dgPerformOrderLineDtoList.stream().allMatch(ld -> changeSkuMap.containsKey(ld.getSkuCode()))) continue;
            availableWarehouse.put(logicalWarehouseCode, changeSkuMap);
            break;
        }
        log.info("\u5e93\u5b58\u68c0\u67e5,\u7b26\u5408\u5e93\u5b58{}", (Object)JSON.toJSONString(availableWarehouse));
        availableWarehouse.forEach((logicWarehouseCode, changeMap) -> {
            List skuInfoList = (List)RestResponseHelper.extractData((RestResponse)this.iItemSkuDgQueryApiProxy.queryBySkuCode(new ArrayList(changeMap.values())));
            Map<String, ItemSkuDgRespDto> skuInfoMapByCode = skuInfoList.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, sku -> sku, (existing, replacement) -> existing));
            changeMap.forEach((originSkuCode, changeSkuCode) -> {
                if (!Objects.equals(originSkuCode, changeSkuCode)) {
                    ItemSkuDgRespDto skuInfo = (ItemSkuDgRespDto)skuInfoMapByCode.get(changeSkuCode);
                    DgModifyOrderItemReqDto dto = new DgModifyOrderItemReqDto();
                    dto.setReplaceSkuCode(originSkuCode);
                    dto.setItemId(skuInfo.getItemId());
                    dto.setSkuId(skuInfo.getId());
                    dto.setSkuName(skuInfo.getName());
                    dto.setType(skuInfo.getCargoType() + "");
                    dto.setSkuCode(changeSkuCode);
                    this.modifyOrderItemBySkuCode(orderInfoEo.getId(), dto);
                }
            });
        });
        DgPerformOrderRespDto dto = new DgPerformOrderRespDto();
        dto.setId(orderInfoEo.getId());
        this.dgCommonLabelManageService.markLabelForOrderItems(dto);
        return true;
    }

    private void modifyOrderItemBySkuCode(Long orderId, DgModifyOrderItemReqDto modifyOrderItemReqDto) {
        DgPerformOrderItemReqDto reqDto = new DgPerformOrderItemReqDto();
        reqDto.setOrderId(orderId);
        reqDto.setSkuCode(modifyOrderItemReqDto.getReplaceSkuCode());
        List oldOrderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderSkus(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)oldOrderLineDtoList)) {
            modifyOrderItemReqDto.setOrderId(orderId);
            oldOrderLineDtoList.forEach(item -> {
                DgModifyOrderItemReqDto changeItemReq = new DgModifyOrderItemReqDto();
                CubeBeanUtils.copyProperties((Object)changeItemReq, (Object)modifyOrderItemReqDto, (String[])new String[0]);
                changeItemReq.setOriginalOrderGoodsId(item.getId());
                changeItemReq.setIfGift(Boolean.valueOf(Objects.equals(DgGiftEnum.GIFT.getType(), item.getGiftFlag())));
                this.omsOrderItemService.manualModifyOrderItem(changeItemReq);
            });
        } else {
            log.warn("[\u901a\u8fc7skucode\u4fee\u6539\u5546\u54c1]\u8ba2\u5355\uff08{}\uff09\u4e0d\u5b58\u5728skucode={}\u7684\u5546\u54c1", (Object)orderId, (Object)modifyOrderItemReqDto.getReplaceSkuCode());
            AssertUtils.notEmpty((Collection)oldOrderLineDtoList, (String)"\u8ba2\u5355\u5546\u54c1/\u8d60\u54c1\u4e0d\u5b58\u5728");
        }
    }

    private Map<String, List<DgItemSkuPageRespDto>> getSameSpecSkuMapBySpec(List<String> sameSpecList) {
        HashMap<String, List<DgItemSkuPageRespDto>> result = new HashMap<String, List<DgItemSkuPageRespDto>>();
        sameSpecList.forEach(sameSpec -> {
            ItemQueryDgReqDto dgReqDto = new ItemQueryDgReqDto();
            dgReqDto.setPageNum(Integer.valueOf(1));
            dgReqDto.setPageSize(Integer.valueOf(1000));
            dgReqDto.setSameModel(sameSpec);
            dgReqDto.setSubStatus(Integer.valueOf(1));
            PageInfo skuInfoPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuDgQueryApiProxy.queryItemListByPage(dgReqDto));
            List skuInfoList = skuInfoPage.getList();
            if (CollectionUtils.isEmpty((Collection)skuInfoList)) {
                throw new BizException("\u67e5\u8be2\u4e0d\u5230\u540c\u578b\u53f7sku" + sameSpec);
            }
            result.put((String)sameSpec, skuInfoList);
        });
        return result;
    }

    private Boolean checkThirdOrderInventory(DgPerformOrderInfoEo orderInfoEo, List<DgPerformOrderLineDto> dgPerformOrderLineDtoList, List<String> logicWarehouseCodes) {
        List skuCodeList = dgPerformOrderLineDtoList.stream().map(DgPerformOrderLineDto::getSkuCode).collect(Collectors.toList());
        InventoryBasicsQueryReqDto inventoryBasicsQueryReqDto = new InventoryBasicsQueryReqDto();
        inventoryBasicsQueryReqDto.setWarehouseCodeList(logicWarehouseCodes);
        inventoryBasicsQueryReqDto.setLongCodeList(skuCodeList);
        inventoryBasicsQueryReqDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        List inventoryList = (List)RestResponseHelper.extractData((RestResponse)this.inventoryExposedQueryApi.queryCommonInventory(inventoryBasicsQueryReqDto));
        log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c{},{}", (Object)orderInfoEo.getSaleOrderNo(), (Object)JSON.toJSONString((Object)inventoryList));
        if (CollectionUtils.isEmpty((Collection)inventoryList)) {
            log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u67e5\u8be2\u7a7a{}", (Object)orderInfoEo.getSaleOrderNo());
            return false;
        }
        Map<String, List<InventoryBasicsQueryRespDto>> inventoryMapByWarehouseCode = inventoryList.stream().collect(Collectors.groupingBy(InventoryBasicsQueryRespDto::getWarehouseCode));
        HashSet<String> unAvailableWarehouseCodes = new HashSet<String>();
        block0: for (Map.Entry<String, List<InventoryBasicsQueryRespDto>> entry : inventoryMapByWarehouseCode.entrySet()) {
            String warehouseCode = entry.getKey();
            List<InventoryBasicsQueryRespDto> inventoryDtoList = entry.getValue();
            Map<String, List<InventoryBasicsQueryRespDto>> inventoryMapBySkuCode = inventoryDtoList.stream().collect(Collectors.groupingBy(InventoryBasicsQueryRespDto::getCargoCode));
            for (DgPerformOrderLineDto orderLine : dgPerformOrderLineDtoList) {
                BigDecimal itemNum = orderLine.getItemNum();
                List inventoryDtos = inventoryMapBySkuCode.getOrDefault(orderLine.getSkuCode(), new ArrayList());
                if (!inventoryDtos.stream().map(inventory -> Optional.ofNullable(inventory).map(InventoryBasicsQueryRespDto::getAvailable).orElse(BigDecimal.ZERO)).noneMatch(available -> available.compareTo(itemNum) >= 0)) continue;
                unAvailableWarehouseCodes.add(warehouseCode);
                continue block0;
            }
        }
        return unAvailableWarehouseCodes.size() < inventoryMapByWarehouseCode.size();
    }

    private Map<String, Map<String, List<InventoryBasicsQueryRespDto>>> getSkuInventory(DgPerformOrderRespDto performOrderRespDto, Map<String, List<DgItemSkuPageRespDto>> sameSpecSkuMapBySpec, List<String> logicWarehouseCodes) {
        ArrayList skuList = new ArrayList();
        sameSpecSkuMapBySpec.forEach((key, value) -> skuList.addAll(value));
        List skuCodeList = skuList.stream().map(DgItemSkuRespDto::getSkuCode).collect(Collectors.toList());
        InventoryBasicsQueryReqDto inventoryBasicsQueryReqDto = new InventoryBasicsQueryReqDto();
        inventoryBasicsQueryReqDto.setWarehouseCodeList(logicWarehouseCodes);
        inventoryBasicsQueryReqDto.setLongCodeList(skuCodeList);
        inventoryBasicsQueryReqDto.setInventoryStrategy(CsInventoryStrategyEnum.LOGIC.getCode());
        List inventoryList = (List)RestResponseHelper.extractData((RestResponse)this.inventoryExposedQueryApi.queryCommonInventory(inventoryBasicsQueryReqDto));
        log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u67e5\u8be2\u7ed3\u679c{},{}", (Object)performOrderRespDto.getSaleOrderNo(), (Object)JSON.toJSONString((Object)inventoryList));
        if (CollectionUtils.isEmpty((Collection)inventoryList)) {
            throw new BizException("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e93\u5b58\u4e0d\u8db3" + performOrderRespDto.getSaleOrderNo());
        }
        HashMap skuSpecMap = new HashMap();
        skuList.forEach(sku -> skuSpecMap.put(sku.getSkuCode(), sku.getSameModel()));
        Map<String, List<InventoryBasicsQueryRespDto>> inventoryMapLogicWarehouse = inventoryList.stream().collect(Collectors.groupingBy(InventoryBasicsQueryRespDto::getWarehouseCode));
        HashMap<String, Map<String, List<InventoryBasicsQueryRespDto>>> result = new HashMap<String, Map<String, List<InventoryBasicsQueryRespDto>>>();
        inventoryMapLogicWarehouse.forEach((key, value) -> {
            HashMap sameSpecMap = new HashMap();
            value.forEach(inventory -> {
                String spec = (String)skuSpecMap.get(inventory.getCargoCode());
                if (sameSpecMap.containsKey(spec)) {
                    ((List)sameSpecMap.get(spec)).add(inventory);
                } else {
                    sameSpecMap.put(spec, Lists.newArrayList((Object[])new InventoryBasicsQueryRespDto[]{inventory}));
                }
            });
            result.put((String)key, sameSpecMap);
        });
        return result;
    }

    private List<String> getLogicalWarehouse(DgPerformOrderInfoEo orderInfoEo) {
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(orderInfoEo.getId());
        DgShopRespDto shopExtRespDto = (DgShopRespDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApiProxy.getShopDetailById(snapshotEo.getShopId()));
        log.info("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u903b\u8f91\u4ed3\u5e97\u94fa\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c{},{}", (Object)orderInfoEo.getSaleOrderNo(), (Object)JSON.toJSONString((Object)shopExtRespDto));
        List logicWarehouseCodes = shopExtRespDto.getLogicWarehouseCodes();
        if (CollectionUtil.isEmpty((Collection)logicWarehouseCodes)) {
            throw new BizException("\u5e97\u94fa\u5e73\u53f0\u53d1\u8d27\u6a21\u5f0f\u6ca1\u914d\u7f6e\u903b\u8f91\u4ed3" + orderInfoEo.getSaleOrderNo());
        }
        return logicWarehouseCodes;
    }
}

