/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelOrderKneadPriceService {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderKneadPriceService.class);
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain performOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;

    void saveAmountInfo(List<DgPerformOrderLineAmountDto> amountDtoList, DgPerformOrderRespDto dto) {
        if (CollectionUtil.isNotEmpty(amountDtoList)) {
            List orderItemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(dto.getId());
            Map<Long, List<DgPerformOrderItemLineDto>> orderItemLineMap = orderItemLineDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
            ArrayList amountEos = new ArrayList();
            CubeBeanUtils.copyCollection(amountEos, amountDtoList, DgPerformOrderLineAmountEo.class);
            this.performOrderLineAmountDomain.insertBatch(amountEos);
            ArrayList itemLineAmountEos = new ArrayList();
            amountDtoList.forEach(amount -> {
                List itemLineDtos = (List)orderItemLineMap.get(amount.getOrderLineId());
                if (itemLineDtos.size() > 1) {
                    log.warn("\u8ba2\u5355\u884c \uff01= \u5546\u54c1\u884c");
                }
                DgPerformOrderItemLineAmountEo orderItemLineAmountEo = new DgPerformOrderItemLineAmountEo();
                CubeBeanUtils.copyProperties((Object)orderItemLineAmountEo, (Object)amount, (String[])new String[]{"id"});
                orderItemLineAmountEo.setAmountSource(DgOrderAmountSourceEnum.KNEAD.getCode());
                orderItemLineAmountEo.setOrderItemLineId(((DgPerformOrderItemLineDto)itemLineDtos.get(0)).getId());
                switch (amount.getAmountSource()) {
                    case "ORDER_LINE_BASE": {
                        orderItemLineAmountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode());
                    }
                }
                switch (amount.getAccountType()) {
                    case "LINE_PROMOTION_KNEAD_AMOUNT": {
                        orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_PROMOTION_KNEAD_AMOUNT.getCode());
                        break;
                    }
                    case "LINE_PROMOTION_KNEAD_TOTAL": {
                        orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_PROMOTION_KNEAD_TOTAL.getCode());
                        break;
                    }
                    case "LINE_COST_KNEAD_AMOUNT": {
                        orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_COST_KNEAD_AMOUNT.getCode());
                        break;
                    }
                    case "LINE_COST_KNEAD_TOTAL": {
                        orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_COST_KNEAD_TOTAL.getCode());
                        break;
                    }
                    case "LINE_KNEAD_LATER_PAY_AMOUNT": {
                        orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_KNEAD_LATER_PAY_AMOUNT.getCode());
                        break;
                    }
                    case "LINE_KNEAD_LATER_SETTLEMENT_AMOUNT": {
                        orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_KNEAD_LATER_SETTLEMENT_AMOUNT.getCode());
                    }
                }
                itemLineAmountEos.add(orderItemLineAmountEo);
            });
            this.performOrderItemLineAmountDomain.insertBatch(itemLineAmountEos);
        }
    }
}

