/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.oms.channel.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.dto.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.customer.dto.entity.CsOrgCustomerRelationPageReqDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgTobOrgCustomerRelationQueryApiProxy;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.data.proxy.api.IDictQueryApiProxy;
import com.yunxi.dg.base.center.item.dto.entity.ItemUnitConversionDgDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemMediasDgRespDto;
import com.yunxi.dg.base.center.item.proxy.sku.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.logistics.dto.DgFreightTemplateAdaptDto;
import com.yunxi.dg.base.center.logistics.dto.DgFreightTemplateCustomerAdaptDto;
import com.yunxi.dg.base.center.logistics.dto.DgFreightTemplateItemDto;
import com.yunxi.dg.base.center.logistics.proxy.entity.IDgFreightTemplateApiProxy;
import com.yunxi.dg.base.center.report.dto.item.ItemSkuDgDto;
import com.yunxi.dg.base.center.report.dto.item.ShopItemEsRespDto;
import com.yunxi.dg.base.center.report.dto.request.DgEsCustomerBuyScopeItemQueryDto;
import com.yunxi.dg.base.center.report.proxy.customer.IDgCustomerBuyScopeItemQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IPreInfoQueryAction;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgF2BOrderContextVo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgShopOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.service.oms.channel.IDgFreightService;
import com.yunxi.dg.base.center.trade.utils.UnitConverUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgFreightServiceImpl
implements IDgFreightService {
    private static final Logger logger = LoggerFactory.getLogger(DgFreightServiceImpl.class);
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IDgFreightTemplateApiProxy freightTemplateApiProxy;
    @Resource
    private IPreInfoQueryAction preInfoQueryAction;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IDgTobOrgCustomerRelationQueryApiProxy tobOrgCustomerRelationQueryApiProxy;
    @Resource
    private IDgCustomerBuyScopeItemQueryApiProxy dgCustomerBuyScopeItemQueryApiProxy;

    @Override
    public boolean checkFreightEnough(DgOrderReqDto dgOrderReqDto, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        logger.info("\u6821\u9a8c\u5355\u636e\u8fd0\u8d39\u662f\u5426\u8db3\u591f\uff1a{}", (Object)JSON.toJSONString((Object)f2BOrderPreviewContext));
        String provinceCode = ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getOrderAddrReqDto().getProvinceCode();
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("yunxi-dg-base-center-logistics", "freightItemConfig"));
        Integer status = Optional.ofNullable(dictDto).map(DictDto::getStatus).orElse(0);
        if (status == 0) {
            logger.info("\u914d\u7f6e\u5df2\u5173\uff0c\u65e0\u9700\u8ba1\u7b97\u8fd0\u8d39");
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)dgOrderReqDto.getOrderStatus()) && DgF2BOrderStatus.WAIT_CHECK.getCode().equals(dgOrderReqDto.getOrderStatus())) {
            logger.info("\u5355\u636e\u4e3a\u4fdd\u5b58\uff0c\u4e0d\u6821\u9a8c\u8fd0\u8d39");
            return true;
        }
        BigDecimal templateFreight = this.calculateFreight(provinceCode, f2BOrderPreviewContext);
        if (templateFreight.compareTo(BigDecimal.ZERO) <= 0) {
            logger.info("\u8fd0\u8d39\u91d1\u989d0");
            return true;
        }
        DgF2BPerformOrderReqDto f2BPerformOrder = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        BigDecimal orderFreight = f2BPerformOrder.getItemList().stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getItemAttribute()) && f.getItemAttribute().equals("10")).map(DgPerformOrderItemDto::getSaleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return orderFreight.compareTo(templateFreight) >= 0;
    }

    @Override
    public void calculateFreightItem(DgF2BOrderContextVo f2BOrderContextVo, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        logger.info("\u8ba1\u7b97\u8fd0\u8d39\u5546\u54c1\uff0cf2BOrderContextVo\uff1a{}", (Object)JSON.toJSONString((Object)f2BOrderContextVo));
        logger.info("\u8ba1\u7b97\u8fd0\u8d39\u5546\u54c1\uff0cf2BOrderPreviewContext\uff1a{}", (Object)JSON.toJSONString((Object)f2BOrderPreviewContext));
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("yunxi-dg-base-center-logistics", "freightItemConfig"));
        Integer status = Optional.ofNullable(dictDto).map(DictDto::getStatus).orElse(0);
        if (status == 0) {
            logger.info("\u914d\u7f6e\u5df2\u5173\uff0c\u65e0\u9700\u8ba1\u7b97\u8fd0\u8d39");
            return;
        }
        DgF2BPerformOrderReqDto f2BPerformOrder = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        List itemList = f2BPerformOrder.getItemList().stream().filter(f -> StringUtils.isBlank((CharSequence)f.getItemAttribute()) || !f.getItemAttribute().equals("10")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(itemList)) {
            logger.info("\u672c\u5355\u53ea\u6709\u8fd0\u8d39\u5546\u54c1");
            return;
        }
        f2BOrderPreviewContext.getDgF2BPerformOrderReqDto().setItemList(itemList);
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)f2BOrderContextVo.getPreviewReqDto().getOrderAddrReqDto()), (String)"\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        String provinceCode = f2BOrderContextVo.getPreviewReqDto().getOrderAddrReqDto().getProvinceCode();
        BigDecimal orderFreight = this.calculateFreight(provinceCode, f2BOrderPreviewContext);
        if (orderFreight.compareTo(BigDecimal.ZERO) <= 0) {
            logger.info("\u8fd0\u8d39\u91d1\u989d\u4e3a0");
            return;
        }
        Long shopId = ((OrderPreviewItemReqDto)f2BOrderContextVo.getPreviewReqDto().getItemList().get(0)).getShopId();
        Long customerId = f2BOrderContextVo.getPreviewReqDto().getCustomerId();
        DgItemSkuDetailRespDto freightItem = this.getFreightItem(shopId, customerId);
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)freightItem), (String)"\u627e\u4e0d\u5230\u8fd0\u8d39\u5546\u54c1");
        Map<Long, DgItemSkuPageRespDto> freightItemSkuMap = this.queryItemInfo(Lists.newArrayList((Object[])new Long[]{shopId}), Lists.newArrayList((Object[])new Long[]{freightItem.getId()}), Lists.newArrayList((Object[])new Long[]{freightItem.getItemId()}));
        AssertUtils.isFalse((boolean)ObjectUtil.isEmpty(freightItemSkuMap), (String)("\u83b7\u53d6\u4e0d\u5230\u8fd0\u8d39\u5546\u54c1\u4fe1\u606f\uff1a" + freightItem.getSkuCode()));
        DgItemSkuPageRespDto freightItemSku = freightItemSkuMap.get(freightItem.getId());
        BigDecimal freightItemNum = orderFreight.divide(freightItem.getRetailPrice(), 0, RoundingMode.CEILING);
        logger.info("\u8ba1\u7b97\u9700\u8981\u8fd0\u8d39\u5546\u54c1\u6570\u91cf\uff1a{}", (Object)freightItemNum);
        DgF2BPerformOrderReqDto f2BPerformOrderReqDto = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        boolean contains = f2BPerformOrderReqDto.getItemList().stream().map(DgPerformOrderItemDto::getSkuId).collect(Collectors.toList()).contains(freightItem.getId());
        if (contains) {
            f2BPerformOrderReqDto.getItemList().forEach(item -> {
                if (item.getSkuId().equals(freightItem.getId()) && item.getItemNum().compareTo(freightItemNum) < 0) {
                    item.setItemNum(freightItemNum);
                    item.setCalcItemNum(freightItemNum);
                    item.setPlaceItemNum(freightItemNum);
                }
            });
        } else {
            DgPreviewPerformOrderItemReqDto previewItemReqDto = new DgPreviewPerformOrderItemReqDto();
            previewItemReqDto.setAllowModifyPrice(false);
            previewItemReqDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
            previewItemReqDto.setItemNum(freightItemNum);
            previewItemReqDto.setBasicNum(freightItemNum);
            previewItemReqDto.setCalcItemNum(freightItemNum);
            previewItemReqDto.setRemark(null);
            previewItemReqDto.setStocksCode(freightItem.getItemCode());
            previewItemReqDto.setPlaceItemNum(previewItemReqDto.getItemNum());
            previewItemReqDto.setOrderItemUnit(freightItem.getSaleUnit());
            previewItemReqDto.setOrderItemUnitName(freightItem.getSaleUnitName());
            previewItemReqDto.setBeforeOrderItemId(null);
            previewItemReqDto.setBatchNo(null);
            this.SKU_ITEM_TO_PREVIEW_ITEM(previewItemReqDto, freightItemSku, freightItem.getRetailPrice());
            previewItemReqDto.setPrice(freightItem.getRetailPrice());
            previewItemReqDto.setSalePrice(freightItem.getRetailPrice());
            previewItemReqDto.setItemMarketPrice(freightItem.getRetailPrice());
            previewItemReqDto.setItemOrigPrice(freightItem.getRetailPrice());
            previewItemReqDto.setShopId(shopId.toString());
            previewItemReqDto.setSortNo(Long.valueOf(100000L));
            previewItemReqDto.setGift(YesNoEnum.NO.getValue());
            previewItemReqDto.setMaterial(YesNoEnum.NO.getValue());
            BigDecimal basicNum = Optional.ofNullable(previewItemReqDto.getBasicNum()).orElse(BigDecimal.ZERO);
            BigDecimal packingNumber = previewItemReqDto.getItemNum() != null && BigDecimal.ZERO.compareTo(previewItemReqDto.getItemNum()) < 0 ? basicNum.divide(previewItemReqDto.getItemNum(), 2, 4) : basicNum;
            previewItemReqDto.setPackingNumber(packingNumber);
            previewItemReqDto.setDiscountAmount(BigDecimal.ZERO);
            previewItemReqDto.setHandmadeDiscount(null);
            previewItemReqDto.setHandmadeDiscountAmount(null);
            previewItemReqDto.setIsRebate(YesNoEnum.NO.getValue());
            previewItemReqDto.setTotalUseCostAmount(BigDecimal.ZERO);
            f2BPerformOrderReqDto.getItemList().add(previewItemReqDto);
        }
        logger.info("\u8ba1\u7b97\u8fd0\u8d39\u5546\u54c1\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)f2BPerformOrderReqDto.getItemList()));
    }

    private DgItemSkuDetailRespDto getFreightItem(Long shopId, Long customerId) {
        DgEsCustomerBuyScopeItemQueryDto queryDto = new DgEsCustomerBuyScopeItemQueryDto();
        queryDto.setShopId(shopId);
        queryDto.setCustomerId(customerId);
        queryDto.setShelfStatus(YesNoEnum.YES.getValue());
        queryDto.setStatus(YesNoEnum.NO.getValue());
        queryDto.setItemAttribute(Integer.valueOf(10));
        queryDto.setPageSize(Integer.valueOf(1));
        logger.info("\u67e5\u8be2\u8fd0\u8d39\u5546\u54c1\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)queryDto));
        PageInfo itemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgCustomerBuyScopeItemQueryApiProxy.queryTobEsBuyScopeItemPage(queryDto));
        if (ObjectUtil.isEmpty((Object)itemRespDtoPageInfo) || CollectionUtil.isEmpty((Collection)itemRespDtoPageInfo.getList()) || CollectionUtil.isEmpty((Collection)((ShopItemEsRespDto)itemRespDtoPageInfo.getList().get(0)).getItemSkuList())) {
            return null;
        }
        logger.info("\u67e5\u8be2\u8fd0\u8d39\u5546\u54c1\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)itemRespDtoPageInfo));
        ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)((ShopItemEsRespDto)itemRespDtoPageInfo.getList().get(0)).getItemSkuList().get(0);
        DgItemSkuDetailRespDto respDto = new DgItemSkuDetailRespDto();
        respDto.setId(itemSkuDgDto.getId());
        respDto.setItemId(itemSkuDgDto.getItemId());
        respDto.setSkuCode(itemSkuDgDto.getCode());
        respDto.setSkuName(itemSkuDgDto.getName());
        respDto.setRetailPrice(itemSkuDgDto.getRetailPrice());
        respDto.setSaleUnit(itemSkuDgDto.getSaleUnit());
        respDto.setSaleUnitName(itemSkuDgDto.getSaleUnitName());
        respDto.setItemAttribute("10");
        return respDto;
    }

    private BigDecimal calculateFreight(String provinceCode, DgF2BOrderPreviewContext f2BOrderPreviewContext) {
        logger.info("\u8ba1\u7b97\u5355\u636e\u8fd0\u8d39\u91d1\u989d\uff1a{}\uff0c{}", (Object)provinceCode, (Object)JSON.toJSONString((Object)f2BOrderPreviewContext));
        DgF2BPerformOrderReqDto f2BPerformOrder = f2BOrderPreviewContext.getDgF2BPerformOrderReqDto();
        DgFreightTemplateAdaptDto adaptDto = new DgFreightTemplateAdaptDto();
        adaptDto.setOrder(f2BPerformOrder.getSaleOrderNo());
        adaptDto.setProvinceCode(provinceCode);
        Optional.ofNullable(f2BOrderPreviewContext.getDgCustomerRespDto()).ifPresent(customer -> {
            DgFreightTemplateCustomerAdaptDto customerAdaptDto = new DgFreightTemplateCustomerAdaptDto();
            customerAdaptDto.setCustomerCode(customer.getCode());
            customerAdaptDto.setCustomerName(customer.getCustomerName());
            if (ObjectUtil.isNotEmpty((Object)f2BPerformOrder.getPerformOrderSnapshotDto()) && ObjectUtil.isNotEmpty((Object)f2BPerformOrder.getPerformOrderSnapshotDto().getShopId())) {
                CsOrgCustomerRelationPageReqDto relationPageReqDto = new CsOrgCustomerRelationPageReqDto();
                relationPageReqDto.setCustomerId(customer.getId());
                relationPageReqDto.setCustomerCode(customer.getCode());
                relationPageReqDto.setShopIdList((List)Lists.newArrayList((Object[])new Long[]{f2BPerformOrder.getPerformOrderSnapshotDto().getShopId()}));
                logger.info("\u83b7\u53d6\u5ba2\u6237\u4ea4\u6613\u5173\u7cfb\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)relationPageReqDto));
                List relationDtoList = (List)RestResponseHelper.extractData((RestResponse)this.tobOrgCustomerRelationQueryApiProxy.queryTobCustomerRelationList(relationPageReqDto));
                if (CollectionUtil.isNotEmpty((Collection)relationDtoList)) {
                    logger.info("\u83b7\u53d6\u5ba2\u6237\u4ea4\u6613\u5173\u7cfb\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)relationDtoList));
                    CsOrgCustomerRelationDto relationDto = (CsOrgCustomerRelationDto)relationDtoList.get(0);
                    customerAdaptDto.setCustomerBusinessCode((String)Optional.ofNullable(relationDto.getAreaId()).map(Object::toString).orElse(null));
                    customerAdaptDto.setCustomerlevel((String)Optional.ofNullable(relationDto.getLevelId()).map(Object::toString).orElse(null));
                    customerAdaptDto.setCustomerType((String)Optional.ofNullable(relationDto.getCustomerTypeId()).map(Object::toString).orElse(null));
                    customerAdaptDto.setCustomerGroup((String)Optional.ofNullable(relationDto.getCustomerGroupId()).map(Object::toString).orElse(null));
                }
            }
            adaptDto.setDgFreightTemplateCustomerAdaptDto(customerAdaptDto);
        });
        List itemList = f2BPerformOrder.getItemList().stream().filter(f -> StringUtils.isBlank((CharSequence)f.getItemAttribute()) || !f.getItemAttribute().equals("10")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(itemList)) {
            logger.info("\u65e0\u9700\u8ba1\u7b97\u8fd0\u8d39\u7684\u5546\u54c1");
            return BigDecimal.ONE;
        }
        List itemDtoList = itemList.stream().map(item -> {
            DgFreightTemplateItemDto templateItemDto = new DgFreightTemplateItemDto();
            templateItemDto.setSkuCode(item.getSkuCode());
            templateItemDto.setItemNum(item.getItemNum());
            templateItemDto.setWeight(item.getWeight());
            templateItemDto.setUnit(item.getCalcUnit());
            return templateItemDto;
        }).collect(Collectors.toList());
        adaptDto.setDgFreightTemplateItemDtos(itemDtoList);
        logger.info("\u8ba1\u7b97\u5355\u636e\u8fd0\u8d39\u91d1\u989d\uff1a{}", (Object)JSON.toJSONString((Object)adaptDto));
        DgFreightTemplateAdaptDto templateAdaptDto = (DgFreightTemplateAdaptDto)RestResponseHelper.extractData((RestResponse)this.freightTemplateApiProxy.adapt(adaptDto));
        logger.info("\u8ba1\u7b97\u5355\u636e\u8fd0\u8d39\u91d1\u989d\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)templateAdaptDto));
        return templateAdaptDto.getTotalAmount();
    }

    private Map<Long, DgItemSkuPageRespDto> queryItemInfo(List<Long> shopIds, List<Long> skuIds, List<Long> itemIds) {
        PageInfo<DgItemSkuPageRespDto> pageInfo = this.preInfoQueryAction.queryShopSkuList(shopIds, skuIds, itemIds, Lists.newArrayList((Object[])new Integer[]{YesNoEnum.YES.getValue()}));
        Map<Long, DgItemSkuPageRespDto> shelfItemMap = pageInfo.getList().stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        return shelfItemMap;
    }

    private void SKU_ITEM_TO_PREVIEW_ITEM(DgPreviewPerformOrderItemReqDto previewItemReqDto, DgItemSkuPageRespDto itemSkuRespDto, BigDecimal dgPolicyPrice) {
        previewItemReqDto.setImgUrl(CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getImgUrlList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getImgUrlList().get(0)).getPath1() : (CollectionUtil.isNotEmpty((Collection)itemSkuRespDto.getMediaMainList()) ? ((ItemMediasDgRespDto)itemSkuRespDto.getMediaMainList().get(0)).getPath1() : null));
        previewItemReqDto.setItemId(itemSkuRespDto.getItemId());
        previewItemReqDto.setItemCode(itemSkuRespDto.getItemCode());
        previewItemReqDto.setItemName(itemSkuRespDto.getItemName());
        previewItemReqDto.setItemAttr(itemSkuRespDto.getItemAttribute());
        previewItemReqDto.setSkuId(itemSkuRespDto.getId());
        previewItemReqDto.setSkuCode(itemSkuRespDto.getSkuCode());
        previewItemReqDto.setSkuName(itemSkuRespDto.getSkuName());
        previewItemReqDto.setSkuDesc(itemSkuRespDto.getSpecOne());
        previewItemReqDto.setCatalogSerial(itemSkuRespDto.getDirId() + "");
        previewItemReqDto.setBrandSerial(itemSkuRespDto.getBrandId() + "");
        previewItemReqDto.setCatalogName(itemSkuRespDto.getDirName());
        previewItemReqDto.setOriginalSkuCode(itemSkuRespDto.getOriginalCode());
        previewItemReqDto.setBasicUnit(itemSkuRespDto.getUnit());
        previewItemReqDto.setBasicUnitName(itemSkuRespDto.getUnitName());
        previewItemReqDto.setCalcUnitSymbol(itemSkuRespDto.getPriceUnit());
        previewItemReqDto.setCalcUnitDesc(itemSkuRespDto.getPriceUnitName());
        previewItemReqDto.setType(itemSkuRespDto.getItemType() == null ? "" : itemSkuRespDto.getItemType().toString());
        previewItemReqDto.setItemAttribute(itemSkuRespDto.getItemAttribute());
        previewItemReqDto.setPackageNum(itemSkuRespDto.getPackageNum());
        previewItemReqDto.setLimitMin(itemSkuRespDto.getLimitMin());
        previewItemReqDto.setItemSaleUnitCode(itemSkuRespDto.getSaleUnit());
        previewItemReqDto.setItemSaleUnitName(itemSkuRespDto.getSaleUnitName());
        previewItemReqDto.setItemSaleUnitNum(previewItemReqDto.getItemNum());
        previewItemReqDto.setSaleAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setItemOrigAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setPayAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setRealPayAmount(dgPolicyPrice.multiply(previewItemReqDto.getItemNum()));
        if (StringUtils.isEmpty((CharSequence)previewItemReqDto.getOrderItemUnit())) {
            previewItemReqDto.setOrderItemUnit(Optional.ofNullable(itemSkuRespDto.getSaleUnit()).orElse(itemSkuRespDto.getUnit()));
        }
        if (StringUtils.isEmpty((CharSequence)previewItemReqDto.getOrderItemUnitName())) {
            previewItemReqDto.setOrderItemUnitName(Optional.ofNullable(itemSkuRespDto.getSaleUnitName()).orElse(itemSkuRespDto.getUnitName()));
        }
        ItemUnitConversionDgDto unitConversionDgDto = ((List)Optional.ofNullable(itemSkuRespDto.getUnitConvertList()).orElse(new ArrayList())).stream().filter(o -> Objects.equals(previewItemReqDto.getOrderItemUnit(), o.getConversionUnit())).findFirst().orElse(new ItemUnitConversionDgDto());
        BigDecimal weight = Optional.ofNullable(unitConversionDgDto.getGrossWeight()).orElse(BigDecimal.ZERO);
        String weightUnit = StringUtils.isBlank((CharSequence)unitConversionDgDto.getWeightUnit()) ? "KG" : unitConversionDgDto.getWeightUnit();
        BigDecimal volume = Optional.ofNullable(unitConversionDgDto.getVolume()).orElse(BigDecimal.ZERO);
        String volumeUnit = unitConversionDgDto.getVolumeUnit();
        previewItemReqDto.setLength(unitConversionDgDto.getLength());
        previewItemReqDto.setHeight(unitConversionDgDto.getHeight());
        previewItemReqDto.setWidth(unitConversionDgDto.getWidth());
        previewItemReqDto.setWeight(Optional.ofNullable(UnitConverUtil.toKg(weight, weightUnit)).orElse(BigDecimal.ZERO).multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setWeightUnit("KG");
        previewItemReqDto.setVolume(Optional.ofNullable(UnitConverUtil.convertToCubicMeter(volume, volumeUnit)).orElse(BigDecimal.ZERO).multiply(previewItemReqDto.getItemNum()));
        previewItemReqDto.setUnitConvertList(itemSkuRespDto.getUnitConvertList());
    }
}

