/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgPlatFormEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyRuleSuitTypeEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgReceiveStrategyConverter;
import com.yunxi.dg.base.center.trade.dao.vo.DgReceiveStrategyVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgReceiveStrategyDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.dto.entity.DgReceiveStrategyDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgReceiveStrategyPageReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgReceiveStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.eo.DgReceiveStrategyEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleSuitEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgReceiveStrategyService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateInUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgReceiveStrategyServiceImpl
extends BaseServiceImpl<DgReceiveStrategyDto, DgReceiveStrategyEo, IDgReceiveStrategyDomain>
implements IDgReceiveStrategyService,
IResetRedisNoIndexCommon {
    private static final Logger log = LoggerFactory.getLogger(DgReceiveStrategyServiceImpl.class);
    @Resource
    private IDgReceiveStrategyDomain domain;
    @Resource
    private NoGreateInUtil noGreateInUtil;
    @Resource
    private IDgStrategyRuleDomain dgStrategyRuleDomain;
    @Resource
    private IDgStrategyConfItemDomain dgStrategyConfItemDomain;
    @Resource
    private IDgStrategyRuleSuitDomain dgStrategyRuleSuitDomain;

    public DgReceiveStrategyServiceImpl(IDgReceiveStrategyDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgReceiveStrategyDto, DgReceiveStrategyEo> converter() {
        return DgReceiveStrategyConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<DgReceiveStrategyDto>> pageParam(DgReceiveStrategyPageReqDto reqDto) {
        DgReceiveStrategyDto querDto = new DgReceiveStrategyDto();
        querDto.setChannelCodeList(reqDto.getChannelCodeList());
        List dgStrategyRuleEos = this.dgStrategyRuleDomain.queryByParam(querDto);
        ArrayList dgReceiveStrategyDtos = new ArrayList();
        Map<Long, List<DgReceiveStrategyVo>> collect = dgStrategyRuleEos.stream().collect(Collectors.groupingBy(BaseRespDto::getId));
        collect.forEach((k, v) -> {
            DgReceiveStrategyDto dgReceiveStrategyDto = new DgReceiveStrategyDto();
            for (DgReceiveStrategyVo dgReceiveStrategyVo : v) {
                String content;
                CubeBeanUtils.copyProperties((Object)dgReceiveStrategyDto, (Object)dgReceiveStrategyVo, (String[])new String[0]);
                if (dgReceiveStrategyVo.getStrategyType().equals(DgStrategyConfItemTypeEnum.ADAPTATION_CHANNEL.getCode())) {
                    content = dgReceiveStrategyVo.getContent();
                    HashMap hashMap = (HashMap)JSON.parseObject((String)content, Map.class);
                    hashMap.forEach((i, h) -> {
                        dgReceiveStrategyDto.setChannelCode(i);
                        dgReceiveStrategyDto.setChannelName(h);
                    });
                    dgReceiveStrategyDto.setId(dgReceiveStrategyVo.getRuleId());
                }
                if (!dgReceiveStrategyVo.getStrategyType().equals(DgStrategyConfItemTypeEnum.TIME_LIMIT.getCode())) continue;
                content = dgReceiveStrategyVo.getContent();
                dgReceiveStrategyDto.setStrategyDay(Integer.valueOf(content));
            }
            dgReceiveStrategyDtos.add(dgReceiveStrategyDto);
        });
        List receiveStrategyDtos = dgReceiveStrategyDtos.stream().sorted(Comparator.comparing(BaseDto::getCreateTime).reversed()).collect(Collectors.toList());
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPages(reqDto.getPageNum().intValue());
        pageInfo.setPageSize(reqDto.getPageSize().intValue());
        pageInfo.setList(receiveStrategyDtos);
        pageInfo.setTotal((long)receiveStrategyDtos.size());
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public RestResponse<List<DgReceiveStrategyDto>> queryParam(DgReceiveStrategyPageReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"reqDto\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgReceiveStrategyDto querDto = new DgReceiveStrategyDto();
        querDto.setChannelCodeList(reqDto.getChannelCodeList());
        List dgStrategyRuleEos = this.dgStrategyRuleDomain.queryByParam(querDto);
        ArrayList dgReceiveStrategyDtos = new ArrayList();
        Map<Long, List<DgReceiveStrategyVo>> collect = dgStrategyRuleEos.stream().collect(Collectors.groupingBy(BaseRespDto::getId));
        collect.forEach((k, v) -> {
            DgReceiveStrategyDto dgReceiveStrategyDto = new DgReceiveStrategyDto();
            for (DgReceiveStrategyVo dgReceiveStrategyVo : v) {
                String content;
                CubeBeanUtils.copyProperties((Object)dgReceiveStrategyDto, (Object)dgReceiveStrategyVo, (String[])new String[0]);
                if (dgReceiveStrategyVo.getStrategyType().equals(DgStrategyConfItemTypeEnum.ADAPTATION_CHANNEL.getCode())) {
                    content = dgReceiveStrategyVo.getContent();
                    HashMap hashMap = (HashMap)JSON.parseObject((String)content, Map.class);
                    hashMap.forEach((i, h) -> {
                        dgReceiveStrategyDto.setChannelCode(i);
                        dgReceiveStrategyDto.setChannelName(h);
                    });
                    dgReceiveStrategyDto.setId(dgReceiveStrategyVo.getRuleId());
                }
                if (!dgReceiveStrategyVo.getStrategyType().equals(DgStrategyConfItemTypeEnum.TIME_LIMIT.getCode())) continue;
                content = dgReceiveStrategyVo.getContent();
                dgReceiveStrategyDto.setStrategyDay(Integer.valueOf(content));
            }
            dgReceiveStrategyDtos.add(dgReceiveStrategyDto);
        });
        return new RestResponse(dgReceiveStrategyDtos);
    }

    @Override
    public RestResponse<Void> logicProDelete(Long idLong) {
        this.dgStrategyRuleDomain.logicDeleteById(idLong);
        StrategyConfItemEo strategyConfItemEo = new StrategyConfItemEo();
        strategyConfItemEo.setRuleId(idLong);
        this.dgStrategyConfItemDomain.logicDelete((BaseEo)strategyConfItemEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Long> insertReceiveStrategy(DgReceiveStrategyDto reqDto) {
        List dgStrategyRuleEos = this.dgStrategyRuleDomain.queryByParam(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)dgStrategyRuleEos)) {
            throw new BizException("\u8be5\u6e20\u9053\u5df2\u7ecf\u5b58\u5728\u7b56\u7565");
        }
        DgStrategyRuleEo dgStrategyRuleEo = new DgStrategyRuleEo();
        CubeBeanUtils.copyProperties((Object)dgStrategyRuleEo, (Object)reqDto, (String[])new String[0]);
        String code = DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_POLICY.getCode();
        dgStrategyRuleEo.setStrategyType(code);
        dgStrategyRuleEo.setRuleCode(this.noGreateInUtil.confirmReceiptStrategyRuleNo());
        dgStrategyRuleEo.setPlatForm(DgPlatFormEnum.PLATFORM_2C.getCode());
        dgStrategyRuleEo.setPeriodicStart(reqDto.getStartTime());
        dgStrategyRuleEo.setPeriodicEnd(reqDto.getEndTime());
        this.dgStrategyRuleDomain.insert((BaseEo)dgStrategyRuleEo);
        Long id = dgStrategyRuleEo.getId();
        DgStrategyRuleSuitEo dgStrategyRuleSuitEo = new DgStrategyRuleSuitEo();
        dgStrategyRuleSuitEo.setRuleId(id);
        dgStrategyRuleSuitEo.setSuitMatchCode(DgStrategyRuleSuitTypeEnum.SUITTYPE_ALL.getCode() + "_ALL");
        dgStrategyRuleSuitEo.setSuitKey("ALL");
        dgStrategyRuleSuitEo.setSuitType(DgStrategyRuleSuitTypeEnum.SUITTYPE_ALL.getCode());
        dgStrategyRuleSuitEo.setSuitSelectType("ALL");
        dgStrategyRuleSuitEo.setStrategyType(DgCisStrategyOrderTypeEnum.CONFIRM_RECEIPT_POLICY.getCode());
        dgStrategyRuleSuitEo.setMd5("1");
        this.dgStrategyRuleSuitDomain.insert((BaseEo)dgStrategyRuleSuitEo);
        DgReceiveStrategyRuleReqDto.DetermineDeliveryTime deliveryTime = new DgReceiveStrategyRuleReqDto.DetermineDeliveryTime(reqDto.getStrategyDay());
        deliveryTime.setRuleId(id);
        DgReceiveStrategyRuleReqDto.ReceiveStrategyChannel receiveStrategyChannel = new DgReceiveStrategyRuleReqDto.ReceiveStrategyChannel(reqDto.getChannelCode(), reqDto.getChannelName());
        receiveStrategyChannel.setRuleId(id);
        ArrayList<StrategyConfItemEo> strategyConfItemEos = new ArrayList<StrategyConfItemEo>();
        StrategyConfItemEo deliveryTimeEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)deliveryTimeEo, (Object)deliveryTime, (String[])new String[0]);
        strategyConfItemEos.add(deliveryTimeEo);
        StrategyConfItemEo receiveStrategyChannelEo = new StrategyConfItemEo();
        CubeBeanUtils.copyProperties((Object)receiveStrategyChannelEo, (Object)receiveStrategyChannel, (String[])new String[0]);
        receiveStrategyChannelEo.setExtension(reqDto.getChannelCode());
        strategyConfItemEos.add(receiveStrategyChannelEo);
        this.dgStrategyConfItemDomain.insertBatch(strategyConfItemEos);
        return new RestResponse((Object)id);
    }

    @Override
    public RestResponse<Integer> updateReceiveStrategy(DgReceiveStrategyDto reqDto) {
        log.info("\u7f16\u8f91\u7b56\u7565");
        StrategyConfItemEo strategyConfItemEo = new StrategyConfItemEo();
        strategyConfItemEo.setRuleId(reqDto.getId());
        List strategyConfItemEos = this.dgStrategyConfItemDomain.selectList((BaseEo)strategyConfItemEo, Integer.valueOf(1), Integer.valueOf(1000));
        Map confItemEoMap = strategyConfItemEos.stream().collect(Collectors.toMap(StrategyConfItemEo::getStrategyType, Function.identity()));
        log.info("\u6267\u884c\u5b8c\u5faa\u73af\u524d:{}", confItemEoMap.values());
        confItemEoMap.forEach((k, v) -> {
            if (k.equals(DgStrategyConfItemTypeEnum.TIME_LIMIT.getCode())) {
                DgReceiveStrategyRuleReqDto.DetermineDeliveryTime deliveryTime = new DgReceiveStrategyRuleReqDto.DetermineDeliveryTime(reqDto.getStrategyDay());
                CubeBeanUtils.copyProperties((Object)v, (Object)deliveryTime, (String[])new String[0]);
            }
            if (k.equals(DgStrategyConfItemTypeEnum.ADAPTATION_CHANNEL.getCode())) {
                DgReceiveStrategyRuleReqDto.ReceiveStrategyChannel receiveStrategyChannel = new DgReceiveStrategyRuleReqDto.ReceiveStrategyChannel(reqDto.getChannelCode(), reqDto.getChannelName());
                CubeBeanUtils.copyProperties((Object)v, (Object)receiveStrategyChannel, (String[])new String[0]);
                v.setExtension(receiveStrategyChannel.getChannelCode());
            }
        });
        log.info("\u6267\u884c\u5b8c\u5faa\u73af\u540e:{}", confItemEoMap.values());
        Collection values = confItemEoMap.values();
        for (StrategyConfItemEo value : values) {
            this.dgStrategyConfItemDomain.updateSelective((BaseEo)value);
        }
        DgStrategyRuleEo dgStrategyRuleEo = new DgStrategyRuleEo();
        dgStrategyRuleEo.setId(reqDto.getId());
        dgStrategyRuleEo.setUpdatePerson(reqDto.getUpdatePerson());
        dgStrategyRuleEo.setUpdateTime(new Date());
        log.info("\u6267\u884c\u66f4\u65b0\u524d\u5bf9\u8c61:{}", (Object)dgStrategyRuleEo);
        this.dgStrategyRuleDomain.updateSelective((BaseEo)dgStrategyRuleEo);
        return RestResponse.createInteger((Integer)1);
    }

    @Override
    public RestResponse<DgReceiveStrategyDto> getReceiveStrategy(Long idLong) {
        StrategyConfItemEo deliveryTimeEo = new StrategyConfItemEo();
        deliveryTimeEo.setRuleId(idLong);
        DgReceiveStrategyDto dgReceiveStrategyDto = new DgReceiveStrategyDto();
        List strategyConfItemEos = this.dgStrategyConfItemDomain.selectList((BaseEo)deliveryTimeEo);
        StrategyConfItemEo strategyConfItemEo1 = (StrategyConfItemEo)strategyConfItemEos.get(0);
        CubeBeanUtils.copyProperties((Object)dgReceiveStrategyDto, (Object)strategyConfItemEo1, (String[])new String[0]);
        for (StrategyConfItemEo strategyConfItemEo : strategyConfItemEos) {
            String content;
            if (strategyConfItemEo.getStrategyType().equals(DgStrategyConfItemTypeEnum.ADAPTATION_CHANNEL.getCode())) {
                content = strategyConfItemEo.getContent();
                HashMap hashMap = (HashMap)JSON.parseObject((String)content, Map.class);
                dgReceiveStrategyDto.setChannelCode(strategyConfItemEo.getExtension());
                dgReceiveStrategyDto.setChannelName((String)hashMap.get(strategyConfItemEo.getExtension()));
            }
            if (!strategyConfItemEo.getStrategyType().equals(DgStrategyConfItemTypeEnum.TIME_LIMIT.getCode())) continue;
            content = strategyConfItemEo.getContent();
            dgReceiveStrategyDto.setStrategyDay(Integer.valueOf(content));
        }
        return new RestResponse((Object)dgReceiveStrategyDto);
    }

    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.eq(DgStrategyRuleEo::getStrategyType, (Object)"CONFIRM_RECEIPT_POLICY")).orderByDesc(BaseEo::getId)).orderByDesc(BaseEo::getCreateTime)).last(" limit 1");
        DgStrategyRuleEo dgStrategyRuleEo = this.dgStrategyRuleDomain.getOne(queryOrderWrapper);
        if (dgStrategyRuleEo == null) {
            return "";
        }
        return dgStrategyRuleEo.getRuleCode();
    }
}

