/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.orderStrategy.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskQueryReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskUpdateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.TaskQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.ITaskQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyContentTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgCisStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgPlatFormEnum;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyReturnNoSourceMatchRuleReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyReturnNoSourceMatchRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemEo;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyReturnNoSourceMatchRuleService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgStrategyReturnNoSourceMatchRuleServiceImpl
implements IDgStrategyReturnNoSourceMatchRuleService {
    private static final Logger log = LoggerFactory.getLogger(DgStrategyReturnNoSourceMatchRuleServiceImpl.class);
    @Resource
    private IDgStrategyRuleDomain dgStrategyRuleDomain;
    @Resource
    private IDgStrategyConfItemDomain dgStrategyConfItemDomain;
    @Resource
    private ITaskApi taskApi;
    @Resource
    private ITaskQueryApi taskQueryApiApi;
    @Value(value="${scheduler.client.app_code:yunxi-dg-base-center-trade}")
    private String appCode;
    private static final List<DgStrategyConfItemTypeEnum> MATCH_TYPES = Lists.newArrayList((Object[])new DgStrategyConfItemTypeEnum[]{DgStrategyConfItemTypeEnum.RETURN_NO_SOURCE_MATCH_ENABLED, DgStrategyConfItemTypeEnum.RETURN_NO_SOURCE_MATCH_TIME, DgStrategyConfItemTypeEnum.RETURN_NO_SOURCE_MATCH_UNSUCCESS_WORK_MODE, DgStrategyConfItemTypeEnum.RETURN_NO_SOURCE_MATCH_SUMMARY_METHOD, DgStrategyConfItemTypeEnum.WMS_RETURN_WAREHOUSE_TYPE});
    private static final List<DgStrategyConfItemTypeEnum> STRING_TYPES = Lists.newArrayList((Object[])new DgStrategyConfItemTypeEnum[]{DgStrategyConfItemTypeEnum.RETURN_NO_SOURCE_MATCH_TIME, DgStrategyConfItemTypeEnum.WMS_RETURN_WAREHOUSE_TYPE});
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("ss mm HH * * ? *");
    private static final String TASK_BIZ_NAME = "\u9000\u8d27\u65e0\u5934\u4ef6\u5339\u914d\u5b9a\u65f6\u4efb\u52a1";
    private static final String TASK_BIZ_CODE = "noSourceReturnRecordMatchJob";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(DgStrategyReturnNoSourceMatchRuleReqDto reqDto) {
        DgStrategyRuleEo ruleEo = this.getDgStrategyRuleEo();
        boolean enabled = true;
        if (Objects.equals(reqDto.getMatchEnabled(), 1)) {
            AssertUtils.notBlank((String)reqDto.getAutoMatchTime(), (String)"\u81ea\u52a8\u5339\u914d\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            enabled = false;
            reqDto.setAutoMatchTime(null);
        }
        StrategyConfItemEo strategyConfItemEo = new StrategyConfItemEo();
        Long id = ruleEo.getId();
        strategyConfItemEo.setRuleId(id);
        List confItemEos = this.dgStrategyConfItemDomain.selectList((BaseEo)strategyConfItemEo);
        for (StrategyConfItemEo confItemEo : confItemEos) {
            DgStrategyConfItemTypeEnum confItemTypeEnum = DgStrategyConfItemTypeEnum.forCode((String)confItemEo.getStrategyType());
            switch (confItemTypeEnum) {
                case RETURN_NO_SOURCE_MATCH_ENABLED: {
                    this.updateContentWithCheck(confItemEo, String.valueOf(reqDto.getMatchEnabled()));
                    break;
                }
                case RETURN_NO_SOURCE_MATCH_TIME: {
                    if (!Objects.nonNull(reqDto.getAutoMatchTime())) break;
                    AssertUtils.isTrue((boolean)DgStrategyReturnNoSourceMatchRuleServiceImpl.isValidTimeFormat(reqDto.getAutoMatchTime()), (String)"\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
                    this.updateContentWithCheck(confItemEo, reqDto.getAutoMatchTime());
                    break;
                }
                case RETURN_NO_SOURCE_MATCH_UNSUCCESS_WORK_MODE: {
                    this.updateContentWithCheck(confItemEo, String.valueOf(reqDto.getMatchUnsucessWorkMode()));
                    break;
                }
                case RETURN_NO_SOURCE_MATCH_SUMMARY_METHOD: {
                    this.updateContentWithCheck(confItemEo, String.valueOf(reqDto.getSummaryMethod()));
                    break;
                }
                case WMS_RETURN_WAREHOUSE_TYPE: {
                    this.updateContentWithCheck(confItemEo, String.valueOf(reqDto.getWmsReturnWarehouseType()));
                    break;
                }
            }
        }
        this.updateTaskTime(reqDto.getAutoMatchTime(), enabled);
    }

    private void updateTaskTime(String autoMatchTime, boolean enabled) {
        TaskQueryRespDto taskQueryRespDto = this.getTask();
        if (enabled) {
            String expression = DgStrategyReturnNoSourceMatchRuleServiceImpl.convertToCronLikeFormat(autoMatchTime);
            if (Objects.isNull(taskQueryRespDto)) {
                RestResponse<Long> addResult = this.initTask(expression);
                RestResponseHelper.extractData((RestResponse)this.taskApi.enableById((Long)addResult.getData(), "{}"));
                log.info("\u65b0\u589e\u4efb\u52a1: {}, {}", (Object)TASK_BIZ_NAME, (Object)JSONObject.toJSONString(addResult));
            } else if (!Objects.equals(taskQueryRespDto.getScheduleExpression(), expression)) {
                TaskUpdateReqDto dto = new TaskUpdateReqDto();
                dto.setScheduleExpression(expression);
                dto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
                dto.setTenantId(ServiceContext.getContext().getRequestTenantId());
                RestResponseHelper.extractData((RestResponse)this.taskApi.modifyById(taskQueryRespDto.getId(), dto));
                log.info("\u66f4\u65b0\u5e76\u542f\u7528\u4efb\u52a1: {}, {}", (Object)TASK_BIZ_NAME, (Object)JSONObject.toJSONString((Object)taskQueryRespDto));
                try {
                    RestResponseHelper.extractData((RestResponse)this.taskApi.enableById(taskQueryRespDto.getId(), "{}"));
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        } else if (Objects.nonNull(taskQueryRespDto) && Objects.equals(taskQueryRespDto.getStatus(), "ENABLE")) {
            try {
                log.info("\u7981\u7528\u4efb\u52a1: {}, {}", (Object)TASK_BIZ_NAME, (Object)JSONObject.toJSONString((Object)taskQueryRespDto));
                RestResponseHelper.extractData((RestResponse)this.taskApi.disableById(taskQueryRespDto.getId(), "{}"));
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    @Override
    public DgStrategyReturnNoSourceMatchRuleRespDto get() {
        DgStrategyRuleEo ruleEo = this.getDgStrategyRuleEo();
        DgStrategyReturnNoSourceMatchRuleRespDto respDto = new DgStrategyReturnNoSourceMatchRuleRespDto();
        if (Objects.isNull(ruleEo)) {
            this.addData();
        } else {
            StrategyConfItemEo strategyConfItemEo = new StrategyConfItemEo();
            strategyConfItemEo.setRuleId(ruleEo.getId());
            List confItemEos = this.dgStrategyConfItemDomain.selectList((BaseEo)strategyConfItemEo);
            for (StrategyConfItemEo confItemEo : confItemEos) {
                DgStrategyConfItemTypeEnum confItemTypeEnum = DgStrategyConfItemTypeEnum.forCode((String)confItemEo.getStrategyType());
                switch (confItemTypeEnum) {
                    case RETURN_NO_SOURCE_MATCH_ENABLED: {
                        respDto.setMatchEnabled(Integer.valueOf(Integer.parseInt(confItemEo.getContent())));
                        break;
                    }
                    case RETURN_NO_SOURCE_MATCH_TIME: {
                        respDto.setAutoMatchTime(confItemEo.getContent());
                        break;
                    }
                    case RETURN_NO_SOURCE_MATCH_UNSUCCESS_WORK_MODE: {
                        respDto.setMatchUnsucessWorkMode(Integer.valueOf(Integer.parseInt(confItemEo.getContent())));
                        break;
                    }
                    case RETURN_NO_SOURCE_MATCH_SUMMARY_METHOD: {
                        respDto.setSummaryMethod(Integer.valueOf(Integer.parseInt(confItemEo.getContent())));
                        break;
                    }
                    case WMS_RETURN_WAREHOUSE_TYPE: {
                        respDto.setWmsReturnWarehouseType(confItemEo.getContent());
                        break;
                    }
                }
            }
        }
        return respDto;
    }

    private void addData() {
        DgStrategyRuleEo eo = new DgStrategyRuleEo();
        eo.setStrategyType(DgCisStrategyOrderTypeEnum.RETURN_NO_SOURCE_MATCH_RULE.getCode());
        eo.setRuleCode("returnNoSourceMatchRule");
        eo.setPriority(Integer.valueOf(0));
        eo.setPlatForm(DgPlatFormEnum.PLATFORM_2C.getCode());
        eo.setPeriodicStatus(Integer.valueOf(1));
        this.dgStrategyRuleDomain.insert((BaseEo)eo);
        Long id = eo.getId();
        MATCH_TYPES.forEach(confItemTypeEnum -> {
            StrategyConfItemEo confItemEo = new StrategyConfItemEo();
            confItemEo.setRuleId(id);
            confItemEo.setStrategyType(confItemTypeEnum.getCode());
            confItemEo.setStrategyTypeName(confItemTypeEnum.getDesc());
            confItemEo.setEnable(Integer.valueOf(1));
            if (STRING_TYPES.contains(confItemTypeEnum)) {
                confItemEo.setContentType(CisStrategyContentTypeEnum.STRING.getCode());
                confItemEo.setContent(null);
            } else {
                confItemEo.setContentType(CisStrategyContentTypeEnum.NUMBER.getCode());
                confItemEo.setContent("0");
            }
            confItemEo.setMd5(MD5Util.getMd5ByString((String)StringUtils.joinWith((String)"#", (Object[])new Object[]{confItemEo.getEnable(), confItemEo.getContent()})));
            this.dgStrategyConfItemDomain.insert((BaseEo)confItemEo);
        });
    }

    private DgStrategyRuleEo getDgStrategyRuleEo() {
        DgStrategyRuleEo queryEo = new DgStrategyRuleEo();
        queryEo.setStrategyType(DgCisStrategyOrderTypeEnum.RETURN_NO_SOURCE_MATCH_RULE.getCode());
        queryEo.setRuleCode("returnNoSourceMatchRule");
        DgStrategyRuleEo ruleEo = (DgStrategyRuleEo)this.dgStrategyRuleDomain.selectOne((BaseEo)queryEo);
        return ruleEo;
    }

    private void updateContentWithCheck(StrategyConfItemEo confItemEo, String newContent) {
        if (!Objects.equals(confItemEo.getContent(), newContent)) {
            confItemEo.setContent(newContent);
            this.dgStrategyConfItemDomain.updateSelective((BaseEo)confItemEo);
            log.info("\u5df2\u66f4\u65b0\u7b56\u7565\u9879\u5185\u5bb9: {}, {}", (Object)confItemEo.getStrategyTypeName(), (Object)newContent);
        }
    }

    private RestResponse<Long> initTask(String expression) {
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode(TASK_BIZ_CODE);
        dto.setBizName(TASK_BIZ_NAME);
        dto.setScheduleExpression(expression);
        dto.setShardType("SINGLE");
        dto.setTaskBatchId(null);
        dto.setTaskDesc(TASK_BIZ_NAME);
        dto.setTaskName(TASK_BIZ_NAME);
        dto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        dto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        RestResponse addResult = this.taskApi.addWithBiz(dto);
        return addResult;
    }

    private TaskQueryRespDto getTask() {
        TaskQueryReqDto taskQueryReqDto = new TaskQueryReqDto();
        taskQueryReqDto.setAppCode(this.appCode);
        taskQueryReqDto.setTaskName(TASK_BIZ_NAME);
        PageInfo taskQueryRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.taskQueryApiApi.queryByPage(JacksonUtil.toJson((Object)taskQueryReqDto), Integer.valueOf(1), Integer.valueOf(1)));
        if (taskQueryRespDtoPageInfo != null && CollUtil.isNotEmpty((Collection)taskQueryRespDtoPageInfo.getList())) {
            return (TaskQueryRespDto)taskQueryRespDtoPageInfo.getList().get(0);
        }
        return null;
    }

    private static boolean isValidTimeFormat(String timeStr) {
        try {
            LocalTime.parse(timeStr, formatter);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private static String convertToCronLikeFormat(String timeStr) {
        LocalTime time = LocalTime.parse(timeStr, formatter);
        return outputFormatter.format(time);
    }
}

