/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.IdGenrator;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgBusinessDgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgCustomerDgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.service.orderStrategy.impl.DgReceiveStrategyServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NoGreateInUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoGreateInUtil.class);
    private static final int EXPIRE_TIME = 90000;
    @Resource
    protected ICacheService cacheService;
    @Resource
    protected Map<String, IResetRedisNoIndexCommon> resetRedisNoIndexCommonMap;

    private static String getOrderIdPrefix(LocalDateTime now, String format) {
        return now.format(DateTimeFormatter.ofPattern(format));
    }

    private long generate(Class<?> noServiceClazz, String key, int expireTime) {
        Long incrNo = this.cacheService.incr(key, (long)expireTime);
        if (incrNo == 1L) {
            incrNo = this.resetLastNo(noServiceClazz, key, expireTime);
        }
        return incrNo;
    }

    private Long resetLastNo(Class<?> noServiceClazz, String key, int expireTime) {
        String beanServiceName = StringUtils.prefixToLower((String)noServiceClazz.getSimpleName(), (int)1);
        IResetRedisNoIndexCommon resetRedisNoIndexCommon = this.resetRedisNoIndexCommonMap.get(beanServiceName);
        AssertUtils.notNull((Object)resetRedisNoIndexCommon, (String)"%s\u6ca1\u6709\u5b9e\u73b0IResetRedisNoIndexCommon\u63a5\u53e3", (Object[])new Object[]{beanServiceName});
        String latestNo = resetRedisNoIndexCommon.getLatestNo();
        Long nextNo = 1L;
        if (latestNo.contains(key)) {
            long latestNoL = Long.parseLong(latestNo.substring(key.length()));
            nextNo = latestNoL + 1L;
            LOGGER.info("\u91cd\u7f6eredis\u5355\u53f7 key\uff1a{}, no:{}", (Object)key, (Object)nextNo);
            this.cacheService.setCache(key, (Object)nextNo, expireTime);
        }
        return nextNo;
    }

    public String generateDefaultPlatformNo() {
        return String.format("PN%s", IdGenrator.getDistributedId());
    }

    public String generateCustomerRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "CR";
        String prefixCustomerRuleNo = prefix + orderIdPrefix;
        return prefixCustomerRuleNo + String.format("%1$04d", this.generate(DgCustomerDgStrategyRuleServiceImpl.class, prefixCustomerRuleNo, 90000));
    }

    public String generateLabelNo(String platform) {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMdd");
        String prefixCustomerRuleNo = platform + orderIdPrefix;
        return prefixCustomerRuleNo + String.format("%1$04d", this.generate(DgCustomerDgStrategyRuleServiceImpl.class, prefixCustomerRuleNo, 90000));
    }

    public String generateBusinessRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "BR";
        String prefixBusinessRuleNo = prefix + orderIdPrefix;
        return prefixBusinessRuleNo + String.format("%1$04d", this.generate(DgBusinessDgStrategyRuleServiceImpl.class, prefixBusinessRuleNo, 90000));
    }

    public String generateAutoMaticAllocationRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "PH";
        String prefixBusinessRuleNo = prefix + orderIdPrefix;
        return prefixBusinessRuleNo + String.format("%1$04d", this.generate(DgCustomerDgStrategyRuleServiceImpl.class, prefixBusinessRuleNo, 90000));
    }

    public String generateAutoDeliveryRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "XF";
        String prefixBusinessRuleNo = prefix + orderIdPrefix;
        return prefixBusinessRuleNo + String.format("%1$04d", this.generate(DgCustomerDgStrategyRuleServiceImpl.class, prefixBusinessRuleNo, 90000));
    }

    public String confirmReceiptStrategyRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "CRF";
        String prefixBusinessRuleNo = prefix + orderIdPrefix;
        return prefixBusinessRuleNo + String.format("%1$04d", this.generate(DgReceiveStrategyServiceImpl.class, prefixBusinessRuleNo, 90000));
    }

    public String generateAutoAuditRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "SH";
        String prefixBusinessRuleNo = prefix + orderIdPrefix;
        return prefixBusinessRuleNo + String.format("%1$04d", this.generate(DgCustomerDgStrategyRuleServiceImpl.class, prefixBusinessRuleNo, 90000));
    }

    public String generateOrderConfirmRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "QR";
        String prefixBusinessRuleNo = prefix + orderIdPrefix;
        return prefixBusinessRuleNo + String.format("%1$04d", this.generate(DgCustomerDgStrategyRuleServiceImpl.class, prefixBusinessRuleNo, 90000));
    }

    public String generateFeeScaleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHH");
        String prefix = "FBGK";
        String prefixCustomerRuleNo = prefix + orderIdPrefix;
        return prefixCustomerRuleNo + String.format("%1$04d", this.generate(DgCustomerDgStrategyRuleServiceImpl.class, prefixCustomerRuleNo, 90000));
    }

    public String generateF2bAutoAuditRuleNo(String prefix) {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMdd");
        String prefixBusinessRuleNo = prefix + orderIdPrefix;
        return prefixBusinessRuleNo + String.format("%1$04d", this.generate(DgCustomerDgStrategyRuleServiceImpl.class, prefixBusinessRuleNo, 90000));
    }
}

