/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.components.optlog.domain.entity.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.components.optlog.dao.das.IOptOperationLogDas;
import com.yunxi.dg.base.components.optlog.domain.entity.IOptOperationLogDomain;
import com.yunxi.dg.base.components.optlog.dto.optlog.OptOperationLogDto;
import com.yunxi.dg.base.components.optlog.eo.OptOperationLogEo;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OptOperationLogDomainImpl
implements IOptOperationLogDomain<OptOperationLogEo> {
    @Resource
    private IOptOperationLogDas das;

    @Override
    public ICommonDas<OptOperationLogEo> commonDas() {
        return this.das;
    }

    @Override
    public RestResponse<PageInfo<OptOperationLogDto>> queryOptLogPage(String optLinkType, String optLinkCode, Integer pageSize, Integer pageNum) {
        OptOperationLogEo optOperationLogEo = new OptOperationLogEo();
        optOperationLogEo.setOptLinkCode(optLinkCode);
        optOperationLogEo.setOptLinkType(optLinkType);
        optOperationLogEo.setOptResult("SUCCESS");
        optOperationLogEo.setSqlOrderBys(Arrays.asList(new SqlOrderBy("create_time", SortOrder.DESC)));
        PageInfo<OptOperationLogEo> optOperationLogEos = this.selectPage(optOperationLogEo, pageNum, pageSize);
        if (optOperationLogEos == null) {
            return new RestResponse();
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, optOperationLogEos, (String[])new String[]{"list", "navigatepageNums"});
        LinkedList operationLogEoList = new LinkedList();
        Map omap = optOperationLogEos.getList().stream().collect(Collectors.toMap(eo -> eo.getOptCorrelationId() + eo.getOptEntryCode() + eo.getOptLinkCode() + eo.getOptLinkType(), Function.identity(), (eo1, eo2) -> {
            eo1.setOptTraceId(null);
            eo1.setOptDetailsCode(eo1.getOptDetailsCode() + "," + eo2.getOptDetailsCode());
            eo1.setOptDetails(eo1.getOptDetails() + "," + eo2.getOptDetails());
            eo1.setOptContent(eo1.getOptContent() + "\n" + eo2.getOptContent());
            return eo1;
        }));
        omap.forEach((k, eo) -> operationLogEoList.add(eo));
        ArrayList<OptOperationLogDto> dtoList = new ArrayList<OptOperationLogDto>();
        CubeBeanUtils.copyCollection(dtoList, operationLogEoList, OptOperationLogDto.class);
        dtoList.sort(Comparator.comparing(OptOperationLogDto::getOptTime).thenComparing(BaseDto::getId).reversed());
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }
}

