/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.cache;

import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;

public class BloomFilterHelper<T> {
    private int numHashFunctions;
    private int bitSize;
    private Funnel<T> funnel;

    public BloomFilterHelper(int expectedInsertions) {
        this.funnel = Funnels.stringFunnel((Charset)Charset.defaultCharset());
        this.bitSize = this.optimalNumOfBits(expectedInsertions, 0.03);
        this.numHashFunctions = this.optimalNumOfHashFunctions(expectedInsertions, this.bitSize);
    }

    public BloomFilterHelper(Funnel<T> funnel, int expectedInsertions, double fpp) {
        this.funnel = funnel;
        this.bitSize = this.optimalNumOfBits(expectedInsertions, fpp);
        this.numHashFunctions = this.optimalNumOfHashFunctions(expectedInsertions, this.bitSize);
    }

    public int[] murmurHashOffset(T value) {
        int[] offset = new int[this.numHashFunctions];
        long hash64 = Hashing.murmur3_128().hashObject(value, this.funnel).asLong();
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        for (int i = 1; i <= this.numHashFunctions; ++i) {
            int nextHash = hash1 + i * hash2;
            if (nextHash < 0) {
                nextHash ^= 0xFFFFFFFF;
            }
            offset[i - 1] = nextHash % this.bitSize;
        }
        return offset;
    }

    private int optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (int)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    private int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }
}

