/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.cache;

import com.yunxi.dg.base.framework.core.cache.BloomFilterHelper;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisBloomFilter<T> {
    @Resource
    private RedisTemplate<String, Object> redisTemplate;

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public <T> void add(BloomFilterHelper<T> bloomFilterHelper, String key, T value) {
        int[] offset;
        for (int i : offset = bloomFilterHelper.murmurHashOffset(value)) {
            this.redisTemplate.opsForValue().setBit((Object)key, (long)i, true);
        }
    }

    public void addList(final BloomFilterHelper<CharSequence> bloomFilterHelper, final String key, final List<String> valueList) {
        this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<Long>(){

            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                connection.openPipeline();
                for (String value : valueList) {
                    int[] offset;
                    for (int i : offset = bloomFilterHelper.murmurHashOffset(value)) {
                        connection.setBit(key.getBytes(), (long)i, true);
                    }
                }
                return null;
            }
        });
    }

    public <T> boolean contains(BloomFilterHelper<T> bloomFilterHelper, String key, T value) {
        return false;
    }
}

