/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.convert;

import cn.hutool.core.util.ArrayUtil;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlOrderBy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.dto.BasePageDto;
import com.yunxi.dg.base.commons.dto.SortDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import java.util.ArrayList;
import java.util.List;

public class DefaultConvertImpl<T extends BaseDto, E extends BaseEo, Q extends BasePageDto>
implements IConverter<T, E> {
    private final Class<T> tClass;
    private final Class<E> eClass;

    public DefaultConvertImpl(Class<T> tClass, Class<E> eClass) {
        this.tClass = tClass;
        this.eClass = eClass;
    }

    @Override
    public T toDto(E eo) {
        return (T)((BaseDto)BeanCopyUtil.copy(eo, this.tClass));
    }

    @Override
    public List<T> toDtoList(List<E> eoList) {
        return BeanCopyUtil.copyPropertiesForList(eoList, this.tClass);
    }

    @Override
    public E toEo(T dto) {
        return (E)((BaseEo)BeanCopyUtil.copy(dto, this.eClass));
    }

    @Override
    public List<E> toEoList(List<T> dtoList) {
        return BeanCopyUtil.copyPropertiesForList(dtoList, this.eClass);
    }

    @Override
    public E toEo(Q queryDto) {
        BaseEo eo = (BaseEo)BeanCopyUtil.copy(queryDto, this.eClass);
        if (ArrayUtil.isNotEmpty((Object)queryDto.getSorts())) {
            eo.setSqlOrderBys(new ArrayList());
            for (SortDto sortDto : queryDto.getSorts()) {
                eo.getSqlOrderBys().add(new SqlOrderBy(sortDto.getField(), SortDto.ASC.equals(sortDto.getDirection()) ? SortOrder.ASC : SortOrder.DESC));
            }
        }
        return (E)eo;
    }
}

