/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.rest;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.dto.BasePageDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.service.BaseService;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.ParameterizedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class BaseController<T extends BaseDto, Q extends BasePageDto, S extends BaseService> {
    private static final Logger log = LoggerFactory.getLogger(BaseController.class);
    protected Class<T> tClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    protected Class<Q> qClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
    protected S service;

    public BaseController(S service) {
        this.service = service;
    }

    @PostMapping(path={"/insert"})
    @ApiOperation(value="\u63d2\u5165\u4e00\u4e2a\u5bf9\u8c61", notes="\u63d2\u5165\u4e00\u4e2a\u5bf9\u8c61")
    public RestResponse<Long> insert(@RequestBody T dto) {
        return this.service.insert(dto);
    }

    @PostMapping(path={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u4e00\u4e2a\u5bf9\u8c61", notes="\u66f4\u65b0\u4e00\u4e2a\u5bf9\u8c61")
    public RestResponse<Void> update(@RequestBody T dto) {
        return this.service.update(dto);
    }

    @PostMapping(path={"/delete/{id}"})
    @ApiOperation(value="\u5220\u9664\u4e00\u4e2a\u5bf9\u8c61", notes="\u5220\u9664\u4e00\u4e2a\u5bf9\u8c61")
    public RestResponse<Void> delete(@PathVariable(name="id", required=true) Long id) {
        return this.service.delete(id);
    }

    @PostMapping(path={"/logicDelete/{id}"})
    @ApiOperation(value="\u903b\u8f91\u5220\u9664\u4e00\u4e2a\u5bf9\u8c61", notes="\u903b\u8f91\u5220\u9664\u4e00\u4e2a\u5bf9\u8c61")
    public RestResponse<Void> logicDelete(@PathVariable(name="id", required=true) Long id) {
        return this.service.logicDelete(id);
    }

    @PostMapping(path={"/get/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u4e00\u4e2a\u5bf9\u8c61", notes="\u83b7\u53d6\u4e00\u4e2a\u5bf9\u8c61")
    public RestResponse<T> get(@PathVariable(name="id", required=true) Long id) {
        return this.service.get(id);
    }

    @PostMapping(path={"/page"})
    @ApiOperation(value="\u6807\u51c6\u5206\u9875\u67e5\u8be2", notes="\u6807\u51c6\u5206\u9875\u67e5\u8be2")
    public RestResponse<PageInfo<T>> page(@RequestBody Q queryDto) {
        BaseDto dto = (BaseDto)BeanCopyUtil.copy(queryDto, this.tClass);
        return this.service.page((BaseDto)dto, queryDto.getPageNum(), queryDto.getPageSize());
    }
}

