/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.service.impl;

import com.yunxi.dg.base.framework.core.cache.BloomFilterHelper;
import com.yunxi.dg.base.framework.core.cache.RedisBloomFilter;
import com.yunxi.dg.base.framework.core.service.IBloomFilterService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class BloomFilterServiceImpl
implements IBloomFilterService,
InitializingBean {
    private static RedisBloomFilter<String> redisBloomFilter;
    private static BloomFilterHelper<String> bloomFilterHelper;
    private static final String BLOOM_KEY = "REQID";

    public void afterPropertiesSet() throws Exception {
        bloomFilterHelper = new BloomFilterHelper(1000);
        redisBloomFilter = new RedisBloomFilter();
    }

    @Override
    public boolean contains(String field, String id) {
        return redisBloomFilter.contains(bloomFilterHelper, field, id);
    }

    @Override
    public void add(String field, String id) {
        redisBloomFilter.add(bloomFilterHelper, field, id);
    }
}

