/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.service.impl;

import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.commons.dto.UploadReqDto;
import com.yunxi.dg.base.commons.dto.UploadRespDto;
import com.yunxi.dg.base.commons.utils.StreamUtil;
import com.yunxi.dg.base.commons.utils.oss.OssUploadService;
import com.yunxi.dg.base.framework.core.service.IUploadService;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class UploadServiceImpl
implements IUploadService {
    private static final Logger log = LoggerFactory.getLogger(UploadServiceImpl.class);
    @Resource
    private OssUploadService ossUploadService;
    @Value(value="${huieryun.ossregistryvo.dir}")
    private String ossBaseDir;
    @Resource
    private IObjectStorageService objectStorageService;

    @Override
    public RestResponse<UploadRespDto> upload(UploadReqDto dto) {
        RestResponse restResponse = new RestResponse();
        UploadRespDto uploadRespDto = new UploadRespDto();
        try {
            SimpleDateFormat sdfYMD = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat sdfYmdHms = new SimpleDateFormat("yyyyMMddHHmmss");
            if (StringUtils.isEmpty((Object)dto.getOssDir())) {
                dto.setOssDir(sdfYMD.format(new Date()));
            }
            uploadRespDto.setPath("/" + this.ossBaseDir + "/" + dto.getOssDir() + "/" + dto.getUploadFile().getOriginalFilename());
            uploadRespDto.setFileName(dto.getUploadFile().getOriginalFilename());
            uploadRespDto.setExtName(uploadRespDto.getFileName().substring(uploadRespDto.getFileName().lastIndexOf(".") + 1));
            uploadRespDto.setSize(Long.valueOf(dto.getUploadFile().getSize()));
            String url = this.ossUploadService.uploadFileToOss(this.ossBaseDir + "/" + dto.getOssDir(), StreamUtil.toByteArray((InputStream)dto.getUploadFile().getInputStream()), sdfYmdHms.format(new Date()) + "_" + dto.getUploadFile().getOriginalFilename());
            uploadRespDto.setUrl(url);
            restResponse.setData((Object)uploadRespDto);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            restResponse.setResultCode("100000");
            restResponse.setResultMsg("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
        }
        return restResponse;
    }

    @Override
    public RestResponse<UploadRespDto> upload(String ossDir, String fileName, byte[] data) {
        RestResponse restResponse = new RestResponse();
        UploadRespDto uploadRespDto = new UploadRespDto();
        try {
            SimpleDateFormat sdfYMD = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat sdfYmdHms = new SimpleDateFormat("yyyyMMddHHmmss");
            if (StringUtils.isEmpty((Object)ossDir)) {
                ossDir = sdfYMD.format(new Date());
            }
            uploadRespDto.setPath("/" + this.ossBaseDir + "/" + ossDir + "/" + fileName);
            uploadRespDto.setFileName(fileName);
            uploadRespDto.setExtName(uploadRespDto.getFileName().substring(uploadRespDto.getFileName().lastIndexOf(".") + 1));
            uploadRespDto.setSize(new Long(data.length));
            String url = this.ossUploadService.uploadFileToOss(this.ossBaseDir + "/" + ossDir, data, sdfYmdHms.format(new Date()) + "_" + fileName);
            uploadRespDto.setUrl(url);
            restResponse.setData((Object)uploadRespDto);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            restResponse.setResultCode("100000");
            restResponse.setResultMsg("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
        }
        return restResponse;
    }

    @Override
    public RestResponse<String> upload(String fileName, Workbook workbook) {
        RestResponse restResponse = new RestResponse();
        try {
            String url = this.ossUploadService.uploadExcelToOss(workbook, fileName);
            restResponse.setData((Object)url);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            restResponse.setResultCode("100000");
            restResponse.setResultMsg("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
        }
        return restResponse;
    }

    @Override
    public RestResponse<Map<String, String>> createPolicy() {
        return new RestResponse((Object)this.objectStorageService.createPolicy());
    }
}

