/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.db.das;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.framework.das.ComBaseDas;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.ds.BaseMapper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.components.optlog.core.constant.OptInfoChangeType;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractDas<T extends BaseEo, P>
extends ComBaseDas<T, P> {
    private static final String __VERSION__ = "_0.0.1_";
    private static final Long EMPTY_ID = -9999L;
    private static final Integer RECORD_CACHE_SECONDS = 86400;
    private Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private ICacheService cacheService;
    @Resource
    private Map<String, BaseMapper> mappers;
    @Value(value="${dg.components.settings.optlog.entity.log.collect.enable:false}")
    private Boolean changeLogCollectEnable;
    @Value(value="${dg.base.select.max.count:10000}")
    private Integer recordSelectMaxCount;
    protected Class<T> eoClass;

    public T selectByPrimaryKey(Long key) {
        if (this.isUseCache()) {
            BaseEo record = this.getCacheByKey(key);
            if (record != null) {
                return (T)(EMPTY_ID.equals(record.getId()) ? null : record);
            }
            record = this.getMapper().findById(key);
            if (record != null && key != null) {
                try {
                    this.getCacheService().setCache(this.getCachePre() + key, (Object)record, RECORD_CACHE_SECONDS.intValue());
                }
                catch (Exception var4) {
                    this.LOGGER.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,record=" + record, (Throwable)var4);
                }
            } else {
                this.addEmptyCache(key);
            }
            return (T)record;
        }
        return (T)this.getMapper().findById(key);
    }

    protected Class<T> getTargetEoClass() {
        if (this.eoClass != null) {
            return this.eoClass;
        }
        this.eoClass = this.extractEoClass(((Object)((Object)this)).getClass());
        return this.eoClass;
    }

    public Class<T> extractEoClass(Class<?> cls) {
        Class tType = null;
        Type pType = cls.getGenericSuperclass();
        if (pType instanceof ParameterizedType) {
            Type[] parameterizedTypes = ((ParameterizedType)pType).getActualTypeArguments();
            tType = Optional.ofNullable(parameterizedTypes).map(Arrays::asList).map(ls -> ls.stream().filter(this::checkTargetClass).findFirst().orElse(null)).orElse(null);
        }
        if (cls.equals(AbstractDas.class)) {
            return tType;
        }
        return tType == null ? this.extractEoClass(cls.getSuperclass()) : tType;
    }

    private boolean checkTargetClass(Type cls) {
        return cls instanceof Class && (((Class)cls).getSuperclass().equals(CubeBaseEo.class) || ((Class)cls).getSuperclass().equals(BaseEo.class));
    }

    protected boolean collectChangeLogEnable() {
        return true;
    }

    protected String getVersion() {
        return __VERSION__;
    }

    protected ICacheService getCacheService() {
        return this.cacheService;
    }

    protected Map<String, BaseMapper> getMappers() {
        return this.mappers;
    }

    public int insert(T record) {
        int result = super.insert(record);
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            OptUtil.addEntityChangeLog((OptInfoChangeType)OptInfoChangeType.INSERT, record, this.getTargetEoClass(), BaseEo::getId, o -> null);
        }
        return result;
    }

    public int update(T record) {
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            OptUtil.addEntityChangeLog((OptInfoChangeType)OptInfoChangeType.UPDATE, record, this.getTargetEoClass(), BaseEo::getId, this::selectByPrimaryKey);
        }
        int result = super.update(record);
        return result;
    }

    public int updateSelective(T record) {
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            OptUtil.addEntityChangeLog((OptInfoChangeType)OptInfoChangeType.UPDATE, record, this.getTargetEoClass(), BaseEo::getId, this::selectByPrimaryKey);
        }
        int result = super.updateSelective(record);
        return result;
    }

    public int updateSelectiveSqlFilter(T record) {
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            OptUtil.addEntityChangeLog((OptInfoChangeType)OptInfoChangeType.UPDATE, record, this.getTargetEoClass(), BaseEo::getId, this::selectByPrimaryKey);
        }
        int result = super.updateSelectiveSqlFilter(record);
        return result;
    }

    public void delete(T record) {
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            OptUtil.addEntityChangeLog((OptInfoChangeType)OptInfoChangeType.DELETE, null, this.getTargetEoClass(), o -> record.getId(), this::selectByPrimaryKey);
        }
        super.delete(record);
    }

    public void logicDelete(T record) {
        super.logicDelete(record);
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            List<T> records = this.select(record);
            List ids = this.getIds(records);
            OptUtil.addEntityChangeLogForBatch((OptInfoChangeType)OptInfoChangeType.DELETE, this.getTargetEoClass(), (List)ids);
        }
    }

    public void deleteById(Long id) {
        super.deleteById(id);
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            OptUtil.addEntityChangeLog((OptInfoChangeType)OptInfoChangeType.DELETE, null, this.getTargetEoClass(), o -> id, this::selectByPrimaryKey);
        }
    }

    public void logicDeleteById(Long id) {
        super.logicDeleteById(id);
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            OptUtil.addEntityChangeLogForBatch((OptInfoChangeType)OptInfoChangeType.DELETE, this.getTargetEoClass(), Arrays.asList(id));
        }
    }

    public int logicDeleteByIds(List<Long> ids) {
        int result = super.logicDeleteByIds(ids);
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            OptUtil.addEntityChangeLogForBatch((OptInfoChangeType)OptInfoChangeType.DELETE, this.getTargetEoClass(), ids);
        }
        return result;
    }

    public int insertBatch(List<T> records) {
        int result = super.insertBatch(records);
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            OptUtil.addEntityChangeLogForBatch((OptInfoChangeType)OptInfoChangeType.INSERT, this.getTargetEoClass(), records, BaseEo::getId);
        }
        return result;
    }

    public int updateBatchByIds(List<T> records) {
        if (this.changeLogCollectEnable.booleanValue() && this.collectChangeLogEnable()) {
            OptUtil.addEntityChangeLogForBatch((OptInfoChangeType)OptInfoChangeType.UPDATE, this.getTargetEoClass(), records, BaseEo::getId, rs -> rs.stream().map(BaseEo::getId).collect(Collectors.toList()), arg_0 -> ((AbstractDas)this).selectByIds(arg_0));
        }
        int result = super.updateBatchByIds(records);
        return result;
    }

    public void removeCache(Object key) {
        super.removeCache(key);
    }

    public void removeLogicCache(T record, Set<P> logicColumns) {
        super.removeLogicCache(record, logicColumns);
    }

    public void removeCacheByExample(T record) {
        super.removeCacheByExample(record);
    }

    public boolean isUseCache() {
        return super.isUseCache();
    }

    public List<T> select(T record) {
        List resultList = super.select(record, Integer.valueOf(1), this.recordSelectMaxCount);
        if (resultList != null && resultList.size() >= this.recordSelectMaxCount) {
            throw new BizException("\u67e5\u8be2\u7ed3\u679c\u8d85\u8fc7\u6700\u5927\u9650\u5236\u6570" + this.recordSelectMaxCount + "\uff0c\u8bf7\u4f7f\u7528\u5206\u9875\u67e5\u8be2");
        }
        return resultList;
    }

    public List<T> selectList(T record) {
        List resultList = super.selectList(record, Integer.valueOf(1), this.recordSelectMaxCount);
        if (resultList != null && resultList.size() >= this.recordSelectMaxCount) {
            throw new BizException("\u67e5\u8be2\u7ed3\u679c\u8d85\u8fc7\u6700\u5927\u9650\u5236\u6570" + this.recordSelectMaxCount + "\uff0c\u8bf7\u4f7f\u7528\u5206\u9875\u67e5\u8be2");
        }
        return resultList;
    }

    public List<T> selectAll() {
        List resultList = super.selectAll();
        if (resultList != null && resultList.size() >= this.recordSelectMaxCount) {
            throw new BizException("\u67e5\u8be2\u7ed3\u679c\u8d85\u8fc7\u6700\u5927\u9650\u5236\u6570" + this.recordSelectMaxCount + "\uff0c\u8bf7\u4f7f\u7528\u5206\u9875\u67e5\u8be2");
        }
        return resultList;
    }

    public PageInfo<T> selectPage(T record) {
        PageInfo pageInfo = super.selectPage(record, Integer.valueOf(1), this.recordSelectMaxCount);
        if (pageInfo != null && pageInfo.getList() != null && pageInfo.getList().size() >= this.recordSelectMaxCount) {
            throw new BizException("\u67e5\u8be2\u7ed3\u679c\u8d85\u8fc7\u6700\u5927\u9650\u5236\u6570" + this.recordSelectMaxCount + "\uff0c\u8bf7\u4f7f\u7528\u5206\u9875\u67e5\u8be2");
        }
        return pageInfo;
    }
}

