/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.framework.core.utils;

import cn.hutool.core.lang.UUID;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.yunxi.dg.base.commons.dto.UploadRespDto;
import com.yunxi.dg.base.framework.core.service.IUploadService;
import com.yunxi.dg.base.framework.core.utils.LogoConfig;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.springframework.beans.factory.annotation.Value;

public class WxCodeUrlUtil {
    @Value(value="${logo.url:http://}")
    private String logoUrl;
    private static final int QRCOLOR = -16777216;
    private static final int BGWHITE = -1;
    private IUploadService uploadService;

    private void loadUploadService() {
        this.uploadService = (IUploadService)SpringBeanUtil.getBean(IUploadService.class);
    }

    public String getLogoQRCodeIgnoreName(String qrUrl) {
        return this.getLogoQRCode(qrUrl, null);
    }

    public String getLogoQRCode(String qrUrl, String productName) {
        String filePath = this.logoUrl;
        String content = qrUrl;
        try {
            productName = productName != null ? productName : UUID.randomUUID().toString();
            BufferedImage bim = this.getQR_CODEBufferedImage(content, BarcodeFormat.QR_CODE, 1000, 1000, this.getDecodeHintType());
            URL url = new URL(filePath);
            return this.addLogo_QRCode(bim, url, new LogoConfig(), productName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String addLogo_QRCode(BufferedImage bim, URL logoPic, LogoConfig logoConfig, String productName) {
        try {
            this.loadUploadService();
            BufferedImage image = bim;
            Graphics2D g = image.createGraphics();
            BufferedImage logo = ImageIO.read(logoPic);
            int widthLogo = logo.getWidth(null) > image.getWidth() * 2 / 10 ? image.getWidth() * 2 / 10 : logo.getWidth(null);
            int heightLogo = logo.getHeight(null) > image.getHeight() * 2 / 10 ? image.getHeight() * 2 / 10 : logo.getWidth(null);
            int x = (image.getWidth() - widthLogo) / 2;
            int y = (image.getHeight() - heightLogo) / 2;
            g.drawImage(logo, x, y, widthLogo, heightLogo, null);
            g.drawRoundRect(x, y, widthLogo, heightLogo, 15, 15);
            g.setStroke(new BasicStroke(logoConfig.getBorder()));
            g.setColor(logoConfig.getBorderColor());
            g.drawRect(x, y, widthLogo, heightLogo);
            g.dispose();
            logo.flush();
            image.flush();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.flush();
            ImageIO.write((RenderedImage)image, "png", baos);
            byte[] bytes = baos.toByteArray();
            UploadRespDto data = (UploadRespDto)this.uploadService.upload("oss", productName + ".jpg", bytes).getData();
            String url = data.getUrl();
            baos.close();
            return url;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BufferedImage fileToBufferedImage(BitMatrix bm) {
        BufferedImage image = null;
        try {
            int w = bm.getWidth();
            int h = bm.getHeight();
            image = new BufferedImage(w, h, 1);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    image.setRGB(x, y, bm.get(x, y) ? -16777216 : -3351058);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public BufferedImage getQR_CODEBufferedImage(String content, BarcodeFormat barcodeFormat, int width, int height, Map<EncodeHintType, ?> hints) {
        MultiFormatWriter multiFormatWriter = null;
        BitMatrix bm = null;
        BufferedImage image = null;
        try {
            multiFormatWriter = new MultiFormatWriter();
            bm = multiFormatWriter.encode(content, barcodeFormat, width, height, hints);
            int w = bm.getWidth();
            int h = bm.getHeight();
            image = new BufferedImage(w, h, 1);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    image.setRGB(x, y, bm.get(x, y) ? -16777216 : -1);
                }
            }
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        return image;
    }

    public Map<EncodeHintType, Object> getDecodeHintType() {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.MARGIN, 0);
        hints.put(EncodeHintType.MAX_SIZE, 350);
        hints.put(EncodeHintType.MIN_SIZE, 100);
        return hints;
    }
}

