/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.scheduler;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.response.AppBizQueryRespDto;
import com.dtyunxi.yundt.cube.center.scheduler.api.query.IAppBizQueryApi;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import com.yunxi.dg.base.framework.core.schedule.config.JobSettingsVo;
import com.yunxi.dg.base.framework.core.schedule.config.SchedulerSettingsVo;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class SchedulerCreateRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SchedulerCreateRunner.class);
    @Resource
    private ITaskApi taskApi;
    @Resource
    private IAppBizQueryApi appBizQueryApi;
    @Resource
    private SchedulerSettingsVo schedulerSettingsVo;
    @Value(value="${scheduler.client.app_code}")
    private String APP_CODE;

    public void run(ApplicationArguments args) throws Exception {
        if (!this.schedulerSettingsVo.getIsAutoRegisterWithApplication().booleanValue()) {
            return;
        }
        try {
            HashSet<String> bizCodeSet = new HashSet<String>();
            RestResponse restResponse = this.appBizQueryApi.queryByAppCode(this.APP_CODE, "{}");
            if ("0".equals(restResponse.getResultCode()) && restResponse.getData() != null) {
                for (AppBizQueryRespDto dto : (List)restResponse.getData()) {
                    bizCodeSet.add(dto.getBizCode());
                }
            }
            log.info("bizCodeSet:" + JacksonUtil.toJson(bizCodeSet));
            restResponse = null;
            for (JobSettingsVo vo : this.schedulerSettingsVo.getJoblist()) {
                log.info("job id:{},name:{},cron:{}", new Object[]{vo.getId(), vo.getName(), vo.getCron()});
                if (bizCodeSet.contains(vo.getId())) continue;
                log.info("create job id:{},name:{},cron:{}", new Object[]{vo.getId(), vo.getName(), vo.getCron()});
                this.createTask(vo.getId(), vo.getName(), vo.getCron());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private void createTask(String bizCode, String taskName, String taskCron) {
        TaskAndBizCreateReqDto taskAndBizCreateReqDto = new TaskAndBizCreateReqDto();
        taskAndBizCreateReqDto.setTaskName(taskName);
        taskAndBizCreateReqDto.setShardType("SINGLE");
        taskAndBizCreateReqDto.setAppCode(this.APP_CODE);
        taskAndBizCreateReqDto.setBizCode(bizCode);
        taskAndBizCreateReqDto.setBizName(taskName);
        taskAndBizCreateReqDto.setScheduleExpression(taskCron);
        Long tempId = ServiceContext.getContext().getRequestInstanceId();
        if (tempId == null) {
            tempId = CommonConstants.SysDefaultValue.INSTANCE_ID;
        }
        taskAndBizCreateReqDto.setInstanceId(tempId);
        tempId = ServiceContext.getContext().getRequestTenantId();
        if (tempId == null) {
            tempId = CommonConstants.SysDefaultValue.TENANT_ID;
        }
        taskAndBizCreateReqDto.setTenantId(tempId);
        try {
            RestResponse restResponse = this.taskApi.addWithBiz(taskAndBizCreateReqDto);
            if ("0".equals(restResponse.getResultCode())) {
                if (restResponse.getData() == null) {
                    log.error("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
                }
                this.taskApi.enableById((Long)restResponse.getData(), "{}");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

