/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.plugins.apifox.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.commons.utils.MD5Util;
import com.yunxi.dg.base.commons.utils.StreamUtil;
import com.yunxi.dg.base.plugins.apifox.PluginParameter;
import com.yunxi.dg.base.plugins.apifox.bean.apifox.Apifox;
import com.yunxi.dg.base.plugins.apifox.bean.apifox.ContentItem;
import com.yunxi.dg.base.plugins.apifox.bean.apifox.Dto;
import com.yunxi.dg.base.plugins.apifox.bean.apifox.HttpMethod;
import com.yunxi.dg.base.plugins.apifox.bean.apifox.Parameter;
import com.yunxi.dg.base.plugins.apifox.bean.apifox.Path;
import com.yunxi.dg.base.plugins.apifox.bean.apifox.Propertie;
import com.yunxi.dg.base.plugins.apifox.bean.apifox.Schema;
import com.yunxi.dg.base.plugins.apifox.bean.apifox.Tag;
import com.yunxi.dg.base.plugins.apifox.bean.apifox.XapifoxRef;
import com.yunxi.dg.base.plugins.apifox.bean.freemarker.FieldItem;
import com.yunxi.dg.base.plugins.apifox.bean.freemarker.FreemarkerVo;
import com.yunxi.dg.base.plugins.apifox.constants.ApifoxConstants;
import com.yunxi.dg.base.plugins.apifox.service.ApifoxService;
import com.yunxi.dg.base.plugins.apifox.utils.FileReadUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApifoxServiceImpl
implements ApifoxService {
    private static final Logger log = LoggerFactory.getLogger(ApifoxServiceImpl.class);
    private static final String CHARSET_UTF8 = "UTF-8";
    private Map<String, String> fileMap = new LinkedHashMap<String, String>();
    private String project;
    private UsernamePasswordCredentialsProvider usernamePasswordCredentialsProvider;

    @Override
    public boolean generateCode(PluginParameter parameter) {
        if (parameter.getOutput().indexOf("/") != -1) {
            parameter.setOutput(parameter.getOutput().substring(0, parameter.getOutput().lastIndexOf("/")));
        } else if (parameter.getOutput().indexOf("\\") != -1) {
            parameter.setOutput(parameter.getOutput().substring(0, parameter.getOutput().lastIndexOf("\\")));
        }
        this.project = parameter.getOutput().substring(parameter.getOutput().lastIndexOf("/") + 1);
        if (parameter.getOutput().equals(this.project)) {
            this.project = null;
        }
        if (StringUtils.isEmpty((String)this.project)) {
            this.project = parameter.getOutput().substring(parameter.getOutput().lastIndexOf("\\") + 1);
        }
        String json = null;
        if (StringUtils.isNotEmpty((String)parameter.getJsonPath())) {
            if (parameter.getJsonPath().startsWith("http")) {
                log.info("\u4eceurl\u4e2d\u83b7\u53d6json\u6587\u4ef6\u5185\u5bb9:" + parameter.getJsonPath());
                json = FileReadUtils.readFileContentByUrl(parameter.getJsonPath());
                log.info("\u83b7\u53d6\u5230json\u6587\u4ef6\u5185\u5bb9\u5927\u5c0f:" + Optional.ofNullable(json).map(String::length).orElse(0));
            } else {
                try {
                    json = new String(StreamUtil.toByteArray((InputStream)new FileInputStream(parameter.getJsonPath())), CHARSET_UTF8);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.usernamePasswordCredentialsProvider = new UsernamePasswordCredentialsProvider(parameter.getGitUserName(), parameter.getGitPassword());
            json = this.cloneFromGit(parameter);
        }
        if (StringUtils.isEmpty(json)) {
            return false;
        }
        Apifox apifox = (Apifox)JacksonUtil.readValue((String)this.getJson(json), Apifox.class);
        apifox.setPluginParameter(parameter);
        File file = null;
        if (Boolean.TRUE.equals(parameter.getIsGenerateApi())) {
            file = new File(parameter.getOutput() + "/" + this.project + "-api" + parameter.getBaseSourceFolder() + "/api");
            if (!file.exists()) {
                file.mkdirs();
            }
            this.generateApis(parameter, apifox);
        }
        if (Boolean.TRUE.equals(parameter.getIsGenerateDto())) {
            String rpcOrDto = Boolean.TRUE.equals(parameter.getIsGenerateProxy()) ? "rpc" : "dto";
            file = new File(parameter.getOutput() + "/" + this.project + "-" + rpcOrDto + parameter.getBaseSourceFolder() + "/constants");
            if (!file.exists()) {
                file.mkdirs();
            }
            FreemarkerVo vo = new FreemarkerVo();
            vo.setClassName("DefaultConstants");
            vo.setClassDesc("\u9ed8\u8ba4\u5e38\u91cf\u5b9a\u4e49\u7c7b");
            this.generateByFreemarker(parameter, vo, parameter.getOutput() + "/" + this.project + "-" + rpcOrDto + parameter.getBaseSourceFolder() + "/constants", "DefaultConstants.java", "constants.ftl");
            file = new File(parameter.getOutput() + "/" + this.project + "-" + rpcOrDto + parameter.getBaseSourceFolder() + "/dto");
            if (!file.exists()) {
                file.mkdirs();
            }
            vo = new FreemarkerVo();
            vo.setClassName("DefaultDto");
            vo.setClassDesc("\u9ed8\u8ba4Dto\u7c7b");
            vo.setExtendsClassName("BaseDto");
            this.generateByFreemarker(parameter, vo, parameter.getOutput() + "/" + this.project + "-" + rpcOrDto + parameter.getBaseSourceFolder() + "/dto", "DefaultDto.java", "dfdto.ftl");
            this.generateConstants(parameter, apifox);
            this.generateDtos(parameter, apifox, false);
            this.generateDtos(parameter, apifox, true);
        }
        if (Boolean.TRUE.equals(parameter.getIsGenerateController())) {
            file = new File(parameter.getOutput() + "/" + this.project + "-rest" + parameter.getBaseSourceFolder() + "/rest");
            if (!file.exists()) {
                file.mkdirs();
            }
            this.generateRests(parameter, apifox);
        }
        if (Boolean.TRUE.equals(parameter.getIsGenerateService())) {
            file = new File(parameter.getOutput() + "/" + this.project + "-service" + parameter.getBaseSourceFolder() + "/service");
            if (!file.exists()) {
                file.mkdirs();
            }
            this.generateServices(parameter, apifox);
        }
        if (Boolean.TRUE.equals(parameter.getIsGenerateProxy())) {
            file = new File(parameter.getOutput() + "/" + this.project + "-rpc" + parameter.getBaseSourceFolder() + "/proxy");
            if (!file.exists()) {
                file.mkdirs();
            }
            this.generateApiProxys(parameter, apifox);
        }
        if (Boolean.TRUE.equals(parameter.getAutoCommit()) && StringUtils.isEmpty((String)parameter.getJsonPath())) {
            this.commitToGit(parameter, "\u4ee3\u7801\u81ea\u52a8\u751f\u6210\u5e76\u63d0\u4ea4", this.fileMap);
        }
        return true;
    }

    private boolean commitToGit(PluginParameter parameter, String commitMessage, Map<String, String> fileMap) {
        boolean pullFlag = true;
        try (Git git = Git.open((File)new File(parameter.getOutput()));){
            ((PullCommand)git.pull().setCredentialsProvider((CredentialsProvider)this.usernamePasswordCredentialsProvider)).call();
        }
        catch (Exception e) {
            e.printStackTrace();
            pullFlag = false;
        }
        if (pullFlag) {
            log.info("Pull successful! filePath:{},commitMessage:{}", (Object)parameter.getOutput(), (Object)commitMessage);
        }
        boolean commitAndPushFlag = true;
        try (Git git = Git.open((File)new File(parameter.getOutput()));){
            for (String filePath : fileMap.keySet()) {
                FileUtils.writeStringToFile((File)new File(filePath), (String)fileMap.get(filePath), (String)CHARSET_UTF8);
                git.add().addFilepattern(filePath).call();
            }
            git.commit().setMessage(commitMessage).call();
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)this.usernamePasswordCredentialsProvider)).call();
            log.info("Commit And Push files {} to repository at {}", fileMap.keySet(), (Object)git.getRepository().getDirectory());
        }
        catch (Exception e) {
            e.printStackTrace();
            commitAndPushFlag = false;
            log.info("Commit And Push error:{}", (Object)e.getMessage());
        }
        return commitAndPushFlag;
    }

    private void deleteFolder(File file) {
        try {
            if (!file.exists()) {
                return;
            }
            if (file.isFile() || file.list().length == 0) {
                file.delete();
            } else {
                File[] files;
                for (File getFile : files = file.listFiles()) {
                    this.deleteFolder(getFile);
                    getFile.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cloneFromGit(PluginParameter parameter) {
        File repoGitDir;
        Git call;
        block10: {
            String string;
            block11: {
                call = null;
                repoGitDir = null;
                File jsonFile = null;
                File workTreeFile = null;
                repoGitDir = new File(parameter.getOutput() + "/swagger/");
                this.deleteFolder(repoGitDir);
                CloneCommand cloneCommand = ((CloneCommand)Git.cloneRepository().setCredentialsProvider((CredentialsProvider)this.usernamePasswordCredentialsProvider)).setURI(parameter.getGitUrl()).setBranch(parameter.getGitBranch()).setDirectory(repoGitDir).setNoCheckout(true);
                call = cloneCommand.call();
                call.checkout().setStartPoint("origin/" + parameter.getGitBranch()).addPath(parameter.getTargetJson()).call();
                Repository repository = call.getRepository();
                workTreeFile = repository.getWorkTree();
                jsonFile = new File(workTreeFile, parameter.getTargetJson());
                if (jsonFile == null || !jsonFile.exists()) break block10;
                string = new String(StreamUtil.toByteArray((InputStream)new FileInputStream(jsonFile)), CHARSET_UTF8);
                if (call == null) break block11;
                call.getRepository().close();
            }
            if (repoGitDir != null) {
                this.deleteFolder(repoGitDir);
                repoGitDir.deleteOnExit();
            }
            return string;
        }
        try {
            try {
                throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (call != null) {
                    call.getRepository().close();
                }
                if (repoGitDir != null) {
                    this.deleteFolder(repoGitDir);
                    repoGitDir.deleteOnExit();
                }
            }
        }
        catch (Throwable throwable) {
            if (call != null) {
                call.getRepository().close();
            }
            if (repoGitDir != null) {
                this.deleteFolder(repoGitDir);
                repoGitDir.deleteOnExit();
            }
            throw throwable;
        }
        return null;
    }

    private String getJson(String json) {
        try {
            json = json.replaceAll("\"default\"", "\"defaultValue\"");
            json = json.replaceAll("\"\\$ref\"", "\"ref\"");
            json = json.replaceAll("\"x-apifox-orders\"", "\"xapifoxOrders\"");
            json = json.replaceAll("\"x-apifox-refs\"", "\"xapifoxRefs\"");
            json = json.replaceAll("\"x-apifox-ignore-properties\"", "\"xapifoxIgnoreProperties\"");
            json = json.replaceAll("\"x-apifox-folder\"", "\"xapifoxFolder\"");
            return json;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            return json;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateByFreemarker(PluginParameter parameter, FreemarkerVo vo, String folder, String fileName, String ftlName) {
        String filePath = folder + "/" + fileName;
        try {
            File directory = new File(folder);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            vo.setBasePackage(parameter.getBasePackage());
            String md5Code = MD5Util.getMD5Code((String)vo.toString());
            File file = new File(filePath);
            if (file.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    if (!(line = line.trim()).startsWith("*") || !(line = line.substring(1).trim()).startsWith(" @MD5Code ".trim())) continue;
                    line = line.replaceAll(" @MD5Code ".trim(), "");
                    if (!md5Code.equals(line = line.trim())) continue;
                    return;
                }
            }
            vo.setMd5Code("* @MD5Code " + md5Code);
            vo.setDate(parameter.getDate());
            Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(this.getClass(), "/template/");
            configuration.setTemplateLoader((TemplateLoader)classTemplateLoader);
            configuration.setDefaultEncoding(CHARSET_UTF8);
            Template template = configuration.getTemplate(ftlName);
            LinkedHashMap<String, FreemarkerVo> map = new LinkedHashMap<String, FreemarkerVo>();
            map.put("vo", vo);
            FileWriter out = new FileWriter(file);
            template.process(map, (Writer)out);
            ((Writer)out).close();
            log.info("generateFile:{} with ftlName:{}", (Object)filePath, (Object)ftlName);
            String content = new String(StreamUtil.toByteArray((InputStream)new FileInputStream(file)), CHARSET_UTF8);
            this.fileMap.put(filePath, content);
        }
        catch (Exception e) {
            log.error("Catch a for ftlName===>{},filePath===>{},vo===>{} when generate , error message===>{}", new Object[]{ftlName, filePath, vo, e.getMessage()});
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateConstants(PluginParameter parameter, Apifox apifox) {
        Map<String, Map<String, Dto>> dtosMap = apifox.getComponents();
        Map<String, Dto> dtoMap = dtosMap.get("schemas");
        for (String key : dtoMap.keySet()) {
            FreemarkerVo vo = new FreemarkerVo();
            Dto dto = dtoMap.get(key);
            if (!StringUtils.isNotEmpty((String)dto.getXapifoxFolder()) || !dto.getXapifoxFolder().startsWith("constants")) continue;
            try {
                String className = dto.getTitle().substring(0, dto.getTitle().indexOf("-"));
                String classDesc = dto.getTitle().substring(dto.getTitle().indexOf("-") + 1);
                vo.setClassName(className);
                vo.setClassDesc(classDesc);
                for (String fieldName : dto.getProperties().keySet()) {
                    Propertie propertie = dto.getProperties().get(fieldName);
                    String value = propertie.getDescription();
                    if (StringUtils.isEmpty((String)value)) {
                        value = fieldName;
                    }
                    if ("class".equals(dto.getDescription())) {
                        String title;
                        String string = title = StringUtils.isEmpty((String)propertie.getTitle()) ? propertie.getDescription() : propertie.getTitle();
                        if (StringUtils.isNotEmpty((String)title)) {
                            title = title.replaceAll("\"", "'");
                        }
                        if ("string".equals(propertie.getType()) && StringUtils.isEmpty((String)propertie.getFormat())) {
                            vo.addField(fieldName, title, this.getFieldType(propertie), "\"" + value + "\"");
                            continue;
                        }
                        vo.addField(fieldName, title, this.getFieldType(propertie), value);
                        continue;
                    }
                    vo.addField(fieldName, propertie.getTitle(), this.getFieldType(propertie), value);
                }
                vo.setVersion("1.0.1");
                String rpcOrDto = Boolean.TRUE.equals(parameter.getIsGenerateProxy()) ? "rpc" : "dto";
                this.generateByFreemarker(parameter, vo, parameter.getOutput() + "/" + this.project + "-" + rpcOrDto + parameter.getBaseSourceFolder() + "/constants" + this.matchFolderByTag(vo.getBaseTag()), key + ".java", "class".equals(dto.getDescription()) ? "constants.ftl" : "constantsEnum.ftl");
            }
            catch (Exception e) {
                log.error("Catch a for constants===>{},vo===>{} , error message===>{}", new Object[]{key, vo, e.getMessage()});
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateDtos(PluginParameter parameter, Apifox apifox, boolean isGen) {
        Map<String, Map<String, Dto>> dtosMap = apifox.getComponents();
        Map<String, Dto> dtoMap = dtosMap.get("schemas");
        FieldItem fieldItem = null;
        for (String key : dtoMap.keySet()) {
            FreemarkerVo vo = new FreemarkerVo();
            Dto dto = dtoMap.get(key);
            if (StringUtils.isNotEmpty((String)dto.getXapifoxFolder()) && dto.getXapifoxFolder().startsWith("constants") || isGen && !apifox.getPluginParameter().getGenIncludeDtoClasses().contains(key) || ApifoxConstants.ignoreDtoMap().keySet().contains(key)) continue;
            try {
                String rpcOrDto;
                String className = dto.getTitle();
                String classDesc = dto.getDescription();
                if (StringUtils.isNotEmpty((String)className) && className.indexOf("-") > 0) {
                    className = dto.getTitle().substring(0, dto.getTitle().indexOf("-"));
                    classDesc = dto.getTitle().substring(dto.getTitle().indexOf("-") + 1);
                }
                if (StringUtils.isEmpty((String)className)) {
                    className = key;
                    classDesc = key;
                }
                vo.setClassName(className);
                vo.setClassDesc(classDesc);
                vo.setBaseTag(this.getBaseTag(dto.getXapifoxFolder()));
                if (StringUtils.isNotEmpty((String)dto.getExtendsClassName())) {
                    vo.setExtendsClassName(dto.getExtendsClassName());
                    this.supplementImportTagByClassName(apifox, vo.getExtendsClassName(), vo);
                }
                for (String fieldName : dto.getProperties().keySet()) {
                    if (dto.getXapifoxIgnoreProperties() != null && dto.getXapifoxIgnoreProperties().contains(fieldName)) continue;
                    fieldItem = new FieldItem();
                    Propertie propertie = dto.getProperties().get(fieldName);
                    if (dto.getRequired() != null && dto.getRequired().contains(fieldName)) {
                        fieldItem.setNotNull(true);
                    }
                    if (propertie.getMinLength() != null || propertie.getMaxLength() != null) {
                        fieldItem.setSizeFlag(true);
                        if (propertie.getMinLength() != null) {
                            fieldItem.setMin(propertie.getMinLength());
                        }
                        if (propertie.getMaxLength() != null) {
                            fieldItem.setMax(propertie.getMaxLength());
                        }
                    }
                    String title = StringUtils.isEmpty((String)propertie.getTitle()) ? propertie.getDescription() : propertie.getTitle();
                    title = StringUtils.isNotEmpty((String)title) ? title.replaceAll("\"", "'") : "";
                    fieldItem.setName(fieldName);
                    fieldItem.setDesc(title);
                    fieldItem.setType(this.getFieldType(propertie, apifox, vo));
                    vo.getFieldList().add(fieldItem);
                }
                vo.setVersion("1.0.3");
                String string = rpcOrDto = Boolean.TRUE.equals(parameter.getIsGenerateProxy()) ? "rpc" : "dto";
                if (!isGen) continue;
                this.generateByFreemarker(parameter, vo, parameter.getOutput() + "/" + this.project + "-" + rpcOrDto + parameter.getBaseSourceFolder() + "/dto" + this.matchFolderByTag(vo.getBaseTag()), key + ".java", "dto.ftl");
            }
            catch (Exception e) {
                log.error("Catch a for dto===>{},vo===>{} , error message===>{}", new Object[]{key, vo, e.getMessage()});
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateApis(PluginParameter parameter, Apifox apifox) {
        StringBuffer sb = null;
        Map<String, Path> pathsMap = apifox.getPaths();
        for (Tag tag : apifox.getTags()) {
            FreemarkerVo vo = new FreemarkerVo();
            vo.setAppName(Optional.ofNullable(apifox.getInfo()).orElse(Apifox.DEFAULT_INFO).getDescription());
            vo.setAppCode(Optional.ofNullable(apifox.getInfo()).orElse(Apifox.DEFAULT_INFO).getTitle());
            try {
                String apiClassName = this.getApiClassName(tag.getName());
                if (StringUtils.isBlank((String)apiClassName)) {
                    log.info("tag=" + tag.getName() + ",\u65e0\u6cd5\u8bc6\u522bapi\uff0c\u4e0d\u751f\u6210api\u6e90\u7801");
                    continue;
                }
                if (!parameter.getGenIncludeApiClasses().isEmpty() && !parameter.getGenIncludeApiClasses().contains(apiClassName)) {
                    log.info("includeApiClasses\u4e0d\u5305\u542b\u63a5\u53e3\u7c7b" + apiClassName + "\uff0c\u65e0\u9700\u751f\u6210\u4ee3\u7801");
                    continue;
                }
                String baseTag = this.getBaseTag(tag.getName());
                String apiDesc = tag.getName().substring(tag.getName().indexOf("-") + 1);
                vo.setClassName(apiClassName);
                vo.setClassDesc(apiDesc);
                vo.setBaseTag(baseTag);
                for (String apiPath : pathsMap.keySet()) {
                    Path path = pathsMap.get(apiPath);
                    HttpMethod reqDefine = null;
                    if (path.getPost() != null) {
                        reqDefine = path.getPost();
                        reqDefine.setMethod("Post");
                    } else if (path.getGet() != null) {
                        reqDefine = path.getGet();
                        reqDefine.setMethod("Get");
                    } else if (path.getDelete() != null) {
                        reqDefine = path.getDelete();
                        reqDefine.setMethod("Delete");
                    } else if (path.getPut() != null) {
                        reqDefine = path.getPut();
                        reqDefine.setMethod("Put");
                    }
                    if (reqDefine == null) {
                        throw new RuntimeException("http\u65b9\u6cd5\u4ec5\u652f\u6301get/post/put/delete");
                    }
                    if (!reqDefine.getTags().contains(tag.getName())) continue;
                    FieldItem fieldItem = new FieldItem();
                    fieldItem.setHttpMethod(reqDefine);
                    fieldItem.setUri(apiPath);
                    fieldItem.setDesc(reqDefine.getDescription());
                    Map<String, ContentItem> contentItemMap = reqDefine.getResponses().get("200").getContent();
                    if (contentItemMap != null) {
                        sb = new StringBuffer();
                        sb.append("");
                        ContentItem contentItem = contentItemMap.get("application/json");
                        if (contentItem != null) {
                            Schema schema = contentItem.getSchema();
                            if (schema.getProperties() != null) {
                                Propertie dataPropertie = schema.getProperties().get("data");
                                if (dataPropertie != null) {
                                    String ref;
                                    if (dataPropertie.getExtendsClassName() != null) {
                                        ref = dataPropertie.getExtendsClassName();
                                        if ("PageInfo".equals(ref)) {
                                            sb.append("<");
                                            sb.append(ref);
                                            if (dataPropertie.getProperties() != null && dataPropertie.getProperties().get("list") != null) {
                                                Propertie listPropertie = dataPropertie.getProperties().get("list");
                                                if (listPropertie.getItems() != null && listPropertie.getItems().getRef() != null) {
                                                    ref = listPropertie.getItems().getRef();
                                                    ref = ref.substring(ref.lastIndexOf("/") + 1);
                                                    sb.append("<" + ref + ">");
                                                    this.supplementImportTag(apifox, ref, vo);
                                                }
                                            } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                                sb.append(dataPropertie.getDescription());
                                            }
                                            sb.append(">");
                                        }
                                    } else if (dataPropertie.getItems() != null) {
                                        sb.append("<");
                                        sb.append(ApifoxConstants.fieldTypeMap().get(dataPropertie.getType()));
                                        if (dataPropertie.getItems().getRef() != null) {
                                            ref = dataPropertie.getItems().getRef();
                                            ref = ref.substring(ref.lastIndexOf("/") + 1);
                                            sb.append("<" + ref + ">");
                                            this.supplementImportTag(apifox, ref, vo);
                                        } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                            sb.append(dataPropertie.getDescription());
                                        }
                                        sb.append(">");
                                    } else if (dataPropertie.getRef() != null) {
                                        sb.append("<");
                                        sb.append(dataPropertie.getRef().substring(dataPropertie.getRef().lastIndexOf("/") + 1));
                                        if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                            sb.append(dataPropertie.getDescription());
                                        }
                                        sb.append(">");
                                        this.supplementImportTag(apifox, dataPropertie.getRef(), vo);
                                    } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                        sb.append(dataPropertie.getDescription());
                                    } else if (dataPropertie.getType() != null && ApifoxConstants.fieldTypeMap().containsKey(dataPropertie.getType())) {
                                        sb.append("<" + this.getFieldType(dataPropertie) + ">");
                                    } else {
                                        sb.append("<Void>");
                                    }
                                    fieldItem.setType(sb.toString());
                                } else {
                                    fieldItem.setType("<Void>");
                                }
                            } else {
                                fieldItem.setType("<Void>");
                            }
                        } else {
                            fieldItem.setType("<Void>");
                        }
                    } else {
                        fieldItem.setType("<Void>");
                    }
                    if (StringUtils.isBlank((String)reqDefine.getSummary())) {
                        throw new BizException("-1", reqDefine.getDescription() + "\u5c11\u4e86summary\u914d\u7f6e");
                    }
                    if (!reqDefine.getSummary().contains("-") || reqDefine.getSummary().indexOf("-") == 0) {
                        throw new BizException("-1", "summary\u683c\u5f0f\u6709\u8bef\uff0c\u53c2\u8003\uff1aapiMethodName-\u63a5\u53e3\u65b9\u6cd5\u63cf\u8ff0");
                    }
                    fieldItem.setName(reqDefine.getSummary().substring(0, reqDefine.getSummary().indexOf("-")));
                    sb = new StringBuffer();
                    if (reqDefine.getParameters() != null) {
                        this.supplementRequestParamsString("api", apifox, sb, new StringBuffer(), null, reqDefine, fieldItem, null);
                    }
                    if (reqDefine.getRequestBody() != null && reqDefine.getRequestBody().getContent() != null) {
                        this.supplementRequestBodyParamsString("api", apifox, sb, new StringBuffer(), vo, null, reqDefine);
                    }
                    if (sb.length() >= 2) {
                        sb.deleteCharAt(sb.length() - 1);
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    fieldItem.setParams(sb.toString());
                    vo.getFieldList().add(fieldItem);
                }
                String rpcOrApi = Boolean.TRUE.equals(parameter.getIsGenerateProxy()) ? "rpc" : "api";
                this.generateByFreemarker(parameter, vo, parameter.getOutput() + "/" + this.project + "-" + rpcOrApi + parameter.getBaseSourceFolder() + "/api" + this.matchFolderByTag(vo.getBaseTag()), apiClassName + ".java", "api.ftl");
            }
            catch (Exception e) {
                log.error("Catch a for api===>{},vo===>{} , error message===>{}", new Object[]{tag, vo, e.getMessage()});
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateRests(PluginParameter parameter, Apifox apifox) {
        StringBuffer sb = null;
        Map<String, Path> pathsMap = apifox.getPaths();
        Set<String> defaultMethodNameSet = ApifoxConstants.defaultMethodNameSet();
        Map<String, String> specialFieldAndTypeInPathMap = ApifoxConstants.specialFieldAndTypeInPathMap();
        for (Tag tag : apifox.getTags()) {
            FreemarkerVo vo = new FreemarkerVo();
            vo.setAppName(Optional.ofNullable(apifox.getInfo()).orElse(Apifox.DEFAULT_INFO).getDescription());
            vo.setAppCode(Optional.ofNullable(apifox.getInfo()).orElse(Apifox.DEFAULT_INFO).getTitle());
            if (StringUtils.isBlank((String)this.getApiClassName(tag.getName()))) {
                log.info("tag=" + tag.getName() + ",\u65e0\u6cd5\u8bc6\u522bapi\uff0c\u4e0d\u751f\u6210rest\u6e90\u7801");
                continue;
            }
            vo.setBaseTag(this.getBaseTag(tag.getName()));
            try {
                for (String apiPath : pathsMap.keySet()) {
                    sb = new StringBuffer();
                    StringBuffer sbCall = new StringBuffer();
                    Path path = pathsMap.get(apiPath);
                    HttpMethod reqDefine = null;
                    if (path.getPost() != null) {
                        reqDefine = path.getPost();
                        reqDefine.setMethod("Post");
                    } else if (path.getGet() != null) {
                        reqDefine = path.getGet();
                        reqDefine.setMethod("Get");
                    } else if (path.getDelete() != null) {
                        reqDefine = path.getDelete();
                        reqDefine.setMethod("Delete");
                    } else if (path.getPut() != null) {
                        reqDefine = path.getPut();
                        reqDefine.setMethod("Put");
                    }
                    if (reqDefine == null) {
                        throw new RuntimeException("http\u65b9\u6cd5\u4ec5\u652f\u6301get/post/put/delete");
                    }
                    if (!reqDefine.getTags().contains(tag.getName())) continue;
                    String apiClassName = this.getApiClassName(tag.getName());
                    if (StringUtils.isBlank((String)apiClassName)) {
                        log.info("tag=" + tag.getName() + ",\u65e0\u6cd5\u8bc6\u522bapi\uff0c\u4e0d\u751f\u6210api\u6e90\u7801");
                        continue;
                    }
                    String apiDesc = tag.getName().substring(tag.getName().indexOf("-") + 1);
                    vo.setClassName(apiClassName);
                    vo.setClassDesc(apiDesc);
                    vo.setBaseBeanName(apiClassName.substring(1, apiClassName.length() - 3));
                    FieldItem fieldItem = new FieldItem();
                    fieldItem.setHttpMethod(reqDefine);
                    fieldItem.setUri(apiPath);
                    fieldItem.setDesc(reqDefine.getDescription());
                    Map<String, ContentItem> contentItemMap = reqDefine.getResponses().get("200").getContent();
                    if (contentItemMap != null) {
                        ContentItem contentItem = contentItemMap.get("application/json");
                        if (contentItem != null) {
                            Schema schema = contentItem.getSchema();
                            if (schema.getProperties() != null) {
                                Propertie dataPropertie = schema.getProperties().get("data");
                                if (dataPropertie != null) {
                                    String ref;
                                    if (dataPropertie.getExtendsClassName() != null) {
                                        ref = dataPropertie.getExtendsClassName();
                                        if ("PageInfo".equals(ref)) {
                                            sb.append("<");
                                            sb.append(ref);
                                            if (dataPropertie.getProperties() != null && dataPropertie.getProperties().get("list") != null) {
                                                Propertie listPropertie = dataPropertie.getProperties().get("list");
                                                if (listPropertie.getItems() != null && listPropertie.getItems().getRef() != null) {
                                                    ref = listPropertie.getItems().getRef();
                                                    ref = ref.substring(ref.lastIndexOf("/") + 1);
                                                    sb.append("<" + ref + ">");
                                                    this.supplementImportTag(apifox, listPropertie.getItems().getRef(), vo);
                                                }
                                            } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                                sb.append(dataPropertie.getDescription());
                                            }
                                            sb.append(">");
                                        }
                                    } else if (dataPropertie.getItems() != null) {
                                        sb.append("<");
                                        sb.append(ApifoxConstants.fieldTypeMap().get(dataPropertie.getType()));
                                        if (dataPropertie.getItems().getRef() != null) {
                                            ref = dataPropertie.getItems().getRef();
                                            ref = ref.substring(ref.lastIndexOf("/") + 1);
                                            sb.append("<" + ref + ">");
                                            this.supplementImportTag(apifox, dataPropertie.getItems().getRef(), vo);
                                        } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                            sb.append(dataPropertie.getDescription());
                                        }
                                        sb.append(">");
                                    } else if (dataPropertie.getRef() != null) {
                                        sb.append("<");
                                        sb.append(dataPropertie.getRef().substring(dataPropertie.getRef().lastIndexOf("/") + 1));
                                        if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                            sb.append(dataPropertie.getDescription());
                                        }
                                        sb.append(">");
                                        this.supplementImportTag(apifox, dataPropertie.getRef(), vo);
                                    } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                        sb.append(dataPropertie.getDescription());
                                    } else if (dataPropertie.getType() != null && ApifoxConstants.fieldTypeMap().containsKey(dataPropertie.getType())) {
                                        sb.append("<" + this.getFieldType(dataPropertie) + ">");
                                    } else {
                                        sb.append("<Void>");
                                    }
                                    fieldItem.setType(sb.toString());
                                } else {
                                    fieldItem.setType("<Void>");
                                }
                            } else {
                                fieldItem.setType("<Void>");
                            }
                        } else {
                            fieldItem.setType("<Void>");
                        }
                    } else {
                        fieldItem.setType("<Void>");
                    }
                    fieldItem.setName(reqDefine.getSummary().substring(0, reqDefine.getSummary().indexOf("-")));
                    sb = new StringBuffer();
                    boolean hasParaFlag = false;
                    if (reqDefine.getParameters() != null) {
                        this.supplementRequestParamsString("rest", apifox, sb, sbCall, defaultMethodNameSet, reqDefine, fieldItem, specialFieldAndTypeInPathMap);
                    }
                    if (reqDefine.getRequestBody() != null && reqDefine.getRequestBody().getContent() != null) {
                        this.supplementRequestBodyParamsString("rest", apifox, sb, sbCall, vo, null, reqDefine);
                    }
                    if (sb.length() >= 2) {
                        sb.deleteCharAt(sb.length() - 1);
                        sbCall.deleteCharAt(sbCall.length() - 1);
                        sb.deleteCharAt(sb.length() - 1);
                        sbCall.deleteCharAt(sbCall.length() - 1);
                    }
                    fieldItem.setParams(sb.toString());
                    fieldItem.setParamsApi(sbCall.toString());
                    vo.getFieldList().add(fieldItem);
                }
                this.generateByFreemarker(parameter, vo, parameter.getOutput() + "/" + this.project + "-rest" + parameter.getBaseSourceFolder() + "/rest" + this.matchFolderByTag(vo.getBaseTag()), vo.getBaseBeanName() + "Controller.java", "controller.ftl");
            }
            catch (Exception e) {
                log.error("Catch a for rest===>{},vo===>{} , error message===>{}", new Object[]{tag, vo, e.getMessage()});
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateServices(PluginParameter parameter, Apifox apifox) {
        StringBuffer sb = null;
        Set<String> defaultMethodNameSet = ApifoxConstants.defaultMethodNameSet();
        Map<String, Path> pathsMap = apifox.getPaths();
        for (Tag tag : apifox.getTags()) {
            String apiClassName = this.getApiClassName(tag.getName());
            if (StringUtils.isBlank((String)apiClassName)) {
                log.info("tag=" + tag.getName() + ",\u65e0\u6cd5\u8bc6\u522bapi\uff0c\u4e0d\u751f\u6210service\u6e90\u7801");
                continue;
            }
            if (!parameter.getGenIncludeApiClasses().isEmpty() && !parameter.getGenIncludeApiClasses().contains(apiClassName)) {
                log.info("includeApiClasses\u4e0d\u5305\u542b\u63a5\u53e3\u7c7b" + apiClassName + "\uff0c\u65e0\u9700\u751f\u6210service\u4ee3\u7801");
                continue;
            }
            String apiDesc = tag.getName().substring(tag.getName().indexOf("-") + 1);
            FreemarkerVo vo = new FreemarkerVo();
            vo.setAppName(Optional.ofNullable(apifox.getInfo()).orElse(Apifox.DEFAULT_INFO).getDescription());
            vo.setClassName(apiClassName);
            vo.setClassDesc(apiDesc);
            vo.setApiClassName(apiClassName);
            vo.setBaseBeanName(apiClassName.substring(1, apiClassName.length() - 3));
            vo.setBaseTag(this.getBaseTag(tag.getName()));
            if ("entity".equals(vo.getBaseTag())) {
                vo.setIsEntityTag("entity".equals(vo.getBaseTag()));
            }
            try {
                for (String apiPath : pathsMap.keySet()) {
                    sb = new StringBuffer();
                    StringBuffer sbCall = new StringBuffer();
                    Path path = pathsMap.get(apiPath);
                    HttpMethod reqDefine = null;
                    if (path.getPost() != null) {
                        reqDefine = path.getPost();
                        reqDefine.setMethod("Post");
                    } else if (path.getGet() != null) {
                        reqDefine = path.getGet();
                        reqDefine.setMethod("Get");
                    } else if (path.getDelete() != null) {
                        reqDefine = path.getDelete();
                        reqDefine.setMethod("Delete");
                    } else if (path.getPut() != null) {
                        reqDefine = path.getPut();
                        reqDefine.setMethod("Put");
                    }
                    if (reqDefine == null) {
                        throw new RuntimeException("http\u65b9\u6cd5\u4ec5\u652f\u6301get/post/put/delete");
                    }
                    if (!reqDefine.getTags().contains(tag.getName())) continue;
                    FieldItem fieldItem = new FieldItem();
                    fieldItem.setHttpMethod(reqDefine);
                    fieldItem.setDesc(reqDefine.getDescription());
                    Map<String, ContentItem> contentItemMap = reqDefine.getResponses().get("200").getContent();
                    if (contentItemMap != null) {
                        ContentItem contentItem = contentItemMap.get("application/json");
                        if (contentItem != null) {
                            Schema schema = contentItem.getSchema();
                            if (schema.getProperties() != null) {
                                Propertie dataPropertie = schema.getProperties().get("data");
                                if (dataPropertie != null) {
                                    String ref;
                                    if (dataPropertie.getExtendsClassName() != null) {
                                        ref = dataPropertie.getExtendsClassName();
                                        if ("PageInfo".equals(ref)) {
                                            sb.append("<");
                                            sb.append(ref);
                                            if (dataPropertie.getProperties() != null && dataPropertie.getProperties().get("list") != null) {
                                                Propertie listPropertie = dataPropertie.getProperties().get("list");
                                                if (listPropertie.getItems() != null && listPropertie.getItems().getRef() != null) {
                                                    ref = listPropertie.getItems().getRef();
                                                    ref = ref.substring(ref.lastIndexOf("/") + 1);
                                                    sb.append("<" + ref + ">");
                                                    this.supplementImportTag(apifox, listPropertie.getItems().getRef(), vo);
                                                }
                                            } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                                sb.append(dataPropertie.getDescription());
                                            }
                                            sb.append(">");
                                        }
                                    } else if (dataPropertie.getItems() != null) {
                                        sb.append("<");
                                        sb.append(ApifoxConstants.fieldTypeMap().get(dataPropertie.getType()));
                                        if (dataPropertie.getItems().getRef() != null) {
                                            ref = dataPropertie.getItems().getRef();
                                            ref = ref.substring(ref.lastIndexOf("/") + 1);
                                            sb.append("<" + ref + ">");
                                            this.supplementImportTag(apifox, dataPropertie.getItems().getRef(), vo);
                                        } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                            sb.append(dataPropertie.getDescription());
                                        }
                                        sb.append(">");
                                    } else if (dataPropertie.getRef() != null) {
                                        sb.append("<");
                                        sb.append(dataPropertie.getRef().substring(dataPropertie.getRef().lastIndexOf("/") + 1));
                                        if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                            sb.append(dataPropertie.getDescription());
                                        }
                                        sb.append(">");
                                    } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                        sb.append(dataPropertie.getDescription());
                                    } else if (dataPropertie.getType() != null && ApifoxConstants.fieldTypeMap().containsKey(dataPropertie.getType())) {
                                        sb.append("<" + this.getFieldType(dataPropertie) + ">");
                                    } else {
                                        sb.append("<Void>");
                                    }
                                    fieldItem.setType(sb.toString());
                                } else {
                                    fieldItem.setType("<Void>");
                                }
                            } else {
                                fieldItem.setType("<Void>");
                            }
                        } else {
                            fieldItem.setType("<Void>");
                        }
                    } else {
                        fieldItem.setType("<Void>");
                    }
                    fieldItem.setName(reqDefine.getSummary().substring(0, reqDefine.getSummary().indexOf("-")));
                    if (defaultMethodNameSet.contains(fieldItem.getName())) continue;
                    sb = new StringBuffer();
                    boolean hasParaFlag = false;
                    if (reqDefine.getParameters() != null) {
                        this.supplementRequestParamsString("service", apifox, sb, sbCall, defaultMethodNameSet, reqDefine, fieldItem, null);
                    }
                    if (reqDefine.getRequestBody() != null && reqDefine.getRequestBody().getContent() != null) {
                        this.supplementRequestBodyParamsString("service", apifox, sb, sbCall, vo, null, reqDefine);
                    }
                    if (sb.length() >= 2) {
                        sb.deleteCharAt(sb.length() - 1);
                        sbCall.deleteCharAt(sbCall.length() - 1);
                        sb.deleteCharAt(sb.length() - 1);
                        sbCall.deleteCharAt(sbCall.length() - 1);
                    }
                    fieldItem.setParams(sb.toString());
                    fieldItem.setParamsApi(sbCall.toString());
                    vo.getFieldList().add(fieldItem);
                }
                this.generateByFreemarker(parameter, vo, parameter.getOutput() + "/" + this.project + "-service" + parameter.getBaseSourceFolder() + "/service" + this.matchFolderByTag(vo.getBaseTag()), "I" + vo.getBaseBeanName() + "Service.java", "service.ftl");
            }
            catch (Exception e) {
                log.error("Catch a for service===>{},vo===>{} , error message===>{}", new Object[]{tag, vo, e.getMessage()});
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateApiProxys(PluginParameter parameter, Apifox apifox) {
        StringBuffer sb = null;
        ArrayList<FreemarkerVo> voList = new ArrayList<FreemarkerVo>();
        Map<String, Path> pathsMap = apifox.getPaths();
        for (Tag tag : apifox.getTags()) {
            String apiClassName = this.getApiClassName(tag.getName());
            if (StringUtils.isBlank((String)apiClassName)) {
                log.info("tag=" + tag.getName() + ",\u65e0\u6cd5\u8bc6\u522bapi\uff0c\u4e0d\u751f\u6210proxys\u6e90\u7801");
                continue;
            }
            if (!parameter.getGenIncludeApiClasses().isEmpty() && !parameter.getGenIncludeApiClasses().contains(apiClassName)) {
                log.info("includeApiClasses\u4e0d\u5305\u542b\u63a5\u53e3\u7c7b" + apiClassName + "\uff0c\u65e0\u9700\u751f\u6210proxy\u4ee3\u7801");
                continue;
            }
            String apiDesc = tag.getName().substring(tag.getName().indexOf("-") + 1);
            FreemarkerVo vo = new FreemarkerVo();
            vo.setAppName(Optional.ofNullable(apifox.getInfo()).orElse(Apifox.DEFAULT_INFO).getDescription());
            vo.setClassName(apiClassName);
            vo.setClassDesc(apiDesc);
            vo.setApiClassName(apiClassName);
            vo.setBaseTag(this.getBaseTag(tag.getName()));
            FreemarkerVo voImpl = new FreemarkerVo();
            voImpl.setAppName(Optional.ofNullable(apifox.getInfo()).orElse(Apifox.DEFAULT_INFO).getDescription());
            voImpl.setClassName(apiClassName.startsWith("I") ? apiClassName.substring(1) : apiClassName);
            voImpl.setClassDesc(apiDesc);
            voImpl.setApiClassName(apiClassName);
            voImpl.setApiClassNameMethod(voImpl.getClassName().substring(0, 1).toLowerCase() + voImpl.getClassName().substring(1));
            voImpl.setBaseTag(this.getBaseTag(tag.getName()));
            voList.add(voImpl);
            try {
                for (String apiPath : pathsMap.keySet()) {
                    sb = new StringBuffer();
                    StringBuffer sbCall = new StringBuffer();
                    Path path = pathsMap.get(apiPath);
                    HttpMethod reqDefine = null;
                    if (path.getPost() != null) {
                        reqDefine = path.getPost();
                        reqDefine.setMethod("Post");
                    } else if (path.getGet() != null) {
                        reqDefine = path.getGet();
                        reqDefine.setMethod("Get");
                    } else if (path.getDelete() != null) {
                        reqDefine = path.getDelete();
                        reqDefine.setMethod("Delete");
                    } else if (path.getPut() != null) {
                        reqDefine = path.getPut();
                        reqDefine.setMethod("Put");
                    }
                    if (reqDefine == null) {
                        throw new RuntimeException("http\u65b9\u6cd5\u4ec5\u652f\u6301get/post/put/delete");
                    }
                    if (!reqDefine.getTags().contains(tag.getName())) continue;
                    FieldItem fieldItem = new FieldItem();
                    fieldItem.setHttpMethod(reqDefine);
                    fieldItem.setDesc(reqDefine.getDescription());
                    Map<String, ContentItem> contentItemMap = reqDefine.getResponses().get("200").getContent();
                    if (contentItemMap != null) {
                        ContentItem contentItem = contentItemMap.get("application/json");
                        if (contentItem != null) {
                            Schema schema = contentItem.getSchema();
                            if (schema.getProperties() != null) {
                                Propertie dataPropertie = schema.getProperties().get("data");
                                if (dataPropertie != null) {
                                    String ref;
                                    if (dataPropertie.getExtendsClassName() != null) {
                                        ref = dataPropertie.getExtendsClassName();
                                        if ("PageInfo".equals(ref)) {
                                            sb.append("<");
                                            sb.append(ref);
                                            if (dataPropertie.getProperties() != null && dataPropertie.getProperties().get("list") != null) {
                                                Propertie listPropertie = dataPropertie.getProperties().get("list");
                                                if (listPropertie.getItems() != null && listPropertie.getItems().getRef() != null) {
                                                    ref = listPropertie.getItems().getRef();
                                                    ref = ref.substring(ref.lastIndexOf("/") + 1);
                                                    sb.append("<" + ref + ">");
                                                    this.supplementImportTag(apifox, listPropertie.getItems().getRef(), vo);
                                                    this.supplementImportTag(apifox, listPropertie.getItems().getRef(), voImpl);
                                                }
                                            } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                                sb.append(dataPropertie.getDescription());
                                            }
                                            sb.append(">");
                                        }
                                    } else if (dataPropertie.getItems() != null) {
                                        sb.append("<");
                                        sb.append(ApifoxConstants.fieldTypeMap().get(dataPropertie.getType()));
                                        if (dataPropertie.getItems().getRef() != null) {
                                            ref = dataPropertie.getItems().getRef();
                                            ref = ref.substring(ref.lastIndexOf("/") + 1);
                                            sb.append("<" + ref + ">");
                                        } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                            sb.append(dataPropertie.getDescription());
                                        }
                                        sb.append(">");
                                        this.supplementImportTag(apifox, dataPropertie.getItems().getRef(), vo);
                                        this.supplementImportTag(apifox, dataPropertie.getItems().getRef(), voImpl);
                                    } else if (dataPropertie.getRef() != null) {
                                        sb.append("<");
                                        sb.append(dataPropertie.getRef().substring(dataPropertie.getRef().lastIndexOf("/") + 1));
                                        if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                            sb.append(dataPropertie.getDescription());
                                        }
                                        sb.append(">");
                                        this.supplementImportTag(apifox, dataPropertie.getRef(), vo);
                                        this.supplementImportTag(apifox, dataPropertie.getRef(), voImpl);
                                    } else if (dataPropertie.getDescription() != null && dataPropertie.getDescription().startsWith("<") && dataPropertie.getDescription().endsWith(">")) {
                                        sb.append(dataPropertie.getDescription());
                                    } else if (dataPropertie.getType() != null && ApifoxConstants.fieldTypeMap().containsKey(dataPropertie.getType())) {
                                        sb.append("<" + this.getFieldType(dataPropertie) + ">");
                                    } else {
                                        sb.append("<Void>");
                                    }
                                    fieldItem.setType(sb.toString());
                                } else {
                                    fieldItem.setType("<Void>");
                                }
                            } else {
                                fieldItem.setType("<Void>");
                            }
                        } else {
                            fieldItem.setType("<Void>");
                        }
                    } else {
                        fieldItem.setType("<Void>");
                    }
                    fieldItem.setName(reqDefine.getSummary().substring(0, reqDefine.getSummary().indexOf("-")));
                    sb = new StringBuffer();
                    boolean hasParaFlag = false;
                    if (reqDefine.getParameters() != null) {
                        this.supplementRequestParamsString("proxy", apifox, sb, sbCall, null, reqDefine, fieldItem, null);
                    }
                    if (reqDefine.getRequestBody() != null && reqDefine.getRequestBody().getContent() != null) {
                        this.supplementRequestBodyParamsString("proxy", apifox, sb, sbCall, vo, voImpl, reqDefine);
                    }
                    if (sb.length() >= 2) {
                        sb.deleteCharAt(sb.length() - 1);
                        sbCall.deleteCharAt(sbCall.length() - 1);
                        sb.deleteCharAt(sb.length() - 1);
                        sbCall.deleteCharAt(sbCall.length() - 1);
                    }
                    fieldItem.setParams(sb.toString());
                    fieldItem.setParamsApi(sbCall.toString());
                    vo.getFieldList().add(fieldItem);
                    voImpl.getFieldList().add(fieldItem);
                }
                vo.setVersion("1.0.0");
                voImpl.setVersion("1.0.1");
                this.generateByFreemarker(parameter, vo, parameter.getOutput() + "/" + this.project + "-rpc" + parameter.getBaseSourceFolder() + "/proxy" + this.matchFolderByTag(vo.getBaseTag()), apiClassName + "Proxy.java", "proxy.ftl");
                this.generateByFreemarker(parameter, voImpl, parameter.getOutput() + "/" + this.project + "-rpc" + parameter.getBaseSourceFolder() + "/proxy" + this.matchFolderByTag(vo.getBaseTag()) + "/impl", voImpl.getClassName() + "ProxyImpl.java", "proxyImpl.ftl");
            }
            catch (Exception e) {
                log.error("Catch a for proxy===>{},vo===>{} , error message===>{}", new Object[]{tag, vo, e.getMessage()});
                e.printStackTrace();
            }
        }
        try {
            if (!voList.isEmpty()) {
                Map<String, List<FreemarkerVo>> voImplMap = voList.stream().collect(Collectors.groupingBy(FreemarkerVo::getBaseTag));
                voImplMap.forEach((bg, list) -> {
                    FreemarkerVo freemarkerVo = new FreemarkerVo();
                    freemarkerVo.setBaseTag((String)bg);
                    freemarkerVo.setProxies((List<FreemarkerVo>)list);
                    freemarkerVo.setBaseTagName(bg.substring(0, 1).toUpperCase() + bg.substring(1));
                    this.generateByFreemarker(parameter, freemarkerVo, parameter.getOutput() + "/" + this.project + "-rpc" + parameter.getBaseSourceFolder() + "/rpc/config", "Proxy" + freemarkerVo.getBaseTagName() + "Configuration.java", "proxyConfig.ftl");
                });
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }

    private void supplementRequestParamsString(String fileType, Apifox apifox, StringBuffer sb, StringBuffer sbCall, Set<String> defaultMethodNameSet, HttpMethod reqDefine, FieldItem fieldItem, Map<String, String> specialFieldAndTypeInPathMap) {
        for (Parameter para : reqDefine.getParameters()) {
            Propertie propertie = this.exchangeArraySchema2Propertie(para.getSchema());
            if ("path".equals(para.getIn())) {
                if (para.getName().toUpperCase().endsWith("ID")) {
                    propertie.setFormat("int16");
                } else {
                    propertie.setFormat("int4");
                }
                if ("api".equals(fileType) || "rest".equals(fileType)) {
                    sb.append("@PathVariable(name=\"").append(para.getName()).append("\",required=").append(para.getRequired()).append(") ").append(this.getFieldType(propertie, apifox, null));
                    sb.append(" ").append(para.getName());
                } else {
                    sb.append(this.getFieldType(propertie, apifox, null)).append(" ").append(para.getName());
                }
                if (defaultMethodNameSet != null) {
                    if (defaultMethodNameSet.contains(fieldItem.getName()) && specialFieldAndTypeInPathMap.containsKey(para.getName())) {
                        sb.append(specialFieldAndTypeInPathMap.get(para.getName()));
                    } else {
                        sb.append(this.getFieldType(propertie));
                    }
                }
            } else {
                if (!"query".equals(para.getIn())) continue;
                if ("api".equals(fileType) || "rest".equals(fileType)) {
                    sb.append("@RequestParam(name=\"").append(para.getName()).append("\", required=").append(para.getRequired()).append(") ").append(this.getFieldType(propertie, apifox, null)).append(" ").append(para.getName());
                } else {
                    sb.append(this.getFieldType(propertie, apifox, null)).append(" ").append(para.getName());
                }
            }
            sbCall.append(para.getName());
            sbCall.append(", ");
            sb.append(", ");
        }
    }

    private void supplementRequestBodyParamsString(String fileType, Apifox apifox, StringBuffer sb, StringBuffer sbCall, FreemarkerVo vo, FreemarkerVo voImpl, HttpMethod reqDefine) {
        String dtoName = "reqDto";
        ContentItem contentItem = reqDefine.getRequestBody().getContent().get("application/json");
        Schema schema = Optional.ofNullable(contentItem).map(ContentItem::getSchema).orElseGet(() -> reqDefine.getRequestBody().getContent().get("multipart/form-data").getSchema());
        if (schema == null) {
            throw new BizException(reqDefine.getSummary() + " schema\u672a\u5b9a\u4e49");
        }
        if ("object".equals(schema.getType()) && schema.getXapifoxRefs() != null) {
            String refClass = null;
            for (XapifoxRef xApifoxRef : schema.getXapifoxRefs().values()) {
                refClass = xApifoxRef.getRef().substring(xApifoxRef.getRef().lastIndexOf("/") + 1);
                this.supplementImportTag(apifox, xApifoxRef.getRef(), vo);
                Optional.ofNullable(voImpl).ifPresent(voi -> this.supplementImportTag(apifox, xApifoxRef.getRef(), (FreemarkerVo)voi));
            }
            if (refClass != null) {
                sb.append(refClass).append(" ").append("reqDto");
                sbCall.append("reqDto");
            }
        } else if ("array".equals(schema.getType())) {
            if ("api".equals(fileType) || "rest".equals(fileType)) {
                sb.append("@RequestBody ").append(this.getFieldType(this.exchangeArraySchema2Propertie(schema), apifox, vo)).append(" ").append("reqDto");
            } else {
                sb.append(this.getFieldType(this.exchangeArraySchema2Propertie(schema), apifox, vo)).append(" ").append("reqDto");
            }
            sbCall.append("reqDto");
        } else {
            String refClass = schema.getRef().substring(schema.getRef().lastIndexOf("/") + 1);
            if ("api".equals(fileType) || "rest".equals(fileType)) {
                sb.append("@RequestBody ").append(refClass).append(" ").append("reqDto");
            } else {
                sb.append(refClass).append(" ").append("reqDto");
            }
            sbCall.append("reqDto");
            this.supplementImportTag(apifox, schema.getRef(), vo);
            Optional.ofNullable(voImpl).ifPresent(voi -> this.supplementImportTag(apifox, schema.getRef(), voImpl));
        }
        sb.append(", ");
        sbCall.append(", ");
    }

    private Propertie exchangeArraySchema2Propertie(Schema schema) {
        Propertie propertie = new Propertie();
        CubeBeanUtils.copyProperties((Object)propertie, (Object)schema, (String[])new String[0]);
        return propertie;
    }

    private String getFieldType(Propertie propertie) {
        return this.getFieldType(propertie, null, null);
    }

    private String getFieldType(Propertie propertie, Apifox apifox, FreemarkerVo vo) {
        Map<String, String> fieldTypeMap = ApifoxConstants.fieldTypeMap();
        String fieldType = null;
        if ("string".equals(propertie.getType()) && "date-time".equals(propertie.getFormat())) {
            fieldType = "Date";
        } else if ("object".equals(propertie.getType())) {
            fieldType = StringUtils.isNotBlank((String)propertie.getRef()) ? propertie.getRef().substring(propertie.getRef().lastIndexOf("/") + 1) : (StringUtils.isNotEmpty((String)propertie.getDescription()) && propertie.getDescription().startsWith("<") && propertie.getDescription().endsWith(">") ? propertie.getDescription() : "Void");
        } else if ("array".equals(propertie.getType())) {
            if (propertie.getItems() != null && StringUtils.isNotEmpty((String)propertie.getItems().getRef())) {
                String className = propertie.getItems().getRef().substring(propertie.getItems().getRef().lastIndexOf("/") + 1);
                fieldType = "List<" + className + ">";
                this.supplementImportTagByClassName(apifox, className, vo);
            } else if (propertie.getItems() != null && StringUtils.isNotEmpty((String)propertie.getItems().getType())) {
                fieldType = "List<" + this.getFieldType(propertie.getItems()) + ">";
            } else if (StringUtils.isNotEmpty((String)propertie.getDescription()) && propertie.getDescription().startsWith("<") && propertie.getDescription().endsWith(">")) {
                fieldType = "List" + propertie.getDescription();
            } else if (StringUtils.isNotEmpty((String)propertie.getDescription())) {
                fieldType = propertie.getDescription();
            }
        } else if ("integer".equals(propertie.getType()) && StringUtils.isNotEmpty((String)propertie.getFormat())) {
            Integer n;
            fieldType = "long".equalsIgnoreCase(propertie.getFormat()) ? "Long" : ((n = new Integer(propertie.getFormat().substring(3))) >= 16 ? "Long" : "Integer");
        } else if ("number".equals(propertie.getType())) {
            fieldType = "BigDecimal";
        } else if (StringUtils.isNotEmpty((String)propertie.getRef())) {
            if (StringUtils.isNotEmpty((String)propertie.getDescription()) && propertie.getDescription().startsWith("<") && propertie.getDescription().endsWith(">")) {
                fieldType = propertie.getDescription();
            } else {
                fieldType = propertie.getRef().substring(propertie.getRef().lastIndexOf("/") + 1);
                this.supplementImportTag(apifox, propertie.getRef(), vo);
            }
        } else {
            fieldType = fieldTypeMap.get(propertie.getType());
        }
        return fieldType;
    }

    private String getApiClassName(String tagName) {
        if (StringUtils.isBlank((String)tagName)) {
            return null;
        }
        String[] names = tagName.split("/");
        String apiName = names[names.length - 1];
        String[] apiSp = apiName.split("-");
        if (apiSp.length <= 1) {
            return null;
        }
        return apiName.substring(0, apiName.indexOf("-"));
    }

    private String getBaseTag(String tagName) {
        if (StringUtils.isBlank((String)tagName)) {
            return null;
        }
        String[] names = tagName.split("/");
        return names[0];
    }

    private String matchFolderByTag(String baseTag) {
        return Optional.ofNullable(baseTag).map(tg -> "/" + tg).orElse("");
    }

    private void supplementImportTag(Apifox apiFox, String dtoRef, FreemarkerVo freemarkerVo) {
        if (StringUtils.isBlank((String)dtoRef)) {
            log.error("dtoRef \u5165\u53c2\u4e3a\u7a7a:", (Throwable)new BizException("dtoRef \u5165\u53c2\u4e3a\u7a7a"));
            return;
        }
        if (dtoRef.endsWith("Object")) {
            return;
        }
        String dtoName = this.getRefDtoDefineString(apiFox, dtoRef);
        Dto dto = apiFox.getComponents().get("schemas").get(dtoName);
        if (dto == null) {
            RuntimeException exception = new RuntimeException("\u83b7\u53d6\u4e0d\u5230" + dtoRef + "\u6a21\u578b\u5b9a\u4e49");
            log.error(exception.getMessage(), (Throwable)exception);
            return;
        }
        apiFox.getPluginParameter().getGenIncludeDtoClasses().add(dtoName);
        if (StringUtils.isNotBlank((String)dto.getXapifoxFolder())) {
            freemarkerVo.getDtoBaseTags().add(dto.getXapifoxFolder());
        }
    }

    private void supplementImportTagByClassName(Apifox apiFox, String className, FreemarkerVo freemarkerVo) {
        Dto dto = apiFox.getComponents().get("schemas").get(className);
        if (dto == null) {
            RuntimeException exception = new RuntimeException("\u83b7\u53d6\u4e0d\u5230" + className + "\u6a21\u578b\u5b9a\u4e49");
            log.error(exception.getMessage(), (Throwable)exception);
            return;
        }
        apiFox.getPluginParameter().getGenIncludeDtoClasses().add(className);
        if (StringUtils.isNotBlank((String)dto.getXapifoxFolder())) {
            freemarkerVo.getDtoBaseTags().add(dto.getXapifoxFolder());
        }
    }

    private String getRefDtoDefineString(Apifox apiFox, String ref) {
        if (apiFox == null) {
            throw new BizException(ref + " apiFox\u672a\u4f20\u5165");
        }
        String[] refs = ref.split("/");
        return refs[refs.length - 1];
    }

    public static void main(String[] args) {
        PluginParameter parameter = new PluginParameter();
        parameter.setOutput("yunxi-dg-base-center-example-gen");
        parameter.setBasePackage("com.yunxi.dg.base.center.example");
        parameter.setBaseSourceFolder("/src/main/java/com/yunxi/dg/base/center/example");
        parameter.setJsonPath("api-json/ApiFox-openapi.json");
        parameter.setIsGenerateProxy(true);
        parameter.setIsGenerateDto(true);
        parameter.setIsGenerateController(false);
        parameter.setIsGenerateService(false);
        parameter.setIsGenerateApi(true);
        ApifoxServiceImpl apifoxService = new ApifoxServiceImpl();
        boolean resultFlag = apifoxService.generateCode(parameter);
    }
}

