/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.plugins.apifox.utils.sql;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.gen.GenUtils;
import com.yunxi.dg.base.plugins.apifox.PluginParameter;
import com.yunxi.dg.base.plugins.apifox.utils.sql.create.CreateStmt;
import com.yunxi.dg.base.plugins.apifox.utils.sql.create.FieldStmt;
import com.yunxi.dg.base.plugins.apifox.utils.sql.utils.FileReadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class Api2JsonTransfer {
    static String descriptionKey = "description";
    static String titleKey = "title";
    static String formatKey = "format";
    static String actionKey = "action";
    static String[] dbFilterFields = new String[]{"id", "createPerson", "createTime", "updatePerson", "updateTime", "dr", "extFields", "instanceId", "tenantId", "extension"};
    static Map<String, Function<CreateStmt, JSONObject>> actionMap = new LinkedHashMap<String, Function<CreateStmt, JSONObject>>();
    static Map<String, Function<CreateStmt, JSONObject>> eoMap = new LinkedHashMap<String, Function<CreateStmt, JSONObject>>();

    public void transfer(List<CreateStmt> createStmts, String fileName, PluginParameter parameter) {
        if (CollectionUtils.isEmpty(createStmts)) {
            return;
        }
        String filePath = Optional.ofNullable(System.getProperty("transfer.filePath")).orElse("api-json");
        JSONObject swaggerJson = JSONObject.parseObject((String)FileReadUtils.readFileToString("/swagger/swagger-temp.json"));
        JSONArray tags = swaggerJson.getJSONArray("tags");
        JSONObject paths = swaggerJson.getJSONObject("paths");
        String componentsKey = "components";
        JSONObject schemas = swaggerJson.getJSONObject(componentsKey).getJSONObject("schemas");
        createStmts.forEach(createStmt -> {
            if (StringUtils.isEmpty((String)createStmt.getTableName())) {
                System.out.println("\u89e3\u6790\u540d\u79f0\u5f02\u5e38:" + JSONObject.toJSONString((Object)createStmt));
                return;
            }
            try {
                eoMap.forEach((key, value) -> {
                    if ("Enum".equals(key)) {
                        createStmt.getFieldStmtList().forEach(fieldStmt -> {
                            Matcher m = Pattern.compile("\\$\\$.*?\\$\\$").matcher(fieldStmt.getComment());
                            if (m.find()) {
                                CreateStmt enumStmt = new CreateStmt();
                                enumStmt.setTableComment(createStmt.getTableComment());
                                enumStmt.setTableName(createStmt.getTableName());
                                enumStmt.setFieldStmtList(Collections.singletonList(fieldStmt));
                                schemas.put(createStmt.getTableName() + Api2JsonTransfer.upCaseFirst(fieldStmt.getName()) + key, value.apply(enumStmt));
                            }
                        });
                    } else {
                        schemas.put(createStmt.getTableName() + key, value.apply(createStmt));
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\u89e3\u6790\u540d\u79f0\u5f02\u5e38:{}" + JSONObject.toJSONString((Object)createStmt));
            }
        });
        swaggerJson.put("tags", (Object)tags);
        swaggerJson.put("paths", (Object)paths);
        JSONObject components = swaggerJson.getJSONObject(componentsKey);
        components.put("schemas", (Object)schemas);
        swaggerJson.put(componentsKey, (Object)components);
        FileReadUtils.createJsonFile(swaggerJson, filePath + "/" + fileName);
    }

    private static String upCaseFirst(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String under2camel(String s) {
        return s;
    }

    private static String underCamelLower(String s) {
        return s;
    }

    public static void main(String[] args) {
        new Api2JsonTransfer().transfer(JSONArray.parseArray((String)"[{\"fieldStmtList\":[{\"canNull\":true,\"comment\":\"\u4e3b\u952eID\",\"name\":\"id\",\"size\":0},{\"canNull\":true,\"comment\":\"\u6807\u7b7e\u7f16\u7801\",\"name\":\"tagCode\",\"size\":50,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u6807\u7b7e\u540d\u79f0\",\"name\":\"tagName\",\"size\":120,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u6807\u7b7e\u72b6\u6001$$<INIT:INIT:\u521d\u59cb\u5316><CREATED::\u5df2\u521b\u5efa><SUCCESS::\u6210\u529f>$$\",\"format\":\"int4\",\"name\":\"tagStatus\",\"size\":4,\"type\":\"TINYINT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u6807\u7b7e\u7c7b\u578b SALE_ORDER_AUTO_TAG-\u9500\u552e\u8ba2\u5355\u81ea\u52a8\u6253\u6807 SALE_ORDER_MANUAL_TAG-\u9500\u552e\u8ba2\u5355\u624b\u52a8\u6253\u6807\",\"name\":\"tagType\",\"size\":50,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u6807\u7b7e\u91d1\u989d\",\"name\":\"tagAmount\",\"size\":28,\"type\":\"DECIMAL\",\"vastType\":\"number\"},{\"canNull\":true,\"comment\":\"\u8ba2\u5355id\",\"format\":\"int20\",\"name\":\"orderId\",\"size\":20,\"type\":\"BIGINT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u6807\u7b7e\u65f6\u95f4\",\"format\":\"date-time\",\"name\":\"tagTime\",\"size\":19,\"type\":\"DATETIME\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u62c6\u5206\u5355\u7ee7\u627f 1-\u7ee7\u627f 0-\u4e0d\u7ee7\u627f\",\"format\":\"int4\",\"name\":\"extend\",\"size\":4,\"type\":\"TINYINT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u903b\u8f91\u5220\u9664\u6807\u5fd7,0\u8868\u793a\u672a\u5220\u9664\uff0c1\u8868\u793a\u5220\u9664\",\"name\":\"dr\",\"size\":0},{\"canNull\":true,\"comment\":\"\u521b\u5efa\u4eba\",\"name\":\"createPerson\",\"size\":0},{\"canNull\":true,\"comment\":\"\u521b\u5efa\u65f6\u95f4\",\"name\":\"createTime\",\"size\":0},{\"canNull\":true,\"comment\":\"\u4fee\u6539\u4eba\",\"name\":\"updatePerson\",\"size\":0},{\"canNull\":true,\"comment\":\"\u4fee\u6539\u65f6\u95f4\",\"name\":\"updateTime\",\"size\":0},{\"canNull\":true,\"comment\":\"\u79df\u6237id\",\"name\":\"instanceId\",\"size\":0},{\"canNull\":true,\"comment\":\"\u79df\u6237\",\"name\":\"tenantId\",\"size\":0},{\"canNull\":true,\"comment\":\"\u6269\u5c55\u5b57\u6bb5\",\"name\":\"extension\",\"size\":1024,\"type\":\"VARCHAR\",\"vastType\":\"string\"}],\"tableComment\":\"\u8ba2\u5355\u6807\u7b7e\u8868\",\"tableName\":\"ex_order_tag\"},{\"fieldStmtList\":[{\"canNull\":true,\"comment\":\"\u4e3b\u952e\",\"name\":\"id\",\"size\":0},{\"canNull\":true,\"comment\":\"\u79df\u6237id\",\"name\":\"tenantId\",\"size\":0},{\"canNull\":true,\"comment\":\"\u5b9e\u4f8bid\",\"name\":\"instanceId\",\"size\":0},{\"canNull\":true,\"comment\":\"\u521b\u5efa\u65f6\u95f4\",\"name\":\"createTime\",\"size\":0},{\"canNull\":true,\"comment\":\"\u521b\u5efa\u4eba\",\"name\":\"createPerson\",\"size\":0},{\"canNull\":true,\"comment\":\"\u66f4\u65b0\u65f6\u95f4\",\"name\":\"updateTime\",\"size\":0},{\"canNull\":true,\"comment\":\"\u66f4\u65b0\u4eba\",\"name\":\"updatePerson\",\"size\":0},{\"canNull\":true,\"comment\":\"\u903b\u8f91\u5220\u9664\u6807\u8bb0\",\"name\":\"dr\",\"size\":0},{\"canNull\":true,\"comment\":\"\u5b66\u751f\u7f16\u7801\",\"name\":\"code\",\"size\":32,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u5b66\u751f\u540d\u79f0\",\"name\":\"name\",\"size\":64,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u6559\u5e08\u7f16\u7801\",\"name\":\"teacherCode\",\"size\":32,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u72b6\u6001\",\"name\":\"status\",\"size\":32,\"type\":\"VARCHAR\",\"vastType\":\"string\"}],\"tableComment\":\"\u5b66\u751f\",\"tableName\":\"ex_student\"},{\"fieldStmtList\":[{\"canNull\":true,\"comment\":\"\u4e3b\u952e\",\"name\":\"id\",\"size\":0},{\"canNull\":true,\"comment\":\"\u79df\u6237id\",\"name\":\"tenantId\",\"size\":0},{\"canNull\":true,\"comment\":\"\u5b9e\u4f8bid\",\"name\":\"instanceId\",\"size\":0},{\"canNull\":true,\"comment\":\"\u521b\u5efa\u65f6\u95f4\",\"name\":\"createTime\",\"size\":0},{\"canNull\":true,\"comment\":\"\u521b\u5efa\u4eba\",\"name\":\"createPerson\",\"size\":0},{\"canNull\":true,\"comment\":\"\u66f4\u65b0\u65f6\u95f4\",\"name\":\"updateTime\",\"size\":0},{\"canNull\":true,\"comment\":\"\u66f4\u65b0\u4eba\",\"name\":\"updatePerson\",\"size\":0},{\"canNull\":true,\"comment\":\"\u903b\u8f91\u5220\u9664\u6807\u8bb0\",\"name\":\"dr\",\"size\":0},{\"canNull\":true,\"comment\":\"\u6559\u5e08\u7f16\u7801\",\"name\":\"code\",\"size\":32,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u6559\u5e08\u540d\u79f0\",\"name\":\"name\",\"size\":64,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u5165\u804c\u65e5\u671f\",\"format\":\"date-time\",\"name\":\"inDate\",\"size\":19,\"type\":\"DATETIME\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u5e74\u9f84\",\"format\":\"int11\",\"name\":\"age\",\"size\":11,\"type\":\"INT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u85aa\u916c\",\"name\":\"salary\",\"size\":12,\"type\":\"DECIMAL\",\"vastType\":\"number\"},{\"canNull\":true,\"comment\":\"\u7a0e\u7387\",\"name\":\"taxRate\",\"size\":12,\"type\":\"FLOAT\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u7a0e\u8d39\",\"name\":\"tax\",\"size\":22,\"type\":\"DOUBLE\",\"vastType\":\"string\"}],\"tableComment\":\"\u6559\u5e08\",\"tableName\":\"ex_teacher\"},{\"fieldStmtList\":[{\"canNull\":true,\"comment\":\"\u4e3b\u952e\",\"name\":\"id\",\"size\":0},{\"canNull\":true,\"comment\":\"\u89c4\u5219\u7f16\u7801\",\"name\":\"code\",\"size\":16,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u7269\u6d41\u516c\u53f8\u7f16\u7801\",\"name\":\"logisticCode\",\"size\":32,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u7269\u6d41\u516c\u53f8\",\"name\":\"logisticCompany\",\"size\":64,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u627f\u8fd0\u65b9\u5f0f\",\"name\":\"transportType\",\"size\":32,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u627f\u8fd0\u65b9\u5f0f\u540d\u79f0\",\"name\":\"transportTypeName\",\"size\":32,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u8ba1\u8d39\u65b9\u5f0f\",\"format\":\"int4\",\"name\":\"chargeMode\",\"size\":4,\"type\":\"TINYINT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u5b50\u8ba1\u8d39\u65b9\u5f0f\",\"format\":\"int4\",\"name\":\"subChargeMode\",\"size\":4,\"type\":\"TINYINT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u8d27\u54c1\u5c5e\u6027\",\"format\":\"int4\",\"name\":\"cargoPeoperty\",\"size\":4,\"type\":\"TINYINT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\",\"format\":\"date-time\",\"name\":\"startTime\",\"size\":19,\"type\":\"DATETIME\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u6709\u6548\u7ed3\u675f\u65f6\u95f4\",\"format\":\"date-time\",\"name\":\"endTime\",\"size\":19,\"type\":\"DATETIME\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u5f52\u5c5e\u7f16\u7801\",\"name\":\"affiliationCode\",\"size\":32,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u5f52\u5c5e\u540d\u79f0\",\"name\":\"affiliationName\",\"size\":64,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u5f52\u5c5e\u7c7b\u578b 1.\u4ed3\u5e93, 2.\u7701\u4efd\",\"format\":\"int4\",\"name\":\"affiliationType\",\"size\":4,\"type\":\"TINYINT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u5907\u6ce8\",\"name\":\"remark\",\"size\":64,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u72b6\u6001\uff081=\u6b63\u5e38 0=\u4f5c\u5e9f\uff09\",\"format\":\"int4\",\"name\":\"status\",\"size\":4,\"type\":\"TINYINT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u7ec4\u7ec7id\",\"format\":\"int20\",\"name\":\"organizationId\",\"size\":20,\"type\":\"BIGINT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u7ec4\u7ec7\u7f16\u7801(\u679a\u4e3e1:v1, \u679a\u4e3e1:v2)\",\"name\":\"organizationCode\",\"size\":64,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u7ec4\u7ec7\u540d\u79f0\",\"name\":\"organizationName\",\"size\":64,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u4e1a\u52a1\u65f6\u95f4\",\"format\":\"date-time\",\"name\":\"bizDate\",\"size\":19,\"type\":\"DATETIME\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u6269\u5c55\u5b57\u6bb5\",\"name\":\"extension\",\"size\":1024,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u79df\u6237ID\",\"name\":\"tenantId\",\"size\":0},{\"canNull\":true,\"comment\":\"\u5e94\u7528\u5b9e\u4f8bID\",\"name\":\"instanceId\",\"size\":0},{\"canNull\":true,\"comment\":\"\u521b\u5efa\u4eba\",\"name\":\"createPerson\",\"size\":0},{\"canNull\":true,\"comment\":\"\u521b\u5efa\u65f6\u95f4\",\"name\":\"createTime\",\"size\":0},{\"canNull\":true,\"comment\":\"\u4fee\u6539\u4eba\",\"name\":\"updatePerson\",\"size\":0},{\"canNull\":true,\"comment\":\"\u4fee\u6539\u65f6\u95f4\",\"name\":\"updateTime\",\"size\":0},{\"canNull\":true,\"comment\":\"\u903b\u8f91\u5220\u9664\u6807\u5fd7\",\"name\":\"dr\",\"size\":0}],\"tableComment\":\"\u7269\u6d41\u8ba1\u8d39\u89c4\u5219\u8bbe\u7f6e\u8868\",\"tableName\":\"ex_bill_rule\"},{\"fieldStmtList\":[{\"canNull\":true,\"comment\":\"\u4e3b\u952e\",\"name\":\"id\",\"size\":0},{\"canNull\":true,\"comment\":\"\u89c4\u5219id\",\"format\":\"int20\",\"name\":\"ruleId\",\"size\":20,\"type\":\"BIGINT\",\"vastType\":\"integer\"},{\"canNull\":true,\"comment\":\"\u5408\u540c\u57fa\u51c6\u6cb9\u4ef7\",\"name\":\"contractOilPrice\",\"size\":22,\"type\":\"DECIMAL\",\"vastType\":\"number\"},{\"canNull\":true,\"comment\":\"\u5408\u5355\u8ba1\u8d39\u89c4\u5219{'supplierEq(\u627f\u8fd0\u5546\u4e00\u81f4)':1,'upsendEq(\u8d77\u9001\u5730\u5740\u4e00\u81f4)':1, 'targetEq(\u9001\u8fbe\u5730\u5740\u4e00\u81f4)':{'enable':1, 'option':'<', 'limit':10}}\",\"name\":\"orderMergeRule\",\"size\":2147483647,\"type\":\"JSON\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u8d39\u7528\u5206\u644a\u89c4\u5219{'cost_allocation_rule(\u9700\u8981\u5206\u644a\u7684\u8d39\u7528)':{'xx1':'price/heavy','xx2':'1','xx3':'1'}}\",\"name\":\"costAllocationRule\",\"size\":2147483647,\"type\":\"JSON\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u57fa\u7840\u8bbe\u7f6e{'heavyFoamRatio':'\u91cd\u6ce1\u6bd4', 'appendicular':'\u9644\u4ef6', 'billCycle':'\u8ba1\u8d39\u5468\u671f'}\",\"name\":\"baseSetting\",\"size\":2147483647,\"type\":\"JSON\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u53d1\u6539\u59d4\u5730\u5740\",\"name\":\"departAddress\",\"size\":32,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u5907\u6ce8\",\"name\":\"remark\",\"size\":248,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u6269\u5c55\u5b57\u6bb5\",\"name\":\"extension\",\"size\":1024,\"type\":\"VARCHAR\",\"vastType\":\"string\"},{\"canNull\":true,\"comment\":\"\u79df\u6237ID\",\"name\":\"tenantId\",\"size\":0},{\"canNull\":true,\"comment\":\"\u5e94\u7528\u5b9e\u4f8bID\",\"name\":\"instanceId\",\"size\":0},{\"canNull\":true,\"comment\":\"\u521b\u5efa\u4eba\",\"name\":\"createPerson\",\"size\":0},{\"canNull\":true,\"comment\":\"\u521b\u5efa\u65f6\u95f4\",\"name\":\"createTime\",\"size\":0},{\"canNull\":true,\"comment\":\"\u4fee\u6539\u4eba\",\"name\":\"updatePerson\",\"size\":0},{\"canNull\":true,\"comment\":\"\u4fee\u6539\u65f6\u95f4\",\"name\":\"updateTime\",\"size\":0},{\"canNull\":true,\"comment\":\"\u903b\u8f91\u5220\u9664\u6807\u5fd7\",\"name\":\"dr\",\"size\":0}],\"tableComment\":\"\u7269\u6d41\u8ba1\u8d39\u89c4\u5219\u8bbe\u7f6e\u8be6\u60c5\u8868\",\"tableName\":\"ex_bill_rule_detail\"}]", CreateStmt.class), "apiFox.json", new PluginParameter());
    }

    static {
        eoMap.put("Dto", cs -> {
            String objectStr = FileReadUtils.readFileToString("/dto/dto.json");
            objectStr = objectStr.replaceAll("%tableName", cs.getTableName() + "Dto").replaceAll("%tableComment", cs.getTableComment());
            JSONObject jsonObject = JSONObject.parseObject((String)objectStr);
            JSONObject properties = new JSONObject(true);
            JSONObject oldProperties = jsonObject.getJSONObject("properties");
            jsonObject.put("properties", (Object)properties);
            JSONArray orders = jsonObject.getJSONArray("x-apifox-orders");
            ArrayList filterList = Lists.newArrayList((Object[])dbFilterFields);
            orders.addAll((Collection)cs.getFieldStmtList().stream().map(FieldStmt::getName).filter(name -> !filterList.contains(name)).collect(Collectors.toList()));
            jsonObject.put("x-apifox-orders", (Object)orders);
            cs.getFieldStmtList().stream().filter(it -> !filterList.contains(it.getName())).forEach(f -> {
                JSONObject field = new JSONObject();
                field.put("type", (Object)f.getVastType());
                field.put(descriptionKey, (Object)f.getComment());
                field.put(titleKey, (Object)f.getComment());
                Optional.ofNullable(f.getFormat()).ifPresent(fm -> field.put(formatKey, fm));
                if (Objects.equals(f.getVastType(), "integer")) {
                    Integer n = f.getSize();
                    n = n | n >>> 1;
                    n = n | n >>> 2;
                    n = n | n >>> 4;
                    n = n | n >>> 8;
                    n = n | n >>> 16;
                    n = n + 1;
                    field.put("format", (Object)("int" + n));
                }
                properties.put(f.getName(), (Object)field);
            });
            properties.putAll((Map)oldProperties);
            jsonObject.put("properties", (Object)properties);
            return jsonObject;
        });
        eoMap.put("PageReqDto", cs -> {
            String objectStr = FileReadUtils.readFileToString("/dto/pagedto.json");
            objectStr = objectStr.replaceAll("%tableName", cs.getTableName() + "PageReqDto").replaceAll("%tableComment", cs.getTableComment() + "\u5206\u9875\u67e5\u8be2\u5bf9\u8c61");
            JSONObject jsonObject = JSONObject.parseObject((String)objectStr);
            JSONObject properties = new JSONObject(true);
            JSONObject oldProperties = jsonObject.getJSONObject("properties");
            jsonObject.put("properties", (Object)properties);
            JSONArray orders = jsonObject.getJSONArray("x-apifox-orders");
            ArrayList filterList = Lists.newArrayList((Object[])dbFilterFields);
            orders.addAll((Collection)cs.getFieldStmtList().stream().map(FieldStmt::getName).filter(name -> !filterList.contains(name)).collect(Collectors.toList()));
            jsonObject.put("x-apifox-orders", (Object)orders);
            cs.getFieldStmtList().stream().filter(it -> !filterList.contains(it.getName())).forEach(f -> {
                JSONObject field = new JSONObject();
                field.put("type", (Object)f.getVastType());
                field.put(descriptionKey, (Object)f.getComment());
                field.put(titleKey, (Object)f.getComment());
                Optional.ofNullable(f.getFormat()).ifPresent(fm -> field.put(formatKey, fm));
                if (Objects.equals(f.getVastType(), "integer")) {
                    Integer n = f.getSize();
                    n = n | n >>> 1;
                    n = n | n >>> 2;
                    n = n | n >>> 4;
                    n = n | n >>> 8;
                    n = n | n >>> 16;
                    n = n + 1;
                    field.put("format", (Object)("int" + n));
                }
                properties.put(f.getName(), (Object)field);
            });
            properties.putAll((Map)oldProperties);
            jsonObject.put("properties", (Object)properties);
            return jsonObject;
        });
        eoMap.put("Enum", cs -> {
            FieldStmt fieldStmt = cs.getFieldStmtList().get(0);
            Matcher m = Pattern.compile("\\$\\$.*?\\$\\$").matcher(fieldStmt.getComment());
            String matchStr = "null";
            String noMatchStr = "null";
            ArrayList enumFieldStmts = Lists.newArrayList();
            if (m.find()) {
                matchStr = m.group(0);
                noMatchStr = fieldStmt.getComment().replace(matchStr, "");
                GenUtils.extractMessageByRegular((String)matchStr).forEach(matchToStr -> {
                    String[] enums = matchToStr.split(":");
                    if (enums.length < 3) {
                        throw new BizException(cs.getTableName() + "." + fieldStmt.getName() + "$$\u679a\u4e3e\u5217\u4e3e\u683c\u5f0f\u6709\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4f8b\u5b50\uff1a$$<INIT:INIT:\u521d\u59cb\u5316><CREATED::\u5df2\u521b\u5efa><SUCCESS::\u6210\u529f>$$");
                    }
                    FieldStmt enumField = new FieldStmt();
                    Matcher matchNum = Pattern.compile("[+,-]?[0-9]+").matcher(enums[0]);
                    if (matchNum.find()) {
                        enumField.setType("integer");
                        enumField.setVastType("integer");
                    } else {
                        enumField.setType("string");
                        enumField.setVastType("string");
                    }
                    enumField.setComment2(enums[0]);
                    if (StringUtils.isBlank((String)enums[1])) {
                        enumField.setName(enums[0]);
                    } else {
                        enumField.setName(enums[1]);
                    }
                    matchNum = Pattern.compile("[+,-]?[0-9]+").matcher(enumField.getName());
                    if (matchNum.find()) {
                        throw new BizException(cs.getTableName() + "." + fieldStmt.getName() + "$$\u679a\u4e3e\u5217\u4e3e\u683c\u5f0f\u6709\u8bef\uff0c:\u5206\u9694\u7b26\u4e2d\u95f4\u5b57\u7b26\u4e0d\u5141\u8bb8\u4e3a\u7eaf\u6570\u5b57\u6216\u7a7a");
                    }
                    enumField.setComment(enums[2]);
                    enumFieldStmts.add(enumField);
                });
            }
            String objectStr = FileReadUtils.readFileToString("/dto/enum.json");
            objectStr = objectStr.replaceAll("%enumName", cs.getTableName() + Api2JsonTransfer.upCaseFirst(fieldStmt.getName()) + "Enum");
            objectStr = objectStr.replaceAll("%fieldsComment", noMatchStr + "\u679a\u4e3e\u5bf9\u8c61");
            JSONObject jsonObject = JSONObject.parseObject((String)objectStr);
            JSONObject properties = new JSONObject(true);
            JSONObject oldProperties = jsonObject.getJSONObject("properties");
            jsonObject.put("properties", (Object)properties);
            JSONArray orders = jsonObject.getJSONArray("x-apifox-orders");
            ArrayList filterList = Lists.newArrayList();
            orders.addAll((Collection)enumFieldStmts.stream().map(FieldStmt::getName).filter(name -> !filterList.contains(name)).collect(Collectors.toList()));
            jsonObject.put("x-apifox-orders", (Object)orders);
            enumFieldStmts.stream().filter(it -> !filterList.contains(it.getName())).forEach(f -> {
                JSONObject field = new JSONObject();
                field.put("type", (Object)f.getVastType());
                field.put(descriptionKey, (Object)f.getComment2());
                field.put(titleKey, (Object)f.getComment());
                Optional.ofNullable(f.getFormat()).ifPresent(fm -> field.put(formatKey, fm));
                if (Objects.equals(f.getVastType(), "integer")) {
                    Integer n = f.getSize();
                    n = n | n >>> 1;
                    n = n | n >>> 2;
                    n = n | n >>> 4;
                    n = n | n >>> 8;
                    n = n | n >>> 16;
                    n = n + 1;
                    field.put("format", (Object)("int" + n));
                }
                properties.put(f.getName(), (Object)field);
            });
            properties.putAll((Map)oldProperties);
            jsonObject.put("properties", (Object)properties);
            return jsonObject;
        });
    }
}

