/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.plugins.framework.service.impl;

import com.alibaba.fastjson.JSON;
import com.yunxi.dg.base.commons.utils.MD5Util;
import com.yunxi.dg.base.plugins.framework.PluginParameter;
import com.yunxi.dg.base.plugins.framework.bean.FreemarkerVo;
import com.yunxi.dg.base.plugins.framework.bean.apifox.Apifox;
import com.yunxi.dg.base.plugins.framework.bean.apifox.Component;
import com.yunxi.dg.base.plugins.framework.bean.apifox.Path;
import com.yunxi.dg.base.plugins.framework.bean.apifox.Properties;
import com.yunxi.dg.base.plugins.framework.bean.apifox.ReqParameter;
import com.yunxi.dg.base.plugins.framework.bean.apifox.Tag;
import com.yunxi.dg.base.plugins.framework.constants.FrameworkConstants;
import com.yunxi.dg.base.plugins.framework.service.FrameworkService;
import com.yunxi.dg.base.plugins.framework.sql.ApiJsonTransfer;
import com.yunxi.dg.base.plugins.framework.sql.create.CreateStmt;
import com.yunxi.dg.base.plugins.framework.sql.create.FieldStmt;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkServiceImpl
implements FrameworkService {
    private static final Logger log = LoggerFactory.getLogger(FrameworkServiceImpl.class);
    private static final String CHARSET_UTF8 = "UTF-8";
    private static Map<String, String> eoMap = new LinkedHashMap<String, String>();
    private static Map<String, FreemarkerVo> eoInfoMap = new LinkedHashMap<String, FreemarkerVo>();
    private static Map<String, Map<String, Properties>> eoFieldMap = new LinkedHashMap<String, Map<String, Properties>>();
    private static Map<String, String> tableRemarkMap = new LinkedHashMap<String, String>();
    private static Map<String, String> fileMap = new LinkedHashMap<String, String>();
    private String baseFilePath;
    private String project;

    @Override
    public boolean generateCode(PluginParameter parameter) {
        if (parameter.getOutput().indexOf("/") != -1) {
            parameter.setOutput(parameter.getOutput().substring(0, parameter.getOutput().lastIndexOf("/")));
        } else if (parameter.getOutput().indexOf("\\") != -1) {
            parameter.setOutput(parameter.getOutput().substring(0, parameter.getOutput().lastIndexOf("\\")));
        }
        this.project = parameter.getOutput().substring(parameter.getOutput().lastIndexOf("/") + 1);
        if (parameter.getOutput().equals(this.project)) {
            this.project = null;
        }
        if (StringUtils.isEmpty((String)this.project)) {
            this.project = parameter.getOutput().substring(parameter.getOutput().lastIndexOf("\\") + 1);
        }
        this.baseFilePath = parameter.getOutput() + "/" + this.project;
        List<CreateStmt> createStmts = this.generateEoDto(parameter);
        Optional.ofNullable(parameter.getGenApiCode() != false ? parameter : null).ifPresent(this::generateApi);
        Optional.ofNullable(parameter.getGenDaoCode() != false ? parameter : null).ifPresent(this::generateDao);
        Optional.ofNullable(parameter.getGenDomainCode() != false ? parameter : null).ifPresent(this::generateDomain);
        Optional.ofNullable(parameter.getGenServerCode() != false ? parameter : null).ifPresent(this::generateService);
        Optional.ofNullable(parameter.getGenRestCode() != false ? parameter : null).ifPresent(this::generateRest);
        if (CollectionUtils.isNotEmpty(createStmts) && parameter.getGenJsonFile().booleanValue()) {
            log.info("generate swagger scanSql={}" + JSON.toJSONString(createStmts));
            new ApiJsonTransfer().transfer(createStmts, this.project + "-ddl.openapi.json", parameter);
        }
        return true;
    }

    private String firstCharToUpperCase(String src) {
        return src.substring(0, 1).toUpperCase() + src.substring(1);
    }

    private String firstCharToLowerCase(String src) {
        return src.substring(0, 1).toLowerCase() + src.substring(1);
    }

    private String toBaseBeanName(PluginParameter parameter, String dbTableName) {
        String baseBeanName = dbTableName.substring(parameter.getTableNamePrefix().length());
        baseBeanName = this.toFieldName(baseBeanName);
        baseBeanName = this.firstCharToUpperCase(baseBeanName);
        return baseBeanName;
    }

    private String toFieldName(String src) {
        if ((src = src.toLowerCase()).indexOf("_") == -1) {
            return src;
        }
        String[] str = src.split("_");
        src = null;
        for (int i = 0; i < str.length; ++i) {
            src = src == null ? str[i] : src + this.firstCharToUpperCase(str[i]);
        }
        return src;
    }

    private String toFieldType(int columnType, int scale) {
        if (columnType == -5) {
            return "Long";
        }
        if (columnType == 2004) {
            return "Blob";
        }
        if (columnType == 2005) {
            return "Clob";
        }
        if (columnType == 93 || columnType == 91) {
            return "Date";
        }
        if (columnType == 3) {
            return "BigDecimal";
        }
        if (columnType == 8) {
            return "Double";
        }
        if (columnType == 6 || columnType == 7) {
            return "Float";
        }
        if (columnType == 4 || columnType == -6 || columnType == 5) {
            return "Integer";
        }
        if (columnType == 12 || columnType == -1 && scale == 0 || columnType == 2 && scale == 0) {
            return "String";
        }
        return "unknow";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateByFreemarker(PluginParameter parameter, FreemarkerVo vo, String folder, String fileName, String ftlName) {
        File file = new File(folder);
        if (!file.exists()) {
            file.mkdirs();
        }
        String filePath = folder + "/" + fileName;
        try {
            vo.setBasePackage(parameter.getBasePackage());
            vo.setDbName(parameter.getDbName());
            vo.setAppName(parameter.getAppName());
            vo.setAppCode(this.project);
            String md5Code = MD5Util.getMD5Code((String)vo.toString());
            if (!parameter.getForceCover().booleanValue() && (file = new File(filePath)).exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    if ("apifox.ftl".equals(ftlName)) {
                        if (!line.startsWith("\"" + "MD5Code".trim() + "\":") || !(line = line.substring(1).trim()).startsWith("MD5Code".trim())) continue;
                        line = line.replaceAll("MD5Code".trim(), "");
                        line = line.trim();
                        if (!md5Code.equals(line = line.substring(4, line.length() - 2))) continue;
                        return;
                    }
                    if (!line.startsWith("*") || !(line = line.substring(1).trim()).startsWith(" @MD5Code ".trim())) continue;
                    line = line.replaceAll(" @MD5Code ".trim(), "");
                    if (!md5Code.equals(line = line.trim())) continue;
                    return;
                }
            }
            if ("apifox.ftl".equals(ftlName)) {
                vo.setMd5Code(md5Code);
            } else {
                vo.setMd5Code("* @MD5Code " + md5Code);
            }
            vo.setDate(parameter.getDate());
            Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(this.getClass(), "/template/");
            configuration.setTemplateLoader((TemplateLoader)classTemplateLoader);
            configuration.setDefaultEncoding(CHARSET_UTF8);
            Template template = configuration.getTemplate(ftlName);
            LinkedHashMap<String, FreemarkerVo> map = new LinkedHashMap<String, FreemarkerVo>();
            map.put("vo", vo);
            FileWriter out = new FileWriter(new File(filePath));
            template.process(map, (Writer)out);
            String content = out.toString();
            ((Writer)out).close();
            log.info("generateFile:{} with ftlName:{}", (Object)filePath, (Object)ftlName);
            fileMap.put(filePath, content);
        }
        catch (Exception e) {
            log.error("Catch a exception:{} for vo:{},ftlName:{},filePath:{}", new Object[]{e.getMessage(), vo, ftlName, filePath});
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CreateStmt> generateEoDto(PluginParameter parameter) {
        ArrayList<CreateStmt> stmtList = new ArrayList<CreateStmt>();
        HashMap<String, CreateStmt> stmtMap = new HashMap<String, CreateStmt>();
        Connection connection = null;
        try {
            String dtoFolderPath;
            Class.forName(parameter.getDriverClassName()).newInstance();
            connection = DriverManager.getConnection(parameter.getJdbcUrl(), parameter.getJdbcUserName(), parameter.getJdbcUserPassword());
            Statement stmt = connection.createStatement();
            LinkedHashSet<String> tableNameSet = new LinkedHashSet<String>();
            ResultSet rs = stmt.executeQuery("select table_name from information_schema.tables where table_schema='" + parameter.getDbName() + "'");
            while (rs.next()) {
                String tableName = rs.getString(1).toLowerCase();
                if (!tableName.startsWith(parameter.getTableNamePrefix()) || tableName.startsWith("temp_") || tableName.endsWith("_copy") || parameter.getIgnoreTableSet().contains(tableName) || CollectionUtils.isNotEmpty(parameter.getIncludeTableSet()) && !parameter.getIncludeTableSet().contains(tableName)) continue;
                tableNameSet.add(tableName);
            }
            rs = stmt.executeQuery("select table_name,table_comment from information_schema.tables where table_schema='" + parameter.getDbName() + "'");
            while (rs.next()) {
                tableRemarkMap.put(rs.getString("table_name").toLowerCase(), rs.getString("table_comment"));
            }
            String eoFolderPath = this.baseFilePath + "-eo" + parameter.getBaseSourceFolder() + "/eo";
            File file = new File(eoFolderPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!(file = new File(dtoFolderPath = this.baseFilePath + "-dto" + parameter.getBaseSourceFolder() + "/dto/entity")).exists()) {
                file.mkdirs();
            }
            ResultSetMetaData rsmd = null;
            int noOfColumns = 0;
            String columnName = null;
            String columnType = null;
            String baseBeanName = null;
            Set<String> ignoreEoFieldSet = FrameworkConstants.ignoreEoFieldSet();
            Map<String, String> apifoxTypeMap = FrameworkConstants.getApifoxTypeMap();
            LinkedHashMap<String, String> fieldRemarkMap = null;
            LinkedHashMap<String, String> fieldDescMap = null;
            LinkedHashMap<String, String> fieldTypeMap = null;
            LinkedHashMap<String, String> fieldDbNameMap = null;
            String comment = null;
            for (String tableName : tableNameSet) {
                boolean isCanExtTable = false;
                baseBeanName = this.toBaseBeanName(parameter, tableName);
                eoMap.put(tableName, baseBeanName);
                fieldRemarkMap = new LinkedHashMap<String, String>();
                fieldDescMap = new LinkedHashMap<String, String>();
                fieldTypeMap = new LinkedHashMap<String, String>();
                fieldDbNameMap = new LinkedHashMap<String, String>();
                rs = stmt.executeQuery("select column_name,column_comment from information_schema.columns where table_schema='" + parameter.getDbName() + "' and table_name='" + tableName + "'");
                CreateStmt createStmt = new CreateStmt(tableName, tableRemarkMap.get(tableName), new ArrayList<FieldStmt>());
                stmtMap.put(tableName, createStmt);
                while (rs.next()) {
                    comment = rs.getString("column_comment");
                    if (StringUtils.isNotEmpty((String)comment)) {
                        comment = comment.replaceAll("\"", "'");
                    }
                    fieldRemarkMap.put(rs.getString("column_name").toLowerCase(), comment);
                    FieldStmt fieldStmt = new FieldStmt();
                    fieldStmt.setComment(comment);
                    fieldStmt.setName(rs.getString("column_name"));
                    createStmt.getFieldStmtList().add(fieldStmt);
                }
                rs = stmt.executeQuery("select * from " + tableName + " limit 1 ");
                rsmd = rs.getMetaData();
                noOfColumns = rsmd.getColumnCount();
                eoFieldMap.put(tableName, new LinkedHashMap());
                for (int i = 1; i < noOfColumns + 1; ++i) {
                    FieldStmt fieldStmt;
                    String cn = rsmd.getColumnName(i);
                    if (ignoreEoFieldSet.contains(rsmd.getColumnName(i))) {
                        fieldStmt = createStmt.getFieldStmtList().stream().filter(sl -> sl.getName().equalsIgnoreCase(cn)).findFirst().get();
                        fieldStmt.setSize(rsmd.getColumnDisplaySize(i));
                        fieldStmt.setType(rsmd.getColumnTypeName(i));
                        this.exchangeVastType(fieldStmt, rsmd.getColumnTypeName(i));
                        if (isCanExtTable || !rsmd.getColumnName(i).equals("extension")) continue;
                        isCanExtTable = true;
                        continue;
                    }
                    columnName = this.toFieldName(rsmd.getColumnName(i));
                    columnType = this.toFieldType(rsmd.getColumnType(i), rsmd.getScale(i));
                    fieldDescMap.put(columnName, (String)fieldRemarkMap.get(rsmd.getColumnName(i)));
                    fieldTypeMap.put(columnName, columnType);
                    fieldDbNameMap.put(columnName, rsmd.getColumnName(i));
                    eoFieldMap.get(tableName).put(columnName, new Properties(columnName, apifoxTypeMap.get(columnType), (String)fieldDescMap.get(columnName), null, "", "Date".equals(columnType) ? "date-time" : null));
                    fieldStmt = createStmt.getFieldStmtList().stream().filter(sl -> sl.getName().equalsIgnoreCase(cn)).findFirst().get();
                    fieldStmt.setSize(rsmd.getColumnDisplaySize(i));
                    fieldStmt.setType(rsmd.getColumnTypeName(i));
                    this.exchangeVastType(fieldStmt, rsmd.getColumnTypeName(i));
                }
                rs.close();
                this.generateEo(parameter, tableName, baseBeanName, eoFolderPath, fieldTypeMap, fieldDescMap, fieldDbNameMap, isCanExtTable);
                this.generateDto(parameter, tableName, baseBeanName, dtoFolderPath, fieldTypeMap, fieldDescMap, isCanExtTable);
                this.generatePageReqDto(parameter, tableName, baseBeanName, dtoFolderPath, fieldTypeMap, fieldDescMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        stmtMap.forEach((k, stm) -> stmtList.add((CreateStmt)stm));
        return stmtList;
    }

    private void generateEo(PluginParameter parameter, String tableName, String baseBeanName, String eoFolderPath, Map<String, String> fieldTypeMap, Map<String, String> fieldDescMap, Map<String, String> fieldDbNameMap, boolean isExtTable) {
        FreemarkerVo vo = new FreemarkerVo();
        vo.setBaseBeanDesc(tableRemarkMap.get(tableName));
        vo.setBaseBeanName(baseBeanName);
        vo.setDomain(this.firstCharToLowerCase(baseBeanName));
        vo.setTableName(tableName);
        vo.setExtTable(isExtTable);
        eoInfoMap.put(tableName, vo);
        for (String fieldName : fieldTypeMap.keySet()) {
            vo.addField(fieldDbNameMap.get(fieldName), fieldName, fieldDescMap.get(fieldName), fieldTypeMap.get(fieldName));
        }
        this.generateByFreemarker(parameter, vo, eoFolderPath, baseBeanName + "Eo.java", "eo.ftl");
    }

    private void generateDto(PluginParameter parameter, String tableName, String baseBeanName, String dtoFolderPath, Map<String, String> fieldTypeMap, Map<String, String> fieldDescMap, boolean isExtTable) {
        FreemarkerVo vo = new FreemarkerVo();
        vo.setBaseBeanDesc(tableRemarkMap.get(tableName));
        vo.setBaseBeanName(baseBeanName);
        vo.setDomain(this.firstCharToLowerCase(baseBeanName));
        vo.setClassName(baseBeanName + "Dto");
        vo.setClassDesc(tableRemarkMap.get(tableName) + "\u4f20\u8f93\u5bf9\u8c61");
        vo.setExtendsClassName("BaseDto");
        vo.setExtTable(isExtTable);
        for (String fieldName : fieldTypeMap.keySet()) {
            vo.addField(fieldName, null, fieldDescMap.get(fieldName), fieldTypeMap.get(fieldName));
        }
        this.generateByFreemarker(parameter, vo, dtoFolderPath, baseBeanName + "Dto.java", "dto.ftl");
        if (vo.getExtTable()) {
            vo.getFieldList().clear();
            this.generateByFreemarker(parameter, vo, dtoFolderPath, baseBeanName + "DtoExtension.java", "extDto.ftl");
        }
    }

    private void generatePageReqDto(PluginParameter parameter, String tableName, String baseBeanName, String dtoFolderPath, Map<String, String> fieldTypeMap, Map<String, String> fieldDescMap) {
        FreemarkerVo vo = new FreemarkerVo();
        vo.setBaseBeanDesc(tableRemarkMap.get(tableName));
        vo.setBaseBeanName(baseBeanName);
        vo.setDomain(this.firstCharToLowerCase(baseBeanName));
        vo.setClassName(baseBeanName + "PageReqDto");
        vo.setClassDesc(tableRemarkMap.get(tableName) + "\u5206\u9875\u67e5\u8be2\u5bf9\u8c61");
        vo.setExtendsClassName("BasePageDto");
        for (String fieldName : fieldTypeMap.keySet()) {
            vo.addField(fieldName, null, fieldDescMap.get(fieldName), fieldTypeMap.get(fieldName));
        }
        this.generateByFreemarker(parameter, vo, dtoFolderPath, baseBeanName + "PageReqDto.java", "dto.ftl");
    }

    private void generateApi(PluginParameter parameter) {
        for (String tableName : eoMap.keySet()) {
            String baseBeanName = eoMap.get(tableName);
            FreemarkerVo vo = new FreemarkerVo();
            vo.setBaseBeanDesc(tableRemarkMap.get(tableName));
            vo.setBaseBeanName(baseBeanName);
            vo.setDomain(this.firstCharToLowerCase(baseBeanName));
            vo.setClassName("I" + baseBeanName + "Api");
            vo.setClassDesc(tableRemarkMap.get(tableName) + "\u670d\u52a1\u63a5\u53e3");
            vo.addField("insert", null, "\u65b0\u589e" + tableRemarkMap.get(tableName) + "\u6570\u636e", "<Long>", "/v1/" + vo.getDomain() + "/insert", "@RequestBody " + baseBeanName + "Dto dto");
            vo.addField("update", null, "\u66f4\u65b0" + tableRemarkMap.get(tableName) + "\u6570\u636e", "<Void>", "/v1/" + vo.getDomain() + "/update", "@RequestBody " + baseBeanName + "Dto dto");
            vo.addField("get", null, "\u6839\u636eid\u83b7\u53d6" + tableRemarkMap.get(tableName) + "\u6570\u636e", "<" + baseBeanName + "Dto>", "/v1/" + vo.getDomain() + "/get/{id}", "@PathVariable(name=\"id\",required=true) Long id");
            vo.addField("logicDelete", null, "\u903b\u8f91\u5220\u9664" + tableRemarkMap.get(tableName) + "\u6570\u636e", "<Void>", "/v1/" + vo.getDomain() + "/logicDelete/{id}", "@PathVariable(name=\"id\",required=true) Long id");
            vo.addField("page", null, "\u5206\u9875\u67e5\u8be2" + tableRemarkMap.get(tableName) + "\u6570\u636e", "<PageInfo<" + baseBeanName + "Dto>>", "/v1/" + vo.getDomain() + "/page", "@RequestBody " + baseBeanName + "PageReqDto dto");
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-api" + parameter.getBaseSourceFolder() + "/api/entity", "I" + baseBeanName + "Api.java", "api.ftl");
        }
    }

    private void generateApifox(PluginParameter parameter) {
        FreemarkerVo vo = new FreemarkerVo();
        Apifox apifox = new Apifox();
        apifox.setAppCode(this.project);
        apifox.setAppName(parameter.getAppName());
        Component componentDto = null;
        Component componentPageReqDto = null;
        Path path = null;
        Properties properties = null;
        for (String tableName : eoMap.keySet()) {
            String baseBeanName = eoMap.get(tableName);
            apifox.getTagList().add(new Tag("I" + baseBeanName + "Api", tableRemarkMap.get(tableName) + "\u670d\u52a1\u63a5\u53e3"));
            componentDto = new Component();
            componentDto.setName(baseBeanName + "Dto");
            componentDto.setDesc(tableRemarkMap.get(tableName) + "\u4f20\u8f93\u5bf9\u8c61");
            componentDto.setTitle(componentDto.getName() + "-" + componentDto.getDesc());
            componentDto.setEntityCode(baseBeanName);
            componentDto.setEntityName(tableRemarkMap.get(tableName));
            componentDto.setRef("BaseDto");
            componentPageReqDto = new Component();
            componentPageReqDto.setName(baseBeanName + "PageReqDto");
            componentPageReqDto.setDesc(tableRemarkMap.get(tableName) + "\u5206\u9875\u67e5\u8be2\u4f20\u8f93\u5bf9\u8c61");
            componentPageReqDto.setTitle(componentPageReqDto.getName() + "-" + componentPageReqDto.getDesc());
            componentPageReqDto.setEntityCode(baseBeanName);
            componentPageReqDto.setEntityName(tableRemarkMap.get(tableName));
            componentPageReqDto.setRef("BasePageDto");
            for (String field : eoFieldMap.get(tableName).keySet()) {
                properties = eoFieldMap.get(tableName).get(field);
                componentDto.getPropertiesList().add(properties);
                componentPageReqDto.getPropertiesList().add(properties);
            }
            apifox.getComponentList().add(componentDto);
            apifox.getComponentList().add(componentPageReqDto);
            path = new Path();
            path.setApiCode("I" + baseBeanName + "Api");
            path.setDomainName(tableRemarkMap.get(tableName));
            path.setUri("/v1/" + this.firstCharToLowerCase(baseBeanName) + "/insert");
            path.setMethodName("insert");
            path.setMethodDesc("\u65b0\u589e" + tableRemarkMap.get(tableName) + "\u5bf9\u8c61");
            path.setReqDtoName(baseBeanName + "Dto");
            path.getRespDataDto().setType("integer");
            path.getRespDataDto().setTitle(tableRemarkMap.get(tableName) + "ID");
            path.getRespDataDto().setDesc("<Long>");
            apifox.getPathList().add(path);
            path = new Path();
            path.setApiCode("I" + baseBeanName + "Api");
            path.setDomainName(tableRemarkMap.get(tableName));
            path.setUri("/v1/" + this.firstCharToLowerCase(baseBeanName) + "/update");
            path.setMethodName("update");
            path.setMethodDesc("\u66f4\u65b0" + tableRemarkMap.get(tableName) + "\u5bf9\u8c61");
            path.setReqDtoName(baseBeanName + "Dto");
            path.getRespDataDto().setType("object");
            path.getRespDataDto().setTitle("\u4e1a\u52a1\u5bf9\u8c61");
            apifox.getPathList().add(path);
            path = new Path();
            path.setApiCode("I" + baseBeanName + "Api");
            path.setDomainName(tableRemarkMap.get(tableName));
            path.setUri("/v1/" + this.firstCharToLowerCase(baseBeanName) + "/get");
            path.setMethodName("get");
            path.setMethodDesc("\u83b7\u53d6" + tableRemarkMap.get(tableName) + "\u5bf9\u8c61");
            path.setReqParameter(new ReqParameter());
            path.getReqParameter().setName("id");
            path.getReqParameter().setDesc("\u4e3b\u952eID");
            path.getReqParameter().setRequired(true);
            path.getReqParameter().setType("int16");
            path.getRespDataDto().setRef(baseBeanName + "Dto");
            apifox.getPathList().add(path);
            path = new Path();
            path.setApiCode("I" + baseBeanName + "Api");
            path.setDomainName(tableRemarkMap.get(tableName));
            path.setUri("/v1/" + this.firstCharToLowerCase(baseBeanName) + "/delete");
            path.setMethodName("delete");
            path.setMethodDesc("\u7269\u7406\u5220\u9664" + tableRemarkMap.get(tableName) + "\u5bf9\u8c61");
            path.setReqParameter(new ReqParameter());
            path.getReqParameter().setName("id");
            path.getReqParameter().setDesc("\u4e3b\u952eID");
            path.getReqParameter().setRequired(true);
            path.getReqParameter().setType("int16");
            path.getRespDataDto().setType("object");
            path.getRespDataDto().setTitle("\u4e1a\u52a1\u5bf9\u8c61");
            apifox.getPathList().add(path);
            path = new Path();
            path.setApiCode("I" + baseBeanName + "Api");
            path.setDomainName(tableRemarkMap.get(tableName));
            path.setUri("/v1/" + this.firstCharToLowerCase(baseBeanName) + "/logicDelete");
            path.setMethodName("logicDelete");
            path.setMethodDesc("\u903b\u8f91\u5220\u9664" + tableRemarkMap.get(tableName) + "\u5bf9\u8c61");
            path.setReqParameter(new ReqParameter());
            path.getReqParameter().setName("id");
            path.getReqParameter().setDesc("\u4e3b\u952eID");
            path.getReqParameter().setRequired(true);
            path.getReqParameter().setType("int16");
            path.getRespDataDto().setType("object");
            path.getRespDataDto().setTitle("\u4e1a\u52a1\u5bf9\u8c61");
            apifox.getPathList().add(path);
            path = new Path();
            path.setApiCode("I" + baseBeanName + "Api");
            path.setDomainName(tableRemarkMap.get(tableName));
            path.setUri("/v1/" + this.firstCharToLowerCase(baseBeanName) + "/page");
            path.setMethodName("page");
            path.setMethodDesc("\u5206\u9875\u67e5\u8be2" + tableRemarkMap.get(tableName) + "\u5bf9\u8c61");
            path.setIsPage(true);
            path.setReqDtoName(baseBeanName + "PageReqDto");
            path.getRespDataDto().setType("object");
            path.getRespDataDto().setTitle("\u4e1a\u52a1\u5bf9\u8c61");
            path.getRespDataDto().setDesc("<" + baseBeanName + "Dto>");
            path.getRespDataDto().setListDtoName(baseBeanName + "Dto");
            apifox.getPathList().add(path);
        }
        vo.setApifox(apifox);
        this.generateByFreemarker(parameter, vo, this.baseFilePath + "-gen/api-json", this.project + ".json", "apifox.ftl");
    }

    private void generateDao(PluginParameter parameter) {
        for (String tableName : eoMap.keySet()) {
            String baseBeanName = eoMap.get(tableName);
            FreemarkerVo vo = new FreemarkerVo();
            vo.setBaseBeanDesc(tableRemarkMap.get(tableName));
            vo.setBaseBeanName(baseBeanName);
            vo.setDomain(this.firstCharToLowerCase(baseBeanName));
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-dao" + parameter.getBaseSourceFolder() + "/dao/mapper", baseBeanName + "Mapper.java", "mapper.ftl");
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-dao/src/main/resources/mapper", baseBeanName + "Mapper.xml", "mapperXml.ftl");
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-dao" + parameter.getBaseSourceFolder() + "/dao/das", "I" + baseBeanName + "Das.java", "das.ftl");
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-dao" + parameter.getBaseSourceFolder() + "/dao/das/impl", baseBeanName + "DasImpl.java", "dasImpl.ftl");
        }
    }

    private void generateDomain(PluginParameter parameter) {
        for (String tableName : eoMap.keySet()) {
            String baseBeanName = eoMap.get(tableName);
            FreemarkerVo vo = new FreemarkerVo();
            vo.setBaseBeanDesc(tableRemarkMap.get(tableName));
            vo.setBaseBeanName(baseBeanName);
            vo.setDomain(this.firstCharToLowerCase(baseBeanName));
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-domain" + parameter.getBaseSourceFolder() + "/domain/entity", "I" + baseBeanName + "Domain.java", "domain.ftl");
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-domain" + parameter.getBaseSourceFolder() + "/domain/entity/impl", baseBeanName + "DomainImpl.java", "domainImpl.ftl");
        }
    }

    private void generateService(PluginParameter parameter) {
        Object os = null;
        StringBuffer sb = new StringBuffer();
        String folderPath = this.baseFilePath + "-service" + parameter.getBaseSourceFolder() + "/service/entity";
        File file = new File(folderPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        for (String tableName : eoMap.keySet()) {
            String baseBeanName = eoMap.get(tableName);
            FreemarkerVo vo = new FreemarkerVo();
            vo.setBaseBeanDesc(tableRemarkMap.get(tableName));
            vo.setBaseBeanName(baseBeanName);
            vo.setDomain(this.firstCharToLowerCase(baseBeanName));
            FreemarkerVo infoVo = eoInfoMap.get(tableName);
            Optional.ofNullable(infoVo).ifPresent(iVo -> vo.setExtTable(iVo.getExtTable()));
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-service" + parameter.getBaseSourceFolder() + "/convert/entity", baseBeanName + "Converter.java", "converter.ftl");
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-service" + parameter.getBaseSourceFolder() + "/service/entity", "I" + baseBeanName + "Service.java", "service.ftl");
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-service" + parameter.getBaseSourceFolder() + "/service/entity/impl", baseBeanName + "ServiceImpl.java", "serviceImpl.ftl");
        }
    }

    private void generateRest(PluginParameter parameter) {
        for (String tableName : eoMap.keySet()) {
            String baseBeanName = eoMap.get(tableName);
            FreemarkerVo vo = new FreemarkerVo();
            vo.setBaseBeanDesc(tableRemarkMap.get(tableName));
            vo.setBaseBeanName(baseBeanName);
            vo.setDomain(this.firstCharToLowerCase(baseBeanName));
            this.generateByFreemarker(parameter, vo, this.baseFilePath + "-rest" + parameter.getBaseSourceFolder() + "/rest/entity", baseBeanName + "Controller.java", "controller.ftl");
        }
    }

    private static String under2camel(String s) {
        return Arrays.stream(s.toLowerCase().replaceAll("`", "").split("_")).map(value -> value.substring(0, 1).toUpperCase() + value.substring(1)).collect(Collectors.joining());
    }

    private static String underCamelLower(String s) {
        String str = Arrays.stream(s.toLowerCase().replaceAll("`", "").split("_")).map(value -> value.substring(0, 1).toUpperCase() + value.substring(1)).collect(Collectors.joining());
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    private void exchangeVastType(FieldStmt fieldStmt, String type) {
        if (type.equalsIgnoreCase("tinyint") || type.equalsIgnoreCase("int")) {
            fieldStmt.setVastType("integer");
            fieldStmt.setFormat("int" + fieldStmt.getSize());
        } else if (type.equalsIgnoreCase("bigint")) {
            fieldStmt.setVastType("integer");
            fieldStmt.setFormat("long");
        } else if (type.equalsIgnoreCase("datetime")) {
            fieldStmt.setVastType("string");
            fieldStmt.setFormat("date-time");
        } else if (type.equalsIgnoreCase("decimal")) {
            fieldStmt.setVastType("number");
        } else {
            fieldStmt.setVastType("string");
        }
    }
}

