/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.plugins.framework.sql.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.stream.Collectors;

public class FileReadUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileToString(String filePath) {
        try (InputStream in = FileReadUtils.class.getResourceAsStream(filePath);){
            BufferedReader test = new BufferedReader(new InputStreamReader(in));
            String string = test.lines().collect(Collectors.joining());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean createJsonFile(Object jsonData, String filePath) {
        String content = JSON.toJSONString((Object)jsonData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        try {
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            OutputStreamWriter write = new OutputStreamWriter(new FileOutputStream(file));
            write.write(content);
            ((Writer)write).flush();
            ((Writer)write).close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

