/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.poi.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.poi.dto.AnalysisSolDefinitionDto;
import com.yunxi.dg.base.poi.dto.EnumDefinitionDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ExportSolFileParams;
import com.yunxi.dg.base.poi.enums.BasicDataTypeEnum;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="AbstractBaseFileOperationCommonService_custom_sol")
public class CustomSolFileOperationCommonServiceImpl
extends AbstractBaseFileOperationCommonService {
    private static final Logger logger = LoggerFactory.getLogger(CustomSolFileOperationCommonServiceImpl.class);
    @Value(value="${mgmt.export.serviceName:yunxi-dg-base-node-cis}")
    private String serviceName;

    public List callBackScrollData(ExportQueryParamsReqDto exportQueryParamsReqDto) throws Exception {
        ExportSolFileParams exportFileParams = (ExportSolFileParams)exportQueryParamsReqDto.getExportFileParams();
        exportFileParams.setFilter(exportQueryParamsReqDto.getFilter());
        exportFileParams.setExtFields(exportQueryParamsReqDto.getExtFields());
        RestResponse<PageInfo> restResponse = this.sendRequestApi(exportFileParams);
        AssertUtils.isTrue((boolean)restResponse.getResultCode().equals("0"), (String)("\u83b7\u53d6\u6570\u636e\u5931\u8d25" + restResponse.getResultMsg()));
        if (CollectionUtil.isEmpty((Collection)((PageInfo)restResponse.getData()).getList())) {
            return Collections.EMPTY_LIST;
        }
        String json = JSON.toJSONString((Object)((PageInfo)restResponse.getData()).getList());
        TypeReference<List<Map<String, Object>>> typeReference = new TypeReference<List<Map<String, Object>>>(){};
        List maps = (List)JSON.parseObject((String)json, (TypeReference)typeReference, (Feature[])new Feature[0]);
        this.extractDataConvert(exportFileParams, maps);
        return maps;
    }

    private List<Map<String, Object>> extractDataConvert(ExportSolFileParams exportFileParams, List<Map<String, Object>> maps) {
        for (Map<String, Object> map : maps) {
            for (AnalysisSolDefinitionDto definition : exportFileParams.getDefinitions()) {
                String[] fields;
                JSONObject jsonObject = JSONUtil.parseObj(map);
                StringBuffer msgSb = new StringBuffer();
                for (String key : fields = definition.getKey().split("\\+")) {
                    Object val = this.analysisKeyFieldsJson(key.trim(), jsonObject);
                    if (val == null) continue;
                    msgSb.append(val);
                }
                if (msgSb == null || msgSb.length() <= 0) continue;
                map.put(definition.getKey(), msgSb.toString());
                if (definition.getFormat() != null && definition.getType().equals(BasicDataTypeEnum.BIGDECIMAL.getType())) {
                    DecimalFormat format = new DecimalFormat(definition.getFormat());
                    map.put(definition.getKey(), format.format(BasicDataTypeEnum.BIGDECIMAL.getConvertVal(msgSb.toString())));
                }
                if (definition.getFormat() != null && definition.getType().equals(BasicDataTypeEnum.DATE.getType())) {
                    String dateStr = DateUtil.format((Date)((Date)BasicDataTypeEnum.DATE.getConvertVal(msgSb.toString())), (String)definition.getFormat());
                    map.put(definition.getKey(), dateStr);
                }
                if (!CollectionUtil.isNotEmpty(definition.getValues())) continue;
                EnumDefinitionDto enumDefinitionDto = definition.getValuesMap().getOrDefault(msgSb.toString(), new EnumDefinitionDto());
                map.put(definition.getKey(), enumDefinitionDto.getLabel());
            }
        }
        return maps;
    }

    private RestResponse<PageInfo> sendRequestApi(ExportSolFileParams exportFileParams) {
        String apiUrl = this.extractApiUrl(exportFileParams);
        HttpHeaders headers = new HttpHeaders();
        this.setRequestHeaders(headers);
        HttpEntity entity = new HttpEntity((Object)exportFileParams.getFilter(), (MultiValueMap)headers);
        logger.info("\u8bf7\u6c42apiUrl\u8def\u5f84={}\uff0c\u8bf7\u6c42\u63a5\u53e3\u5165\u53c2={}", (Object)apiUrl, (Object)JSONUtil.toJsonStr((Object)entity));
        String json = (String)new RestTemplate().exchange(apiUrl, HttpMethod.resolve((String)exportFileParams.getApiMethod().toUpperCase()), entity, String.class, new Object[0]).getBody();
        RestResponse pageInfoRestResponse = (RestResponse)JSON.parseObject((String)json, (TypeReference)new TypeReference<RestResponse<PageInfo>>(){}, (Feature[])new Feature[0]);
        return pageInfoRestResponse;
    }

    private void setRequestHeaders(HttpHeaders headers) {
        Map attachments = ServiceContext.getContext().getAttachments();
        headers.setAll(attachments);
        attachments.entrySet().forEach(e -> {
            if (((String)e.getKey()).startsWith("x-dtyunxi-context-")) {
                logger.info("\u5904\u7406\u8bbe\u7f6e\u8bf7\u6c42\u5934");
                headers.add(((String)e.getKey()).replace("x-dtyunxi-context-", ""), (String)e.getValue());
            }
        });
        logger.info("\u8bf7\u6c42\u5934====\u300b{}", (Object)JSONUtil.toJsonStr((Object)ServiceContext.getContext().getKeys()));
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.APPLICATION_JSON}));
    }

    private String extractApiUrl(ExportSolFileParams exportFileParams) {
        exportFileParams.setServiceNameIndex(exportFileParams.getServiceNameIndex() == null ? 0 : exportFileParams.getServiceNameIndex());
        String[] serviceNameArr = this.serviceName.split(",");
        String serviceNameStr = serviceNameArr[0];
        serviceNameStr = serviceNameArr.length <= exportFileParams.getServiceNameIndex() ? serviceNameArr[serviceNameArr.length - 1] : serviceNameArr[exportFileParams.getServiceNameIndex()];
        return exportFileParams.getApiUri().startsWith("/") ? String.format("http://%s%s", serviceNameStr, exportFileParams.getApiUri()) : String.format("http://%s/%s", serviceNameStr, exportFileParams.getApiUri());
    }

    private Object analysisKeyFieldsJson(String key, JSONObject jsonObject) {
        if (Objects.isNull(jsonObject)) {
            return null;
        }
        if (key.indexOf(".") < 0) {
            return jsonObject.get((Object)key);
        }
        int indexOf = key.indexOf("[");
        if (indexOf >= 0 && indexOf < key.indexOf(".")) {
            String[] fields = key.split("\\[");
            JSONArray list = JSONUtil.parseArray((Object)jsonObject.get((Object)fields[0]));
            if (list.isEmpty()) {
                return null;
            }
            Integer index = Integer.valueOf(fields[1].substring(0, fields[1].indexOf("]")));
            JSONObject obj = JSONUtil.parseObj((Object)list.get(index.intValue()));
            return this.analysisKeyFieldsJson(key.substring(key.indexOf(".") + 1), obj);
        }
        if (key.indexOf(".") >= 0) {
            String[] fields = key.split("\\.");
            Object obj = jsonObject.get((Object)fields[0]);
            if (Objects.isNull(obj) || !(obj instanceof Map)) {
                return obj;
            }
            JSONObject jsonObj = JSONUtil.parseObj((Object)obj);
            key = key.substring(key.indexOf(".") + 1);
            return this.analysisKeyFieldsJson(key, jsonObj);
        }
        return null;
    }
}

