/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.poi.service.impl;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.excel.export.ExcelExportService;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.das.IFileOperationInfoDas;
import com.yunxi.dg.base.poi.dto.CallBackExportParamAsyncRespDto;
import com.yunxi.dg.base.poi.dto.ExcelImportMultiResult;
import com.yunxi.dg.base.poi.dto.ExportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.dto.ExportFileParams;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ExportSolFileParams;
import com.yunxi.dg.base.poi.dto.FileOperationInfoRespDto;
import com.yunxi.dg.base.poi.dto.GetImportListPageReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonRespDto;
import com.yunxi.dg.base.poi.enums.FileOperationStatusEnum;
import com.yunxi.dg.base.poi.enums.OperationFileModeEnum;
import com.yunxi.dg.base.poi.enums.OperationTypeEnum;
import com.yunxi.dg.base.poi.eo.FileOperationInfoEo;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import com.yunxi.dg.base.poi.service.FileOperationCommonService;
import com.yunxi.dg.base.poi.utils.CodeGenerateUtil;
import com.yunxi.dg.base.poi.utils.EasyPoiExportUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StopWatch;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="baseFileOperationCommonService")
public class FileOperationCommonServiceImpl
implements FileOperationCommonService {
    private static final Logger log = LoggerFactory.getLogger(FileOperationCommonServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(FileOperationCommonServiceImpl.class);
    @Resource
    private Map<String, AbstractBaseFileOperationCommonService> mapService;
    @Resource
    private IFileOperationInfoDas iFileOperationInfoDas;
    @Autowired
    private ExecutorService fileOperationExecutor;
    @Value(value="${base.mgmt.export.scroll.data.size:1000}")
    private Integer scrollDataSize;
    @Resource(name="baseCodeGenerateUtil")
    private CodeGenerateUtil codeGenerateUtil;
    @Resource
    private PlatformTransactionManager platformTransactionManager;

    @Override
    public RestResponse<ImportFileOperationCommonRespDto> importFileOperationCommonSync(ImportFileOperationCommonReqDto commonReqDto) {
        String userCode = ServiceContext.getContext().getRequestUserCode();
        commonReqDto.setCreatePerson(userCode);
        logger.info("commonReqDto=\u300b{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        StopWatch sw = new StopWatch("\u540c\u6b65\u89e3\u6790\u5bfc\u5165\u4efb\u52a1");
        sw.start(String.format("\u5f00\u59cb\u540c\u6b65\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u903b\u8f91,\u89e3\u6790ServiceImpl=%s", commonReqDto.getKey()));
        AbstractBaseFileOperationCommonService commonService = this.getCommonService(commonReqDto.getKey());
        Long id = this.insertImportFileOperationInfo(commonReqDto, FileOperationStatusEnum.IMPORT_PROCESSING, OperationFileModeEnum.SYNC.getMode());
        this.setRequestAttributes(commonReqDto);
        ArrayList<Object> objects = new ArrayList<Object>();
        ImportFileOperationCommonRespDto respDto = new ImportFileOperationCommonRespDto();
        ExcelImportMultiResult<ImportBaseModeDto> result = this.handleVerifyImportFileMultiContent(commonService, commonReqDto, respDto, objects);
        if (CollectionUtil.isEmpty((Collection)result.getList()) || respDto.getStatus().equals(FileOperationStatusEnum.IMPORT_ERROR.getCode())) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
        } else {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
            commonService.callBackImportFileOperationCommonSync(result, commonReqDto, respDto, CollectionUtil.isNotEmpty(objects) ? objects.get(0) : null);
        }
        this.createErrorSheetForMap(respDto, commonReqDto);
        this.updateFileOperationInfoStatusAndMsg(id, FileOperationStatusEnum.getInstance(respDto.getStatus()), "", respDto.getErrorFileUrl());
        sw.stop();
        logger.info(sw.prettyPrint());
        respDto.setErrorDetailsMap(null);
        return new RestResponse(respDto);
    }

    @Override
    public RestResponse<ImportFileOperationCommonRespDto> importFileOperationCommonAsync(ImportFileOperationCommonReqDto commonReqDto) {
        logger.info("commonReqDto=\u300b{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        StopWatch sw = new StopWatch("\u5f02\u6b65\u89e3\u6790\u5bfc\u5165\u4efb\u52a1");
        sw.start(String.format("\u5f00\u59cb\u89e3\u6790\u5f02\u6b65\u5bfc\u5165\u6587\u4ef6\u903b\u8f91,\u89e3\u6790ServiceImpl=%s", commonReqDto.getKey()));
        Long id = this.insertImportFileOperationInfo(commonReqDto, FileOperationStatusEnum.IMPORT_PROCESSING, OperationFileModeEnum.ASYNC.getMode());
        this.setRequestAttributes(commonReqDto);
        AbstractBaseFileOperationCommonService commonService = this.getCommonService(commonReqDto.getKey());
        ArrayList<Object> objects = new ArrayList<Object>();
        ImportFileOperationCommonRespDto respDto = new ImportFileOperationCommonRespDto();
        ExcelImportMultiResult<ImportBaseModeDto> result = this.handleVerifyImportFileMultiContent(commonService, commonReqDto, respDto, objects);
        logger.info("result.size:{}", (Object)result.getSuccessMap().size());
        logger.info("objects.size:{}", (Object)objects.size());
        if (CollectionUtil.isEmpty(result.getSuccessMap()) || respDto.getStatus().equals(FileOperationStatusEnum.IMPORT_ERROR.getCode())) {
            respDto.setStatus(FileOperationStatusEnum.IMPORT_ERROR.getCode());
            this.createErrorSheetForMap(respDto, commonReqDto);
            this.updateFileOperationInfoStatusAndMsg(id, FileOperationStatusEnum.IMPORT_ERROR, "", respDto.getErrorFileUrl());
            sw.stop();
            logger.info(sw.prettyPrint());
            respDto.setErrorDetailsMap(null);
            return new RestResponse(respDto);
        }
        sw.stop();
        logger.info(sw.prettyPrint());
        respDto.setStatus(FileOperationStatusEnum.IMPORT_PROCESSING.getCode());
        Map<String, String> attachments = this.getRequestHeaders();
        CompletableFuture.runAsync(() -> {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = this.platformTransactionManager.getTransaction((TransactionDefinition)def);
            this.setServiceContextAsync(attachments);
            try {
                respDto.setStatus(FileOperationStatusEnum.IMPORT_SUCCESS.getCode());
                commonService.callBackImportFileOperationCommonAsync(result, commonReqDto, respDto, CollectionUtil.isNotEmpty((Collection)objects) ? objects.get(0) : null);
                this.createErrorSheetForMap(respDto, commonReqDto);
                this.updateFileOperationInfoStatusAndMsg(id, FileOperationStatusEnum.getInstance(respDto.getStatus()), respDto.getErrorMsg(), respDto.getErrorFileUrl());
            }
            catch (Exception e) {
                log.error("\u5bfc\u5165\u9519\u8bef-\u300b", (Throwable)e);
                this.updateFileOperationInfoStatusAndMsg(id, FileOperationStatusEnum.IMPORT_ERROR, respDto.getErrorMsg(), respDto.getErrorFileUrl());
            }
            finally {
                this.delServiceContext();
                this.platformTransactionManager.commit(status);
            }
        }, this.fileOperationExecutor);
        respDto.setErrorDetailsMap(null);
        return new RestResponse(respDto);
    }

    @Override
    public RestResponse<ExportFileOperationCommonRespDto> exportFileOperationCommonSync(ExportFileParams commonReqDto) {
        StopWatch sw = new StopWatch("\u540c\u6b65\u89e3\u6790\u5bfc\u51fa\u4efb\u52a1");
        sw.start(String.format("\u5f00\u59cb\u540c\u6b65\u89e3\u6790\u5bfc\u51fa\u4efb\u52a1,\u89e3\u6790ServiceImpl=%s", commonReqDto.getKey()));
        logger.info("commonReqDto=\u300b{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        this.checkExportFileOperationCommonParam(commonReqDto);
        Long id = this.insertExportFileOperationInfo(commonReqDto, FileOperationStatusEnum.IMPORT_PROCESSING, OperationFileModeEnum.SYNC.getMode());
        this.setRequestAttributes(commonReqDto);
        AbstractBaseFileOperationCommonService commonService = this.getCommonService(commonReqDto.getKey());
        ExportQueryParamsReqDto exportQueryParamsReqDto = this.buildExportQueryParamsReqDto(commonReqDto);
        commonService.initTemplateMap(exportQueryParamsReqDto);
        List list = (List)PoiFileModeMap.exportTemplateMap.get((Object)commonReqDto.getKey());
        String fileName = "";
        if (list.size() >= 3) {
            fileName = (String)list.get(3);
        }
        Class exportTemplate = (Class)list.get(0);
        String path = commonService.uploadExportDataFile(exportQueryParamsReqDto, fileName, exportTemplate);
        ExportFileOperationCommonRespDto commonRespDto = new ExportFileOperationCommonRespDto();
        commonRespDto.setPath(path);
        this.updateExportFileOperationInfo(FileOperationStatusEnum.IMPORT_SUCCESS, id, exportQueryParamsReqDto.getExportFileName(), path, "");
        sw.stop();
        logger.info(sw.prettyPrint());
        return new RestResponse((Object)commonRespDto);
    }

    @Override
    public RestResponse<ExportFileOperationCommonRespDto> exportFileOperationCommonAsync(ExportFileParams commonReqDto) {
        StopWatch sw = new StopWatch("\u5f02\u6b65\u89e3\u6790\u5bfc\u51fa\u4efb\u52a1");
        sw.start(String.format("\u5f00\u59cb\u5f02\u6b65\u89e3\u6790\u5bfc\u51fa\u4efb\u52a1,\u89e3\u6790ServiceImpl=%s", commonReqDto.getKey()));
        logger.info("commonReqDto=\u300b{}", (Object)JSON.toJSONString((Object)((Object)commonReqDto)));
        Long id = this.insertExportFileOperationInfo(commonReqDto, FileOperationStatusEnum.IMPORT_PROCESSING, OperationFileModeEnum.ASYNC.getMode());
        this.setRequestAttributes(commonReqDto);
        this.checkExportFileOperationCommonParam(commonReqDto);
        AbstractBaseFileOperationCommonService commonService = this.getCommonService(commonReqDto.getKey());
        ExportQueryParamsReqDto exportQueryParamsReqDto = this.buildExportQueryParamsReqDto(commonReqDto);
        Map<String, String> attachments = this.getRequestHeaders();
        CompletableFuture.runAsync(() -> {
            this.setServiceContextAsync(attachments);
            CallBackExportParamAsyncRespDto asyncRespDto = new CallBackExportParamAsyncRespDto();
            asyncRespDto.setFilter(commonReqDto.getFilter());
            asyncRespDto.setKey(commonReqDto.getKey());
            FileOperationStatusEnum statusEnum = null;
            try {
                commonService.initTemplateMap(exportQueryParamsReqDto);
                List list = (List)PoiFileModeMap.exportTemplateMap.get((Object)commonReqDto.getKey());
                log.info("==>>>{}", (Object)JSONUtil.toJsonStr((Object)list));
                Class exportTemplate = (Class)list.get(0);
                String path = commonService.uploadExportDataFile(exportQueryParamsReqDto, list.get(3).toString(), exportTemplate);
                asyncRespDto.setStatus("1");
                asyncRespDto.setExportFileName(exportQueryParamsReqDto.getExportFileName());
                asyncRespDto.setUploadPath(path);
                statusEnum = FileOperationStatusEnum.IMPORT_SUCCESS;
            }
            catch (Exception e) {
                try {
                    logger.error("\u5bfc\u51fa\u6570\u636e\u5931\u8d25", (Throwable)e);
                    asyncRespDto.setStatus("2");
                    asyncRespDto.setErrorMsg(e.getMessage());
                    statusEnum = FileOperationStatusEnum.IMPORT_ERROR;
                }
                catch (Throwable throwable) {
                    statusEnum = Objects.isNull(statusEnum) ? FileOperationStatusEnum.IMPORT_ERROR : statusEnum;
                    commonService.callBackExportFinishAsync(asyncRespDto);
                    this.updateExportFileOperationInfo(statusEnum, id, exportQueryParamsReqDto.getExportFileName(), asyncRespDto.getUploadPath(), asyncRespDto.getErrorMsg());
                    this.delServiceContext();
                    throw throwable;
                }
                statusEnum = Objects.isNull((Object)statusEnum) ? FileOperationStatusEnum.IMPORT_ERROR : statusEnum;
                commonService.callBackExportFinishAsync(asyncRespDto);
                this.updateExportFileOperationInfo(statusEnum, id, exportQueryParamsReqDto.getExportFileName(), asyncRespDto.getUploadPath(), asyncRespDto.getErrorMsg());
                this.delServiceContext();
            }
            statusEnum = Objects.isNull((Object)statusEnum) ? FileOperationStatusEnum.IMPORT_ERROR : statusEnum;
            commonService.callBackExportFinishAsync(asyncRespDto);
            this.updateExportFileOperationInfo(statusEnum, id, exportQueryParamsReqDto.getExportFileName(), asyncRespDto.getUploadPath(), asyncRespDto.getErrorMsg());
            this.delServiceContext();
        }, this.fileOperationExecutor);
        sw.stop();
        logger.info(sw.prettyPrint());
        return new RestResponse();
    }

    @Override
    public RestResponse<PageInfo<FileOperationInfoRespDto>> queryByPage(GetImportListPageReqDto dto) {
        log.info("------\u67e5\u8be2\u5217\u8868--------");
        log.info("------\u67e5\u8be2\u5217\u8868--------{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo pageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iFileOperationInfoDas.filter().like(StrUtil.isNotBlank((CharSequence)dto.getFileName()), (Object)"file_name", (Object)dto.getFileName())).like(StrUtil.isNotBlank((CharSequence)dto.getModuleName()), (Object)"module_name", (Object)dto.getModuleName())).eq(dto.getStatus() != null, (Object)"status", (Object)dto.getStatus())).eq(StrUtil.isNotBlank((CharSequence)dto.getTaskCode()), (Object)"task_code", (Object)dto.getTaskCode())).eq(StrUtil.isNotBlank((CharSequence)dto.getCreatePerson()), (Object)"create_person", (Object)dto.getCreatePerson())).eq(dto.getIsSync() != null, (Object)"is_sync", (Object)dto.getIsSync())).eq(dto.getOperationType() != null, (Object)"operation_Type", (Object)dto.getOperationType())).ge(StrUtil.isNotBlank((CharSequence)dto.getCreateDateStart()), (Object)"create_time", (Object)dto.getCreateDateStart())).le(StrUtil.isNotBlank((CharSequence)dto.getCreateDateEnd()), (Object)"create_time", (Object)dto.getCreateDateEnd())).orderByDesc((Object)"complete_time")).page(dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List fileOperationInfoRespDtos = BeanUtil.copyToList((Collection)pageInfo.getList(), FileOperationInfoRespDto.class);
        dtoPageInfo.setList(fileOperationInfoRespDtos);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<PageInfo<FileOperationInfoRespDto>> queryPage(GetImportListPageReqDto dto) {
        log.info("------\u67e5\u8be2\u5217\u8868\u5bfc\u51fa\u5217\u8868\uff1a-------{}", (Object)JSONObject.toJSONString((Object)dto));
        PageInfo pageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iFileOperationInfoDas.filter().like(StrUtil.isNotBlank((CharSequence)dto.getFileName()), (Object)"file_name", (Object)dto.getFileName())).like(StrUtil.isNotBlank((CharSequence)dto.getModuleName()), (Object)"module_name", (Object)dto.getModuleName())).eq(dto.getStatus() != null, (Object)"status", (Object)dto.getStatus())).eq(StrUtil.isNotBlank((CharSequence)dto.getTaskCode()), (Object)"task_code", (Object)dto.getTaskCode())).eq(dto.getIsSync() != null, (Object)"is_sync", (Object)dto.getIsSync())).eq(dto.getOperationType() != null, (Object)"operation_Type", (Object)dto.getOperationType())).eq((Object)"create_person", (Object)ServiceContext.getContext().getRequestUserCode())).ge(StrUtil.isNotBlank((CharSequence)dto.getCreateDateStart()), (Object)"create_time", (Object)dto.getCreateDateStart())).le(StrUtil.isNotBlank((CharSequence)dto.getCreateDateEnd()), (Object)"create_time", (Object)dto.getCreateDateEnd())).orderByDesc((Object)"complete_time")).page(dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List fileOperationInfoRespDtos = BeanUtil.copyToList((Collection)pageInfo.getList(), FileOperationInfoRespDto.class);
        dtoPageInfo.setList(fileOperationInfoRespDtos);
        return new RestResponse((Object)dtoPageInfo);
    }

    private Map<String, String> getRequestHeaders() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        Enumeration headerNames = request.getHeaderNames();
        Map headerMap = (Map)JSON.parseObject((String)JSONUtil.toJsonStr((Object)ServiceContext.getContext().getAttachments()), Map.class);
        headerMap.put("Dg-Application-Type", request.getHeader("Dg-Application-Type"));
        headerMap.put("Root-Organization-Id", request.getHeader("Root-Organization-Id"));
        log.info("headerMap==>{}", (Object)JSONUtil.toJsonStr((Object)headerMap));
        return headerMap;
    }

    private void setServiceContextAsync(Map<String, String> attachments) {
        if (CollectionUtil.isEmpty(attachments)) {
            log.info("!!!!!!\u6ce8\u610f\u662f\u7a7a\u8bf7\u6c42\u5934--->");
            return;
        }
        log.info("setServiceContextAsync attachments---\u300b{}", (Object)JSON.toJSONString(attachments));
        for (Map.Entry<String, String> entry : attachments.entrySet()) {
            if (!entry.getKey().startsWith("x-dtyunxi-context-")) {
                ServiceContext.getContext().setAttachment(String.format("x-dtyunxi-context-%s", entry.getKey()), entry.getValue());
            }
            ServiceContext.getContext().setAttachment(entry.getKey(), entry.getValue());
        }
    }

    private void setRequestAttributes(BaseVo commonReqDto) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        commonReqDto.getExtFields().put("Access-Token", request.getHeader("Access-Token"));
    }

    private ExportQueryParamsReqDto buildExportQueryParamsReqDto(ExportFileParams commonReqDto) {
        ExportQueryParamsReqDto exportQueryParamsReqDto = new ExportQueryParamsReqDto();
        exportQueryParamsReqDto.setFilter(commonReqDto.getFilter());
        exportQueryParamsReqDto.setPageNum(1);
        exportQueryParamsReqDto.setPageSize(this.scrollDataSize);
        exportQueryParamsReqDto.setExtFields(commonReqDto.getExtFields());
        exportQueryParamsReqDto.setExportFileName(commonReqDto.getExportFunctionName());
        if (commonReqDto instanceof ExportSolFileParams) {
            ExportSolFileParams solFileParams = (ExportSolFileParams)commonReqDto;
            exportQueryParamsReqDto.setExportFileName(solFileParams.getExportFunctionName());
        }
        exportQueryParamsReqDto.setExportFileParams(commonReqDto);
        return exportQueryParamsReqDto;
    }

    private void updateFileOperationInfoStatusAndMsg(Long id, FileOperationStatusEnum statusEnum, String errorMsg, String errorMsgUrl) {
        FileOperationInfoEo infoEo = (FileOperationInfoEo)((Object)this.iFileOperationInfoDas.getMapper().selectById((Serializable)id));
        infoEo.setStatus(statusEnum.getCode());
        infoEo.setId(id);
        infoEo.setErrorMsg(errorMsg);
        infoEo.setErrorMsgUrl(errorMsgUrl);
        infoEo.setCompleteTime(new Date());
        this.iFileOperationInfoDas.update(infoEo);
    }

    private Long insertImportFileOperationInfo(ImportFileOperationCommonReqDto commonReqDto, FileOperationStatusEnum statusEnum, Integer isSync) {
        String userCode = ServiceContext.getContext().getRequestUserCode();
        log.info("\u4e0a\u4e0b\u6587\u7684\u7528\u6237\u4fe1\u606f:{}", (Object)userCode);
        List list = (List)PoiFileModeMap.importTemplateMap.get((Object)commonReqDto.getKey());
        FileOperationInfoEo infoEo = new FileOperationInfoEo();
        infoEo.setFileName(StrUtil.isNotBlank((CharSequence)commonReqDto.getFileName()) ? commonReqDto.getFileName() : (String)list.get(2));
        infoEo.setFileUrl(commonReqDto.getImportFileUrl());
        infoEo.setOperationType(OperationTypeEnum.IMPORT.getType());
        infoEo.setModuleName((String)list.get(2));
        infoEo.setIsSync(isSync);
        infoEo.setTaskCode(this.codeGenerateUtil.getCreateTaskCode("EX"));
        infoEo.setStatus(statusEnum.getCode());
        infoEo.setModuleKey(commonReqDto.getKey());
        infoEo.setSource(commonReqDto.getKey());
        infoEo.setCreatePerson(userCode);
        infoEo.setUpdatePerson(userCode);
        this.iFileOperationInfoDas.insert(infoEo);
        return infoEo.getId();
    }

    private Long insertExportFileOperationInfo(ExportFileParams commonReqDto, FileOperationStatusEnum statusEnum, Integer isSync) {
        String userCode = ServiceContext.getContext().getRequestUserCode();
        logger.info("userCode=\u300b{}", (Object)userCode);
        List list = (List)PoiFileModeMap.importTemplateMap.get((Object)commonReqDto.getKey());
        FileOperationInfoEo infoEo = new FileOperationInfoEo();
        infoEo.setOperationType(OperationTypeEnum.EXPORT.getType());
        infoEo.setModuleName((String)list.get(2));
        infoEo.setIsSync(isSync);
        infoEo.setTaskCode(this.codeGenerateUtil.getCreateTaskCode("EX"));
        infoEo.setParam(JSON.toJSONString((Object)((Object)commonReqDto)));
        infoEo.setStatus(statusEnum.getCode());
        infoEo.setModuleKey(commonReqDto.getKey());
        infoEo.setSource(commonReqDto.getKey());
        if (commonReqDto instanceof ExportSolFileParams) {
            ExportSolFileParams solFileParams = (ExportSolFileParams)commonReqDto;
            infoEo.setModuleName(solFileParams.getMenuModuleName());
            solFileParams.setExportFunctionName(StrUtil.isBlank((CharSequence)solFileParams.getExportFunctionName()) ? list.get(3).toString() : solFileParams.getExportFunctionName());
            infoEo.setFileName(solFileParams.getExportFunctionName());
        }
        infoEo.setUpdatePerson(userCode);
        infoEo.setCreatePerson(userCode);
        logger.info("infoEo----=\u300b{}", (Object)JSON.toJSONString((Object)((Object)infoEo)));
        this.iFileOperationInfoDas.insert(infoEo);
        return infoEo.getId();
    }

    private void updateExportFileOperationInfo(FileOperationStatusEnum statusEnum, Long id, String fileName, String fileUrl, String errorMsg) {
        FileOperationInfoEo infoEo = (FileOperationInfoEo)((Object)this.iFileOperationInfoDas.getMapper().selectById((Serializable)id));
        infoEo.setStatus(statusEnum.getCode());
        infoEo.setId(id);
        infoEo.setFileUrl(fileUrl);
        infoEo.setFileName(fileName);
        infoEo.setErrorMsg(errorMsg);
        infoEo.setCompleteTime(new Date());
        this.iFileOperationInfoDas.update(infoEo);
    }

    private ExcelImportResult<ImportBaseModeDto> handleVerifyImportFileContent(AbstractBaseFileOperationCommonService commonService, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, List<Object> objects) {
        Object object;
        logger.info("\u9700\u8981\u5bfc\u5165\u7684objects.size:{}", (Object)objects.size());
        this.checkImportFileOperationCommonParam(commonReqDto);
        ExcelImportResult<ImportBaseModeDto> result = commonService.parseExcelDataResult(commonReqDto, respDto);
        logger.info("\u89e3\u6790\u540e\u6b63\u5e38\u7684\u6570\u636e\u5217\u8868\u6570\u91cf:{},\u5931\u8d25\u7684\u6570\u636e\u5217\u8868\u6570\u91cf:{}", (Object)result.getList().size(), (Object)result.getFailList().size());
        if (CollectionUtil.isEmpty((Collection)result.getList())) {
            return result;
        }
        if (!result.getFailList().isEmpty()) {
            result.getFailList().stream().forEach(e -> e.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u6709\u8bef,%s", e.getRowNum() + commonReqDto.getHeadRows(), e.getErrorMsg())));
            respDto.getErrorDetails().addAll(result.getFailList());
        }
        if (Objects.nonNull(object = commonService.verifyImportFileOperationCommon(result, commonReqDto, respDto))) {
            objects.add(object);
        }
        respDto.setErrorFileName(StrUtil.isNotBlank((CharSequence)commonReqDto.getFileName()) ? commonReqDto.getFileName() : "\u5bfc\u51fa\u5b58\u5728\u9519\u8bef\u6587\u4ef6");
        respDto.setErrorFileUrl(commonService.uploadImportErrorFile(respDto.getErrorDetails(), respDto.getErrorFileName()));
        return result;
    }

    private ExcelImportMultiResult<ImportBaseModeDto> handleVerifyImportFileMultiContent(AbstractBaseFileOperationCommonService commonService, ImportFileOperationCommonReqDto commonReqDto, ImportFileOperationCommonRespDto respDto, List<Object> objects) {
        Object object;
        logger.info("\u9700\u8981\u5bfc\u5165\u7684objects.size:{}", (Object)objects.size());
        this.checkImportFileOperationCommonParam(commonReqDto);
        ExcelImportMultiResult<ImportBaseModeDto> multiResult = commonService.parseExcelDataMultiResult(commonReqDto, respDto);
        if (CollectionUtil.isNotEmpty(multiResult.getSuccessMap()) && Objects.nonNull(object = commonService.verifyImportFileOperationCommon(multiResult, commonReqDto, respDto))) {
            objects.add(object);
        }
        if (CollectionUtil.isNotEmpty(multiResult.getSuccessMap())) {
            for (Map.Entry<Integer, List<ImportBaseModeDto>> entry : multiResult.getSuccessMap().entrySet()) {
                Iterator<ImportBaseModeDto> iterator = entry.getValue().iterator();
                while (iterator.hasNext()) {
                    ImportBaseModeDto next = iterator.next();
                    if (!StrUtil.isNotBlank((CharSequence)next.getErrorMsg())) continue;
                    multiResult.getFailMap().get(entry.getKey()).add(next);
                    iterator.remove();
                }
            }
        }
        return multiResult;
    }

    private void checkExportFileOperationCommonParam(ExportFileParams commonReqDto) {
        if (Objects.isNull((Object)commonReqDto)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)commonReqDto.getKey())) {
            throw new BizException("\u64cd\u4f5c\u529f\u80fd\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkImportFileOperationCommonParam(ImportFileOperationCommonReqDto commonReqDto) {
        if (Objects.isNull((Object)commonReqDto)) {
            throw new BizException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)commonReqDto.getImportFileUrl())) {
            throw new BizException("\u4e0a\u4f20\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(commonReqDto.getKey())) {
            throw new BizException("\u64cd\u4f5c\u529f\u80fd\u6a21\u5757\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private AbstractBaseFileOperationCommonService getCommonService(String module) {
        AbstractBaseFileOperationCommonService commonService = this.mapService.get(String.format("%s_%s", "AbstractBaseFileOperationCommonService", module));
        if (Objects.isNull(commonService)) {
            log.error("\u5b9e\u73b0\u7f16\u7801\uff1a{} \u670d\u52a1\u4e0d\u5b58\u5728 mapService\uff1a{}", (Object)module, (Object)JSON.toJSONString(this.mapService));
            commonService = this.mapService.get("AbstractBaseFileOperationCommonService");
        }
        return commonService;
    }

    private void delServiceContext() {
        ServiceContext.getContext().removeAttachmentContext();
    }

    private void createErrorSheetForMap(ImportFileOperationCommonRespDto respDto, ImportFileOperationCommonReqDto commonReqDto) {
        log.info("\u6253\u5370\u9519\u8bef\u4fe1\u606f===\u300b{}", (Object)JSONUtil.toJsonStr((Object)((Object)respDto)));
        List list = (List)PoiFileModeMap.importTemplateMap.get((Object)commonReqDto.getKey());
        boolean multiFlag = list.get(0) instanceof List;
        if (!multiFlag && CollectionUtil.isNotEmpty(respDto.getErrorDetails())) {
            List errList = respDto.getErrorDetailsMap().getOrDefault(0, new ArrayList());
            errList.addAll(respDto.getErrorDetails());
            respDto.getErrorDetailsMap().put(0, errList);
        }
        respDto.setErrorFileName(StrUtil.isNotBlank((CharSequence)commonReqDto.getFileName()) ? commonReqDto.getFileName() : "\u5bfc\u51fa\u5b58\u5728\u9519\u8bef\u6587\u4ef6");
        if (CollectionUtil.isNotEmpty(respDto.getErrorDetailsMap())) {
            XSSFWorkbook workbook = new XSSFWorkbook();
            Iterator<Integer> iterator = respDto.getErrorDetailsMap().keySet().iterator();
            while (iterator.hasNext()) {
                Integer obj;
                Integer key = obj = iterator.next();
                List<ImportBaseModeDto> importList = respDto.getErrorDetailsMap().get(key);
                if (CollectionUtil.isEmpty(importList)) continue;
                ExcelExportService server = new ExcelExportService();
                ExportParams exportParams = new ExportParams(null, "\u5bfc\u51fa\u5931\u8d25\u6570\u636e-" + key, ExcelType.XSSF);
                List<ExcelExportEntity> excelExportEntities = EasyPoiExportUtil.extractImportErrorTitle(((Object)((Object)importList.get(0))).getClass());
                TypeReference<List<Map<String, Object>>> typeReference = new TypeReference<List<Map<String, Object>>>(){};
                List maps = (List)JSON.parseObject((String)JSONUtil.toJsonStr(importList), (TypeReference)typeReference, (Feature[])new Feature[0]);
                server.createSheetForMap((Workbook)workbook, exportParams, excelExportEntities, (Collection)maps);
            }
            log.info("\u4e0a\u4f20\u5bfc\u5165\u751f\u6210\u5931\u8d25\u7684\u6587\u4ef6");
            respDto.setErrorFileUrl(EasyPoiExportUtil.getLoadWorkbookUrl((Workbook)workbook, respDto.getErrorFileName()));
        }
    }
}

