/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.poi.utils;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.annotation.Excel;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.MD5Util;
import com.dtyunxi.util.SpringBeanUtil;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ImportFileOperationCommonReqDto;
import com.yunxi.dg.base.poi.utils.CheckUtils;
import com.yunxi.dg.base.poi.utils.ExcelExportStatisticStyler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyPoiExportUtil {
    private static final Logger logger = LoggerFactory.getLogger(EasyPoiExportUtil.class);
    private static IObjectStorageService objectStorageService;
    private static String BUCKET_NAME;
    private static String END_POINT;

    private static void initConfig() {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (BUCKET_NAME == null) {
            BUCKET_NAME = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        if (END_POINT == null) {
            END_POINT = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        }
    }

    public static Workbook append(List excelRespDtos, Class tClass, String title, String excelName) {
        ExportParams params = new ExportParams(title, "");
        return ExcelExportUtil.exportBigExcel((ExportParams)params, (Class)tClass, (Collection)excelRespDtos);
    }

    public static Workbook append(List excelRespDtos, List<ExcelExportEntity> excelParams, String title, String excelName) {
        ExportParams params = new ExportParams(title, excelName);
        params.setStyle(ExcelExportStatisticStyler.class);
        return ExcelExportUtil.exportBigExcel((ExportParams)params, excelParams, (Collection)excelRespDtos);
    }

    public static String getLoadWorkbookUrl(Workbook workbook, String exportFileName) {
        try {
            EasyPoiExportUtil.initConfig();
            EasyPoiExportUtil.close();
            if (!exportFileName.endsWith(".xlsx")) {
                exportFileName = exportFileName + "_" + System.currentTimeMillis() + ".xlsx";
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            workbook.write((OutputStream)bos);
            byte[] barray = bos.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(barray);
            return objectStorageService.put(BUCKET_NAME, exportFileName, (InputStream)is);
        }
        catch (Exception e) {
            logger.error("{}\u5bfc\u51faexcel\u5f02\u5e38", (Object)exportFileName, (Object)e);
            throw new BusinessRuntimeException(exportFileName + "\u5bfc\u51faexcel\u5f02\u5e38");
        }
    }

    public static String getUploadingUrl(InputStream is, String exportFileName) {
        return objectStorageService.put(BUCKET_NAME, exportFileName, is);
    }

    public static ExcelImportResult<ImportBaseModeDto> handlerExcelDataResult(ImportFileOperationCommonReqDto commonReqDto, String url) {
        List list = (List)PoiFileModeMap.importTemplateMap.get((Object)commonReqDto.getKey());
        commonReqDto.setHeadRows((Integer)list.get(1));
        InputStream inputStream = EasyPoiExportUtil.getInputStream(url);
        logger.info("handlerExcelDataResult\u5f00\u59cb\u89e3\u6790\u6570\u636e\uff1a{}", (Object)url);
        return EasyPoiExportUtil.handlerExcelDataResult((Class)list.get(0), inputStream, commonReqDto.getHeadRows());
    }

    public static ExcelImportResult<ImportBaseModeDto> handlerExcelDataResult(Class classTemplate, InputStream inputStream, Integer headRows) {
        try {
            ImportParams params = new ImportParams();
            params.setHeadRows(headRows.intValue());
            params.setNeedVerify(true);
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)classTemplate, (ImportParams)params);
            EasyPoiExportUtil.handleImportResultListFilterEmpty(result);
            logger.info("---\u89e3\u6790\u6570\u636e-----");
            if (CollectionUtil.isEmpty((Collection)result.getList()) && CollectionUtil.isEmpty((Collection)result.getFailList())) {
                throw new BizException("\u8bf7\u4e0d\u8981\u5bfc\u5165\u7a7a\u6587\u4ef6");
            }
            return result;
        }
        catch (BusinessRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6a21\u677f\u5931\u8d25", (Throwable)e);
            throw new BizException("\u89e3\u6790\u5bfc\u5165\u7684\u6570\u636e\u5931\u8d25");
        }
    }

    public static void checkFileInfo(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new BizException("\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!url.endsWith("xls") && !url.endsWith("xlsx")) {
            throw new BizException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef,\u6587\u4ef6\u683c\u5f0f\u53ea\u80fd\u662fxls\u6216\u8005xlsx");
        }
    }

    public static InputStream getInputStream(String url) {
        HttpResponse response = HttpUtil.createGet((String)url).execute();
        return response.bodyStream();
    }

    public static HttpURLConnection getHttpURLConnection(String url) {
        HttpURLConnection http = null;
        try {
            URL realUrl = new URL(url);
            http = (HttpURLConnection)realUrl.openConnection();
            http.setRequestMethod("GET");
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            http.setDoOutput(true);
            http.setDoInput(true);
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
            System.setProperty("sun.net.client.defaultReadTimeout", "30000");
            http.connect();
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38", (Throwable)e);
            throw new BizException(e.getMessage());
        }
        return http;
    }

    public static void checkExcelHeader(InputStream inputStream, Class<? extends ImportBaseModeDto> importTemplate, int rowNum) {
        ExcelReader excelReader = EasyPoiExportUtil.getExcelReader(inputStream, importTemplate);
        List names = excelReader.readRow(rowNum);
        boolean b = EasyPoiExportUtil.checkExcelHeader(names, importTemplate);
        if (!b) {
            throw new BizException("\u4e0a\u4f20\u7684\u6a21\u677f\u4e0d\u5bf9\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u7684\u6a21\u677f");
        }
    }

    public static void handleImportResultListFilterEmpty(ExcelImportResult result) {
        ArrayList fails = new ArrayList();
        boolean isFail = false;
        if (result.isVerfiyFail()) {
            for (Object val : result.getFailList()) {
                boolean b = CheckUtils.checkFieldAllNull(val);
                if (b) continue;
                logger.info("\u5b58\u5728\u6821\u9a8c\u5931\u8d25\u7684");
                fails.add(val);
                isFail = true;
            }
        }
        result.setFailList(fails);
        result.setVerfiyFail(isFail);
        List list = result.getList().stream().filter(l -> !CheckUtils.checkFieldAllNull(l)).collect(Collectors.toList());
        result.setList(list);
    }

    public static List<ExcelExportEntity> extractImportErrorTitle(Class<? extends ImportBaseModeDto> templateClass) {
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        for (Field field : ReflectUtil.getFields(templateClass)) {
            if (field.getName().equals("errorMsg")) {
                ExcelExportEntity entity = new ExcelExportEntity("\u9519\u8bef\u4fe1\u606f", (Object)field.getName());
                entitys.add(entity);
                continue;
            }
            Excel annotation = field.getAnnotation(Excel.class);
            if (!Objects.nonNull(annotation)) continue;
            ExcelExportEntity entity = new ExcelExportEntity(annotation.name(), (Object)field.getName());
            entity.setFixedIndex(annotation.fixedIndex());
            entitys.add(entity);
        }
        return entitys;
    }

    private static void checkFileSize(InputStream inputStream, int fileSize) {
        try {
            if (inputStream.available() > 0) {
                double size = inputStream.available() / 0x100000;
                logger.info("\u6587\u4ef6size:" + size + "M");
                if (size > (double)fileSize) {
                    throw new BizException("\u6587\u4ef6\u4e0d\u80fd\u5927\u4e8e" + fileSize + "M");
                }
            }
        }
        catch (IOException e) {
            throw new BizException("\u8bfb\u53d6\u6587\u4ef6IO\u5f02\u5e38");
        }
    }

    private static ExcelReader getExcelReader(InputStream inputStream, Class beanType) {
        ExcelReader excelReader = ExcelUtil.getReader((InputStream)inputStream);
        EasyPoiExportUtil.addHeaderAlias(excelReader, beanType);
        return excelReader;
    }

    private static void addHeaderAlias(ExcelReader excelReader, Class beanType) {
        Field[] fields;
        for (Field field : fields = beanType.getDeclaredFields()) {
            Excel annotation = field.getAnnotation(Excel.class);
            if (annotation == null) continue;
            String header = field.getAnnotation(Excel.class).name();
            excelReader.addHeaderAlias(header, field.getName());
        }
    }

    private static boolean checkExcelHeader(List<Object> readRow, Class clazz) {
        Field[] fields;
        StringBuilder fieldNames = new StringBuilder();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Excel annotation = field.getAnnotation(Excel.class);
            if (annotation == null) continue;
            String annotationName = field.getAnnotation(Excel.class).name();
            fieldNames.append(annotationName);
        }
        StringBuilder headerNames = new StringBuilder();
        for (Object headerName : readRow) {
            if (headerName == null) continue;
            headerNames.append(headerName);
        }
        String md5FieldNames = MD5Util.getMd5ByString((String)fieldNames.toString());
        String md5HeaderNames = MD5Util.getMd5ByString((String)headerNames.toString());
        logger.info("md5FieldNames = {} fieldNames ={}", (Object)md5FieldNames, (Object)fieldNames.toString());
        logger.info("md5HeaderNames = {} fieldNames ={}", (Object)md5HeaderNames, (Object)headerNames.toString());
        return md5FieldNames.equals(md5HeaderNames);
    }

    private static void close() {
        ExcelExportUtil.closeExportBigExcel();
    }
}

