/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.cluster.RoundRobin;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.ClientResources;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

class RoundRobinSocketAddressSupplier
implements Supplier<SocketAddress> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RoundRobinSocketAddressSupplier.class);
    private final Collection<RedisClusterNode> partitions;
    private final Function<Collection<RedisClusterNode>, Collection<RedisClusterNode>> sortFunction;
    private final ClientResources clientResources;
    private RoundRobin<RedisClusterNode> roundRobin;

    public RoundRobinSocketAddressSupplier(Collection<RedisClusterNode> partitions, Function<? extends Collection<RedisClusterNode>, Collection<RedisClusterNode>> sortFunction, ClientResources clientResources) {
        LettuceAssert.notNull(partitions, "Partitions must not be null");
        LettuceAssert.notNull(sortFunction, "Sort-Function must not be null");
        this.partitions = partitions;
        this.roundRobin = new RoundRobin();
        this.sortFunction = sortFunction;
        this.clientResources = clientResources;
        this.resetRoundRobin();
    }

    @Override
    public SocketAddress get() {
        if (!this.roundRobin.isConsistent(this.partitions)) {
            this.resetRoundRobin();
        }
        RedisClusterNode redisClusterNode = this.roundRobin.next();
        return this.getSocketAddress(redisClusterNode);
    }

    protected void resetRoundRobin() {
        this.roundRobin.rebuild(this.sortFunction.apply(this.partitions));
    }

    protected SocketAddress getSocketAddress(RedisClusterNode redisClusterNode) {
        SocketAddress resolvedAddress = this.clientResources.socketAddressResolver().resolve(redisClusterNode.getUri());
        logger.debug("Resolved SocketAddress {} using for Cluster node {}", (Object)resolvedAddress, (Object)redisClusterNode.getNodeId());
        return resolvedAddress;
    }
}

