/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.SslOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.DecodeBufferPolicy;
import io.lettuce.core.protocol.ProtocolVersion;
import java.nio.charset.Charset;
import java.time.Duration;

public class ClusterClientOptions
extends ClientOptions {
    public static final boolean DEFAULT_CLOSE_STALE_CONNECTIONS = true;
    public static final int DEFAULT_MAX_REDIRECTS = 5;
    public static final boolean DEFAULT_REFRESH_CLUSTER_VIEW = false;
    public static final long DEFAULT_REFRESH_PERIOD = 60L;
    public static final Duration DEFAULT_REFRESH_PERIOD_DURATION = Duration.ofSeconds(60L);
    public static final boolean DEFAULT_VALIDATE_CLUSTER_MEMBERSHIP = true;
    private final int maxRedirects;
    private final ClusterTopologyRefreshOptions topologyRefreshOptions;
    private final boolean validateClusterNodeMembership;

    protected ClusterClientOptions(Builder builder) {
        super(builder);
        this.validateClusterNodeMembership = builder.validateClusterNodeMembership;
        this.maxRedirects = builder.maxRedirects;
        ClusterTopologyRefreshOptions refreshOptions = builder.topologyRefreshOptions;
        if (refreshOptions == null) {
            refreshOptions = ClusterTopologyRefreshOptions.builder().enablePeriodicRefresh(false).refreshPeriod(DEFAULT_REFRESH_PERIOD_DURATION).closeStaleConnections(builder.closeStaleConnections).build();
        }
        this.topologyRefreshOptions = refreshOptions;
    }

    protected ClusterClientOptions(ClusterClientOptions original) {
        super(original);
        this.validateClusterNodeMembership = original.validateClusterNodeMembership;
        this.maxRedirects = original.maxRedirects;
        this.topologyRefreshOptions = original.topologyRefreshOptions;
    }

    public static ClusterClientOptions copyOf(ClusterClientOptions options) {
        return new ClusterClientOptions(options);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClientOptions clientOptions) {
        LettuceAssert.notNull((Object)clientOptions, "ClientOptions must not be null");
        if (clientOptions instanceof ClusterClientOptions) {
            return ((ClusterClientOptions)clientOptions).mutate();
        }
        Builder builder = new Builder();
        builder.autoReconnect(clientOptions.isAutoReconnect()).cancelCommandsOnReconnectFailure(clientOptions.isCancelCommandsOnReconnectFailure()).decodeBufferPolicy(clientOptions.getDecodeBufferPolicy()).disconnectedBehavior(clientOptions.getDisconnectedBehavior()).pingBeforeActivateConnection(clientOptions.isPingBeforeActivateConnection()).publishOnScheduler(clientOptions.isPublishOnScheduler()).protocolVersion(clientOptions.getConfiguredProtocolVersion()).requestQueueSize(clientOptions.getRequestQueueSize()).scriptCharset(clientOptions.getScriptCharset()).socketOptions(clientOptions.getSocketOptions()).sslOptions(clientOptions.getSslOptions()).suspendReconnectOnProtocolFailure(clientOptions.isSuspendReconnectOnProtocolFailure()).timeoutOptions(clientOptions.getTimeoutOptions());
        return builder;
    }

    public static ClusterClientOptions create() {
        return ClusterClientOptions.builder().build();
    }

    @Override
    public Builder mutate() {
        Builder builder = new Builder();
        builder.autoReconnect(this.isAutoReconnect()).cancelCommandsOnReconnectFailure(this.isCancelCommandsOnReconnectFailure()).decodeBufferPolicy(this.getDecodeBufferPolicy()).disconnectedBehavior(this.getDisconnectedBehavior()).maxRedirects(this.getMaxRedirects()).publishOnScheduler(this.isPublishOnScheduler()).pingBeforeActivateConnection(this.isPingBeforeActivateConnection()).protocolVersion(this.getConfiguredProtocolVersion()).requestQueueSize(this.getRequestQueueSize()).scriptCharset(this.getScriptCharset()).socketOptions(this.getSocketOptions()).sslOptions(this.getSslOptions()).suspendReconnectOnProtocolFailure(this.isSuspendReconnectOnProtocolFailure()).timeoutOptions(this.getTimeoutOptions()).topologyRefreshOptions(this.getTopologyRefreshOptions()).validateClusterNodeMembership(this.isValidateClusterNodeMembership());
        return builder;
    }

    public boolean isCloseStaleConnections() {
        return this.topologyRefreshOptions.isCloseStaleConnections();
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isRefreshClusterView() {
        return this.topologyRefreshOptions.isPeriodicRefreshEnabled();
    }

    public Duration getRefreshPeriod() {
        return this.topologyRefreshOptions.getRefreshPeriod();
    }

    public ClusterTopologyRefreshOptions getTopologyRefreshOptions() {
        return this.topologyRefreshOptions;
    }

    public boolean isValidateClusterNodeMembership() {
        return this.validateClusterNodeMembership;
    }

    public static class Builder
    extends ClientOptions.Builder {
        private boolean closeStaleConnections = true;
        private boolean validateClusterNodeMembership = true;
        private int maxRedirects = 5;
        private ClusterTopologyRefreshOptions topologyRefreshOptions = null;

        protected Builder() {
        }

        @Override
        public Builder autoReconnect(boolean autoReconnect) {
            super.autoReconnect(autoReconnect);
            return this;
        }

        @Override
        @Deprecated
        public Builder bufferUsageRatio(int bufferUsageRatio) {
            super.bufferUsageRatio(bufferUsageRatio);
            return this;
        }

        @Override
        public Builder cancelCommandsOnReconnectFailure(boolean cancelCommandsOnReconnectFailure) {
            super.cancelCommandsOnReconnectFailure(cancelCommandsOnReconnectFailure);
            return this;
        }

        @Override
        public Builder decodeBufferPolicy(DecodeBufferPolicy decodeBufferPolicy) {
            super.decodeBufferPolicy(decodeBufferPolicy);
            return this;
        }

        @Override
        public Builder disconnectedBehavior(ClientOptions.DisconnectedBehavior disconnectedBehavior) {
            super.disconnectedBehavior(disconnectedBehavior);
            return this;
        }

        public Builder maxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        @Override
        public Builder pingBeforeActivateConnection(boolean pingBeforeActivateConnection) {
            super.pingBeforeActivateConnection(pingBeforeActivateConnection);
            return this;
        }

        @Override
        public Builder protocolVersion(ProtocolVersion protocolVersion) {
            super.protocolVersion(protocolVersion);
            return this;
        }

        @Override
        public Builder suspendReconnectOnProtocolFailure(boolean suspendReconnectOnProtocolFailure) {
            super.suspendReconnectOnProtocolFailure(suspendReconnectOnProtocolFailure);
            return this;
        }

        @Override
        public Builder publishOnScheduler(boolean publishOnScheduler) {
            super.publishOnScheduler(publishOnScheduler);
            return this;
        }

        @Override
        public Builder requestQueueSize(int requestQueueSize) {
            super.requestQueueSize(requestQueueSize);
            return this;
        }

        @Override
        public Builder scriptCharset(Charset scriptCharset) {
            super.scriptCharset(scriptCharset);
            return this;
        }

        @Override
        public Builder socketOptions(SocketOptions socketOptions) {
            super.socketOptions(socketOptions);
            return this;
        }

        @Override
        public Builder sslOptions(SslOptions sslOptions) {
            super.sslOptions(sslOptions);
            return this;
        }

        @Override
        public Builder timeoutOptions(TimeoutOptions timeoutOptions) {
            super.timeoutOptions(timeoutOptions);
            return this;
        }

        public Builder topologyRefreshOptions(ClusterTopologyRefreshOptions topologyRefreshOptions) {
            this.topologyRefreshOptions = topologyRefreshOptions;
            return this;
        }

        public Builder validateClusterNodeMembership(boolean validateClusterNodeMembership) {
            this.validateClusterNodeMembership = validateClusterNodeMembership;
            return this;
        }

        @Override
        public ClusterClientOptions build() {
            return new ClusterClientOptions(this);
        }
    }
}

