/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;

final class ReactorNetty {
    static final AttributeKey<Boolean> PERSISTENT_CHANNEL = AttributeKey.newInstance((String)"PERSISTENT_CHANNEL");
    static final Object TERMINATED = new TerminatedHandlerEvent();
    static final Object RESPONSE_COMPRESSION_EVENT = new ResponseWriteCompleted();
    static final Logger log = Loggers.getLogger(ReactorNetty.class);

    static void addHandlerBeforeReactorEndHandlers(NettyContext context, String name, ChannelHandler handler) {
        boolean exists;
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(handler, "handler");
        Channel channel = context.channel();
        boolean bl = exists = channel.pipeline().get(name) != null;
        if (exists) {
            if (log.isDebugEnabled()) {
                log.debug("Handler [{}] already exists in the pipeline, decoder has been skipped", new Object[]{name});
            }
            return;
        }
        String before = null;
        for (String s : channel.pipeline().names()) {
            if (!s.startsWith("reactor.right.")) continue;
            before = s;
            break;
        }
        if (before == null) {
            channel.pipeline().addLast(name, handler);
        } else {
            channel.pipeline().addBefore("reactor.right.reactiveBridge", name, handler);
        }
        ReactorNetty.registerForClose(ReactorNetty.shouldCleanupOnClose(channel), name, context);
        if (log.isDebugEnabled()) {
            log.debug("Added decoder [{}] at the end of the user pipeline, full pipeline: {}", new Object[]{name, channel.pipeline().names()});
        }
    }

    static void addHandlerAfterReactorCodecs(NettyContext context, String name, ChannelHandler handler) {
        boolean exists;
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(handler, "handler");
        Channel channel = context.channel();
        boolean bl = exists = channel.pipeline().get(name) != null;
        if (exists) {
            if (log.isDebugEnabled()) {
                log.debug("Handler [{}] already exists in the pipeline, encoder has been skipped", new Object[]{name});
            }
            return;
        }
        String after = null;
        for (String s : channel.pipeline().names()) {
            if (!s.startsWith("reactor.left.")) continue;
            after = s;
        }
        if (after == null) {
            channel.pipeline().addFirst(name, handler);
        } else {
            channel.pipeline().addAfter(after, name, handler);
        }
        ReactorNetty.registerForClose(ReactorNetty.shouldCleanupOnClose(channel), name, context);
        if (log.isDebugEnabled()) {
            log.debug("Added encoder [{}] at the beginning of the user pipeline, full pipeline: {}", new Object[]{name, channel.pipeline().names()});
        }
    }

    static void registerForClose(boolean shouldCleanupOnClose, String name, NettyContext context) {
        if (!shouldCleanupOnClose) {
            return;
        }
        context.onClose(() -> context.removeHandler(name));
    }

    static void removeHandler(Channel channel, String name) {
        if (channel.isActive() && channel.pipeline().context(name) != null) {
            channel.pipeline().remove(name);
            if (log.isDebugEnabled()) {
                log.debug("{} Removed handler: {}, pipeline: {}", new Object[]{channel, name, channel.pipeline()});
            }
        } else if (log.isDebugEnabled()) {
            log.debug("{} Non Removed handler: {}, context: {}, pipeline: {}", new Object[]{channel, name, channel.pipeline().context(name), channel.pipeline()});
        }
    }

    static void replaceHandler(Channel channel, String name, ChannelHandler handler) {
        if (channel.isActive() && channel.pipeline().context(name) != null) {
            channel.pipeline().replace(name, name, handler);
            if (log.isDebugEnabled()) {
                log.debug("{} Replaced handler: {}, pipeline: {}", new Object[]{channel, name, channel.pipeline()});
            }
        } else if (log.isDebugEnabled()) {
            log.debug("{} Non Replaced handler: {}, context: {}, pipeline: {}", new Object[]{channel, name, channel.pipeline().context(name), channel.pipeline()});
        }
    }

    static boolean shouldCleanupOnClose(Channel channel) {
        boolean registerForClose = true;
        if (!NettyContext.isPersistent(channel)) {
            registerForClose = false;
        }
        return registerForClose;
    }

    static <T, V> Publisher<V> publisherOrScalarMap(Publisher<T> publisher, Function<? super T, ? extends V> mapper) {
        if (publisher instanceof Callable) {
            return Mono.fromCallable(new ScalarMap<T, V>(publisher, mapper));
        }
        if (publisher instanceof Mono) {
            return ((Mono)publisher).map(mapper);
        }
        return Flux.from(publisher).map(mapper);
    }

    ReactorNetty() {
    }

    @ChannelHandler.Sharable
    static final class ExtractorHandler
    extends ChannelInboundHandlerAdapter {
        final BiConsumer<? super ChannelHandlerContext, Object> extractor;

        ExtractorHandler(BiConsumer<? super ChannelHandlerContext, Object> extractor) {
            this.extractor = Objects.requireNonNull(extractor, "extractor");
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.extractor.accept((ChannelHandlerContext)ctx, msg);
        }
    }

    static final class InboundIdleStateHandler
    extends IdleStateHandler {
        final Runnable onReadIdle;

        InboundIdleStateHandler(long idleTimeout, Runnable onReadIdle) {
            super(idleTimeout, 0L, 0L, TimeUnit.MILLISECONDS);
            this.onReadIdle = onReadIdle;
        }

        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.READER_IDLE) {
                this.onReadIdle.run();
            }
            super.channelIdle(ctx, evt);
        }
    }

    static final class OutboundIdleStateHandler
    extends IdleStateHandler {
        final Runnable onWriteIdle;

        OutboundIdleStateHandler(long idleTimeout, Runnable onWriteIdle) {
            super(0L, idleTimeout, 0L, TimeUnit.MILLISECONDS);
            this.onWriteIdle = onWriteIdle;
        }

        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.WRITER_IDLE) {
                this.onWriteIdle.run();
            }
            super.channelIdle(ctx, evt);
        }
    }

    static final class OutboundThen
    implements NettyOutbound {
        final NettyContext sourceContext;
        final Mono<Void> thenMono;

        OutboundThen(NettyOutbound source, Publisher<Void> thenPublisher) {
            this.sourceContext = source.context();
            Mono<Void> parentMono = source.then();
            this.thenMono = parentMono == Mono.empty() ? Mono.from(thenPublisher) : parentMono.thenEmpty(thenPublisher);
        }

        @Override
        public NettyContext context() {
            return this.sourceContext;
        }

        @Override
        public Mono<Void> then() {
            return this.thenMono;
        }
    }

    static final class ResponseWriteCompleted {
        ResponseWriteCompleted() {
        }

        public String toString() {
            return "[Response Write Completed]";
        }
    }

    static final class TerminatedHandlerEvent {
        TerminatedHandlerEvent() {
        }

        public String toString() {
            return "[Handler Terminated]";
        }
    }

    static final class ScalarMap<T, V>
    implements Callable<V> {
        final Callable<T> source;
        final Function<? super T, ? extends V> mapper;

        ScalarMap(Publisher<T> source, Function<? super T, ? extends V> mapper) {
            this.source = (Callable)source;
            this.mapper = mapper;
        }

        @Override
        public V call() throws Exception {
            T called = this.source.call();
            if (called == null) {
                return null;
            }
            return this.mapper.apply(called);
        }
    }
}

