/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.DisposableServer;
import reactor.netty.NettyInbound;
import reactor.netty.NettyOutbound;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpServerBind;
import reactor.netty.tcp.TcpServerBootstrap;
import reactor.netty.tcp.TcpServerDoOn;
import reactor.netty.tcp.TcpServerDoOnConnection;
import reactor.netty.tcp.TcpServerHandle;
import reactor.netty.tcp.TcpServerObserve;
import reactor.netty.tcp.TcpServerRunOn;
import reactor.netty.tcp.TcpServerSecure;
import reactor.netty.tcp.TcpServerUnsecure;
import reactor.netty.tcp.TcpUtils;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class TcpServer {
    static final int DEFAULT_PORT = 0;
    static final LoggingHandler LOGGING_HANDLER = new LoggingHandler(TcpServer.class);
    static final Logger log = Loggers.getLogger(TcpServer.class);

    public static TcpServer create() {
        return TcpServerBind.INSTANCE;
    }

    public final TcpServer addressSupplier(Supplier<? extends SocketAddress> bindingAddressSupplier) {
        Objects.requireNonNull(bindingAddressSupplier, "bindingAddressSupplier");
        return this.bootstrap(b -> (ServerBootstrap)b.localAddress((SocketAddress)bindingAddressSupplier.get()));
    }

    public final <T> TcpServer attr(AttributeKey<T> key, @Nullable T value) {
        Objects.requireNonNull(key, "key");
        return this.bootstrap(b -> b.childAttr(key, value));
    }

    public final TcpServer bootstrap(Function<? super ServerBootstrap, ? extends ServerBootstrap> bootstrapMapper) {
        return new TcpServerBootstrap(this, bootstrapMapper);
    }

    public final Mono<? extends DisposableServer> bind() {
        ServerBootstrap b;
        try {
            b = this.configure();
        }
        catch (Throwable t) {
            Exceptions.throwIfJvmFatal((Throwable)t);
            return Mono.error((Throwable)t);
        }
        return this.bind(b);
    }

    public abstract Mono<? extends DisposableServer> bind(ServerBootstrap var1);

    public final DisposableServer bindNow() {
        return this.bindNow(Duration.ofSeconds(45L));
    }

    public final DisposableServer bindNow(Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        try {
            return Objects.requireNonNull((DisposableServer)this.bind().block(timeout), "aborted");
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("blocking read")) {
                throw new IllegalStateException("HttpServer couldn't be started within " + timeout.toMillis() + "ms");
            }
            throw e;
        }
    }

    public final void bindUntilJavaShutdown(Duration timeout, @Nullable Consumer<DisposableServer> onStart) {
        Objects.requireNonNull(timeout, "timeout");
        DisposableServer facade = this.bindNow();
        Objects.requireNonNull(facade, "facade");
        if (onStart != null) {
            onStart.accept(facade);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> facade.disposeNow(timeout)));
        facade.onDispose().block();
    }

    public abstract ServerBootstrap configure();

    public final TcpServer doOnBind(Consumer<? super ServerBootstrap> doOnBind) {
        Objects.requireNonNull(doOnBind, "doOnBind");
        return new TcpServerDoOn(this, doOnBind, null, null);
    }

    public final TcpServer doOnBound(Consumer<? super DisposableServer> doOnBound) {
        Objects.requireNonNull(doOnBound, "doOnBound");
        return new TcpServerDoOn(this, null, doOnBound, null);
    }

    public final TcpServer doOnConnection(Consumer<? super Connection> doOnConnection) {
        return new TcpServerDoOnConnection(this, doOnConnection);
    }

    public final TcpServer doOnUnbound(Consumer<? super DisposableServer> doOnUnbind) {
        Objects.requireNonNull(doOnUnbind, "doOnUnbound");
        return new TcpServerDoOn(this, null, null, doOnUnbind);
    }

    public final TcpServer doOnLifecycle(Consumer<? super ServerBootstrap> onBind, Consumer<? super DisposableServer> onBound, Consumer<? super DisposableServer> onUnbound) {
        Objects.requireNonNull(onBind, "onBind");
        Objects.requireNonNull(onBound, "onBound");
        Objects.requireNonNull(onUnbound, "onUnbound");
        return new TcpServerDoOn(this, onBind, onBound, onUnbound);
    }

    public final TcpServer handle(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler) {
        return new TcpServerHandle(this, handler);
    }

    public final TcpServer host(String host) {
        Objects.requireNonNull(host, "host");
        return this.bootstrap(b -> TcpUtils.updateHost(b, host));
    }

    public final boolean isSecure() {
        return this.sslProvider() != null;
    }

    public final TcpServer noSSL() {
        return new TcpServerUnsecure(this);
    }

    public final TcpServer observe(ConnectionObserver observer) {
        return new TcpServerObserve(this, observer);
    }

    public final <T> TcpServer option(ChannelOption<T> key, @Nullable T value) {
        Objects.requireNonNull(key, "key");
        return this.bootstrap(b -> b.childOption(key, value));
    }

    public final TcpServer port(int port) {
        return this.bootstrap(b -> TcpUtils.updatePort(b, port));
    }

    public final TcpServer runOn(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return this.runOn((boolean preferNative) -> eventLoopGroup);
    }

    public final TcpServer runOn(LoopResources channelResources) {
        return this.runOn(channelResources, LoopResources.DEFAULT_NATIVE);
    }

    public final TcpServer runOn(LoopResources channelResources, boolean preferNative) {
        return new TcpServerRunOn(this, channelResources, preferNative);
    }

    @Deprecated
    public final TcpServer secure(SslContext sslContext) {
        return this.secure((? super SslProvider.SslContextSpec sslProviderBuilder) -> sslProviderBuilder.sslContext(sslContext));
    }

    public final TcpServer secure(Consumer<? super SslProvider.SslContextSpec> sslProviderBuilder) {
        return TcpServerSecure.secure(this, sslProviderBuilder);
    }

    public final TcpServer secure(SslProvider sslProvider) {
        return new TcpServerSecure(this, sslProvider);
    }

    public final <T> TcpServer selectorAttr(AttributeKey<T> key, T value) {
        Objects.requireNonNull(key, "key");
        return this.bootstrap(b -> (ServerBootstrap)b.attr(key, value));
    }

    public final <T> TcpServer selectorOption(ChannelOption<T> key, T value) {
        Objects.requireNonNull(key, "key");
        return this.bootstrap(b -> (ServerBootstrap)b.option(key, value));
    }

    @Nullable
    public SslProvider sslProvider() {
        return null;
    }

    @Deprecated
    public final TcpServer wiretap() {
        return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, LOGGING_HANDLER));
    }

    public final TcpServer wiretap(boolean enable) {
        if (enable) {
            return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, LOGGING_HANDLER));
        }
        return this.bootstrap(b -> BootstrapHandlers.removeConfiguration(b, "reactor.left.loggingHandler"));
    }

    public final TcpServer wiretap(String category) {
        return this.wiretap(category, LogLevel.DEBUG);
    }

    public final TcpServer wiretap(String category, LogLevel level) {
        Objects.requireNonNull(category, "category");
        Objects.requireNonNull(level, "level");
        return this.bootstrap(b -> BootstrapHandlers.updateLogSupport(b, new LoggingHandler(category, level)));
    }
}

