/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.udp.UdpClient;
import reactor.netty.udp.UdpResources;

final class UdpClientConnect
extends UdpClient {
    static final UdpClientConnect INSTANCE = new UdpClientConnect();

    UdpClientConnect() {
    }

    @Override
    protected Mono<? extends Connection> connect(Bootstrap b) {
        if (b.config().group() == null) {
            UdpResources loopResources = UdpResources.get();
            EventLoopGroup elg = loopResources.onClient(LoopResources.DEFAULT_NATIVE);
            ((Bootstrap)b.group(elg)).channel(loopResources.onDatagramChannel(elg));
        }
        return ConnectionProvider.newConnection().acquire(b);
    }
}

