/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.mysql;

import java.util.Iterator;
import org.jooq.Record;
import zipkin.internal.DependencyLinkSpan;
import zipkin.internal.Nullable;
import zipkin.internal.PeekingIterator;
import zipkin.storage.mysql.internal.generated.tables.ZipkinAnnotations;
import zipkin.storage.mysql.internal.generated.tables.ZipkinSpans;

final class DependencyLinkSpanIterator
implements Iterator<DependencyLinkSpan> {
    final PeekingIterator<Record> delegate;
    @Nullable
    final Long traceIdHi;
    final long traceIdLo;

    DependencyLinkSpanIterator(PeekingIterator<Record> delegate, Long traceIdHi, long traceIdLo) {
        this.delegate = delegate;
        this.traceIdHi = traceIdHi;
        this.traceIdLo = traceIdLo;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext() && (this.traceIdHi == null || this.traceIdHi.equals(DependencyLinkSpanIterator.traceIdHigh(this.delegate))) && (Long)((Record)this.delegate.peek()).getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID) == this.traceIdLo;
    }

    @Override
    public DependencyLinkSpan next() {
        Record row = (Record)this.delegate.next();
        DependencyLinkSpan.Builder result = DependencyLinkSpan.builder((long)(this.traceIdHi != null ? this.traceIdHi : 0L), (long)this.traceIdLo, (Long)((Long)row.getValue(ZipkinSpans.ZIPKIN_SPANS.PARENT_ID)), (long)((Long)row.getValue(ZipkinSpans.ZIPKIN_SPANS.ID)));
        this.parseClientAndServerNames(result, (String)row.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY), (String)row.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME));
        while (this.hasNext()) {
            Record next = (Record)this.delegate.peek();
            if (next == null) continue;
            if (!((Long)row.getValue(ZipkinSpans.ZIPKIN_SPANS.ID)).equals(next.getValue(ZipkinSpans.ZIPKIN_SPANS.ID))) break;
            this.delegate.next();
            this.parseClientAndServerNames(result, (String)next.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY), (String)next.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME));
        }
        return result.build();
    }

    void parseClientAndServerNames(DependencyLinkSpan.Builder span, String key, String value) {
        if (key == null) {
            return;
        }
        switch (key) {
            case "ca": {
                span.caService(value);
                break;
            }
            case "cs": {
                span.csService(value);
                break;
            }
            case "sa": {
                span.saService(value);
                break;
            }
            case "sr": {
                span.srService(value);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static long traceIdHigh(PeekingIterator<Record> delegate) {
        return (Long)((Record)delegate.peek()).getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH);
    }

    static final class ByTraceId
    implements Iterator<Iterator<DependencyLinkSpan>> {
        final PeekingIterator<Record> delegate;
        final boolean hasTraceIdHigh;
        @Nullable
        Long currentTraceIdHi;
        long currentTraceIdLo;

        ByTraceId(Iterator<Record> delegate, boolean hasTraceIdHigh) {
            this.delegate = new PeekingIterator(delegate);
            this.hasTraceIdHigh = hasTraceIdHigh;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Iterator<DependencyLinkSpan> next() {
            this.currentTraceIdHi = this.hasTraceIdHigh ? Long.valueOf(DependencyLinkSpanIterator.traceIdHigh(this.delegate)) : null;
            this.currentTraceIdLo = (Long)((Record)this.delegate.peek()).getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID);
            return new DependencyLinkSpanIterator(this.delegate, this.currentTraceIdHi, this.currentTraceIdLo);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

