/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid;

import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.IdGenerator;

public class IntegerIdGenerator {
    protected final IdGenerator actual;

    public IntegerIdGenerator(IdGenerator actual) {
        this.actual = actual;
    }

    public int generate() throws IdOverflowException {
        long id = this.actual.generate();
        this.ensureInteger(id);
        return (int)id;
    }

    public String generateAsString() throws IdOverflowException {
        long id = this.actual.generate();
        this.ensureInteger(id);
        return this.actual.idConverter().asString(id);
    }

    private void ensureInteger(long id) throws IdOverflowException {
        if (id < Integer.MIN_VALUE || id > Integer.MAX_VALUE) {
            throw new IdOverflowException(id);
        }
    }

    public static class IdOverflowException
    extends CosIdException {
        private final long id;

        public IdOverflowException(long id) {
            super("id [" + id + "] overflow.");
            this.id = id;
        }

        public long getId() {
            return this.id;
        }
    }
}

