/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.sharding;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class ExactCollection<E>
extends AbstractCollection<E>
implements RandomAccess {
    private static final ExactCollection EMPTY = new ExactCollection(0);
    private final int size;
    private final Object[] elements;

    public static final <E> ExactCollection<E> empty() {
        return EMPTY;
    }

    public ExactCollection(int size) {
        this.size = size;
        this.elements = new Object[size];
    }

    public ExactCollection(Object ... elements) {
        this.size = elements.length;
        this.elements = elements;
    }

    @Override
    public int size() {
        return this.size;
    }

    public E get(int index) {
        return (E)this.elements[index];
    }

    public void add(int index, E element) {
        this.elements[index] = element;
    }

    public int indexOf(Object element) {
        for (int i = 0; i < this.elements.length; ++i) {
            if (!element.equals(this.elements[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return Arrays.copyOf(this.elements, this.size, a.getClass());
    }

    @Override
    public boolean remove(Object o) {
        int idx = this.indexOf(o);
        if (idx >= 0) {
            this.elements[idx] = null;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.elements);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Collection)) {
            return false;
        }
        Collection other = (Collection)obj;
        if (this.size != other.size()) {
            return false;
        }
        return this.containsAll((Collection)obj);
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, null);
    }

    private class Itr
    implements Iterator<E> {
        int cursor = 0;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < ExactCollection.this.size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Cursor: " + this.cursor + ", Size: " + ExactCollection.this.size);
            }
            Object element = ExactCollection.this.elements[this.cursor];
            ++this.cursor;
            return element;
        }
    }
}

